/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.repository.persistence;

import com.exlibris.repository.persistence.HPersistent;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;

@Entity
@Table(name="HDeProvanence")
public class HDeProvenance
extends HPersistent {
    public static final String DPS = "DPS";
    public static final String PID = "PID";
    private static final long serialVersionUID = 1L;
    private String eventIdentifierType;
    private String eventIdentifierValue;
    private EventType eventType;
    private String provenanceEventType;
    private Calendar eventDateTime;
    private String eventDetail;
    private EventOutcome eventOutcome;
    private String provenanceEventOutcome;
    private String eventOutcomeDetail;
    private String linkingObjectIdentifierType;
    private String linkingObjectIdentifierValue;
    private LinkingAgentIdentifierType linkingAgentIdentifierType;
    private String provenanceLinkingAgentIdentifierType;
    private String linkingAgentIdentifierValue;
    private String linkingAgentRole;
    private String eventDescription;
    private Map<String, String> eventParams = new HashMap<String, String>();
    private String module = null;
    private String subModule = null;
    private String userName = null;
    private String userInstitute = null;
    private String userSessionId = null;

    public HDeProvenance() {
    }

    public HDeProvenance(String identifier, EventType type, EventOutcome eventOutcome, String eventOutcomeDetail) {
        this.setEventIdentifier(identifier);
        this.setEventType(type);
        this.setEventOutcome(eventOutcome);
        this.setEventOutcomeDetail(eventOutcomeDetail);
        this.setEventDateTime(Calendar.getInstance());
    }

    @Column(length=255, name="Event_Identifier_Type")
    public String getEventIdentifierType() {
        return this.eventIdentifierType;
    }

    public void setEventIdentifierType(String eventIdentifierType) {
        this.eventIdentifierType = eventIdentifierType;
    }

    @Column(length=255, name="Event_Identifier_Value")
    public String getEventIdentifierValue() {
        return this.eventIdentifierValue;
    }

    public void setEventIdentifierValue(String eventIdentifierValue) {
        this.eventIdentifierValue = eventIdentifierValue;
    }

    @Column(length=255, name="Event_Type", nullable=false)
    @Enumerated(value=EnumType.STRING)
    public EventType getEventType() {
        return this.eventType;
    }

    public void setEventType(EventType eventType) {
        this.eventType = eventType;
    }

    @Transient
    public String getProvenanceEventType() {
        return this.eventType.toString();
    }

    public void setProvenanceEventType(String provenanceEventType) {
        this.eventType = EventType.valueOf(provenanceEventType);
        this.provenanceEventType = provenanceEventType;
    }

    @Column(name="Event_Date_Time", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    public Calendar getEventDateTime() {
        return this.eventDateTime;
    }

    public void setEventDateTime(Calendar eventDateTime) {
        this.eventDateTime = eventDateTime;
    }

    @Column(length=255, name="Event_Detail")
    public String getEventDetail() {
        return this.eventDetail;
    }

    public void setEventDetail(String eventDetail) {
        this.eventDetail = eventDetail;
    }

    @Column(length=255, name="Event_Outcome")
    @Enumerated(value=EnumType.STRING)
    public EventOutcome getEventOutcome() {
        return this.eventOutcome;
    }

    public void setEventOutcome(EventOutcome eventOutcome) {
        this.eventOutcome = eventOutcome;
    }

    @Transient
    public String getProvenanceEventOutcome() {
        return this.eventOutcome.toString();
    }

    public void setProvenanceEventOutcome(String provenanceEventOutcome) {
        this.eventOutcome = EventOutcome.valueOf(provenanceEventOutcome);
        this.provenanceEventOutcome = provenanceEventOutcome;
    }

    @Column(length=255, name="Event_Outcome_Detail")
    public String getEventOutcomeDetail() {
        return this.eventOutcomeDetail;
    }

    public void setEventOutcomeDetail(String eventOutcomeDetail) {
        this.eventOutcomeDetail = eventOutcomeDetail;
    }

    @Column(length=255, name="Link_Obj_Identifier_Type")
    public String getLinkingObjectIdentifierType() {
        return this.linkingObjectIdentifierType;
    }

    public void setLinkingObjectIdentifierType(String linkingObjectIdentifierType) {
        this.linkingObjectIdentifierType = linkingObjectIdentifierType;
    }

    @Column(length=255, name="Link_Obj_Identifier_Value", nullable=false)
    public String getLinkingObjectIdentifierValue() {
        return this.linkingObjectIdentifierValue;
    }

    public void setLinkingObjectIdentifierValue(String linkingObjectIdentifierValue) {
        this.linkingObjectIdentifierValue = linkingObjectIdentifierValue;
    }

    @Column(name="Link_Agent_Identifier_Type")
    @Enumerated(value=EnumType.STRING)
    public LinkingAgentIdentifierType getLinkingAgentIdentifierType() {
        return this.linkingAgentIdentifierType;
    }

    public void setLinkingAgentIdentifierType(LinkingAgentIdentifierType linkingAgentIdentifierType) {
        this.linkingAgentIdentifierType = linkingAgentIdentifierType;
    }

    @Transient
    public String getProvenanceLinkingAgentIdentifierType() {
        return this.linkingAgentIdentifierType.toString();
    }

    public void setProvenanceLinkingAgentIdentifierType(String provenanceLinkingAgentIdentifierType) {
        this.provenanceLinkingAgentIdentifierType = provenanceLinkingAgentIdentifierType;
        this.linkingAgentIdentifierType = LinkingAgentIdentifierType.valueOf(provenanceLinkingAgentIdentifierType);
    }

    @Column(length=255, name="Link_Agent_Identifier_Value")
    public String getLinkingAgentIdentifierValue() {
        return this.linkingAgentIdentifierValue;
    }

    public void setLinkingAgentIdentifierValue(String linkingAgentIdentifierValue) {
        this.linkingAgentIdentifierValue = linkingAgentIdentifierValue;
    }

    @Column(length=255, name="Link_Agent_Role")
    public String getLinkingAgentRole() {
        return this.linkingAgentRole;
    }

    public void setLinkingAgentRole(String linkingAgentRole) {
        this.linkingAgentRole = linkingAgentRole;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.eventDateTime == null ? 0 : this.eventDateTime.hashCode());
        result = 31 * result + (this.eventDetail == null ? 0 : this.eventDetail.hashCode());
        result = 31 * result + (this.eventIdentifierType == null ? 0 : this.eventIdentifierType.hashCode());
        result = 31 * result + (this.eventIdentifierValue == null ? 0 : this.eventIdentifierValue.hashCode());
        result = 31 * result + (this.eventOutcome == null ? 0 : this.eventOutcome.hashCode());
        result = 31 * result + (this.eventOutcomeDetail == null ? 0 : this.eventOutcomeDetail.hashCode());
        result = 31 * result + (this.eventType == null ? 0 : this.eventType.hashCode());
        result = 31 * result + (this.linkingAgentIdentifierType == null ? 0 : this.linkingAgentIdentifierType.hashCode());
        result = 31 * result + (this.linkingAgentIdentifierValue == null ? 0 : this.linkingAgentIdentifierValue.hashCode());
        result = 31 * result + (this.linkingAgentRole == null ? 0 : this.linkingAgentRole.hashCode());
        result = 31 * result + (this.linkingObjectIdentifierType == null ? 0 : this.linkingObjectIdentifierType.hashCode());
        result = 31 * result + (this.linkingObjectIdentifierValue == null ? 0 : this.linkingObjectIdentifierValue.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HDeProvenance other = (HDeProvenance)obj;
        if (this.eventDateTime == null ? other.eventDateTime != null : !this.eventDateTime.equals(other.eventDateTime)) {
            return false;
        }
        if (this.eventDetail == null ? other.eventDetail != null : !this.eventDetail.equals(other.eventDetail)) {
            return false;
        }
        if (this.eventIdentifierType == null ? other.eventIdentifierType != null : !this.eventIdentifierType.equals(other.eventIdentifierType)) {
            return false;
        }
        if (this.eventIdentifierValue == null ? other.eventIdentifierValue != null : !this.eventIdentifierValue.equals(other.eventIdentifierValue)) {
            return false;
        }
        if (this.eventOutcome == null ? other.eventOutcome != null : !this.eventOutcome.equals((Object)other.eventOutcome)) {
            return false;
        }
        if (this.eventOutcomeDetail == null ? other.eventOutcomeDetail != null : !this.eventOutcomeDetail.equals(other.eventOutcomeDetail)) {
            return false;
        }
        if (this.eventType == null ? other.eventType != null : !this.eventType.equals((Object)other.eventType)) {
            return false;
        }
        if (this.linkingAgentIdentifierType == null ? other.linkingAgentIdentifierType != null : !this.linkingAgentIdentifierType.equals((Object)other.linkingAgentIdentifierType)) {
            return false;
        }
        if (this.linkingAgentIdentifierValue == null ? other.linkingAgentIdentifierValue != null : !this.linkingAgentIdentifierValue.equals(other.linkingAgentIdentifierValue)) {
            return false;
        }
        if (this.linkingAgentRole == null ? other.linkingAgentRole != null : !this.linkingAgentRole.equals(other.linkingAgentRole)) {
            return false;
        }
        if (this.linkingObjectIdentifierType == null ? other.linkingObjectIdentifierType != null : !this.linkingObjectIdentifierType.equals(other.linkingObjectIdentifierType)) {
            return false;
        }
        return !(this.linkingObjectIdentifierValue == null ? other.linkingObjectIdentifierValue != null : !this.linkingObjectIdentifierValue.equals(other.linkingObjectIdentifierValue));
    }

    public void setEventIdentifier(String value) {
        this.setEventIdentifierType(DPS);
        this.setEventIdentifierValue(value);
    }

    public void setLinkingAgent(LinkingAgentIdentifierType type, String value) {
        this.setLinkingAgentIdentifierType(type);
        this.setLinkingAgentIdentifierValue(value);
    }

    public void setLinkingObject(String pid) {
        this.setLinkingObjectIdentifierType(PID);
        this.setLinkingObjectIdentifierValue(pid);
    }

    public HDeProvenance addEventParam(String key, String value) {
        if (this.eventParams == null) {
            this.eventParams = new HashMap<String, String>();
        }
        this.eventParams.put(key, value);
        return this;
    }

    public void clearEventParams() {
        this.eventParams = new HashMap<String, String>();
    }

    @Transient
    public Map<String, String> getEventParams() {
        return this.eventParams;
    }

    @Transient
    public String getEventParamsStr() {
        String ret = "";
        for (String key : this.eventParams.keySet()) {
            ret = ret + key + "=" + this.eventParams.get(key) + ";";
        }
        return ret;
    }

    public void setEventParams(Map<String, String> eventParams) {
        this.eventParams = eventParams;
    }

    @Transient
    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    @Transient
    public String getSubModule() {
        return this.subModule;
    }

    public void setSubModule(String subModule) {
        this.subModule = subModule;
    }

    @Transient
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Transient
    public String getUserInstitute() {
        return this.userInstitute;
    }

    public void setUserInstitute(String userInstitute) {
        this.userInstitute = userInstitute;
    }

    @Transient
    public String getUserSessionId() {
        return this.userSessionId;
    }

    public void setUserSessionId(String userSessionId) {
        this.userSessionId = userSessionId;
    }

    @Transient
    public String getEventDescription() {
        return this.eventDescription;
    }

    public void setEventDescription(String eventDescription) {
        this.eventDescription = eventDescription;
    }

    public static enum EventOutcome {
        SUCCESS,
        FAILURE;

    }

    public static enum EventType {
        TRANSFORMATION,
        PROCESSING,
        VALIDATION,
        IDENTIFICATION,
        EXTRACTION,
        DISCOVERY,
        CREATION,
        MIGRATION,
        HARVEST,
        DATA_MIGRATION,
        ENRICHMENT;

    }

    public static enum LinkingAgentIdentifierType {
        USER,
        SOFTWARE;

    }
}

