/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.repository.persistence.digitalentity;

import com.exlibris.core.sdk.consts.Enum;
import com.exlibris.digitool.repository.api.xmlbeans.StreamRef;
import com.exlibris.repository.persistence.HPersistent;
import java.util.Calendar;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Index;
import org.hibernate.validator.NotNull;

@Entity
@NamedQueries(value={@NamedQuery(name="numberOfStreamRefBySipId", query="select count(*) from HDeStreamRef sr, HDeControl c where sr.pid=c.pid and c.ingestId= :sipId"), @NamedQuery(name="numberOfStreamRefBySipIdWithErrorsOrStatus", query="select count(*) from HDeStreamRef sr, HDeControl c where sr.pid=c.pid and (sr.vs_evaluation > 0 or sr.status is not null) and c.ingestId= :sipId"), @NamedQuery(name="streamRefBySipIdWithErrorsOrStatus", query="select sr from HDeStreamRef sr, HDeControl c where sr.pid=c.pid and (sr.vs_evaluation > 0 or sr.status is not null) and c.ingestId= :sipId"), @NamedQuery(name="numberOfStreamRefBySipIdWithErrors", query="select count(*) from HDeStreamRef sr, HDeControl c where sr.pid=c.pid and sr.vs_evaluation > 0 and (sr.status is null or sr.status <> 'DECLINE' and sr.status <> 'REJECT') and c.ingestId= :sipId"), @NamedQuery(name="numberOfStreamRefByRipIdWithErrors", query="select count(*) from HDeStreamRef streamRef, HrRipItem ripItem where ripItem.destFilePid=streamRef.pid and streamRef.vs_evaluation > 0 and ripItem.ripId= :ripId"), @NamedQuery(name="streamRefByRipIdWithErrors", query="select streamRef from HDeStreamRef streamRef, HrRipItem ripItem where ripItem.destFilePid=streamRef.pid and streamRef.vs_evaluation > 0 and ripItem.ripId= :ripId"), @NamedQuery(name="streamRefBySipIdWithStatus", query="select sr from HDeStreamRef sr, HDeControl c where sr.pid=c.pid and sr.status = :status and c.ingestId= :sipId"), @NamedQuery(name="numberOfStreamRefBySipIdWithStatus", query="select count(*) from HDeStreamRef sr, HDeControl c where sr.pid=c.pid and sr.status = :status and c.ingestId= :sipId"), @NamedQuery(name="listOfPathsBySipId", query="select ie.pid, sr.fileName, sr.fileOriginalPath  from HDeStreamRef sr, HDeControl ie, HDeControl rep, HDeControl fi where sr.pid=fi.pid and fi.parentId = rep.pid and rep.parentId = ie.pid and (rep.preservationType like 'PRESERVATION_MASTER' or rep.preservationType like 'MODIFIED_MASTER') and ie.ingestId= :sipId"), @NamedQuery(name="listOfFileOrigPathByIePid", query="select sr.fileOriginalPath from HDeStreamRef sr, HDeControl c where sr.pid=c.pid and c.objectType = :objectType and c.pid= :iePid and trim(sr.fileOriginalPath) is not null"), @NamedQuery(name="listOfFileNameByIePid", query="select sr.fileName from HDeStreamRef sr, HDeControl c where sr.pid=c.pid and c.objectType = :objectType and c.pid= :iePid and trim(sr.fileOriginalPath) is null"), @NamedQuery(name="countEmptyOriginalPathBySipId", query="select count(*) from HDeStreamRef sr, HDeControl fi, HDeControl rep where sr.pid=fi.pid and fi.objectType = :objectType and fi.parentId = rep.pid and (rep.preservationType like 'PRESERVATION_MASTER' or rep.preservationType like 'MODIFIED_MASTER')  and fi.ingestId= :sipId and trim(sr.fileOriginalPath) is null"), @NamedQuery(name="countNumOfFilesByIePid", query="select count(*) from HDeStreamRef sr, HDeControl c where sr.pid=c.pid and c.objectType = :objectType and c.pid= :iePid"), @NamedQuery(name="streamRefByPid", query="select sr from HDeStreamRef sr where sr.pid = :pid"), @NamedQuery(name="quotaByFormat", query="select sum(sr.fileSizeBytes) from HDeStreamRef sr, HDeControl c where sr.pid=c.pid and sr.formatLibraryId = :formatLibraryId and c.owner like :owner")})
@org.hibernate.annotations.Table(appliesTo="HDeStreamRef")
@Table(name="HDeStreamRef")
public class HDeStreamRef
extends HPersistent {
    private static final long serialVersionUID = 1L;
    public static final int UNDEFINED_STORAGE = -1;
    private int storageId = -1;
    private int storageGroupId = -1;
    private String mimeType;
    private String fileExtension;
    private String fileName;
    private String internalPath;
    private int externalType;
    private String fileId;
    private Long fileSizeBytes;
    private String pid;
    private Calendar createDate;
    private Enum.FileLocationType fileLocationType;
    private String fileOriginalId;
    private String fileOriginalName;
    private String fileOriginalPath;
    private int fileFormatLibraryId;
    private long vs_result;
    private long vs_evaluation;
    private Status status;
    private String streamRefStatus;
    private String formatLibraryId;
    private String riskLibraryIdentifiers;

    @Column
    public int getExternalType() {
        return this.externalType;
    }

    public void setExternalType(int externalType) {
        this.externalType = externalType;
    }

    @Column
    public int getStorageGroupId() {
        return this.storageGroupId;
    }

    public void setStorageGroupId(int storageGroupId) {
        this.storageGroupId = storageGroupId;
    }

    @Column(length=500)
    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Column
    public String getInternalPath() {
        return this.internalPath;
    }

    public void setInternalPath(String internalPath) {
        this.internalPath = internalPath;
    }

    @Column
    public String getFileExtension() {
        return this.fileExtension;
    }

    public void setFileExtension(String fileExtension) {
        this.fileExtension = fileExtension;
    }

    @Column
    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    @Column
    @Index(name="HDESTREAMREF_STORAGEID")
    public int getStorageId() {
        return this.storageId;
    }

    public void setStorageId(int storageId) {
        this.storageId = storageId;
    }

    @Column
    public String getFileId() {
        return this.fileId;
    }

    public void setFileId(String fileId) {
        this.fileId = fileId;
    }

    public void export(StreamRef s_ref) {
        s_ref.setMimeType(this.getMimeType());
        s_ref.setDirectoryPath(this.getInternalPath());
        s_ref.setFileName(this.getFileName());
        s_ref.setStorageId(this.getStorageId());
        s_ref.setFileId(this.getFileId());
        s_ref.setFileSizeBytes(this.getFileSizeBytes());
        s_ref.setExternalType(this.getExternalType());
        s_ref.setFileExtension(this.getFileExtension());
    }

    @Column
    @Index(name="HDESTREAMREF_FILESIZEBYTES")
    public Long getFileSizeBytes() {
        return this.fileSizeBytes;
    }

    public void setFileSizeBytes(Long fileSizeBytes) {
        this.fileSizeBytes = fileSizeBytes;
    }

    @Column
    @NotNull
    @Index(name="HDESTREAMREF_PID")
    public String getPid() {
        return this.pid;
    }

    public void setPid(String pid) {
        this.pid = pid;
    }

    @Column
    public Calendar getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Calendar createDate) {
        this.createDate = createDate;
    }

    @Column
    @Enumerated(value=EnumType.STRING)
    public Enum.FileLocationType getFileLocationType() {
        return this.fileLocationType;
    }

    public void setFileLocationType(Enum.FileLocationType fileLocationType) {
        this.fileLocationType = fileLocationType;
    }

    @Column(length=1000)
    public String getFileOriginalId() {
        return this.fileOriginalId;
    }

    public void setFileOriginalId(String fileOriginalId) {
        this.fileOriginalId = fileOriginalId;
    }

    @Column(length=500)
    public String getFileOriginalName() {
        return this.fileOriginalName;
    }

    public void setFileOriginalName(String fileOriginalName) {
        this.fileOriginalName = fileOriginalName;
    }

    @Column(length=1000)
    public String getFileOriginalPath() {
        return this.fileOriginalPath;
    }

    public void setFileOriginalPath(String fileOriginalPath) {
        this.fileOriginalPath = fileOriginalPath;
    }

    @Column
    public int getFileFormatLibraryId() {
        return this.fileFormatLibraryId;
    }

    public void setFileFormatLibraryId(int fileFormatLibraryId) {
        this.fileFormatLibraryId = fileFormatLibraryId;
    }

    @Column
    @Index(name="HDESTREAMREF_VS_EVALUATION")
    public long getVs_evaluation() {
        return this.vs_evaluation;
    }

    public void setVs_evaluation(long vs_evaluation) {
        this.vs_evaluation = vs_evaluation;
    }

    public long getVs_result() {
        return this.vs_result;
    }

    public void setVs_result(long vs_result) {
        this.vs_result = vs_result;
    }

    @Column
    @Enumerated(value=EnumType.STRING)
    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    @Transient
    public String getStreamRefStatus() {
        return this.status.toString();
    }

    public void setStreamRefStatus(String streamRefStatus) {
        this.status = Status.valueOf(streamRefStatus);
        this.streamRefStatus = streamRefStatus;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.externalType;
        result = 31 * result + (this.fileExtension == null ? 0 : this.fileExtension.hashCode());
        result = 31 * result + (this.fileId == null ? 0 : this.fileId.hashCode());
        result = 31 * result + (this.fileName == null ? 0 : this.fileName.hashCode());
        result = 31 * result + this.fileSizeBytes.intValue();
        result = 31 * result + (this.internalPath == null ? 0 : this.internalPath.hashCode());
        result = 31 * result + (this.mimeType == null ? 0 : this.mimeType.hashCode());
        result = 31 * result + this.storageGroupId;
        result = 31 * result + this.storageId;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HDeStreamRef other = (HDeStreamRef)obj;
        if (this.externalType != other.externalType) {
            return false;
        }
        if (this.fileExtension == null ? other.fileExtension != null : !this.fileExtension.equals(other.fileExtension)) {
            return false;
        }
        if (this.fileId == null ? other.fileId != null : !this.fileId.equals(other.fileId)) {
            return false;
        }
        if (this.fileName == null ? other.fileName != null : !this.fileName.equals(other.fileName)) {
            return false;
        }
        if (!this.fileSizeBytes.equals(other.fileSizeBytes)) {
            return false;
        }
        if (this.internalPath == null ? other.internalPath != null : !this.internalPath.equals(other.internalPath)) {
            return false;
        }
        if (this.mimeType == null ? other.mimeType != null : !this.mimeType.equals(other.mimeType)) {
            return false;
        }
        if (this.storageGroupId != other.storageGroupId) {
            return false;
        }
        return this.storageId == other.storageId;
    }

    @Column
    public String getFormatLibraryId() {
        return this.formatLibraryId;
    }

    public void setFormatLibraryId(String formatLibraryId) {
        this.formatLibraryId = formatLibraryId;
    }

    @Column(length=255)
    public String getRiskLibraryIdentifiers() {
        return this.riskLibraryIdentifiers;
    }

    public void setRiskLibraryIdentifiers(String riskLibraryIdentifiers) {
        this.riskLibraryIdentifiers = riskLibraryIdentifiers;
    }

    public static enum Status {
        IGNORE,
        REJECT,
        DECLINE;

    }
}

