/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.sxc.pexcel.records;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.BIFFRecord;
import org.openoffice.xmerge.util.Debug;
import org.openoffice.xmerge.util.EndianConverter;

public class ColInfo
implements BIFFRecord {
    private byte[] colFirst = new byte[2];
    private byte[] colLast = new byte[2];
    private byte[] colDX = new byte[2];
    private byte[] ixfe = new byte[2];
    private byte grbit;
    private float scale = 2.5f;

    public ColInfo(int n, int n2, int n3, int n4) {
        this.colFirst = EndianConverter.writeShort((short)((short)n));
        this.colLast = EndianConverter.writeShort((short)((short)n2));
        n3 = (int)((float)n3 * this.scale);
        this.colDX = EndianConverter.writeShort((short)((short)n3));
        this.ixfe = EndianConverter.writeShort((short)((short)n4));
        this.grbit = 0;
    }

    public ColInfo(InputStream inputStream) throws IOException {
        this.read(inputStream);
    }

    @Override
    public int read(InputStream inputStream) throws IOException {
        int n = inputStream.read(this.colFirst);
        n += inputStream.read(this.colLast);
        n += inputStream.read(this.colDX);
        short s = (short)((float)EndianConverter.readShort((byte[])this.colDX) / this.scale);
        this.colDX = EndianConverter.writeShort((short)s);
        n += inputStream.read(this.ixfe);
        this.grbit = (byte)inputStream.read();
        Debug.log((int)4, (String)("\tcolFirst : " + EndianConverter.readShort((byte[])this.colFirst) + " colLast : " + EndianConverter.readShort((byte[])this.colLast) + " colDX : " + EndianConverter.readShort((byte[])this.colDX) + " ixfe : " + EndianConverter.readShort((byte[])this.ixfe) + " grbit : " + this.grbit));
        return ++n;
    }

    @Override
    public short getBiffType() {
        return 125;
    }

    public short getColWidth() {
        return EndianConverter.readShort((byte[])this.colDX);
    }

    public short getFirst() {
        return EndianConverter.readShort((byte[])this.colFirst);
    }

    public short getLast() {
        return EndianConverter.readShort((byte[])this.colLast);
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        outputStream.write(this.getBiffType());
        outputStream.write(this.colFirst);
        outputStream.write(this.colLast);
        outputStream.write(this.colDX);
        outputStream.write(this.ixfe);
        outputStream.write(this.grbit);
        Debug.log((int)4, (String)"Writing ColInfo record");
    }
}

