/*
 * Decompiled with CFR 0.152.
 */
package bsh.classpath;

import bsh.BshClassManager;
import bsh.ClassPathException;
import bsh.Interpreter;
import bsh.UtilEvalError;
import bsh.classpath.BshClassLoader;
import bsh.classpath.BshClassPath;
import bsh.classpath.DiscreteFilesClassLoader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class ClassManagerImpl
extends BshClassManager {
    static final String BSH_PACKAGE = "bsh";
    private BshClassPath baseClassPath;
    private boolean superImport;
    private BshClassPath fullClassPath;
    private Vector listeners = new Vector();
    private ReferenceQueue refQueue = new ReferenceQueue();
    private BshClassLoader baseLoader;
    private Map loaderMap;

    public ClassManagerImpl() {
        this.reset();
    }

    @Override
    public Class classForName(String string) {
        ClassLoader classLoader;
        Class<?> clazz = (Class<?>)this.absoluteClassCache.get(string);
        if (clazz != null) {
            return clazz;
        }
        if (this.absoluteNonClasses.get(string) != null) {
            if (Interpreter.DEBUG) {
                Interpreter.debug("absoluteNonClass list hit: " + string);
            }
            return null;
        }
        if (Interpreter.DEBUG) {
            Interpreter.debug("Trying to load class: " + string);
        }
        if ((classLoader = this.getLoaderForClass(string)) != null) {
            try {
                clazz = classLoader.loadClass(string);
            }
            catch (Exception exception) {
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                throw ClassManagerImpl.noClassDefFound(string, noClassDefFoundError);
            }
        }
        if (clazz == null) {
            if (string.startsWith(BSH_PACKAGE)) {
                try {
                    clazz = Interpreter.class.getClassLoader().loadClass(string);
                }
                catch (ClassNotFoundException classNotFoundException) {}
            } else if (this.baseLoader != null) {
                try {
                    clazz = this.baseLoader.loadClass(string);
                }
                catch (ClassNotFoundException classNotFoundException) {}
            } else {
                try {
                    clazz = this.plainClassForName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        if (clazz == null) {
            clazz = this.loadSourceClass(string);
        }
        this.cacheClassInfo(string, clazz);
        return clazz;
    }

    @Override
    public Class plainClassForName(String string) throws ClassNotFoundException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            return Class.forName(string, true, classLoader);
        }
        return super.plainClassForName(string);
    }

    @Override
    public URL getResource(String string) {
        URL uRL = null;
        if (this.baseLoader != null) {
            uRL = this.baseLoader.getResource(string.substring(1));
        }
        if (uRL == null) {
            uRL = super.getResource(string);
        }
        return uRL;
    }

    @Override
    public InputStream getResourceAsStream(String string) {
        InputStream inputStream = null;
        if (this.baseLoader != null) {
            inputStream = this.baseLoader.getResourceAsStream(string.substring(1));
        }
        if (inputStream == null) {
            inputStream = super.getResourceAsStream(string);
        }
        return inputStream;
    }

    ClassLoader getLoaderForClass(String string) {
        return (ClassLoader)this.loaderMap.get(string);
    }

    @Override
    public void addClassPath(URL uRL) throws IOException {
        if (this.baseLoader == null) {
            this.setClassPath(new URL[]{uRL});
        } else {
            this.baseLoader.addURL(uRL);
            this.baseClassPath.add(uRL);
            this.classLoaderChanged();
        }
    }

    @Override
    public void reset() {
        this.baseClassPath = new BshClassPath("baseClassPath");
        this.baseLoader = null;
        this.loaderMap = new HashMap();
        this.classLoaderChanged();
    }

    @Override
    public void setClassPath(URL[] uRLArray) {
        this.baseClassPath.setPath(uRLArray);
        this.initBaseLoader();
        this.loaderMap = new HashMap();
        this.classLoaderChanged();
    }

    @Override
    public void reloadAllClasses() throws ClassPathException {
        BshClassPath bshClassPath = new BshClassPath("temp");
        bshClassPath.addComponent(this.baseClassPath);
        bshClassPath.addComponent(BshClassPath.getUserClassPath());
        this.setClassPath(bshClassPath.getPathComponents());
    }

    private void initBaseLoader() {
        this.baseLoader = new BshClassLoader((BshClassManager)this, this.baseClassPath);
    }

    @Override
    public void reloadClasses(String[] stringArray) throws ClassPathException {
        Object object;
        if (this.baseLoader == null) {
            this.initBaseLoader();
        }
        DiscreteFilesClassLoader.ClassSourceMap classSourceMap = new DiscreteFilesClassLoader.ClassSourceMap();
        for (int i = 0; i < stringArray.length; ++i) {
            object = stringArray[i];
            this.baseClassPath.insureInitialized();
            BshClassPath.ClassSource classSource = this.baseClassPath.getClassSource((String)object);
            if (classSource == null) {
                BshClassPath.getUserClassPath().insureInitialized();
                classSource = BshClassPath.getUserClassPath().getClassSource((String)object);
            }
            if (classSource == null) {
                throw new ClassPathException("Nothing known about class: " + (String)object);
            }
            if (!(classSource instanceof BshClassPath.DirClassSource)) {
                throw new ClassPathException("Cannot reload class: " + (String)object + " from source: " + classSource);
            }
            classSourceMap.put((String)object, ((BshClassPath.DirClassSource)classSource).getDir());
        }
        DiscreteFilesClassLoader discreteFilesClassLoader = new DiscreteFilesClassLoader((BshClassManager)this, classSourceMap);
        object = classSourceMap.keySet().iterator();
        while (object.hasNext()) {
            this.loaderMap.put((String)object.next(), discreteFilesClassLoader);
        }
        this.classLoaderChanged();
    }

    @Override
    public void reloadPackage(String string) throws ClassPathException {
        Set set = this.baseClassPath.getClassesForPackage(string);
        if (set == null) {
            set = BshClassPath.getUserClassPath().getClassesForPackage(string);
        }
        if (set == null) {
            throw new ClassPathException("No classes found for package: " + string);
        }
        this.reloadClasses(set.toArray(new String[0]));
    }

    public BshClassPath getClassPath() throws ClassPathException {
        if (this.fullClassPath != null) {
            return this.fullClassPath;
        }
        this.fullClassPath = new BshClassPath("BeanShell Full Class Path");
        this.fullClassPath.addComponent(BshClassPath.getUserClassPath());
        try {
            this.fullClassPath.addComponent(BshClassPath.getBootClassPath());
        }
        catch (ClassPathException classPathException) {
            System.err.println("Warning: can't get boot class path");
        }
        this.fullClassPath.addComponent(this.baseClassPath);
        return this.fullClassPath;
    }

    @Override
    public void doSuperImport() throws UtilEvalError {
        try {
            this.getClassPath().insureInitialized();
            this.getClassNameByUnqName("");
        }
        catch (ClassPathException classPathException) {
            throw new UtilEvalError("Error importing classpath " + classPathException);
        }
        this.superImport = true;
    }

    @Override
    protected boolean hasSuperImport() {
        return this.superImport;
    }

    @Override
    public String getClassNameByUnqName(String string) throws ClassPathException {
        return this.getClassPath().getClassNameByUnqName(string);
    }

    @Override
    public void addListener(BshClassManager.Listener listener) {
        Reference reference;
        this.listeners.addElement(new WeakReference<BshClassManager.Listener>(listener, this.refQueue));
        while ((reference = this.refQueue.poll()) != null) {
            boolean bl = this.listeners.removeElement(reference);
            if (bl || !Interpreter.DEBUG) continue;
            Interpreter.debug("tried to remove non-existent weak ref: " + reference);
        }
    }

    @Override
    public void removeListener(BshClassManager.Listener listener) {
        throw new Error("unimplemented");
    }

    public ClassLoader getBaseLoader() {
        return this.baseLoader;
    }

    @Override
    protected void classLoaderChanged() {
        this.clearCaches();
        Vector<WeakReference> vector = new Vector<WeakReference>();
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            WeakReference weakReference = (WeakReference)enumeration.nextElement();
            BshClassManager.Listener listener = (BshClassManager.Listener)weakReference.get();
            if (listener == null) {
                vector.add(weakReference);
                continue;
            }
            listener.classLoaderChanged();
        }
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.listeners.removeElement(enumeration.nextElement());
        }
    }

    @Override
    public void dump(PrintWriter printWriter) {
        printWriter.println("Bsh Class Manager Dump: ");
        printWriter.println("----------------------- ");
        printWriter.println("baseLoader = " + this.baseLoader);
        printWriter.println("loaderMap= " + this.loaderMap);
        printWriter.println("----------------------- ");
        printWriter.println("baseClassPath = " + this.baseClassPath);
    }
}

