/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.instruct.InstructionDetails;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.TraceListener;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.Value;

public class Trace
extends SystemFunction {
    NamespaceResolver resolver;

    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.resolver = visitor.getStaticContext().getNamespaceResolver();
        return super.simplify(visitor);
    }

    public Expression preEvaluate(ExpressionVisitor visitor) {
        return this;
    }

    public int computeSpecialProperties() {
        return this.argument[0].getSpecialProperties();
    }

    public int computeCardinality() {
        return this.argument[0].getCardinality();
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        Item val = this.argument[0].evaluateItem(context);
        String label = ((Object)this.argument[1].evaluateAsString(context)).toString();
        if (context.getController().isTracing()) {
            this.notifyListener(label, Value.asValue(val), context);
        } else {
            this.traceItem(val, label);
        }
        return val;
    }

    private void notifyListener(String label, Value val, XPathContext context) {
        InstructionDetails info = (InstructionDetails)this.getInstructionInfo();
        info.setConstructType(2031);
        info.setNamespaceResolver(this.resolver);
        info.setProperty("label", label);
        info.setProperty("value", val);
        TraceListener listener = context.getController().getTraceListener();
        listener.enter(info, context);
        listener.leave(info);
    }

    private void traceItem(Item val, String label) {
        if (val == null) {
            System.err.println(label + ": empty sequence");
        } else if (val instanceof NodeInfo) {
            System.err.println(label + ": " + Type.displayTypeName(val) + ": " + Navigator.getPath((NodeInfo)val));
        } else {
            System.err.println(label + ": " + Type.displayTypeName(val) + ": " + val.getStringValue());
        }
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        if (context.getController().isTracing()) {
            String label = ((Object)this.argument[1].evaluateAsString(context)).toString();
            Value value = Value.asValue(ExpressionTool.eagerEvaluate(this.argument[0], context));
            this.notifyListener(label, value, context);
            return value.iterate();
        }
        return new TracingIterator(this.argument[0].iterate(context), ((Object)this.argument[1].evaluateAsString(context)).toString());
    }

    public class TracingIterator
    implements SequenceIterator {
        SequenceIterator base;
        String label;
        boolean empty = true;

        public TracingIterator(SequenceIterator base, String label) {
            this.base = base;
            this.label = label;
        }

        public Item next() throws XPathException {
            Item n = this.base.next();
            if (n == null) {
                if (this.empty) {
                    Trace.this.traceItem(null, this.label);
                }
            } else {
                Trace.this.traceItem(n, this.label + " [" + this.position() + ']');
                this.empty = false;
            }
            return n;
        }

        public Item current() {
            return this.base.current();
        }

        public int position() {
            return this.base.position();
        }

        public SequenceIterator getAnother() throws XPathException {
            return new TracingIterator(this.base.getAnother(), this.label);
        }

        public int getProperties() {
            return 0;
        }
    }
}

