/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.accessibility.awb.canvas;

import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Iterator;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.openoffice.accessibility.awb.canvas.Canvas;
import org.openoffice.accessibility.awb.canvas.CanvasShape;

public class MouseObserver
implements MouseListener,
MouseMotionListener {
    private Canvas maCanvas;
    private JTree maTree;

    public MouseObserver(Canvas canvas) {
        this.maCanvas = canvas;
        this.maCanvas.addMouseListener(this);
        this.maCanvas.addMouseMotionListener(this);
    }

    public void SetTree(JTree jTree) {
        this.maTree = jTree;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        CanvasShape canvasShape = this.FindCanvasShapeUnderMouse(mouseEvent);
        this.maTree.clearSelection();
        if (canvasShape != null) {
            TreePath treePath = canvasShape.getNodePath();
            if ((mouseEvent.getModifiers() & 2) != 0) {
                this.maTree.expandPath(treePath);
            }
            this.maTree.setSelectionPath(treePath);
            this.maTree.makeVisible(treePath);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 1) != 0) {
            this.maCanvas.HighlightObject(this.FindCanvasShapeUnderMouse(mouseEvent));
        }
    }

    protected CanvasShape FindCanvasShapeUnderMouse(MouseEvent mouseEvent) {
        Dimension dimension = null;
        Iterator iterator = this.maCanvas.GetShapeIterator();
        CanvasShape canvasShape = null;
        while (iterator.hasNext()) {
            CanvasShape canvasShape2 = (CanvasShape)iterator.next();
            if (canvasShape2 == null || !canvasShape2.Contains(mouseEvent.getX(), mouseEvent.getY())) continue;
            if (canvasShape == null) {
                dimension = canvasShape2.GetSize();
                canvasShape = canvasShape2;
                continue;
            }
            Dimension dimension2 = canvasShape2.GetSize();
            if (!(dimension2.getWidth() < dimension.getWidth()) && !(dimension2.getHeight() < dimension.getHeight())) continue;
            dimension = dimension2;
            canvasShape = canvasShape2;
        }
        return canvasShape;
    }
}

