/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.accessibility.awb.tree;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.accessibility.XAccessibleEventListener;
import com.sun.star.awt.XExtendedToolkit;
import com.sun.star.awt.XTopWindowListener;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.UnoRuntime;
import java.lang.ref.WeakReference;
import java.util.Hashtable;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.openoffice.accessibility.awb.tree.AccessibilityNode;
import org.openoffice.accessibility.awb.tree.ToolkitNode;

public abstract class AccessibilityModel
extends DefaultTreeModel {
    protected Hashtable nodeList = new Hashtable();
    protected static DefaultMutableTreeNode disconnectedRootNode = new DefaultMutableTreeNode("<not connected>");

    public AccessibilityModel() {
        super(disconnectedRootNode, false);
    }

    public synchronized void setRoot(XExtendedToolkit xExtendedToolkit) {
        if (xExtendedToolkit != null) {
            try {
                if (this.getRoot() instanceof ToolkitNode) {
                    ToolkitNode toolkitNode = (ToolkitNode)this.getRoot();
                    if (toolkitNode.xToolkit != null) {
                        toolkitNode.xToolkit.removeTopWindowListener((XTopWindowListener)toolkitNode);
                    }
                }
                this.nodeList.clear();
                this.setRoot(new ToolkitNode(xExtendedToolkit, this));
                xExtendedToolkit.addTopWindowListener((XTopWindowListener)((ToolkitNode)this.getRoot()));
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    public void addNodeInto(MutableTreeNode mutableTreeNode, MutableTreeNode mutableTreeNode2) {
        int n = mutableTreeNode2.getChildCount();
        if (mutableTreeNode != null && mutableTreeNode.getParent() == mutableTreeNode2) {
            --n;
        }
        this.insertNodeInto(mutableTreeNode, mutableTreeNode2, n);
    }

    public static void addEventListener(TreeNode treeNode, XAccessibleEventListener xAccessibleEventListener) {
        if (treeNode instanceof AccessibilityNode) {
            ((AccessibilityNode)treeNode).addEventListener(xAccessibleEventListener);
        }
    }

    public static void removeEventListener(TreeNode treeNode, XAccessibleEventListener xAccessibleEventListener) {
        if (treeNode instanceof AccessibilityNode) {
            ((AccessibilityNode)treeNode).removeEventListener(xAccessibleEventListener);
        }
    }

    protected abstract AccessibilityNode createWindowNode(XAccessible var1, XAccessibleContext var2);

    protected abstract AccessibilityNode createNode(XAccessible var1);

    public AccessibilityNode putNode(XAccessible xAccessible, AccessibilityNode accessibilityNode) {
        String string;
        WeakReference<AccessibilityNode> weakReference;
        if (xAccessible != null && (weakReference = this.nodeList.put(string = UnoRuntime.generateOid((Object)xAccessible), new WeakReference<AccessibilityNode>(accessibilityNode))) != null) {
            return (AccessibilityNode)weakReference.get();
        }
        return null;
    }

    public AccessibilityNode findNode(XAccessible xAccessible) {
        String string;
        WeakReference weakReference;
        if (xAccessible != null && (weakReference = (WeakReference)this.nodeList.get(string = UnoRuntime.generateOid((Object)xAccessible))) != null) {
            return (AccessibilityNode)weakReference.get();
        }
        return null;
    }

    public AccessibilityNode removeNode(XAccessible xAccessible) {
        String string;
        WeakReference weakReference;
        if (xAccessible != null && (weakReference = (WeakReference)this.nodeList.remove(string = UnoRuntime.generateOid((Object)xAccessible))) != null) {
            return (AccessibilityNode)weakReference.get();
        }
        return null;
    }

    public AccessibilityNode removeNode(Object object) {
        if (object instanceof XAccessible) {
            return this.removeNode((XAccessible)object);
        }
        return null;
    }
}

