/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.accessibility.awb.tree;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.uno.RuntimeException;
import java.util.Enumeration;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeNode;
import org.openoffice.accessibility.awb.tree.AccessibilityModel;
import org.openoffice.accessibility.awb.tree.AccessibilityNode;
import org.openoffice.accessibility.awb.tree.DynamicAccessibilityNode;

public class DynamicAccessibilityModel
extends AccessibilityModel
implements TreeExpansionListener,
TreeWillExpandListener {
    @Override
    protected AccessibilityNode createWindowNode(XAccessible xAccessible, XAccessibleContext xAccessibleContext) {
        if (xAccessible != null && xAccessibleContext != null) {
            AccessibilityNode accessibilityNode = new AccessibilityNode(this);
            accessibilityNode.setUserObject(xAccessible);
            accessibilityNode.setAccessibleContext(xAccessibleContext);
            this.putNode(xAccessible, accessibilityNode);
            return accessibilityNode;
        }
        return null;
    }

    @Override
    protected AccessibilityNode createNode(XAccessible xAccessible) {
        if (xAccessible != null) {
            try {
                XAccessibleContext xAccessibleContext = xAccessible.getAccessibleContext();
                if (xAccessibleContext != null) {
                    DynamicAccessibilityNode dynamicAccessibilityNode = new DynamicAccessibilityNode(this);
                    dynamicAccessibilityNode.setUserObject(xAccessible);
                    dynamicAccessibilityNode.setAccessibleContext(xAccessibleContext);
                    this.putNode(xAccessible, dynamicAccessibilityNode);
                    return dynamicAccessibilityNode;
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
        TreeNode treeNode = (TreeNode)treeExpansionEvent.getPath().getLastPathComponent();
        if (treeNode instanceof DynamicAccessibilityNode) {
            DynamicAccessibilityNode dynamicAccessibilityNode = (DynamicAccessibilityNode)treeNode;
            dynamicAccessibilityNode.clear();
        }
    }

    @Override
    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        TreeNode treeNode = (TreeNode)treeExpansionEvent.getPath().getLastPathComponent();
        if (treeNode instanceof AccessibilityNode) {
            Enumeration<? extends TreeNode> enumeration = treeNode.children();
            while (enumeration.hasMoreElements()) {
                ((AccessibilityNode)enumeration.nextElement()).setAttached(true);
            }
        }
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
        TreeNode treeNode = (TreeNode)treeExpansionEvent.getPath().getLastPathComponent();
        if (treeNode instanceof AccessibilityNode) {
            Enumeration<? extends TreeNode> enumeration = treeNode.children();
            while (enumeration.hasMoreElements()) {
                ((AccessibilityNode)enumeration.nextElement()).setAttached(false);
            }
        }
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
        TreeNode treeNode = (TreeNode)treeExpansionEvent.getPath().getLastPathComponent();
        if (treeNode instanceof DynamicAccessibilityNode) {
            DynamicAccessibilityNode dynamicAccessibilityNode = (DynamicAccessibilityNode)treeNode;
            dynamicAccessibilityNode.populate();
        }
    }
}

