/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.accessibility.awb.view;

import com.sun.star.accessibility.AccessibleEventObject;
import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.accessibility.XAccessibleSelection;
import com.sun.star.accessibility.XAccessibleStateSet;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.uno.UnoRuntime;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import org.openoffice.accessibility.awb.view.ObjectView;
import org.openoffice.accessibility.awb.view.ObjectViewContainer;

class SelectionView
extends ObjectView
implements ActionListener {
    private JPanel maChildrenSelector;
    private XAccessibleSelection mxSelection;
    private JLabel maTypeLabel;

    public static ObjectView Create(ObjectViewContainer objectViewContainer, XAccessibleContext xAccessibleContext) {
        XAccessibleSelection xAccessibleSelection = (XAccessibleSelection)UnoRuntime.queryInterface(XAccessibleSelection.class, (Object)xAccessibleContext);
        if (xAccessibleSelection != null) {
            return new SelectionView(objectViewContainer);
        }
        return null;
    }

    public SelectionView(ObjectViewContainer objectViewContainer) {
        super(objectViewContainer);
        this.Layout();
    }

    @Override
    public String GetTitle() {
        return "Selection";
    }

    private void Layout() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.maTypeLabel = new JLabel();
        this.maTypeLabel.setFont(this.maContainer.GetViewFont());
        this.add((Component)this.maTypeLabel, gridBagConstraints);
        this.maChildrenSelector = new JPanel();
        this.maChildrenSelector.setPreferredSize(new Dimension(100, 100));
        this.maChildrenSelector.setLayout(new BoxLayout(this.maChildrenSelector, 1));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.add((Component)new JScrollPane(this.maChildrenSelector, 20, 30), gridBagConstraints);
        JButton jButton = new JButton("Select all");
        jButton.setFont(this.maContainer.GetViewFont());
        jButton.setActionCommand("Select all");
        jButton.addActionListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)jButton, gridBagConstraints);
        jButton = new JButton("Clear Selection");
        jButton.setFont(this.maContainer.GetViewFont());
        jButton.setActionCommand("Clear Selection");
        jButton.addActionListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)jButton, gridBagConstraints);
        this.setSize(this.getPreferredSize());
    }

    @Override
    public void SetObject(XAccessibleContext xAccessibleContext) {
        this.mxSelection = (XAccessibleSelection)UnoRuntime.queryInterface(XAccessibleSelection.class, (Object)xAccessibleContext);
        super.SetObject(xAccessibleContext);
    }

    @Override
    public void Update() {
        this.maChildrenSelector.removeAll();
        XAccessibleStateSet xAccessibleStateSet = this.mxContext.getAccessibleStateSet();
        boolean bl = false;
        if (xAccessibleStateSet != null && xAccessibleStateSet.contains((short)18)) {
            bl = true;
            this.maTypeLabel.setText("multi selectable");
        } else {
            this.maTypeLabel.setText("single selectable");
        }
        if (this.mxContext.getAccessibleRole() != 58) {
            int n = this.mxContext.getAccessibleChildCount();
            for (int i = 0; i < n; ++i) {
                try {
                    XAccessible xAccessible = this.mxContext.getAccessibleChild(i);
                    XAccessibleContext xAccessibleContext = xAccessible.getAccessibleContext();
                    String string = i + " " + xAccessibleContext.getAccessibleName();
                    JCheckBox jCheckBox = new JCheckBox(string);
                    jCheckBox.setFont(this.maContainer.GetViewFont());
                    XAccessibleStateSet xAccessibleStateSet2 = this.mxContext.getAccessibleStateSet();
                    jCheckBox.setSelected(xAccessibleStateSet2 != null && xAccessibleStateSet2.contains((short)23));
                    jCheckBox.addActionListener(this);
                    this.maChildrenSelector.add(jCheckBox);
                    continue;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }
    }

    void SelectAll() {
        this.mxSelection.selectAllAccessibleChildren();
    }

    void ClearSelection() {
        this.mxSelection.clearAccessibleSelection();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Clear Selection")) {
            this.ClearSelection();
        } else if (string.equals("Select all")) {
            this.SelectAll();
        } else {
            String[] stringArray = string.split(" ");
            int n = Integer.parseInt(stringArray[0]);
            try {
                if (((JToggleButton)actionEvent.getSource()).isSelected()) {
                    this.mxSelection.selectAccessibleChild(n);
                } else {
                    this.mxSelection.deselectAccessibleChild(n);
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                System.err.println("caught exception while changing selection: " + (Object)((Object)indexOutOfBoundsException));
            }
        }
    }

    @Override
    public void notifyEvent(AccessibleEventObject accessibleEventObject) {
        switch (accessibleEventObject.EventId) {
            case 4: 
            case 7: 
            case 9: {
                this.Update();
            }
        }
    }
}

