/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.java.accessibility;

import com.sun.star.accessibility.XAccessibleComponent;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.awt.Point;
import com.sun.star.awt.Size;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.UnoRuntime;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;

public class AccessibleComponentImpl
implements AccessibleComponent {
    protected XAccessibleComponent unoObject;

    public AccessibleComponentImpl(XAccessibleComponent xAccessibleComponent) {
        this.unoObject = xAccessibleComponent;
    }

    protected boolean hasState(short s) {
        try {
            XAccessibleContext xAccessibleContext = (XAccessibleContext)UnoRuntime.queryInterface(XAccessibleContext.class, (Object)this.unoObject);
            return xAccessibleContext.getAccessibleStateSet().contains(s);
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
        catch (NullPointerException nullPointerException) {
            System.err.println("XAccessibleContext unsupported or no XAccessibleStateSet returned.");
            return false;
        }
    }

    @Override
    public Color getBackground() {
        try {
            return new Color(this.unoObject.getBackground());
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    @Override
    public void setBackground(Color color) {
    }

    @Override
    public Color getForeground() {
        try {
            return new Color(this.unoObject.getForeground());
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    @Override
    public void setForeground(Color color) {
    }

    @Override
    public Cursor getCursor() {
        return null;
    }

    @Override
    public void setCursor(Cursor cursor) {
    }

    @Override
    public Font getFont() {
        return null;
    }

    @Override
    public void setFont(Font font) {
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        return null;
    }

    @Override
    public boolean isEnabled() {
        return this.hasState((short)7);
    }

    @Override
    public void setEnabled(boolean bl) {
    }

    @Override
    public boolean isVisible() {
        return this.hasState((short)30);
    }

    @Override
    public void setVisible(boolean bl) {
    }

    @Override
    public boolean isShowing() {
        return this.hasState((short)25);
    }

    @Override
    public boolean contains(java.awt.Point point) {
        try {
            return this.unoObject.containsPoint(new Point(point.x, point.y));
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
    }

    @Override
    public java.awt.Point getLocationOnScreen() {
        try {
            Point point = this.unoObject.getLocationOnScreen();
            return new java.awt.Point(point.X, point.Y);
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    @Override
    public java.awt.Point getLocation() {
        try {
            Point point = this.unoObject.getLocation();
            return new java.awt.Point(point.X, point.Y);
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    @Override
    public void setLocation(java.awt.Point point) {
    }

    @Override
    public Rectangle getBounds() {
        try {
            com.sun.star.awt.Rectangle rectangle = this.unoObject.getBounds();
            return new Rectangle(rectangle.X, rectangle.Y, rectangle.Width, rectangle.Height);
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    @Override
    public void setBounds(Rectangle rectangle) {
    }

    @Override
    public Dimension getSize() {
        try {
            Size size = this.unoObject.getSize();
            return new Dimension(size.Width, size.Height);
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    @Override
    public void setSize(Dimension dimension) {
    }

    @Override
    public Accessible getAccessibleAt(java.awt.Point point) {
        return null;
    }

    @Override
    public boolean isFocusTraversable() {
        return this.hasState((short)10);
    }

    @Override
    public void requestFocus() {
        this.unoObject.grabFocus();
    }

    @Override
    public void addFocusListener(FocusListener focusListener) {
    }

    @Override
    public void removeFocusListener(FocusListener focusListener) {
    }
}

