/*
 * Decompiled with CFR 0.152.
 */
package net.domesdaybook.matcher.singlebyte;

import java.util.List;
import net.domesdaybook.matcher.singlebyte.ByteUtilities;
import net.domesdaybook.matcher.singlebyte.SingleByteMatcher;
import net.domesdaybook.reader.ByteReader;

public final class AnyBitMaskMatcher
implements SingleByteMatcher {
    final byte mBitMaskValue;

    public AnyBitMaskMatcher(byte bitMaskValue) {
        this.mBitMaskValue = bitMaskValue;
    }

    @Override
    public final boolean matches(ByteReader reader, long matchFrom) {
        return this.matches(reader.readByte(matchFrom));
    }

    @Override
    public final boolean matches(byte theByte) {
        return (theByte & this.mBitMaskValue) != 0;
    }

    @Override
    public final String toRegularExpression(boolean prettyPrint) {
        String regEx = String.format("~%02x", 0xFF & this.mBitMaskValue);
        return prettyPrint ? " " + regEx + " " : regEx;
    }

    @Override
    public final byte[] getMatchingBytes() {
        List<Byte> bytes = ByteUtilities.getBytesMatchingAnyBitMask(this.mBitMaskValue);
        int numBytes = bytes.size();
        byte[] values = new byte[numBytes];
        for (int index = 0; index < numBytes; ++index) {
            values[index] = bytes.get(index);
        }
        return values;
    }

    @Override
    public final int getNumberOfMatchingBytes() {
        return ByteUtilities.countBytesMatchingAnyBit(this.mBitMaskValue);
    }
}

