/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.command;

import java.io.PrintWriter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import uk.gov.nationalarchives.droid.command.action.CommandFactory;
import uk.gov.nationalarchives.droid.command.action.CommandFactoryImpl;
import uk.gov.nationalarchives.droid.command.action.CommandLineException;
import uk.gov.nationalarchives.droid.command.action.CommandLineParam;
import uk.gov.nationalarchives.droid.command.action.CommandLineSyntaxException;
import uk.gov.nationalarchives.droid.command.action.HelpCommand;
import uk.gov.nationalarchives.droid.command.context.SpringUiContext;
import uk.gov.nationalarchives.droid.command.i18n.I18N;
import uk.gov.nationalarchives.droid.core.interfaces.config.RuntimeConfig;

public final class DroidCommandLine {
    public static final String USAGE = "droid [options]";
    public static final int WRAP_WIDTH = 120;
    private final String[] args;
    private CommandFactory commandFactory;
    private CommandLine cli;
    private Log log = LogFactory.getLog(this.getClass());

    DroidCommandLine(String[] args, CommandFactory commandFactory) {
        this.args = args;
        this.commandFactory = commandFactory;
    }

    public void run() throws CommandLineException {
        GnuParser parser = new GnuParser();
        try {
            Option opt;
            this.cli = parser.parse(CommandLineParam.options(), this.args);
            String logThreshold = "INFO";
            if (this.cli.hasOption(CommandLineParam.QUIET.toString())) {
                logThreshold = "ERROR";
            }
            System.setProperty("consoleLogThreshold", logThreshold);
            CommandLineParam option = null;
            Option[] arr$ = this.cli.getOptions();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (option = CommandLineParam.TOP_LEVEL_COMMANDS.get((opt = arr$[i$]).getOpt())) == null; ++i$) {
            }
            if (option == null) {
                throw new CommandLineSyntaxException("No command line options specified");
            }
            option.getCommand(this.commandFactory, this.cli).execute();
        }
        catch (ParseException e) {
            throw new CommandLineSyntaxException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        RuntimeConfig.configureRuntimeEnvironment();
        SpringUiContext context = new SpringUiContext();
        try {
            PrintWriter out = new PrintWriter(System.out);
            CommandFactoryImpl commandFactory = new CommandFactoryImpl(context, out);
            DroidCommandLine commandLine = new DroidCommandLine(args, commandFactory);
            commandLine.run();
            out.close();
        }
        catch (CommandLineSyntaxException e) {
            PrintWriter err = new PrintWriter(System.err);
            HelpFormatter formatter = new HelpFormatter();
            formatter.printWrapped(err, 120, e.getMessage());
            formatter.printWrapped(err, 120, I18N.getResource("invalid.options"));
            HelpCommand help = new HelpCommand(err);
            help.execute();
            err.close();
        }
        catch (CommandLineException e) {
            PrintWriter err = new PrintWriter(System.err);
            HelpFormatter formatter = new HelpFormatter();
            formatter.printWrapped(err, 120, e.getMessage());
            err.close();
        }
        finally {
            context.close();
        }
    }

    public CommandLine getCommandLine() {
        return this.cli;
    }
}

