/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.command.action;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.ResourceBundle;
import javax.xml.bind.JAXBException;
import org.apache.commons.io.FileUtils;
import uk.gov.nationalarchives.droid.command.ResultPrinter;
import uk.gov.nationalarchives.droid.command.action.CommandExecutionException;
import uk.gov.nationalarchives.droid.command.action.DroidCommand;
import uk.gov.nationalarchives.droid.container.ContainerSignatureDefinitions;
import uk.gov.nationalarchives.droid.container.ContainerSignatureSaxParser;
import uk.gov.nationalarchives.droid.core.BinarySignatureIdentifier;
import uk.gov.nationalarchives.droid.core.SignatureParseException;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationResultCollection;
import uk.gov.nationalarchives.droid.core.interfaces.RequestIdentifier;
import uk.gov.nationalarchives.droid.core.interfaces.resource.FileSystemIdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.resource.RequestMetaData;

public class NoProfileRunCommand
implements DroidCommand {
    private static final String FORWARD_SLASH = "/";
    private static final String BACKWARD_SLASH = "\\";
    private static final String PRINTABLE_TRUE = "True";
    private static final String PRINTABLE_FALSE = "False";
    private String fileSignaturesFileName;
    private String containerSignaturesFileName;
    private String[] resources;
    private String[] extensions;
    private int maxBytesToScan = -1;
    private boolean quietFlag;
    private boolean recursive;
    private boolean archives;

    @Override
    public void execute() throws CommandExecutionException {
        String slash;
        File dirToSearch;
        if (!this.quietFlag) {
            this.outputRuntimeInformation();
        }
        if (!(dirToSearch = new File(this.resources[0])).isDirectory()) {
            throw new CommandExecutionException("Resources directory not found");
        }
        BinarySignatureIdentifier binarySignatureIdentifier = new BinarySignatureIdentifier();
        File fileSignaturesFile = new File(this.fileSignaturesFileName);
        if (!fileSignaturesFile.exists()) {
            throw new CommandExecutionException("Signature file not found");
        }
        binarySignatureIdentifier.setSignatureFile(this.fileSignaturesFileName);
        try {
            binarySignatureIdentifier.init();
        }
        catch (SignatureParseException e) {
            throw new CommandExecutionException("Can't parse signature file");
        }
        binarySignatureIdentifier.setMaxBytesToScan((long)this.maxBytesToScan);
        String path = fileSignaturesFile.getAbsolutePath();
        String slash1 = slash = path.contains(FORWARD_SLASH) ? FORWARD_SLASH : BACKWARD_SLASH;
        ContainerSignatureDefinitions containerSignatureDefinitions = null;
        if (this.containerSignaturesFileName != null) {
            File containerSignaturesFile = new File(this.containerSignaturesFileName);
            if (!containerSignaturesFile.exists()) {
                throw new CommandExecutionException("Container signature file not found");
            }
            try {
                FileInputStream in = new FileInputStream(this.containerSignaturesFileName);
                ContainerSignatureSaxParser parser = new ContainerSignatureSaxParser();
                containerSignatureDefinitions = parser.parse((InputStream)in);
            }
            catch (SignatureParseException e) {
                throw new CommandExecutionException("Can't parse container signature file");
            }
            catch (IOException ioe) {
                throw new CommandExecutionException(ioe);
            }
            catch (JAXBException jaxbe) {
                throw new CommandExecutionException(jaxbe);
            }
        }
        path = "";
        ResultPrinter resultPrinter = new ResultPrinter(binarySignatureIdentifier, containerSignatureDefinitions, path, slash, slash1, this.archives);
        Collection matchedFiles = FileUtils.listFiles((File)dirToSearch, (String[])this.extensions, (boolean)this.recursive);
        String fileName = null;
        for (File file : matchedFiles) {
            try {
                fileName = file.getCanonicalPath();
            }
            catch (IOException e) {
                throw new CommandExecutionException(e);
            }
            URI uri = file.toURI();
            RequestMetaData metaData = new RequestMetaData(Long.valueOf(file.length()), Long.valueOf(file.lastModified()), fileName);
            RequestIdentifier identifier = new RequestIdentifier(uri);
            identifier.setParentId(Long.valueOf(1L));
            FileInputStream in = null;
            FileSystemIdentificationRequest request = new FileSystemIdentificationRequest(metaData, identifier);
            try {
                in = new FileInputStream(file);
                request.open((InputStream)in);
                IdentificationResultCollection results = binarySignatureIdentifier.matchBinarySignatures((IdentificationRequest)request);
                resultPrinter.print(results, (IdentificationRequest)request);
            }
            catch (IOException e) {
                throw new CommandExecutionException(e);
            }
            finally {
                if (in == null) continue;
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    throw new CommandExecutionException(e);
                }
            }
        }
    }

    private void outputRuntimeInformation() {
        String versionString = ResourceBundle.getBundle("options").getString("version_no");
        System.out.println("DROID " + versionString + " No Profile mode: Runtime Information");
        System.out.println("Resource folder: " + this.resources[0]);
        System.out.println("Binary signature file: " + this.fileSignaturesFileName);
        if (this.containerSignaturesFileName == null) {
            System.out.println("Container signature file: None");
        } else {
            System.out.println("Container signature file: " + this.containerSignaturesFileName);
        }
        if (this.extensions == null) {
            System.out.println("Extension filter: No filter set");
        } else {
            System.out.println("Extension filter: " + Arrays.toString(this.extensions).replace("[", "").replace("]", "").trim());
        }
        System.out.println("Recurse folders: " + (this.recursive ? PRINTABLE_TRUE : PRINTABLE_FALSE));
        System.out.println("Open archives: " + (this.archives ? PRINTABLE_TRUE : PRINTABLE_FALSE));
    }

    public void setResources(String[] resources) {
        this.resources = resources;
    }

    public void setSignatureFile(String signatureFile) {
        this.fileSignaturesFileName = signatureFile;
    }

    public void setContainerSignatureFile(String containerSignatureFile) {
        this.containerSignaturesFileName = containerSignatureFile;
    }

    public void setArchives(boolean archives) {
        this.archives = archives;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public void setExtensionFilter(String[] extensionsFilter) {
        this.extensions = extensionsFilter;
    }

    public void setQuiet(boolean quiet) {
        this.quietFlag = quiet;
    }
}

