/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.command.filter;

import java.util.ArrayList;
import java.util.List;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.tree.CommonTree;
import org.apache.commons.lang.StringUtils;
import uk.gov.nationalarchives.droid.command.filter.AntlrUtils;
import uk.gov.nationalarchives.droid.command.filter.DqlCriterionFactory;
import uk.gov.nationalarchives.droid.command.filter.DqlFilterParser;
import uk.gov.nationalarchives.droid.command.filter.DqlParseException;
import uk.gov.nationalarchives.droid.core.interfaces.filter.FilterCriterion;

public class AntlrDqlParser
implements DqlFilterParser {
    private static final String SINGLE_QUOTE = "'";

    @Override
    public FilterCriterion parse(String dql) {
        try {
            FilterCriterion criterion;
            CommonTree tree = AntlrUtils.parseDqlToAbstractSytntaxTree(dql);
            List children = tree.getChildren();
            CommonTree field = (CommonTree)children.get(0);
            String dqlField = field.getText();
            CommonTree operator = (CommonTree)children.get(1);
            String dqlOperator = operator.getText();
            CommonTree values = (CommonTree)children.get(2);
            List setValues = values.getChildren();
            if (setValues == null) {
                String dqlValue = values.getText();
                criterion = DqlCriterionFactory.newCriterion(dqlField, dqlOperator, AntlrDqlParser.fromDqlString(dqlValue));
            } else {
                ArrayList<String> dqlValues = new ArrayList<String>();
                for (CommonTree element : setValues) {
                    dqlValues.add(element.getText());
                }
                criterion = DqlCriterionFactory.newCriterion(dqlField, dqlOperator, dqlValues);
            }
            return criterion;
        }
        catch (RecognitionException e) {
            throw new DqlParseException(e);
        }
    }

    private static String fromDqlString(String dqlString) {
        return StringUtils.strip((String)dqlString, (String)SINGLE_QUOTE).replace("\\'", SINGLE_QUOTE);
    }
}

