/*
 * Decompiled with CFR 0.152.
 */
package net.domesdaybook.matcher.singlebyte;

import net.domesdaybook.matcher.singlebyte.ByteUtilities;
import net.domesdaybook.matcher.singlebyte.InvertibleMatcher;
import net.domesdaybook.matcher.singlebyte.SingleByteMatcher;
import net.domesdaybook.reader.ByteReader;

public final class ByteSetRangeMatcher
extends InvertibleMatcher
implements SingleByteMatcher {
    private static final String ILLEGAL_ARGUMENTS = "Values must be between 0 and 255 inclusive: min=%d max=%d";
    private final int minByteValue;
    private final int maxByteValue;

    public ByteSetRangeMatcher(int minValue, int maxValue, boolean inverted) {
        super(inverted);
        if (minValue < 0 || minValue > 255 || maxValue < 0 || maxValue > 255) {
            String error = String.format(ILLEGAL_ARGUMENTS, minValue, maxValue);
            throw new IllegalArgumentException(error);
        }
        if (minValue > maxValue) {
            int tempValue = minValue;
            this.minByteValue = maxValue;
            this.maxByteValue = tempValue;
        } else {
            this.minByteValue = minValue;
            this.maxByteValue = maxValue;
        }
    }

    @Override
    public final boolean matches(ByteReader reader, long matchFrom) {
        return this.matches(reader.readByte(matchFrom));
    }

    @Override
    public final boolean matches(byte theByte) {
        int byteValue = theByte & 0xFF;
        boolean insideRange = byteValue >= this.minByteValue && byteValue <= this.maxByteValue;
        return insideRange ^ this.inverted;
    }

    @Override
    public final String toRegularExpression(boolean prettyPrint) {
        StringBuffer regularExpression = new StringBuffer();
        if (prettyPrint) {
            regularExpression.append(" ");
        }
        regularExpression.append("[");
        if (this.inverted) {
            regularExpression.append("^");
        }
        String minValue = ByteUtilities.byteToString(prettyPrint, this.minByteValue);
        String maxValue = ByteUtilities.byteToString(prettyPrint, this.maxByteValue);
        regularExpression.append(String.format("%s-%s]", minValue, maxValue));
        if (prettyPrint) {
            regularExpression.append(" ");
        }
        return regularExpression.toString();
    }

    @Override
    public final byte[] getMatchingBytes() {
        byte[] values = new byte[this.getNumberOfMatchingBytes()];
        if (this.inverted) {
            int value;
            int byteIndex = 0;
            for (value = 0; value < this.minByteValue; ++value) {
                values[byteIndex++] = (byte)value;
            }
            for (value = this.maxByteValue + 1; value < 256; ++value) {
                values[byteIndex++] = (byte)value;
            }
        } else {
            int byteIndex = 0;
            for (int value = this.minByteValue; value <= this.maxByteValue; ++value) {
                values[byteIndex++] = (byte)value;
            }
        }
        return values;
    }

    @Override
    public final int getNumberOfMatchingBytes() {
        return this.inverted ? 255 - this.maxByteValue + this.minByteValue : this.maxByteValue - this.minByteValue + 1;
    }
}

