/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.interfaces.resource;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.collections.FunctorException;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.collections.map.LazyMap;
import uk.gov.nationalarchives.droid.core.interfaces.resource.CachedBytes;
import uk.gov.nationalarchives.droid.core.interfaces.resource.ResourceUtils;

public final class CachedByteArrays
implements CachedBytes {
    private static final String READ_ONLY = "r";
    private final Map<Long, byte[]> cache;
    private File source;
    private RandomAccessFile raf;
    private int bufferCapacity;
    private long currentBufferStart;
    private long currentBufferEnd;
    private byte[] currentBuffer;
    private int limit;

    public CachedByteArrays(int blocks, int blockCapacity, byte[] blockZero, int limit) {
        this.cache = LazyMap.decorate((Map)new LRUMap(blocks), (Transformer)new CacheTransformer());
        this.bufferCapacity = blockCapacity;
        this.cache.put(0L, blockZero);
        this.currentBuffer = blockZero;
        this.currentBufferStart = 0L;
        this.currentBufferEnd = this.bufferCapacity - 1;
        this.limit = limit;
    }

    void setRaf(RandomAccessFile file) throws IOException {
        if (this.raf != null) {
            this.raf.close();
        }
        this.raf = file;
    }

    public byte readByte(long position) {
        if (position > this.currentBufferEnd || position < this.currentBufferStart) {
            long blockStart = position - position % (long)this.bufferCapacity;
            this.currentBuffer = this.cache.get(blockStart);
            this.currentBufferStart = blockStart;
            this.currentBufferEnd = blockStart + (long)this.bufferCapacity - 1L;
        }
        return this.currentBuffer[(int)(position - this.currentBufferStart)];
    }

    @Override
    public void close() throws IOException {
        if (this.raf != null) {
            this.raf.close();
        }
    }

    Map<Long, byte[]> getBuffer() {
        return this.cache;
    }

    RandomAccessFile getRaf() {
        return this.raf;
    }

    @Override
    public InputStream getSourceInputStream() throws IOException {
        InputStream in = null;
        try {
            if (this.raf == null) {
                byte[] bytes = this.cache.get(0L);
                if (bytes.length > this.limit) {
                    bytes = Arrays.copyOf(bytes, this.limit);
                }
                in = new ByteArrayInputStream(bytes);
            } else {
                in = new FileInputStream(this.source);
            }
            return in;
        }
        catch (RuntimeException ex) {
            if (in != null) {
                in.close();
            }
            throw ex;
        }
    }

    @Override
    public File getSourceFile() {
        return this.source;
    }

    @Override
    public void setSourceFile(File sourceFile) throws IOException {
        this.source = sourceFile;
        if (this.raf != null) {
            this.raf.close();
        }
        this.raf = new RandomAccessFile(this.source, READ_ONLY);
    }

    private final class CacheTransformer
    implements Transformer {
        private CacheTransformer() {
        }

        public Object transform(Object input) {
            Long block = (Long)input;
            try {
                byte[] buffer = new byte[CachedByteArrays.this.bufferCapacity];
                CachedByteArrays.this.raf.seek(block);
                ResourceUtils.readBuffer(CachedByteArrays.this.raf, buffer);
                return buffer;
            }
            catch (IOException e) {
                String message = "Error reading from file into CachedByteArray.";
                throw new FunctorException("Error reading from file into CachedByteArray.", (Throwable)e);
            }
        }
    }
}

