/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.interfaces.resource;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import net.domesdaybook.reader.ByteReader;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.RequestIdentifier;
import uk.gov.nationalarchives.droid.core.interfaces.resource.CachedByteArray;
import uk.gov.nationalarchives.droid.core.interfaces.resource.CachedByteArrays;
import uk.gov.nationalarchives.droid.core.interfaces.resource.CachedBytes;
import uk.gov.nationalarchives.droid.core.interfaces.resource.RequestMetaData;
import uk.gov.nationalarchives.droid.core.interfaces.resource.ResourceUtils;

public class FileSystemIdentificationRequest
implements IdentificationRequest {
    private static final int BUFFER_CACHE_CAPACITY = 16;
    private static final int CAPACITY = 32768;
    private final String extension;
    private final String fileName;
    private final long size;
    private CachedBytes cachedBinary;
    private final RequestIdentifier identifier;
    private final int lruCapacity;
    private final int bufferCapacity;
    private RequestMetaData requestMetaData;

    FileSystemIdentificationRequest(RequestMetaData metaData, RequestIdentifier identifier, int lruCapacity, int bufferCapacity) {
        this.identifier = identifier;
        this.requestMetaData = metaData;
        this.size = metaData.getSize();
        this.fileName = metaData.getName();
        this.extension = ResourceUtils.getExtension(this.fileName);
        this.lruCapacity = lruCapacity;
        this.bufferCapacity = bufferCapacity;
    }

    public FileSystemIdentificationRequest(RequestMetaData metaData, RequestIdentifier identifier) {
        this(metaData, identifier, 16, 32768);
    }

    @Override
    public final void open(InputStream in) throws IOException {
        byte[] firstBuffer = new byte[this.bufferCapacity];
        int bytesRead = ResourceUtils.readBuffer(in, firstBuffer);
        if (bytesRead < 1) {
            firstBuffer = new byte[]{};
            this.cachedBinary = new CachedByteArray(firstBuffer, 0);
        } else {
            this.cachedBinary = bytesRead < this.bufferCapacity ? new CachedByteArray(firstBuffer, bytesRead) : new CachedByteArrays(this.lruCapacity, this.bufferCapacity, firstBuffer, this.bufferCapacity);
        }
        File theFile = new File(this.identifier.getUri());
        this.cachedBinary.setSourceFile(theFile);
    }

    @Override
    public final byte getByte(long position) {
        return this.cachedBinary.readByte(position);
    }

    @Override
    public final String getExtension() {
        return this.extension;
    }

    @Override
    public final String getFileName() {
        return this.fileName;
    }

    @Override
    public final long size() {
        return this.size;
    }

    @Override
    public final void close() throws IOException {
        this.cachedBinary.close();
    }

    final CachedBytes getCache() {
        return this.cachedBinary;
    }

    @Override
    public final InputStream getSourceInputStream() throws IOException {
        return this.cachedBinary.getSourceInputStream();
    }

    @Override
    public final RequestMetaData getRequestMetaData() {
        return this.requestMetaData;
    }

    @Override
    public final RequestIdentifier getIdentifier() {
        return this.identifier;
    }

    @Override
    public final ByteReader getReader() {
        return this.cachedBinary;
    }

    @Override
    public final File getSourceFile() throws IOException {
        return this.cachedBinary.getSourceFile();
    }
}

