/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.signature.droid6;

import java.util.ArrayList;
import java.util.List;
import uk.gov.nationalarchives.droid.core.signature.ByteReader;
import uk.gov.nationalarchives.droid.core.signature.droid6.SubSequence;
import uk.gov.nationalarchives.droid.core.signature.xml.SimpleElement;

public class ByteSequence
extends SimpleElement {
    private static final String HEX_FORMAT = "%02x";
    private static final int END_PRINTABLE_ASCII_CHARS = 126;
    private static final int START_PRINTABLE_ASCII_CHARS = 32;
    private static final int BYTEMASK = 255;
    private static final int BYTEVALUES = 256;
    private static final int SORT1 = 1;
    private static final int SORT2 = 2;
    private static final int SORT3 = 3;
    private static final int SORT4 = 4;
    private static final int SORT5 = 5;
    private static final String BOF_OFFSET = "BOFoffset";
    private static final String EOF_OFFSET = "EOFoffset";
    private static final int QUOTE_CHARACTER_VALUE = 39;
    private List<SubSequence> subSequences = new ArrayList<SubSequence>();
    private SubSequence[] sequences = new SubSequence[0];
    private String reference = "Variable";
    private boolean bigEndian = true;
    private boolean hasIndirectOffset;
    private boolean anchoredToBOF;
    private boolean anchoredToEOF;
    private boolean reverseOrder;
    private boolean isFixedStart;
    private int indirectOffsetLength;
    private int indirectOffsetLocation;
    private int sortOrder;
    private boolean isInvalidByteSequence;

    public final boolean isAnchoredToBOF() {
        return this.anchoredToBOF;
    }

    public final boolean isAnchoredToEOF() {
        return this.anchoredToEOF;
    }

    public final int getSortOrder() {
        return this.sortOrder;
    }

    public final String getReference() {
        return this.reference;
    }

    public final void addSubSequence(SubSequence sseq) {
        this.subSequences.add(sseq);
    }

    public final int getNumberOfSubSequences() {
        return this.subSequences.size();
    }

    public final void setReference(String theRef) {
        this.hasIndirectOffset = theRef.startsWith("Indirect");
        this.anchoredToEOF = theRef.endsWith(EOF_OFFSET);
        this.anchoredToBOF = theRef.endsWith(BOF_OFFSET);
        this.isFixedStart = this.anchoredToEOF || this.anchoredToBOF;
        this.reverseOrder = theRef.equalsIgnoreCase(EOF_OFFSET);
        this.reference = theRef;
    }

    public final void setEndianness(String endianness) {
        this.bigEndian = !"Little-endian".equals(endianness);
    }

    public final void setIndirectOffsetLength(String indirectOffsetLength) {
        this.indirectOffsetLength = Integer.parseInt(indirectOffsetLength);
    }

    public final void setIndirectOffsetLocation(String indirectOffsetLocation) {
        this.indirectOffsetLocation = Integer.parseInt(indirectOffsetLocation);
    }

    @Override
    public final void setAttributeValue(String name, String value) {
        if ("Reference".equals(name)) {
            this.setReference(value);
        } else if ("Endianness".equals(name)) {
            this.setEndianness(value);
        } else if ("IndirectOffsetLength".equals(name)) {
            this.setIndirectOffsetLength(value);
        } else if ("IndirectOffsetLocation".equals(name)) {
            this.setIndirectOffsetLocation(value);
        } else {
            this.unknownAttributeWarning(name, this.getElementName());
        }
    }

    private SubSequence getSubSequence(int theIndex) {
        return this.subSequences.get(theIndex);
    }

    public final void prepareForUse() {
        int noOfSubSequences = this.subSequences.size();
        this.sortOrder = this.anchoredToBOF ? (noOfSubSequences == 1 ? 1 : 2) : (this.anchoredToEOF ? (noOfSubSequences == 1 ? 3 : 4) : 5);
        this.prepareSequenceFragments();
    }

    private void prepareSequenceFragments() {
        int firstSequenceToMatch = this.reverseOrder ? this.subSequences.size() - 1 : 0;
        int stop = this.subSequences.size();
        for (int subSequenceIndex = 0; subSequenceIndex < stop; ++subSequenceIndex) {
            boolean fullFileScan = subSequenceIndex != firstSequenceToMatch || !this.isFixedStart;
            SubSequence sequence = this.getSubSequence(subSequenceIndex);
            sequence.prepareForUse(this.reverseOrder, fullFileScan);
            if (!sequence.isInvalidSubSequence()) continue;
            this.isInvalidByteSequence = true;
            break;
        }
        this.sequences = this.subSequences.toArray(this.sequences);
    }

    public boolean isInvalidByteSequence() {
        return this.isInvalidByteSequence;
    }

    private int getIndirectOffset(ByteReader targetFile) {
        int offset;
        block5: {
            offset = 0;
            if (!this.hasIndirectOffset) break block5;
            long power = 1L;
            long offsetLocation = this.indirectOffsetLocation;
            int offsetLength = this.indirectOffsetLength;
            if (this.anchoredToEOF) {
                offsetLocation = targetFile.getNumBytes() - offsetLocation - 1L;
            }
            net.domesdaybook.reader.ByteReader reader = targetFile.getReader();
            if (this.bigEndian) {
                for (int byteIndex = offsetLength - 1; byteIndex > -1; --byteIndex) {
                    Byte fileByte = reader.readByte(offsetLocation + (long)byteIndex);
                    int byteValue = fileByte.intValue();
                    byteValue = byteValue >= 0 ? byteValue : byteValue + 256;
                    offset = (int)((long)offset + power * (long)byteValue);
                    power *= 256L;
                }
            } else {
                for (int byteIndex = 0; byteIndex < offsetLength; ++byteIndex) {
                    Byte fileByte = reader.readByte(offsetLocation + (long)byteIndex);
                    int byteValue = fileByte.intValue();
                    byteValue = byteValue >= 0 ? byteValue : byteValue + 256;
                    offset = (int)((long)offset + power * (long)byteValue);
                    power *= 256L;
                }
            }
        }
        return offset;
    }

    public final boolean matches(ByteReader targetFile, long maxBytesToScan) {
        boolean matchResult = true;
        SubSequence[] seq = this.sequences;
        if (this.reverseOrder) {
            boolean fixedSubsequence = this.anchoredToEOF;
            long fileSize = targetFile.getNumBytes() - 1L;
            targetFile.setFileMarker(fileSize);
            for (int subSequenceIndex = seq.length - 1; matchResult && subSequenceIndex >= 0; --subSequenceIndex) {
                SubSequence subseq = seq[subSequenceIndex];
                long currentFilePos = targetFile.getFileMarker();
                matchResult = subseq.findSequenceFromPosition(currentFilePos, targetFile, maxBytesToScan, false, fixedSubsequence);
                fixedSubsequence = false;
            }
        } else {
            boolean fixedSubsequence = this.anchoredToBOF;
            long offset = this.getIndirectOffset(targetFile);
            targetFile.setFileMarker(offset);
            for (int subSequenceIndex = 0; matchResult && subSequenceIndex < seq.length; ++subSequenceIndex) {
                SubSequence subseq = seq[subSequenceIndex];
                long currentFilePos = targetFile.getFileMarker();
                matchResult = subseq.findSequenceFromPosition(currentFilePos, targetFile, maxBytesToScan, fixedSubsequence, false);
                fixedSubsequence = false;
            }
        }
        return matchResult;
    }

    public final String toRegularExpression(boolean prettyPrint) {
        StringBuffer regularExpression = new StringBuffer();
        int numSequences = this.subSequences.size();
        for (int subSequenceIndex = 0; subSequenceIndex < numSequences; ++subSequenceIndex) {
            SubSequence subseq = this.subSequences.get(subSequenceIndex);
            int minSeqOffset = subseq.getMinSeqOffset();
            int maxSeqOffset = subseq.getMaxSeqOffset();
            String subSeqExpression = subseq.toRegularExpression(prettyPrint);
            ByteSequence.appendBoundedGapExpression(prettyPrint, this.reverseOrder, regularExpression, subSeqExpression, minSeqOffset, subSequenceIndex == 0 ? maxSeqOffset : -1);
        }
        return regularExpression.toString().trim();
    }

    public static final String bytesToString(boolean prettyPrint, byte[] bytes) {
        StringBuffer hexString = new StringBuffer();
        boolean inString = false;
        int byteLength = bytes.length;
        for (int byteIndex = 0; byteIndex < byteLength; ++byteIndex) {
            String formatString;
            int byteValue = 0xFF & bytes[byteIndex];
            if (prettyPrint && byteValue >= 32 && byteValue <= 126 && byteValue != 39) {
                formatString = inString ? "%c" : " '%c";
                hexString.append(String.format(formatString, Character.valueOf((char)byteValue)));
                inString = true;
                continue;
            }
            formatString = prettyPrint ? (inString ? "' %02x" : HEX_FORMAT) : HEX_FORMAT;
            hexString.append(String.format(formatString, byteValue));
            inString = false;
        }
        if (prettyPrint && inString) {
            hexString.append("' ");
        }
        return hexString.toString();
    }

    public static final String byteValueToString(boolean prettyPrint, int byteValue) {
        byte theByte = (byte)(0xFF & byteValue);
        byte[] singleByte = new byte[]{theByte};
        return ByteSequence.bytesToString(prettyPrint, singleByte);
    }

    public static void appendBoundedGap(boolean prettyPrint, StringBuffer buffer, int minGap, int maxGap) {
        if (maxGap < 0) {
            if (minGap > 0) {
                String formatString = prettyPrint ? "  {%d-*}  " : "{%d-*}";
                buffer.append(String.format(formatString, minGap));
            } else {
                buffer.append(prettyPrint ? "  *  " : "*");
            }
        } else if (minGap > 0 || maxGap > 0) {
            if (minGap == maxGap) {
                String formatString = prettyPrint ? " {%d} " : "{%d}";
                buffer.append(String.format(formatString, minGap));
            } else {
                String formatString = prettyPrint ? " {%d-%d} " : "{%d-%d}";
                buffer.append(String.format(formatString, minGap, maxGap));
            }
        }
    }

    public static void appendBoundedGapExpression(boolean prettyPrint, boolean expressionFirst, StringBuffer buffer, String expression, int min, int max) {
        if (expressionFirst) {
            buffer.append(expression);
            ByteSequence.appendBoundedGap(prettyPrint, buffer, min, max);
        } else {
            ByteSequence.appendBoundedGap(prettyPrint, buffer, min, max);
            buffer.append(expression);
        }
    }
}

