/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CompoundFileWriter;
import org.apache.lucene.index.ConcurrentMergeScheduler;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DocumentsWriter;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexFileDeleter;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.KeepOnlyLastCommitDeletionPolicy;
import org.apache.lucene.index.LogByteSizeMergePolicy;
import org.apache.lucene.index.LogDocMergePolicy;
import org.apache.lucene.index.LogMergePolicy;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentMerger;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.util.BitVector;

public class IndexWriter {
    public static long WRITE_LOCK_TIMEOUT;
    private long writeLockTimeout = WRITE_LOCK_TIMEOUT;
    public static final String WRITE_LOCK_NAME = "write.lock";
    public static final int DEFAULT_MERGE_FACTOR = 10;
    public static final int DISABLE_AUTO_FLUSH = -1;
    public static final int DEFAULT_MAX_BUFFERED_DOCS = -1;
    public static final double DEFAULT_RAM_BUFFER_SIZE_MB = 16.0;
    public static final int DEFAULT_MAX_BUFFERED_DELETE_TERMS = -1;
    public static final int DEFAULT_MAX_MERGE_DOCS = Integer.MAX_VALUE;
    public static final int DEFAULT_MAX_FIELD_LENGTH = 10000;
    public static final int DEFAULT_TERM_INDEX_INTERVAL = 128;
    public static final int MAX_TERM_LENGTH;
    private static final int MERGE_READ_BUFFER_SIZE = 4096;
    private static Object MESSAGE_ID_LOCK;
    private static int MESSAGE_ID;
    private int messageID = -1;
    private volatile boolean hitOOM;
    private Directory directory;
    private Analyzer analyzer;
    private Similarity similarity = Similarity.getDefault();
    private boolean commitPending;
    private SegmentInfos rollbackSegmentInfos;
    private SegmentInfos localRollbackSegmentInfos;
    private boolean localAutoCommit;
    private boolean autoCommit = true;
    private SegmentInfos segmentInfos = new SegmentInfos();
    private DocumentsWriter docWriter;
    private IndexFileDeleter deleter;
    private Set segmentsToOptimize = new HashSet();
    private Lock writeLock;
    private int termIndexInterval = 128;
    private boolean closeDir;
    private boolean closed;
    private boolean closing;
    private HashSet mergingSegments = new HashSet();
    private MergePolicy mergePolicy = new LogByteSizeMergePolicy();
    private MergeScheduler mergeScheduler = new ConcurrentMergeScheduler();
    private LinkedList pendingMerges = new LinkedList();
    private Set runningMerges = new HashSet();
    private List mergeExceptions = new ArrayList();
    private long mergeGen;
    private boolean stopMerges;
    private int maxFieldLength = 10000;
    private PrintStream infoStream = null;
    private static PrintStream defaultInfoStream;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected final void ensureOpen() throws AlreadyClosedException {
        if (this.closed) {
            throw new AlreadyClosedException("this IndexWriter is closed");
        }
    }

    public void message(String message) {
        if (this.infoStream != null) {
            this.infoStream.println("IW " + this.messageID + " [" + Thread.currentThread().getName() + "]: " + message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void setMessageID() {
        if (this.infoStream != null && this.messageID == -1) {
            Object object = MESSAGE_ID_LOCK;
            synchronized (object) {
                this.messageID = MESSAGE_ID++;
            }
        }
    }

    private LogMergePolicy getLogMergePolicy() {
        if (this.mergePolicy instanceof LogMergePolicy) {
            return (LogMergePolicy)this.mergePolicy;
        }
        throw new IllegalArgumentException("this method can only be called when the merge policy is the default LogMergePolicy");
    }

    public boolean getUseCompoundFile() {
        return this.getLogMergePolicy().getUseCompoundFile();
    }

    public void setUseCompoundFile(boolean value) {
        this.getLogMergePolicy().setUseCompoundFile(value);
        this.getLogMergePolicy().setUseCompoundDocStore(value);
    }

    public void setSimilarity(Similarity similarity) {
        this.ensureOpen();
        this.similarity = similarity;
    }

    public Similarity getSimilarity() {
        this.ensureOpen();
        return this.similarity;
    }

    public void setTermIndexInterval(int interval) {
        this.ensureOpen();
        this.termIndexInterval = interval;
    }

    public int getTermIndexInterval() {
        this.ensureOpen();
        return this.termIndexInterval;
    }

    public IndexWriter(String path, Analyzer a, boolean create) throws CorruptIndexException, LockObtainFailedException, IOException {
        this.init(FSDirectory.getDirectory(path), a, create, true, null, true);
    }

    public IndexWriter(File path, Analyzer a, boolean create) throws CorruptIndexException, LockObtainFailedException, IOException {
        this.init(FSDirectory.getDirectory(path), a, create, true, null, true);
    }

    public IndexWriter(Directory d, Analyzer a, boolean create) throws CorruptIndexException, LockObtainFailedException, IOException {
        this.init(d, a, create, false, null, true);
    }

    public IndexWriter(String path, Analyzer a) throws CorruptIndexException, LockObtainFailedException, IOException {
        this.init(FSDirectory.getDirectory(path), a, true, null, true);
    }

    public IndexWriter(File path, Analyzer a) throws CorruptIndexException, LockObtainFailedException, IOException {
        this.init(FSDirectory.getDirectory(path), a, true, null, true);
    }

    public IndexWriter(Directory d, Analyzer a) throws CorruptIndexException, LockObtainFailedException, IOException {
        this.init(d, a, false, null, true);
    }

    public IndexWriter(Directory d, boolean autoCommit, Analyzer a) throws CorruptIndexException, LockObtainFailedException, IOException {
        this.init(d, a, false, null, autoCommit);
    }

    public IndexWriter(Directory d, boolean autoCommit, Analyzer a, boolean create) throws CorruptIndexException, LockObtainFailedException, IOException {
        this.init(d, a, create, false, null, autoCommit);
    }

    public IndexWriter(Directory d, boolean autoCommit, Analyzer a, IndexDeletionPolicy deletionPolicy) throws CorruptIndexException, LockObtainFailedException, IOException {
        this.init(d, a, false, deletionPolicy, autoCommit);
    }

    public IndexWriter(Directory d, boolean autoCommit, Analyzer a, boolean create, IndexDeletionPolicy deletionPolicy) throws CorruptIndexException, LockObtainFailedException, IOException {
        this.init(d, a, create, false, deletionPolicy, autoCommit);
    }

    private void init(Directory d, Analyzer a, boolean closeDir, IndexDeletionPolicy deletionPolicy, boolean autoCommit) throws CorruptIndexException, LockObtainFailedException, IOException {
        if (IndexReader.indexExists(d)) {
            this.init(d, a, false, closeDir, deletionPolicy, autoCommit);
        } else {
            this.init(d, a, true, closeDir, deletionPolicy, autoCommit);
        }
    }

    private void init(Directory d, Analyzer a, boolean create, boolean closeDir, IndexDeletionPolicy deletionPolicy, boolean autoCommit) throws CorruptIndexException, LockObtainFailedException, IOException {
        Lock writeLock;
        this.closeDir = closeDir;
        this.directory = d;
        this.analyzer = a;
        this.infoStream = defaultInfoStream;
        this.setMessageID();
        if (create) {
            this.directory.clearLock(WRITE_LOCK_NAME);
        }
        if (!(writeLock = this.directory.makeLock(WRITE_LOCK_NAME)).obtain(this.writeLockTimeout)) {
            throw new LockObtainFailedException("Index locked for write: " + writeLock);
        }
        this.writeLock = writeLock;
        try {
            if (create) {
                try {
                    this.segmentInfos.read(this.directory);
                    this.segmentInfos.clear();
                }
                catch (IOException e) {
                    // empty catch block
                }
                this.segmentInfos.write(this.directory);
            } else {
                this.segmentInfos.read(this.directory);
            }
            this.autoCommit = autoCommit;
            if (!autoCommit) {
                this.rollbackSegmentInfos = (SegmentInfos)this.segmentInfos.clone();
            }
            this.docWriter = new DocumentsWriter(this.directory, this);
            this.docWriter.setInfoStream(this.infoStream);
            this.deleter = new IndexFileDeleter(this.directory, deletionPolicy == null ? new KeepOnlyLastCommitDeletionPolicy() : deletionPolicy, this.segmentInfos, this.infoStream, this.docWriter);
            this.pushMaxBufferedDocs();
            if (this.infoStream != null) {
                this.message("init: create=" + create);
                this.messageState();
            }
        }
        catch (IOException e) {
            this.writeLock.release();
            this.writeLock = null;
            throw e;
        }
    }

    public void setMergePolicy(MergePolicy mp) {
        this.ensureOpen();
        if (mp == null) {
            throw new NullPointerException("MergePolicy must be non-null");
        }
        if (this.mergePolicy != mp) {
            this.mergePolicy.close();
        }
        this.mergePolicy = mp;
        this.pushMaxBufferedDocs();
        if (this.infoStream != null) {
            this.message("setMergePolicy " + mp);
        }
    }

    public MergePolicy getMergePolicy() {
        this.ensureOpen();
        return this.mergePolicy;
    }

    public void setMergeScheduler(MergeScheduler mergeScheduler) throws CorruptIndexException, IOException {
        this.ensureOpen();
        if (mergeScheduler == null) {
            throw new NullPointerException("MergeScheduler must be non-null");
        }
        if (this.mergeScheduler != mergeScheduler) {
            this.finishMerges(true);
            this.mergeScheduler.close();
        }
        this.mergeScheduler = mergeScheduler;
        if (this.infoStream != null) {
            this.message("setMergeScheduler " + mergeScheduler);
        }
    }

    public MergeScheduler getMergeScheduler() {
        this.ensureOpen();
        return this.mergeScheduler;
    }

    public void setMaxMergeDocs(int maxMergeDocs) {
        this.getLogMergePolicy().setMaxMergeDocs(maxMergeDocs);
    }

    public int getMaxMergeDocs() {
        return this.getLogMergePolicy().getMaxMergeDocs();
    }

    public void setMaxFieldLength(int maxFieldLength) {
        this.ensureOpen();
        this.maxFieldLength = maxFieldLength;
        if (this.infoStream != null) {
            this.message("setMaxFieldLength " + maxFieldLength);
        }
    }

    public int getMaxFieldLength() {
        this.ensureOpen();
        return this.maxFieldLength;
    }

    public void setMaxBufferedDocs(int maxBufferedDocs) {
        this.ensureOpen();
        if (maxBufferedDocs != -1 && maxBufferedDocs < 2) {
            throw new IllegalArgumentException("maxBufferedDocs must at least be 2 when enabled");
        }
        if (maxBufferedDocs == -1 && this.getRAMBufferSizeMB() == -1.0) {
            throw new IllegalArgumentException("at least one of ramBufferSize and maxBufferedDocs must be enabled");
        }
        this.docWriter.setMaxBufferedDocs(maxBufferedDocs);
        this.pushMaxBufferedDocs();
        if (this.infoStream != null) {
            this.message("setMaxBufferedDocs " + maxBufferedDocs);
        }
    }

    private void pushMaxBufferedDocs() {
        MergePolicy mp;
        if (this.docWriter.getMaxBufferedDocs() != -1 && (mp = this.mergePolicy) instanceof LogDocMergePolicy) {
            LogDocMergePolicy lmp = (LogDocMergePolicy)mp;
            int maxBufferedDocs = this.docWriter.getMaxBufferedDocs();
            if (lmp.getMinMergeDocs() != maxBufferedDocs) {
                if (this.infoStream != null) {
                    this.message("now push maxBufferedDocs " + maxBufferedDocs + " to LogDocMergePolicy");
                }
                lmp.setMinMergeDocs(maxBufferedDocs);
            }
        }
    }

    public int getMaxBufferedDocs() {
        this.ensureOpen();
        return this.docWriter.getMaxBufferedDocs();
    }

    public void setRAMBufferSizeMB(double mb) {
        if (mb != -1.0 && mb <= 0.0) {
            throw new IllegalArgumentException("ramBufferSize should be > 0.0 MB when enabled");
        }
        if (mb == -1.0 && this.getMaxBufferedDocs() == -1) {
            throw new IllegalArgumentException("at least one of ramBufferSize and maxBufferedDocs must be enabled");
        }
        this.docWriter.setRAMBufferSizeMB(mb);
        if (this.infoStream != null) {
            this.message("setRAMBufferSizeMB " + mb);
        }
    }

    public double getRAMBufferSizeMB() {
        return this.docWriter.getRAMBufferSizeMB();
    }

    public void setMaxBufferedDeleteTerms(int maxBufferedDeleteTerms) {
        this.ensureOpen();
        if (maxBufferedDeleteTerms != -1 && maxBufferedDeleteTerms < 1) {
            throw new IllegalArgumentException("maxBufferedDeleteTerms must at least be 1 when enabled");
        }
        this.docWriter.setMaxBufferedDeleteTerms(maxBufferedDeleteTerms);
        if (this.infoStream != null) {
            this.message("setMaxBufferedDeleteTerms " + maxBufferedDeleteTerms);
        }
    }

    public int getMaxBufferedDeleteTerms() {
        this.ensureOpen();
        return this.docWriter.getMaxBufferedDeleteTerms();
    }

    public void setMergeFactor(int mergeFactor) {
        this.getLogMergePolicy().setMergeFactor(mergeFactor);
    }

    public int getMergeFactor() {
        return this.getLogMergePolicy().getMergeFactor();
    }

    public static void setDefaultInfoStream(PrintStream infoStream) {
        defaultInfoStream = infoStream;
    }

    public static PrintStream getDefaultInfoStream() {
        return defaultInfoStream;
    }

    public void setInfoStream(PrintStream infoStream) {
        this.ensureOpen();
        this.infoStream = infoStream;
        this.setMessageID();
        this.docWriter.setInfoStream(infoStream);
        this.deleter.setInfoStream(infoStream);
        if (infoStream != null) {
            this.messageState();
        }
    }

    private void messageState() {
        this.message("setInfoStream: dir=" + this.directory + " autoCommit=" + this.autoCommit + " mergePolicy=" + this.mergePolicy + " mergeScheduler=" + this.mergeScheduler + " ramBufferSizeMB=" + this.docWriter.getRAMBufferSizeMB() + " maxBuffereDocs=" + this.docWriter.getMaxBufferedDocs() + " maxBuffereDeleteTerms=" + this.docWriter.getMaxBufferedDeleteTerms() + " maxFieldLength=" + this.maxFieldLength + " index=" + this.segString());
    }

    public PrintStream getInfoStream() {
        this.ensureOpen();
        return this.infoStream;
    }

    public void setWriteLockTimeout(long writeLockTimeout) {
        this.ensureOpen();
        this.writeLockTimeout = writeLockTimeout;
    }

    public long getWriteLockTimeout() {
        this.ensureOpen();
        return this.writeLockTimeout;
    }

    public static void setDefaultWriteLockTimeout(long writeLockTimeout) {
        WRITE_LOCK_TIMEOUT = writeLockTimeout;
    }

    public static long getDefaultWriteLockTimeout() {
        return WRITE_LOCK_TIMEOUT;
    }

    public void close() throws CorruptIndexException, IOException {
        this.close(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean waitForMerges) throws CorruptIndexException, IOException {
        boolean doClose;
        if (this.hitOOM) {
            this.abort();
        }
        IndexWriter indexWriter = this;
        synchronized (indexWriter) {
            if (!this.closing) {
                doClose = true;
                this.closing = true;
            } else {
                doClose = false;
            }
        }
        if (doClose) {
            this.closeInternal(waitForMerges);
        } else {
            this.waitForClose();
        }
    }

    private synchronized void waitForClose() {
        while (!this.closed && this.closing) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeInternal(boolean waitForMerges) throws CorruptIndexException, IOException {
        try {
            if (this.infoStream != null) {
                this.message("now flush at close");
            }
            this.docWriter.close();
            this.flush(waitForMerges, true);
            if (waitForMerges) {
                this.mergeScheduler.merge(this);
            }
            this.mergePolicy.close();
            this.finishMerges(waitForMerges);
            this.mergeScheduler.close();
            IndexWriter indexWriter = this;
            synchronized (indexWriter) {
                if (this.commitPending) {
                    boolean success = false;
                    try {
                        this.segmentInfos.write(this.directory);
                        success = true;
                    }
                    finally {
                        if (!success) {
                            if (this.infoStream != null) {
                                this.message("hit exception committing segments file during close");
                            }
                            this.deletePartialSegmentsFile();
                        }
                    }
                    if (this.infoStream != null) {
                        this.message("close: wrote segments file \"" + this.segmentInfos.getCurrentSegmentFileName() + "\"");
                    }
                    this.deleter.checkpoint(this.segmentInfos, true);
                    this.commitPending = false;
                    this.rollbackSegmentInfos = null;
                }
                if (this.infoStream != null) {
                    this.message("at close: " + this.segString());
                }
                this.docWriter = null;
                this.deleter.close();
            }
            if (this.closeDir) {
                this.directory.close();
            }
            if (this.writeLock != null) {
                this.writeLock.release();
                this.writeLock = null;
            }
            this.closed = true;
        }
        catch (OutOfMemoryError oom) {
            this.hitOOM = true;
            throw oom;
        }
        finally {
            IndexWriter indexWriter = this;
            synchronized (indexWriter) {
                if (!this.closed) {
                    this.closing = false;
                    if (this.infoStream != null) {
                        this.message("hit exception while closing");
                    }
                }
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean flushDocStores() throws IOException {
        List files = this.docWriter.files();
        boolean useCompoundDocStore = false;
        if (files.size() > 0) {
            String docStoreSegment;
            boolean success = false;
            try {
                docStoreSegment = this.docWriter.closeDocStore();
                success = true;
            }
            finally {
                if (!success) {
                    if (this.infoStream != null) {
                        this.message("hit exception closing doc store segment");
                    }
                    this.docWriter.abort(null);
                }
            }
            useCompoundDocStore = this.mergePolicy.useCompoundDocStore(this.segmentInfos);
            if (useCompoundDocStore && docStoreSegment != null) {
                block16: {
                    String compoundFileName;
                    int numSegments;
                    block17: {
                        success = false;
                        numSegments = this.segmentInfos.size();
                        compoundFileName = docStoreSegment + "." + "cfx";
                        try {
                            int i;
                            CompoundFileWriter cfsWriter = new CompoundFileWriter(this.directory, compoundFileName);
                            int size = files.size();
                            for (i = 0; i < size; ++i) {
                                cfsWriter.addFile((String)files.get(i));
                            }
                            cfsWriter.close();
                            for (i = 0; i < numSegments; ++i) {
                                SegmentInfo si = this.segmentInfos.info(i);
                                if (si.getDocStoreOffset() == -1 || !si.getDocStoreSegment().equals(docStoreSegment)) continue;
                                si.setDocStoreIsCompoundFile(true);
                            }
                            this.checkpoint();
                            success = true;
                            Object var12_12 = null;
                            if (success) break block16;
                            if (this.infoStream == null) break block17;
                            this.message("hit exception building compound file doc store for segment " + docStoreSegment);
                        }
                        catch (Throwable throwable) {
                            Object var12_13 = null;
                            if (!success) {
                                if (this.infoStream != null) {
                                    this.message("hit exception building compound file doc store for segment " + docStoreSegment);
                                }
                                for (int i = 0; i < numSegments; ++i) {
                                    SegmentInfo si = this.segmentInfos.info(i);
                                    if (si.getDocStoreOffset() == -1 || !si.getDocStoreSegment().equals(docStoreSegment)) continue;
                                    si.setDocStoreIsCompoundFile(false);
                                }
                                this.deleter.deleteFile(compoundFileName);
                                this.deletePartialSegmentsFile();
                            }
                            throw throwable;
                        }
                    }
                    for (int i = 0; i < numSegments; ++i) {
                        SegmentInfo si = this.segmentInfos.info(i);
                        if (si.getDocStoreOffset() == -1 || !si.getDocStoreSegment().equals(docStoreSegment)) continue;
                        si.setDocStoreIsCompoundFile(false);
                    }
                    this.deleter.deleteFile(compoundFileName);
                    this.deletePartialSegmentsFile();
                    {
                    }
                }
                this.deleter.checkpoint(this.segmentInfos, false);
            }
        }
        return useCompoundDocStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.writeLock != null) {
                this.writeLock.release();
                this.writeLock = null;
            }
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            super.finalize();
            throw throwable;
        }
        super.finalize();
    }

    public Directory getDirectory() {
        this.ensureOpen();
        return this.directory;
    }

    public Analyzer getAnalyzer() {
        this.ensureOpen();
        return this.analyzer;
    }

    public synchronized int docCount() {
        this.ensureOpen();
        int count = this.docWriter.getNumDocsInRAM();
        for (int i = 0; i < this.segmentInfos.size(); ++i) {
            SegmentInfo si = this.segmentInfos.info(i);
            count += si.docCount;
        }
        return count;
    }

    public void addDocument(Document doc) throws CorruptIndexException, IOException {
        this.addDocument(doc, this.analyzer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDocument(Document doc, Analyzer analyzer) throws CorruptIndexException, IOException {
        this.ensureOpen();
        boolean doFlush = false;
        boolean success = false;
        try {
            block15: {
                IndexWriter indexWriter;
                try {
                    doFlush = this.docWriter.addDocument(doc, analyzer);
                    success = true;
                    Object var6_5 = null;
                    if (success) break block15;
                    if (this.infoStream != null) {
                        this.message("hit exception adding document");
                    }
                    indexWriter = this;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    if (!success) {
                        if (this.infoStream != null) {
                            this.message("hit exception adding document");
                        }
                        IndexWriter indexWriter2 = this;
                        synchronized (indexWriter2) {
                            List files;
                            if (this.docWriter != null && (files = this.docWriter.abortedFiles()) != null) {
                                this.deleter.deleteNewFiles(files);
                            }
                        }
                    }
                    throw throwable;
                }
                synchronized (indexWriter) {
                    List files;
                    if (this.docWriter != null && (files = this.docWriter.abortedFiles()) != null) {
                        this.deleter.deleteNewFiles(files);
                    }
                }
            }
            if (doFlush) {
                this.flush(true, false);
            }
        }
        catch (OutOfMemoryError oom) {
            this.hitOOM = true;
            throw oom;
        }
    }

    public void deleteDocuments(Term term) throws CorruptIndexException, IOException {
        this.ensureOpen();
        try {
            boolean doFlush = this.docWriter.bufferDeleteTerm(term);
            if (doFlush) {
                this.flush(true, false);
            }
        }
        catch (OutOfMemoryError oom) {
            this.hitOOM = true;
            throw oom;
        }
    }

    public void deleteDocuments(Term[] terms) throws CorruptIndexException, IOException {
        this.ensureOpen();
        try {
            boolean doFlush = this.docWriter.bufferDeleteTerms(terms);
            if (doFlush) {
                this.flush(true, false);
            }
        }
        catch (OutOfMemoryError oom) {
            this.hitOOM = true;
            throw oom;
        }
    }

    public void updateDocument(Term term, Document doc) throws CorruptIndexException, IOException {
        this.ensureOpen();
        this.updateDocument(term, doc, this.getAnalyzer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDocument(Term term, Document doc, Analyzer analyzer) throws CorruptIndexException, IOException {
        this.ensureOpen();
        try {
            boolean doFlush;
            block15: {
                IndexWriter indexWriter;
                doFlush = false;
                boolean success = false;
                try {
                    doFlush = this.docWriter.updateDocument(term, doc, analyzer);
                    success = true;
                    Object var7_7 = null;
                    if (success) break block15;
                    if (this.infoStream != null) {
                        this.message("hit exception updating document");
                    }
                    indexWriter = this;
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    if (!success) {
                        if (this.infoStream != null) {
                            this.message("hit exception updating document");
                        }
                        IndexWriter indexWriter2 = this;
                        synchronized (indexWriter2) {
                            List files = this.docWriter.abortedFiles();
                            if (files != null) {
                                this.deleter.deleteNewFiles(files);
                            }
                        }
                    }
                    throw throwable;
                }
                synchronized (indexWriter) {
                    List files = this.docWriter.abortedFiles();
                    if (files != null) {
                        this.deleter.deleteNewFiles(files);
                    }
                }
            }
            if (doFlush) {
                this.flush(true, false);
            }
        }
        catch (OutOfMemoryError oom) {
            this.hitOOM = true;
            throw oom;
        }
    }

    final synchronized int getSegmentCount() {
        return this.segmentInfos.size();
    }

    final synchronized int getNumBufferedDocuments() {
        return this.docWriter.getNumDocsInRAM();
    }

    final synchronized int getDocCount(int i) {
        if (i >= 0 && i < this.segmentInfos.size()) {
            return this.segmentInfos.info((int)i).docCount;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final String newSegmentName() {
        SegmentInfos segmentInfos = this.segmentInfos;
        synchronized (segmentInfos) {
            this.commitPending = true;
            return "_" + Integer.toString(this.segmentInfos.counter++, 36);
        }
    }

    public void optimize() throws CorruptIndexException, IOException {
        this.optimize(true);
    }

    public void optimize(int maxNumSegments) throws CorruptIndexException, IOException {
        this.optimize(maxNumSegments, true);
    }

    public void optimize(boolean doWait) throws CorruptIndexException, IOException {
        this.optimize(1, doWait);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void optimize(int maxNumSegments, boolean doWait) throws CorruptIndexException, IOException {
        MergePolicy.OneMerge merge;
        this.ensureOpen();
        if (maxNumSegments < 1) {
            throw new IllegalArgumentException("maxNumSegments must be >= 1; got " + maxNumSegments);
        }
        if (this.infoStream != null) {
            this.message("optimize: index now " + this.segString());
        }
        this.flush();
        IndexWriter indexWriter = this;
        synchronized (indexWriter) {
            this.resetMergeExceptions();
            this.segmentsToOptimize = new HashSet();
            int numSegments = this.segmentInfos.size();
            for (int i = 0; i < numSegments; ++i) {
                this.segmentsToOptimize.add(this.segmentInfos.info(i));
            }
            Iterator it = this.pendingMerges.iterator();
            while (it.hasNext()) {
                merge = (MergePolicy.OneMerge)it.next();
                merge.optimize = true;
                merge.maxNumSegmentsOptimize = maxNumSegments;
            }
            it = this.runningMerges.iterator();
            while (it.hasNext()) {
                merge = (MergePolicy.OneMerge)it.next();
                merge.optimize = true;
                merge.maxNumSegmentsOptimize = maxNumSegments;
            }
        }
        this.maybeMerge(maxNumSegments, true);
        if (doWait) {
            indexWriter = this;
            synchronized (indexWriter) {
                while (this.optimizeMergesPending()) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                    if (this.mergeExceptions.size() <= 0) continue;
                    int size = this.mergeExceptions.size();
                    for (int i = 0; i < size; ++i) {
                        merge = (MergePolicy.OneMerge)this.mergeExceptions.get(0);
                        if (!merge.optimize) continue;
                        IOException err = new IOException("background merge hit exception: " + merge.segString(this.directory));
                        err.initCause(merge.getException());
                        throw err;
                    }
                }
            }
        }
    }

    private synchronized boolean optimizeMergesPending() {
        Iterator it = this.pendingMerges.iterator();
        while (it.hasNext()) {
            if (!((MergePolicy.OneMerge)it.next()).optimize) continue;
            return true;
        }
        it = this.runningMerges.iterator();
        while (it.hasNext()) {
            if (!((MergePolicy.OneMerge)it.next()).optimize) continue;
            return true;
        }
        return false;
    }

    public final void maybeMerge() throws CorruptIndexException, IOException {
        this.maybeMerge(false);
    }

    private final void maybeMerge(boolean optimize) throws CorruptIndexException, IOException {
        this.maybeMerge(1, optimize);
    }

    private final void maybeMerge(int maxNumSegmentsOptimize, boolean optimize) throws CorruptIndexException, IOException {
        this.updatePendingMerges(maxNumSegmentsOptimize, optimize);
        this.mergeScheduler.merge(this);
    }

    private synchronized void updatePendingMerges(int maxNumSegmentsOptimize, boolean optimize) throws CorruptIndexException, IOException {
        int i;
        int numMerges;
        MergePolicy.MergeSpecification spec;
        if (!$assertionsDisabled && optimize && maxNumSegmentsOptimize <= 0) {
            throw new AssertionError();
        }
        if (this.stopMerges) {
            return;
        }
        if (optimize) {
            spec = this.mergePolicy.findMergesForOptimize(this.segmentInfos, this, maxNumSegmentsOptimize, this.segmentsToOptimize);
            if (spec != null) {
                numMerges = spec.merges.size();
                for (i = 0; i < numMerges; ++i) {
                    MergePolicy.OneMerge merge = (MergePolicy.OneMerge)spec.merges.get(i);
                    merge.optimize = true;
                    merge.maxNumSegmentsOptimize = maxNumSegmentsOptimize;
                }
            }
        } else {
            spec = this.mergePolicy.findMerges(this.segmentInfos, this);
        }
        if (spec != null) {
            numMerges = spec.merges.size();
            for (i = 0; i < numMerges; ++i) {
                this.registerMerge((MergePolicy.OneMerge)spec.merges.get(i));
            }
        }
    }

    synchronized MergePolicy.OneMerge getNextMerge() {
        if (this.pendingMerges.size() == 0) {
            return null;
        }
        MergePolicy.OneMerge merge = (MergePolicy.OneMerge)this.pendingMerges.removeFirst();
        this.runningMerges.add(merge);
        return merge;
    }

    private synchronized void startTransaction() throws IOException {
        if (this.infoStream != null) {
            this.message("now start transaction");
        }
        if (!$assertionsDisabled && this.docWriter.getNumBufferedDeleteTerms() != 0) {
            throw new AssertionError((Object)"calling startTransaction with buffered delete terms not supported");
        }
        if (!$assertionsDisabled && this.docWriter.getNumDocsInRAM() != 0) {
            throw new AssertionError((Object)"calling startTransaction with buffered documents not supported");
        }
        this.localRollbackSegmentInfos = (SegmentInfos)this.segmentInfos.clone();
        this.localAutoCommit = this.autoCommit;
        if (this.localAutoCommit) {
            if (this.infoStream != null) {
                this.message("flush at startTransaction");
            }
            this.flush();
            this.autoCommit = false;
        } else {
            this.deleter.incRef(this.segmentInfos, false);
        }
    }

    private synchronized void rollbackTransaction() throws IOException {
        if (this.infoStream != null) {
            this.message("now rollback transaction");
        }
        this.autoCommit = this.localAutoCommit;
        this.segmentInfos.clear();
        this.segmentInfos.addAll(this.localRollbackSegmentInfos);
        this.localRollbackSegmentInfos = null;
        this.deleter.checkpoint(this.segmentInfos, false);
        if (!this.autoCommit) {
            this.deleter.decRef(this.segmentInfos);
        }
        this.deleter.refresh();
        this.finishMerges(false);
        this.stopMerges = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void commitTransaction() throws IOException {
        block6: {
            block7: {
                if (this.infoStream != null) {
                    this.message("now commit transaction");
                }
                this.autoCommit = this.localAutoCommit;
                boolean success = false;
                try {
                    this.checkpoint();
                    success = true;
                    Object var3_2 = null;
                    if (success) break block6;
                    if (this.infoStream == null) break block7;
                    this.message("hit exception committing transaction");
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    if (!success) {
                        if (this.infoStream != null) {
                            this.message("hit exception committing transaction");
                        }
                        this.rollbackTransaction();
                    }
                    throw throwable;
                }
            }
            this.rollbackTransaction();
            {
            }
        }
        if (!this.autoCommit) {
            this.deleter.decRef(this.localRollbackSegmentInfos);
        }
        this.localRollbackSegmentInfos = null;
        this.deleter.checkpoint(this.segmentInfos, this.autoCommit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() throws IOException {
        boolean doClose;
        this.ensureOpen();
        if (this.autoCommit) {
            throw new IllegalStateException("abort() can only be called when IndexWriter was opened with autoCommit=false");
        }
        IndexWriter indexWriter = this;
        synchronized (indexWriter) {
            if (!this.closing) {
                doClose = true;
                this.closing = true;
            } else {
                doClose = false;
            }
        }
        if (doClose) {
            this.finishMerges(false);
            this.mergePolicy.close();
            this.mergeScheduler.close();
            indexWriter = this;
            synchronized (indexWriter) {
                this.segmentInfos.clear();
                this.segmentInfos.addAll(this.rollbackSegmentInfos);
                this.docWriter.abort(null);
                this.deleter.checkpoint(this.segmentInfos, false);
                this.deleter.refresh();
            }
            this.commitPending = false;
            this.closeInternal(false);
        } else {
            this.waitForClose();
        }
    }

    private synchronized void finishMerges(boolean waitForMerges) throws IOException {
        if (!waitForMerges) {
            MergePolicy.OneMerge merge;
            this.stopMerges = true;
            Iterator it = this.pendingMerges.iterator();
            while (it.hasNext()) {
                merge = (MergePolicy.OneMerge)it.next();
                if (this.infoStream != null) {
                    this.message("now abort pending merge " + merge.segString(this.directory));
                }
                merge.abort();
                this.mergeFinish(merge);
            }
            this.pendingMerges.clear();
            it = this.runningMerges.iterator();
            while (it.hasNext()) {
                merge = (MergePolicy.OneMerge)it.next();
                if (this.infoStream != null) {
                    this.message("now abort running merge " + merge.segString(this.directory));
                }
                merge.abort();
            }
            while (this.runningMerges.size() > 0) {
                if (this.infoStream != null) {
                    this.message("now wait for " + this.runningMerges.size() + " running merge to abort");
                }
                try {
                    this.wait();
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
            }
            if (!$assertionsDisabled && 0 != this.mergingSegments.size()) {
                throw new AssertionError();
            }
            if (this.infoStream != null) {
                this.message("all running merges have aborted");
            }
        } else {
            while (this.pendingMerges.size() > 0 || this.runningMerges.size() > 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (!$assertionsDisabled && 0 != this.mergingSegments.size()) {
                throw new AssertionError();
            }
        }
    }

    private synchronized void checkpoint() throws IOException {
        if (this.autoCommit) {
            this.segmentInfos.write(this.directory);
            this.commitPending = false;
            if (this.infoStream != null) {
                this.message("checkpoint: wrote segments file \"" + this.segmentInfos.getCurrentSegmentFileName() + "\"");
            }
        } else {
            this.commitPending = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addIndexes(Directory[] dirs) throws CorruptIndexException, IOException {
        this.ensureOpen();
        this.docWriter.pauseAllThreads();
        try {
            try {
                block13: {
                    block12: {
                        if (this.infoStream != null) {
                            this.message("flush at addIndexes");
                        }
                        this.flush();
                        boolean success = false;
                        this.startTransaction();
                        try {
                            IndexWriter indexWriter = this;
                            synchronized (indexWriter) {
                                for (int i = 0; i < dirs.length; ++i) {
                                    SegmentInfos sis = new SegmentInfos();
                                    sis.read(dirs[i]);
                                    for (int j = 0; j < sis.size(); ++j) {
                                        SegmentInfo info = sis.info(j);
                                        this.segmentInfos.addElement(sis.info(j));
                                    }
                                }
                            }
                            this.optimize();
                            success = true;
                            Object var10_9 = null;
                            if (!success) break block12;
                        }
                        catch (Throwable throwable) {
                            Object var10_10 = null;
                            if (success) {
                                this.commitTransaction();
                                throw throwable;
                            }
                            this.rollbackTransaction();
                            throw throwable;
                        }
                        this.commitTransaction();
                        break block13;
                    }
                    this.rollbackTransaction();
                }
                Object var12_12 = null;
                this.docWriter.resumeAllThreads();
                return;
            }
            catch (OutOfMemoryError oom) {
                this.hitOOM = true;
                throw oom;
            }
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            this.docWriter.resumeAllThreads();
            throw throwable;
        }
    }

    private synchronized void resetMergeExceptions() {
        this.mergeExceptions = new ArrayList();
        ++this.mergeGen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addIndexesNoOptimize(Directory[] dirs) throws CorruptIndexException, IOException {
        this.ensureOpen();
        this.docWriter.pauseAllThreads();
        try {
            try {
                block14: {
                    block13: {
                        if (this.infoStream != null) {
                            this.message("flush at addIndexesNoOptimize");
                        }
                        this.flush();
                        boolean success = false;
                        this.startTransaction();
                        try {
                            IndexWriter indexWriter = this;
                            synchronized (indexWriter) {
                                for (int i = 0; i < dirs.length; ++i) {
                                    if (this.directory == dirs[i]) {
                                        throw new IllegalArgumentException("Cannot add this index to itself");
                                    }
                                    SegmentInfos sis = new SegmentInfos();
                                    sis.read(dirs[i]);
                                    for (int j = 0; j < sis.size(); ++j) {
                                        SegmentInfo info = sis.info(j);
                                        this.segmentInfos.addElement(info);
                                    }
                                }
                            }
                            this.maybeMerge();
                            this.copyExternalSegments();
                            success = true;
                            Object var10_9 = null;
                            if (!success) break block13;
                        }
                        catch (Throwable throwable) {
                            Object var10_10 = null;
                            if (success) {
                                this.commitTransaction();
                                throw throwable;
                            }
                            this.rollbackTransaction();
                            throw throwable;
                        }
                        this.commitTransaction();
                        break block14;
                    }
                    this.rollbackTransaction();
                }
                Object var12_12 = null;
                this.docWriter.resumeAllThreads();
                return;
            }
            catch (OutOfMemoryError oom) {
                this.hitOOM = true;
                throw oom;
            }
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            this.docWriter.resumeAllThreads();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyExternalSegments() throws CorruptIndexException, IOException {
        boolean any;
        block6: {
            SegmentInfo info;
            any = false;
            while (true) {
                info = null;
                MergePolicy.OneMerge merge = null;
                IndexWriter indexWriter = this;
                synchronized (indexWriter) {
                    int numSegments = this.segmentInfos.size();
                    for (int i = 0; i < numSegments; ++i) {
                        info = this.segmentInfos.info(i);
                        if (info.dir == this.directory) continue;
                        merge = new MergePolicy.OneMerge(this.segmentInfos.range(i, 1 + i), info.getUseCompoundFile());
                        break;
                    }
                }
                if (merge == null) break block6;
                if (!this.registerMerge(merge)) break;
                this.pendingMerges.remove(merge);
                this.runningMerges.add(merge);
                any = true;
                this.merge(merge);
            }
            throw new MergePolicy.MergeException("segment \"" + info.name + " exists in external directory yet the MergeScheduler executed the merge in a separate thread");
        }
        if (any) {
            this.mergeScheduler.merge(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addIndexes(IndexReader[] readers) throws CorruptIndexException, IOException {
        this.ensureOpen();
        this.docWriter.pauseAllThreads();
        try {
            try {
                block30: {
                    SegmentInfo info;
                    boolean success;
                    SegmentMerger merger;
                    String mergedName;
                    block27: {
                        this.optimize();
                        mergedName = this.newSegmentName();
                        merger = new SegmentMerger(this, mergedName, null);
                        IndexReader sReader = null;
                        try {
                            block29: {
                                block26: {
                                    IndexWriter indexWriter = this;
                                    synchronized (indexWriter) {
                                        if (this.segmentInfos.size() == 1) {
                                            sReader = SegmentReader.get(this.segmentInfos.info(0));
                                            merger.add(sReader);
                                        }
                                    }
                                    for (int i = 0; i < readers.length; ++i) {
                                        merger.add(readers[i]);
                                    }
                                    success = false;
                                    this.startTransaction();
                                    try {
                                        int docCount = merger.merge();
                                        if (sReader != null) {
                                            sReader.close();
                                            sReader = null;
                                        }
                                        IndexWriter indexWriter2 = this;
                                        synchronized (indexWriter2) {
                                            this.segmentInfos.setSize(0);
                                            info = new SegmentInfo(mergedName, docCount, this.directory, false, true, -1, null, false);
                                            this.segmentInfos.addElement(info);
                                        }
                                        success = true;
                                        Object var11_12 = null;
                                        if (success) break block26;
                                        if (this.infoStream != null) {
                                            this.message("hit exception in addIndexes during merge");
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        Object var11_13 = null;
                                        if (success) {
                                            this.commitTransaction();
                                            throw throwable;
                                        }
                                        if (this.infoStream != null) {
                                            this.message("hit exception in addIndexes during merge");
                                        }
                                        this.rollbackTransaction();
                                        throw throwable;
                                    }
                                    this.rollbackTransaction();
                                    break block29;
                                }
                                this.commitTransaction();
                            }
                            Object var13_15 = null;
                            if (sReader == null) break block27;
                        }
                        catch (Throwable throwable) {
                            Object var13_16 = null;
                            if (sReader == null) throw throwable;
                            sReader.close();
                            throw throwable;
                        }
                        sReader.close();
                    }
                    if (this.mergePolicy instanceof LogMergePolicy && this.getUseCompoundFile()) {
                        block28: {
                            success = false;
                            this.startTransaction();
                            try {
                                merger.createCompoundFile(mergedName + ".cfs");
                                IndexWriter indexWriter = this;
                                synchronized (indexWriter) {
                                    info.setUseCompoundFile(true);
                                }
                                success = true;
                                Object var16_18 = null;
                                if (success) break block28;
                                if (this.infoStream != null) {
                                    this.message("hit exception building compound file in addIndexes during merge");
                                }
                            }
                            catch (Throwable throwable) {
                                Object var16_19 = null;
                                if (success) {
                                    this.commitTransaction();
                                    throw throwable;
                                }
                                if (this.infoStream != null) {
                                    this.message("hit exception building compound file in addIndexes during merge");
                                }
                                this.rollbackTransaction();
                                throw throwable;
                            }
                            this.rollbackTransaction();
                            break block30;
                        }
                        this.commitTransaction();
                    }
                }
                Object var18_21 = null;
                this.docWriter.resumeAllThreads();
                return;
            }
            catch (OutOfMemoryError oom) {
                this.hitOOM = true;
                throw oom;
            }
        }
        catch (Throwable throwable) {
            Object var18_22 = null;
            this.docWriter.resumeAllThreads();
            throw throwable;
        }
    }

    void doAfterFlush() throws IOException {
    }

    public final void flush() throws CorruptIndexException, IOException {
        this.flush(true, false);
    }

    protected final void flush(boolean triggerMerge, boolean flushDocStores) throws CorruptIndexException, IOException {
        this.ensureOpen();
        if (this.doFlush(flushDocStores) && triggerMerge) {
            this.maybeMerge();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final synchronized boolean doFlush(boolean flushDocStores) throws CorruptIndexException, IOException {
        block39: {
            boolean success;
            String segment;
            boolean flushDocs;
            SegmentInfo newSegment;
            block40: {
                block43: {
                    block41: {
                        if (this.docWriter.pauseAllThreads()) {
                            this.docWriter.resumeAllThreads();
                            return false;
                        }
                        newSegment = null;
                        int numDocs = this.docWriter.getNumDocsInRAM();
                        flushDocs = numDocs > 0;
                        flushDocStores |= this.autoCommit;
                        String docStoreSegment = this.docWriter.getDocStoreSegment();
                        if (docStoreSegment == null) {
                            flushDocStores = false;
                        }
                        boolean flushDeletes = this.docWriter.hasDeletes();
                        if (this.infoStream != null) {
                            this.message("  flush: segment=" + this.docWriter.getSegment() + " docStoreSegment=" + this.docWriter.getDocStoreSegment() + " docStoreOffset=" + this.docWriter.getDocStoreOffset() + " flushDocs=" + flushDocs + " flushDeletes=" + flushDeletes + " flushDocStores=" + flushDocStores + " numDocs=" + numDocs + " numBufDelTerms=" + this.docWriter.getNumBufferedDeleteTerms());
                            this.message("  index before flush " + this.segString());
                        }
                        int docStoreOffset = this.docWriter.getDocStoreOffset();
                        if (!$assertionsDisabled && this.autoCommit && 0 != docStoreOffset) {
                            throw new AssertionError();
                        }
                        boolean docStoreIsCompoundFile = false;
                        if (!(!flushDocStores || flushDocs && this.docWriter.getSegment().equals(this.docWriter.getDocStoreSegment()))) {
                            if (this.infoStream != null) {
                                this.message("  flush shared docStore segment " + docStoreSegment);
                            }
                            docStoreIsCompoundFile = this.flushDocStores();
                            flushDocStores = false;
                        }
                        segment = this.docWriter.getSegment();
                        if (!$assertionsDisabled && segment == null && flushDocs) {
                            throw new AssertionError();
                        }
                        if (!flushDocs && !flushDeletes) break block39;
                        SegmentInfos rollback = null;
                        if (flushDeletes) {
                            rollback = (SegmentInfos)this.segmentInfos.clone();
                        }
                        success = false;
                        try {
                            if (flushDocs) {
                                if (0 == docStoreOffset && flushDocStores) {
                                    if (!$assertionsDisabled && docStoreSegment == null) {
                                        throw new AssertionError();
                                    }
                                    if (!$assertionsDisabled && !docStoreSegment.equals(segment)) {
                                        throw new AssertionError();
                                    }
                                    docStoreOffset = -1;
                                    docStoreIsCompoundFile = false;
                                    docStoreSegment = null;
                                }
                                int flushedDocCount = this.docWriter.flush(flushDocStores);
                                newSegment = new SegmentInfo(segment, flushedDocCount, this.directory, false, true, docStoreOffset, docStoreSegment, docStoreIsCompoundFile);
                                this.segmentInfos.addElement(newSegment);
                            }
                            if (flushDeletes) {
                                this.applyDeletes(flushDocs);
                            }
                            this.doAfterFlush();
                            this.checkpoint();
                            success = true;
                            Object var14_15 = null;
                            if (success) break block40;
                            if (this.infoStream != null) {
                                this.message("hit exception flushing segment " + segment);
                            }
                            if (!flushDeletes) break block41;
                        }
                        catch (Throwable throwable) {
                            Object var14_16 = null;
                            if (!success) {
                                if (this.infoStream != null) {
                                    this.message("hit exception flushing segment " + segment);
                                }
                                if (flushDeletes) {
                                    int size = rollback.size();
                                    for (int i = 0; i < size; ++i) {
                                        String newDelFileName = this.segmentInfos.info(i).getDelFileName();
                                        String delFileName = rollback.info(i).getDelFileName();
                                        if (newDelFileName == null || newDelFileName.equals(delFileName)) continue;
                                        this.deleter.deleteFile(newDelFileName);
                                    }
                                    this.segmentInfos.clear();
                                    this.segmentInfos.addAll(rollback);
                                } else if (newSegment != null && this.segmentInfos.size() > 0 && this.segmentInfos.info(this.segmentInfos.size() - 1) == newSegment) {
                                    this.segmentInfos.remove(this.segmentInfos.size() - 1);
                                }
                                if (flushDocs) {
                                    this.docWriter.abort(null);
                                }
                                this.deletePartialSegmentsFile();
                                this.deleter.checkpoint(this.segmentInfos, false);
                                if (segment != null) {
                                    this.deleter.refresh(segment);
                                }
                            }
                            throw throwable;
                        }
                        int size = rollback.size();
                        for (int i = 0; i < size; ++i) {
                            String newDelFileName = this.segmentInfos.info(i).getDelFileName();
                            String delFileName = rollback.info(i).getDelFileName();
                            if (newDelFileName == null || newDelFileName.equals(delFileName)) continue;
                            this.deleter.deleteFile(newDelFileName);
                        }
                        this.segmentInfos.clear();
                        this.segmentInfos.addAll(rollback);
                        break block43;
                    }
                    if (newSegment != null && this.segmentInfos.size() > 0 && this.segmentInfos.info(this.segmentInfos.size() - 1) == newSegment) {
                        this.segmentInfos.remove(this.segmentInfos.size() - 1);
                    }
                }
                if (flushDocs) {
                    this.docWriter.abort(null);
                }
                this.deletePartialSegmentsFile();
                this.deleter.checkpoint(this.segmentInfos, false);
                if (segment != null) {
                    this.deleter.refresh(segment);
                }
            }
            this.deleter.checkpoint(this.segmentInfos, this.autoCommit);
            if (flushDocs && this.mergePolicy.useCompoundFile(this.segmentInfos, newSegment)) {
                block42: {
                    success = false;
                    try {
                        this.docWriter.createCompoundFile(segment);
                        newSegment.setUseCompoundFile(true);
                        this.checkpoint();
                        success = true;
                        Object var20_26 = null;
                        if (success) break block42;
                        if (this.infoStream != null) {
                            this.message("hit exception creating compound file for newly flushed segment " + segment);
                        }
                        newSegment.setUseCompoundFile(false);
                    }
                    catch (Throwable throwable) {
                        Object var20_27 = null;
                        if (!success) {
                            if (this.infoStream != null) {
                                this.message("hit exception creating compound file for newly flushed segment " + segment);
                            }
                            newSegment.setUseCompoundFile(false);
                            this.deleter.deleteFile(segment + "." + "cfs");
                            this.deletePartialSegmentsFile();
                        }
                        throw throwable;
                    }
                    this.deleter.deleteFile(segment + "." + "cfs");
                    this.deletePartialSegmentsFile();
                    {
                    }
                }
                this.deleter.checkpoint(this.segmentInfos, this.autoCommit);
            }
            boolean bl = true;
            Object var22_29 = null;
            this.docWriter.clearFlushPending();
            this.docWriter.resumeAllThreads();
            return bl;
        }
        try {
            boolean bl = false;
            Object var22_30 = null;
            this.docWriter.clearFlushPending();
            this.docWriter.resumeAllThreads();
            return bl;
        }
        catch (OutOfMemoryError oom) {
            try {
                this.hitOOM = true;
                throw oom;
            }
            catch (Throwable throwable) {
                Object var22_31 = null;
                this.docWriter.clearFlushPending();
                this.docWriter.resumeAllThreads();
                throw throwable;
            }
        }
    }

    public final long ramSizeInBytes() {
        this.ensureOpen();
        return this.docWriter.getRAMUsed();
    }

    public final synchronized int numRamDocs() {
        this.ensureOpen();
        return this.docWriter.getNumDocsInRAM();
    }

    private int ensureContiguousMerge(MergePolicy.OneMerge merge) {
        int first = this.segmentInfos.indexOf(merge.segments.info(0));
        if (first == -1) {
            throw new MergePolicy.MergeException("could not find segment " + merge.segments.info((int)0).name + " in current segments");
        }
        int numSegments = this.segmentInfos.size();
        int numSegmentsToMerge = merge.segments.size();
        for (int i = 0; i < numSegmentsToMerge; ++i) {
            SegmentInfo info = merge.segments.info(i);
            if (first + i < numSegments && this.segmentInfos.info(first + i).equals(info)) continue;
            if (this.segmentInfos.indexOf(info) == -1) {
                throw new MergePolicy.MergeException("MergePolicy selected a segment (" + info.name + ") that is not in the index");
            }
            throw new MergePolicy.MergeException("MergePolicy selected non-contiguous segments to merge (" + merge + " vs " + this.segString() + "), which IndexWriter (currently) cannot handle");
        }
        return first;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean commitMerge(MergePolicy.OneMerge merge) throws IOException {
        block38: {
            SegmentInfos rollback;
            block39: {
                int start;
                boolean success;
                block36: {
                    block37: {
                        if (!$assertionsDisabled && !merge.registerDone) {
                            throw new AssertionError();
                        }
                        if (this.hitOOM) {
                            return false;
                        }
                        if (this.infoStream != null) {
                            this.message("commitMerge: " + merge.segString(this.directory));
                        }
                        if (merge.isAborted()) {
                            if (this.infoStream != null) {
                                this.message("commitMerge: skipping merge " + merge.segString(this.directory) + ": it was aborted");
                            }
                            if (!$assertionsDisabled && !merge.increfDone) {
                                throw new AssertionError();
                            }
                            this.decrefMergeSegments(merge);
                            this.deleter.refresh(merge.info.name);
                            return false;
                        }
                        success = false;
                        try {
                            SegmentInfos sourceSegmentsClone = merge.segmentsClone;
                            SegmentInfos sourceSegments = merge.segments;
                            start = this.ensureContiguousMerge(merge);
                            if (this.infoStream != null) {
                                this.message("commitMerge " + merge.segString(this.directory));
                            }
                            BitVector deletes = null;
                            int docUpto = 0;
                            int numSegmentsToMerge = sourceSegments.size();
                            for (int i = 0; i < numSegmentsToMerge; ++i) {
                                SegmentInfo previousInfo = sourceSegmentsClone.info(i);
                                SegmentInfo currentInfo = sourceSegments.info(i);
                                if (!$assertionsDisabled && currentInfo.docCount != previousInfo.docCount) {
                                    throw new AssertionError();
                                }
                                int docCount = currentInfo.docCount;
                                if (previousInfo.hasDeletions()) {
                                    if (!$assertionsDisabled && !currentInfo.hasDeletions()) {
                                        throw new AssertionError();
                                    }
                                    BitVector previousDeletes = new BitVector(previousInfo.dir, previousInfo.getDelFileName());
                                    if (!currentInfo.getDelFileName().equals(previousInfo.getDelFileName())) {
                                        if (deletes == null) {
                                            deletes = new BitVector(merge.info.docCount);
                                        }
                                        BitVector currentDeletes = new BitVector(currentInfo.dir, currentInfo.getDelFileName());
                                        for (int j = 0; j < docCount; ++j) {
                                            if (previousDeletes.get(j)) {
                                                if (!$assertionsDisabled && !currentDeletes.get(j)) {
                                                    throw new AssertionError();
                                                }
                                                continue;
                                            }
                                            if (currentDeletes.get(j)) {
                                                deletes.set(docUpto);
                                            }
                                            ++docUpto;
                                        }
                                    } else {
                                        docUpto += docCount - previousDeletes.count();
                                    }
                                } else if (currentInfo.hasDeletions()) {
                                    if (deletes == null) {
                                        deletes = new BitVector(merge.info.docCount);
                                    }
                                    BitVector currentDeletes = new BitVector(this.directory, currentInfo.getDelFileName());
                                    for (int j = 0; j < docCount; ++j) {
                                        if (currentDeletes.get(j)) {
                                            deletes.set(docUpto);
                                        }
                                        ++docUpto;
                                    }
                                } else {
                                    docUpto += currentInfo.docCount;
                                }
                                merge.checkAborted(this.directory);
                            }
                            if (deletes != null) {
                                merge.info.advanceDelGen();
                                deletes.write(this.directory, merge.info.getDelFileName());
                            }
                            success = true;
                            Object var17_21 = null;
                            if (success) break block36;
                            if (this.infoStream == null) break block37;
                            this.message("hit exception creating merged deletes file");
                        }
                        catch (Throwable throwable) {
                            Object var17_22 = null;
                            if (!success) {
                                if (this.infoStream != null) {
                                    this.message("hit exception creating merged deletes file");
                                }
                                this.deleter.refresh(merge.info.name);
                            }
                            throw throwable;
                        }
                    }
                    this.deleter.refresh(merge.info.name);
                    {
                    }
                }
                String mergeDocStoreSegment = merge.info.getDocStoreSegment();
                if (mergeDocStoreSegment != null && !merge.info.getDocStoreIsCompoundFile()) {
                    int size = this.segmentInfos.size();
                    for (int i = 0; i < size; ++i) {
                        SegmentInfo info = this.segmentInfos.info(i);
                        String docStoreSegment = info.getDocStoreSegment();
                        if (docStoreSegment == null || !docStoreSegment.equals(mergeDocStoreSegment) || !info.getDocStoreIsCompoundFile()) continue;
                        merge.info.setDocStoreIsCompoundFile(true);
                        break;
                    }
                }
                success = false;
                rollback = null;
                try {
                    rollback = (SegmentInfos)this.segmentInfos.clone();
                    this.segmentInfos.subList(start, start + merge.segments.size()).clear();
                    this.segmentInfos.add(start, merge.info);
                    this.checkpoint();
                    success = true;
                    Object var19_24 = null;
                    if (success || rollback == null) break block38;
                    if (this.infoStream == null) break block39;
                    this.message("hit exception when checkpointing after merge");
                }
                catch (Throwable throwable) {
                    Object var19_25 = null;
                    if (!success && rollback != null) {
                        if (this.infoStream != null) {
                            this.message("hit exception when checkpointing after merge");
                        }
                        this.segmentInfos.clear();
                        this.segmentInfos.addAll(rollback);
                        this.deletePartialSegmentsFile();
                        this.deleter.refresh(merge.info.name);
                    }
                    throw throwable;
                }
            }
            this.segmentInfos.clear();
            this.segmentInfos.addAll(rollback);
            this.deletePartialSegmentsFile();
            this.deleter.refresh(merge.info.name);
            {
            }
        }
        if (merge.optimize) {
            this.segmentsToOptimize.add(merge.info);
        }
        this.deleter.checkpoint(this.segmentInfos, this.autoCommit);
        this.decrefMergeSegments(merge);
        return true;
    }

    private void decrefMergeSegments(MergePolicy.OneMerge merge) throws IOException {
        SegmentInfos sourceSegmentsClone = merge.segmentsClone;
        int numSegmentsToMerge = sourceSegmentsClone.size();
        if (!$assertionsDisabled && !merge.increfDone) {
            throw new AssertionError();
        }
        merge.increfDone = false;
        for (int i = 0; i < numSegmentsToMerge; ++i) {
            SegmentInfo previousInfo = sourceSegmentsClone.info(i);
            if (previousInfo.dir != this.directory) continue;
            this.deleter.decRef(previousInfo.files());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void merge(MergePolicy.OneMerge merge) throws CorruptIndexException, IOException {
        if (!$assertionsDisabled && !merge.registerDone) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && merge.optimize && merge.maxNumSegmentsOptimize <= 0) {
            throw new AssertionError();
        }
        boolean success = false;
        try {
            IndexWriter indexWriter;
            try {
                block25: {
                    try {
                        this.mergeInit(merge);
                        if (this.infoStream != null) {
                            this.message("now merge\n  merge=" + merge.segString(this.directory) + "\n  index=" + this.segString());
                        }
                        this.mergeMiddle(merge);
                        success = true;
                    }
                    catch (MergePolicy.MergeAbortedException e) {
                        merge.setException(e);
                        this.addMergeException(merge);
                        if (!merge.isExternal) break block25;
                        throw e;
                    }
                }
                Object var5_5 = null;
                indexWriter = this;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                IndexWriter indexWriter2 = this;
                synchronized (indexWriter2) {
                    try {
                        this.mergeFinish(merge);
                        if (!success) {
                            if (this.infoStream != null) {
                                this.message("hit exception during merge");
                            }
                            this.addMergeException(merge);
                            if (merge.info != null && !this.segmentInfos.contains(merge.info)) {
                                this.deleter.refresh(merge.info.name);
                            }
                        }
                        if (success && !merge.isAborted() && !this.closed && !this.closing) {
                            this.updatePendingMerges(merge.maxNumSegmentsOptimize, merge.optimize);
                        }
                        Object var8_11 = null;
                        this.runningMerges.remove(merge);
                    }
                    catch (Throwable throwable2) {
                        Object var8_12 = null;
                        this.runningMerges.remove(merge);
                        this.notifyAll();
                        throw throwable2;
                    }
                    this.notifyAll();
                }
                throw throwable;
            }
            synchronized (indexWriter) {
                try {
                    this.mergeFinish(merge);
                    if (!success) {
                        if (this.infoStream != null) {
                            this.message("hit exception during merge");
                        }
                        this.addMergeException(merge);
                        if (merge.info != null && !this.segmentInfos.contains(merge.info)) {
                            this.deleter.refresh(merge.info.name);
                        }
                    }
                    if (success && !merge.isAborted() && !this.closed && !this.closing) {
                        this.updatePendingMerges(merge.maxNumSegmentsOptimize, merge.optimize);
                    }
                    Object var8_9 = null;
                    this.runningMerges.remove(merge);
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    this.runningMerges.remove(merge);
                    this.notifyAll();
                    throw throwable;
                }
                this.notifyAll();
            }
        }
        catch (OutOfMemoryError oom) {
            this.hitOOM = true;
            throw oom;
        }
    }

    final synchronized boolean registerMerge(MergePolicy.OneMerge merge) {
        int i;
        if (merge.registerDone) {
            return true;
        }
        int count = merge.segments.size();
        boolean isExternal = false;
        for (i = 0; i < count; ++i) {
            SegmentInfo info = merge.segments.info(i);
            if (this.mergingSegments.contains(info)) {
                return false;
            }
            if (this.segmentInfos.indexOf(info) == -1) {
                return false;
            }
            if (info.dir == this.directory) continue;
            isExternal = true;
        }
        this.pendingMerges.add(merge);
        if (this.infoStream != null) {
            this.message("add merge to pendingMerges: " + merge.segString(this.directory) + " [total " + this.pendingMerges.size() + " pending]");
        }
        merge.mergeGen = this.mergeGen;
        merge.isExternal = isExternal;
        for (i = 0; i < count; ++i) {
            this.mergingSegments.add(merge.segments.info(i));
        }
        merge.registerDone = true;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final synchronized void mergeInit(MergePolicy.OneMerge merge) throws IOException {
        boolean success = false;
        try {
            this._mergeInit(merge);
            return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (success) throw throwable;
            this.mergeFinish(merge);
            this.runningMerges.remove(merge);
            throw throwable;
        }
    }

    private final synchronized void _mergeInit(MergePolicy.OneMerge merge) throws IOException {
        boolean docStoreIsCompoundFile;
        String docStoreSegment;
        int docStoreOffset;
        if (!$assertionsDisabled && !this.testPoint("startMergeInit")) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !merge.registerDone) {
            throw new AssertionError();
        }
        if (merge.info != null) {
            return;
        }
        if (merge.isAborted()) {
            return;
        }
        SegmentInfos sourceSegments = merge.segments;
        int end = sourceSegments.size();
        this.ensureContiguousMerge(merge);
        Directory lastDir = this.directory;
        String lastDocStoreSegment = null;
        int next = -1;
        boolean mergeDocStores = false;
        boolean doFlushDocStore = false;
        String currentDocStoreSegment = this.docWriter.getDocStoreSegment();
        for (int i = 0; i < end; ++i) {
            String docStoreSegment2;
            SegmentInfo si = sourceSegments.info(i);
            if (si.hasDeletions()) {
                mergeDocStores = true;
            }
            if (-1 == si.getDocStoreOffset()) {
                mergeDocStores = true;
            }
            if ((docStoreSegment2 = si.getDocStoreSegment()) == null) {
                mergeDocStores = true;
            } else if (lastDocStoreSegment == null) {
                lastDocStoreSegment = docStoreSegment2;
            } else if (!lastDocStoreSegment.equals(docStoreSegment2)) {
                mergeDocStores = true;
            }
            if (-1 == next) {
                next = si.getDocStoreOffset() + si.docCount;
            } else if (next != si.getDocStoreOffset()) {
                mergeDocStores = true;
            } else {
                next = si.getDocStoreOffset() + si.docCount;
            }
            if (lastDir != si.dir) {
                mergeDocStores = true;
            }
            if (si.getDocStoreOffset() == -1 || currentDocStoreSegment == null || !si.getDocStoreSegment().equals(currentDocStoreSegment)) continue;
            doFlushDocStore = true;
        }
        if (mergeDocStores) {
            docStoreOffset = -1;
            docStoreSegment = null;
            docStoreIsCompoundFile = false;
        } else {
            SegmentInfo si = sourceSegments.info(0);
            docStoreOffset = si.getDocStoreOffset();
            docStoreSegment = si.getDocStoreSegment();
            docStoreIsCompoundFile = si.getDocStoreIsCompoundFile();
        }
        if (mergeDocStores && doFlushDocStore) {
            if (this.infoStream != null) {
                this.message("flush at merge");
            }
            this.flush(false, true);
        }
        merge.segmentsClone = (SegmentInfos)merge.segments.clone();
        for (int i = 0; i < end; ++i) {
            SegmentInfo si = merge.segmentsClone.info(i);
            if (si.dir != this.directory) continue;
            this.deleter.incRef(si.files());
        }
        merge.increfDone = true;
        merge.mergeDocStores = mergeDocStores;
        merge.info = new SegmentInfo(this.newSegmentName(), 0, this.directory, false, true, docStoreOffset, docStoreSegment, docStoreIsCompoundFile);
        this.mergingSegments.add(merge.info);
    }

    final synchronized void mergeFinish(MergePolicy.OneMerge merge) throws IOException {
        if (merge.increfDone) {
            this.decrefMergeSegments(merge);
        }
        if (!$assertionsDisabled && !merge.registerDone) {
            throw new AssertionError();
        }
        SegmentInfos sourceSegments = merge.segments;
        int end = sourceSegments.size();
        for (int i = 0; i < end; ++i) {
            this.mergingSegments.remove(sourceSegments.info(i));
        }
        this.mergingSegments.remove(merge.info);
        merge.registerDone = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int mergeMiddle(MergePolicy.OneMerge merge) throws CorruptIndexException, IOException {
        boolean success;
        int mergedDocCount;
        SegmentMerger merger;
        String mergedName;
        block49: {
            merge.checkAborted(this.directory);
            mergedName = merge.info.name;
            merger = null;
            mergedDocCount = 0;
            SegmentInfos sourceSegments = merge.segments;
            SegmentInfos sourceSegmentsClone = merge.segmentsClone;
            int numSegments = sourceSegments.size();
            if (this.infoStream != null) {
                this.message("merging " + merge.segString(this.directory));
            }
            merger = new SegmentMerger(this, mergedName, merge);
            success = false;
            try {
                int totDocCount = 0;
                for (int i = 0; i < numSegments; ++i) {
                    SegmentInfo si = sourceSegmentsClone.info(i);
                    SegmentReader reader = SegmentReader.get(si, 4096, merge.mergeDocStores);
                    merger.add(reader);
                    totDocCount += ((IndexReader)reader).numDocs();
                }
                if (this.infoStream != null) {
                    this.message("merge: total " + totDocCount + " docs");
                }
                merge.checkAborted(this.directory);
                mergedDocCount = merge.info.docCount = merger.merge(merge.mergeDocStores);
                if (!$assertionsDisabled && mergedDocCount != totDocCount) {
                    throw new AssertionError();
                }
                success = true;
                Object var14_15 = null;
                if (merger == null) break block49;
            }
            catch (Throwable throwable) {
                Object var14_16 = null;
                if (merger != null) {
                    merger.closeReaders();
                }
                if (!success) {
                    if (this.infoStream != null) {
                        this.message("hit exception during merge; now refresh deleter on segment " + mergedName);
                    }
                    IndexWriter indexWriter = this;
                    synchronized (indexWriter) {
                        this.addMergeException(merge);
                        this.deleter.refresh(mergedName);
                    }
                }
                throw throwable;
            }
            merger.closeReaders();
        }
        if (!success) {
            if (this.infoStream != null) {
                this.message("hit exception during merge; now refresh deleter on segment " + mergedName);
            }
            IndexWriter indexWriter = this;
            synchronized (indexWriter) {
                this.addMergeException(merge);
                this.deleter.refresh(mergedName);
            }
        }
        if (!this.commitMerge(merge)) {
            return 0;
        }
        if (merge.useCompoundFile) {
            String compoundFileName;
            boolean skip;
            block50: {
                IndexWriter indexWriter;
                success = false;
                skip = false;
                compoundFileName = mergedName + "." + "cfs";
                try {
                    try {
                        merger.createCompoundFile(compoundFileName);
                        success = true;
                    }
                    catch (IOException ioe) {
                        IndexWriter indexWriter2 = this;
                        synchronized (indexWriter2) {
                            if (this.segmentInfos.indexOf(merge.info) == -1) {
                                if (this.infoStream != null) {
                                    this.message("hit exception creating compound file; ignoring it because our info (segment " + merge.info.name + ") has been merged away");
                                }
                            } else {
                                throw ioe;
                            }
                            skip = true;
                        }
                    }
                    Object var19_23 = null;
                    if (success) break block50;
                    if (this.infoStream != null) {
                        this.message("hit exception creating compound file during merge: skip=" + skip);
                    }
                    indexWriter = this;
                }
                catch (Throwable throwable) {
                    Object var19_24 = null;
                    if (!success) {
                        if (this.infoStream != null) {
                            this.message("hit exception creating compound file during merge: skip=" + skip);
                        }
                        IndexWriter indexWriter3 = this;
                        synchronized (indexWriter3) {
                            if (!skip) {
                                this.addMergeException(merge);
                            }
                            this.deleter.deleteFile(compoundFileName);
                        }
                    }
                    throw throwable;
                }
                synchronized (indexWriter) {
                    if (!skip) {
                        this.addMergeException(merge);
                    }
                    this.deleter.deleteFile(compoundFileName);
                }
            }
            if (!skip) {
                IndexWriter indexWriter = this;
                synchronized (indexWriter) {
                    if (skip || this.segmentInfos.indexOf(merge.info) == -1 || merge.isAborted()) {
                        this.deleter.deleteFile(compoundFileName);
                    } else {
                        block51: {
                            success = false;
                            try {
                                merge.info.setUseCompoundFile(true);
                                this.checkpoint();
                                success = true;
                                Object var23_30 = null;
                                if (success) break block51;
                                if (this.infoStream != null) {
                                    this.message("hit exception checkpointing compound file during merge");
                                }
                                this.addMergeException(merge);
                                merge.info.setUseCompoundFile(false);
                            }
                            catch (Throwable throwable) {
                                Object var23_31 = null;
                                if (!success) {
                                    if (this.infoStream != null) {
                                        this.message("hit exception checkpointing compound file during merge");
                                    }
                                    this.addMergeException(merge);
                                    merge.info.setUseCompoundFile(false);
                                    this.deletePartialSegmentsFile();
                                    this.deleter.deleteFile(compoundFileName);
                                }
                                throw throwable;
                            }
                            this.deletePartialSegmentsFile();
                            this.deleter.deleteFile(compoundFileName);
                            {
                            }
                        }
                        this.deleter.checkpoint(this.segmentInfos, this.autoCommit);
                    }
                }
            }
        }
        return mergedDocCount;
    }

    synchronized void addMergeException(MergePolicy.OneMerge merge) {
        if (!this.mergeExceptions.contains(merge) && this.mergeGen == merge.mergeGen) {
            this.mergeExceptions.add(merge);
        }
    }

    private void deletePartialSegmentsFile() throws IOException {
        if (this.segmentInfos.getLastGeneration() != this.segmentInfos.getGeneration()) {
            String segmentFileName = IndexFileNames.fileNameFromGeneration("segments", "", this.segmentInfos.getGeneration());
            if (this.infoStream != null) {
                this.message("now delete partial segments file \"" + segmentFileName + "\"");
            }
            this.deleter.deleteFile(segmentFileName);
        }
    }

    /*
     * Exception decompiling
     */
    private final void applyDeletes(boolean flushedNewSegment) throws CorruptIndexException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Missing node tying up JSR block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.tieUpRelations(Op02WithProcessedDataAndRefs.java:2900)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.copyBlock(Op02WithProcessedDataAndRefs.java:2889)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.inlineJSR(Op02WithProcessedDataAndRefs.java:2845)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSRs(Op02WithProcessedDataAndRefs.java:2591)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSR(Op02WithProcessedDataAndRefs.java:2481)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:444)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    final synchronized int getBufferedDeleteTermsSize() {
        return this.docWriter.getBufferedDeleteTerms().size();
    }

    final synchronized int getNumBufferedDeleteTerms() {
        return this.docWriter.getNumBufferedDeleteTerms();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void applyDeletesSelectively(HashMap deleteTerms, List deleteIds, IndexReader reader) throws CorruptIndexException, IOException {
        Iterator iter = deleteTerms.entrySet().iterator();
        while (iter.hasNext()) {
            Object var11_10;
            Map.Entry entry = iter.next();
            Term term = (Term)entry.getKey();
            TermDocs docs = reader.termDocs(term);
            if (docs == null) continue;
            int num = ((DocumentsWriter.Num)entry.getValue()).getNum();
            try {
                int doc;
                while (docs.next() && (doc = docs.doc()) < num) {
                    reader.deleteDocument(doc);
                }
                var11_10 = null;
            }
            catch (Throwable throwable) {
                var11_10 = null;
                docs.close();
                throw throwable;
            }
            docs.close();
            {
            }
        }
        if (deleteIds.size() > 0) {
            iter = deleteIds.iterator();
            while (iter.hasNext()) {
                reader.deleteDocument((Integer)((Object)iter.next()));
            }
        }
    }

    private final void applyDeletes(HashMap deleteTerms, IndexReader reader) throws CorruptIndexException, IOException {
        Iterator iter = deleteTerms.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            reader.deleteDocuments((Term)entry.getKey());
        }
    }

    SegmentInfo newestSegment() {
        return this.segmentInfos.info(this.segmentInfos.size() - 1);
    }

    public synchronized String segString() {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.segmentInfos.size(); ++i) {
            if (i > 0) {
                buffer.append(' ');
            }
            buffer.append(this.segmentInfos.info(i).segString(this.directory));
        }
        return buffer.toString();
    }

    boolean testPoint(String name) {
        return true;
    }

    static {
        $assertionsDisabled = !IndexWriter.class.desiredAssertionStatus();
        WRITE_LOCK_TIMEOUT = 1000L;
        MAX_TERM_LENGTH = DocumentsWriter.MAX_TERM_LENGTH;
        MESSAGE_ID_LOCK = new Object();
        MESSAGE_ID = 0;
        defaultInfoStream = null;
    }
}

