/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.report;

import com.sun.star.awt.Rectangle;
import com.sun.star.awt.Size;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNameContainer;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.table.XTableColumns;
import com.sun.star.text.XRelativeTextContentRemove;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.wizards.common.FileAccess;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.common.JavaTools;
import com.sun.star.wizards.common.NumberFormatter;
import com.sun.star.wizards.common.PropertyNames;
import com.sun.star.wizards.common.Resource;
import com.sun.star.wizards.db.FieldColumn;
import com.sun.star.wizards.db.RecordParser;
import com.sun.star.wizards.document.FormHandler;
import com.sun.star.wizards.report.DBColumn;
import com.sun.star.wizards.report.RecordTable;
import com.sun.star.wizards.text.TextDocument;
import com.sun.star.wizards.text.TextFieldHandler;
import com.sun.star.wizards.text.TextSectionHandler;
import com.sun.star.wizards.text.TextStyleHandler;
import com.sun.star.wizards.text.TextTableHandler;
import com.sun.star.wizards.text.ViewHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

class ReportTextDocument
extends TextDocument
implements Comparator {
    private static final String ISLANDSCAPE = "IsLandscape";
    private static final String ISVISIBLE = "IsVisible";
    private static final String QUERYNAME = "QueryName";
    private static final String SIZE = "Size";
    private Object ReportPageStyle;
    private Object FirstPageStyle;
    private int PageWidth;
    private Rectangle PosSize;
    public Vector DBColumnsVector;
    private RecordTable CurRecordTable;
    private String sMsgTableNotExisting;
    private String sMsgCommonReportError;
    private String ContentTemplatePath;
    private String LayoutTemplatePath;
    private String sMsgEndAutopilot;
    public boolean bIsCurLandscape;
    public TextTableHandler oTextTableHandler;
    public TextSectionHandler oTextSectionHandler;
    public FormHandler oFormHandler;
    public TextStyleHandler oTextStyleHandler;
    public TextFieldHandler oTextFieldHandler;
    public ViewHandler oViewHandler;
    public NumberFormatter oNumberFormatter;
    public static final String TBLRECORDSECTION = "Tbl_RecordSection";
    public static final String TBLGROUPSECTION = "Tbl_GroupField";
    public static final String RECORDSECTION = "RecordSection";
    public static final String GROUPSECTION = "GroupField";
    public static final String COPYOFTBLRECORDSECTION = "CopyOfTbl_RecordSection";
    public static final String COPYOFTBLGROUPSECTION = "CopyOfTbl_GroupField";
    public static final String COPYOFRECORDSECTION = "CopyOfRecordSection";
    public static final String COPYOFGROUPSECTION = "CopyOfGroupField";
    private RecordParser CurDBMetaData;

    public ReportTextDocument(XMultiServiceFactory xMultiServiceFactory, XTextDocument xTextDocument, Resource resource, RecordParser recordParser) {
        super(xMultiServiceFactory, xTextDocument, false);
        this.lateInit(resource, recordParser);
    }

    public ReportTextDocument(XMultiServiceFactory xMultiServiceFactory, String string, Resource resource, RecordParser recordParser) {
        super(xMultiServiceFactory, string, true, null);
        this.lateInit(resource, recordParser);
    }

    private void lateInit(Resource resource, RecordParser recordParser) {
        this.oTextTableHandler = new TextTableHandler(this.xMSFDoc, this.xTextDocument);
        this.oTextSectionHandler = new TextSectionHandler(this.xMSFDoc, this.xTextDocument);
        this.oFormHandler = new FormHandler(this.xMSFDoc, this.xTextDocument);
        this.oTextStyleHandler = new TextStyleHandler(this.xMSFDoc, this.xTextDocument);
        this.oViewHandler = new ViewHandler(this.xMSFDoc, this.xTextDocument);
        this.oTextFieldHandler = new TextFieldHandler(this.xMSFDoc, this.xTextDocument);
        this.DBColumnsVector = new Vector();
        this.oNumberFormatter = this.oTextTableHandler.getNumberFormatter();
        this.CurDBMetaData = recordParser;
        long l = this.oNumberFormatter.getNullDateCorrection();
        this.oNumberFormatter.setBooleanReportDisplayNumberFormat();
        this.oNumberFormatter.setNullDateCorrection(l);
        this.sMsgTableNotExisting = resource.getResText(2461);
        this.sMsgCommonReportError = resource.getResText(2472);
        this.sMsgCommonReportError = JavaTools.replaceSubString(this.sMsgCommonReportError, String.valueOf('\r'), "<BR>");
        this.sMsgEndAutopilot = resource.getResText(1033);
        this.sMsgTableNotExisting = this.sMsgTableNotExisting + '\r' + this.sMsgEndAutopilot;
        this.bIsCurLandscape = true;
        this.getReportPageStyles();
    }

    public NumberFormatter getNumberFormatter() {
        return this.oNumberFormatter;
    }

    public boolean checkReportLayoutMode(String[] stringArray) {
        try {
            XNameAccess xNameAccess = this.oTextSectionHandler.xTextSectionsSupplier.getTextSections();
            Object object = stringArray.length > 0 ? xNameAccess.getByName(GROUPSECTION + String.valueOf(1)) : xNameAccess.getByName(RECORDSECTION);
            return AnyConverter.toBoolean((Object)Helper.getUnoPropertyValue(object, ISVISIBLE));
        }
        catch (Exception exception) {
            Logger.getLogger(ReportTextDocument.class.getName()).log(Level.SEVERE, null, exception);
            return true;
        }
    }

    public void swapContentTemplate(String string) {
        this.ContentTemplatePath = string;
        this.loadSectionsfromTemplate(string);
        this.oTextStyleHandler.loadStyleTemplates(string, "LoadTextStyles");
        if (this.CurRecordTable != null) {
            this.CurRecordTable.adjustOptimalTableWidths(this.xMSF, this.oViewHandler);
        }
        this.oViewHandler.selectFirstPage(this.oTextTableHandler);
    }

    public void swapLayoutTemplate(String string) {
        try {
            this.LayoutTemplatePath = string;
            boolean bl = AnyConverter.toBoolean((Object)Helper.getUnoPropertyValue(this.ReportPageStyle, ISLANDSCAPE));
            this.oTextStyleHandler.loadStyleTemplates(string, "LoadPageStyles");
            this.changePageOrientation(bl);
            this.oViewHandler.selectFirstPage(this.oTextTableHandler);
        }
        catch (Exception exception) {
            Logger.getLogger(ReportTextDocument.class.getName()).log(Level.SEVERE, null, exception);
        }
    }

    public void createReportForm(String string) {
        XNameContainer xNameContainer = this.oFormHandler.insertFormbyName(string);
        XNameAccess xNameAccess = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)xNameContainer);
        this.oFormHandler.insertHiddenControl(xNameAccess, xNameContainer, PropertyNames.COMMAND_TYPE, Integer.toString(this.CurDBMetaData.getCommandType()));
        if (this.CurDBMetaData.getCommandType() == 1) {
            this.oFormHandler.insertHiddenControl(xNameAccess, xNameContainer, QUERYNAME, this.CurDBMetaData.getCommandName());
            this.oFormHandler.insertHiddenControl(xNameAccess, xNameContainer, PropertyNames.COMMAND, "");
        } else {
            this.oFormHandler.insertHiddenControl(xNameAccess, xNameContainer, QUERYNAME, "");
            this.oFormHandler.insertHiddenControl(xNameAccess, xNameContainer, PropertyNames.COMMAND, this.CurDBMetaData.Command);
        }
        this.oFormHandler.insertHiddenControl(xNameAccess, xNameContainer, "GroupFieldNames", JavaTools.ArraytoString(this.CurDBMetaData.GroupFieldNames));
        this.oFormHandler.insertHiddenControl(xNameAccess, xNameContainer, "FieldNames", JavaTools.ArraytoString(this.CurDBMetaData.getFieldNames()));
        String[][] stringArray = this.CurDBMetaData.getSortFieldNames();
        if (stringArray != null && stringArray.length > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String[] stringArray2 : stringArray) {
                stringBuilder.append(stringArray2[0]).append(",").append(stringArray2[1]).append(";");
            }
            if (stringBuilder.length() != 0) {
                stringBuilder.delete(stringBuilder.lastIndexOf(";"), stringBuilder.length());
            }
            this.oFormHandler.insertHiddenControl(xNameAccess, xNameContainer, "Sorting", stringBuilder.toString());
        } else {
            this.oFormHandler.insertHiddenControl(xNameAccess, xNameContainer, "Sorting", "");
        }
        this.oFormHandler.insertHiddenControl(xNameAccess, xNameContainer, "RecordFieldNames", JavaTools.ArraytoString(this.CurDBMetaData.getRecordFieldNames()));
    }

    public void updateReportTitle(String string) {
        this.m_xDocProps.setTitle(string);
    }

    public void getReportPageStyles() {
        try {
            Object object = this.oTextStyleHandler.xStyleFamiliesSupplier.getStyleFamilies().getByName("PageStyles");
            this.ReportPageStyle = Helper.getUnoObjectbyName(object, "Standard");
            this.FirstPageStyle = Helper.getUnoObjectbyName(object, "First Page");
        }
        catch (Exception exception) {
            Logger.getLogger(ReportTextDocument.class.getName()).log(Level.SEVERE, null, exception);
        }
    }

    public void changePageOrientation(boolean bl) {
        try {
            this.getReportPageStyles();
            Size size = (Size)Helper.getUnoStructValue(this.ReportPageStyle, SIZE);
            this.bIsCurLandscape = AnyConverter.toBoolean((Object)Helper.getUnoPropertyValue(this.ReportPageStyle, ISLANDSCAPE));
            if (this.bIsCurLandscape != bl) {
                Size size2 = new Size(size.Height, size.Width);
                Helper.setUnoPropertyValue(this.ReportPageStyle, ISLANDSCAPE, bl);
                Helper.setUnoPropertyValue(this.ReportPageStyle, SIZE, size2);
                Helper.setUnoPropertyValue(this.FirstPageStyle, ISLANDSCAPE, bl);
                Helper.setUnoPropertyValue(this.FirstPageStyle, SIZE, size2);
                int n = AnyConverter.toInt((Object)Helper.getUnoPropertyValue(this.ReportPageStyle, "LeftMargin"));
                int n2 = AnyConverter.toInt((Object)Helper.getUnoPropertyValue(this.ReportPageStyle, "RightMargin"));
                this.PageWidth = size2.Width - n - n2;
                if (this.CurRecordTable != null) {
                    this.CurRecordTable.adjustOptimalTableWidths(this.xMSF, this.oViewHandler);
                }
            }
        }
        catch (Exception exception) {
            Logger.getLogger(ReportTextDocument.class.getName()).log(Level.SEVERE, null, exception);
        }
    }

    public boolean loadSectionsfromTemplate(String string) {
        try {
            int n;
            int n2 = this.CurDBMetaData.GroupFieldNames.length;
            this.CurRecordTable = null;
            for (n = 0; n < n2; ++n) {
                String string2 = GROUPSECTION + Integer.toString(n + 1);
                this.oTextTableHandler.renameTextTable("Tbl_" + string2, "MyTextTable");
                this.oTextSectionHandler.linkSectiontoTemplate(string, string2);
                this.oTextTableHandler.renameTextTable("MyTextTable", "Tbl_" + string2);
            }
            if (this.oTextSectionHandler.xTextSectionsSupplier.getTextSections().getElementNames().length > this.CurDBMetaData.GroupFieldNames.length) {
                this.oTextSectionHandler.linkSectiontoTemplate(string, RECORDSECTION);
                this.CurRecordTable = new RecordTable(this.oTextTableHandler);
                this.insertColumnstoRecordTable();
            }
            for (n = 0; n < n2; ++n) {
                DBColumn dBColumn = new DBColumn(this.oTextTableHandler, this.CurDBMetaData, this.CurDBMetaData.GroupFieldNames[n], n, TBLGROUPSECTION + (n + 1));
                dBColumn.formatValueCell();
                this.DBColumnsVector.set(n, dBColumn);
                this.replaceFieldValueInGroupTable(dBColumn, n);
            }
            return true;
        }
        catch (Exception exception) {
            Logger.getLogger(ReportTextDocument.class.getName()).log(Level.SEVERE, null, exception);
            return false;
        }
    }

    public void setupRecordSection(String string) {
        this.ContentTemplatePath = string;
        if (this.CurDBMetaData.getRecordFieldNames().length > 0) {
            boolean bl = true;
            if (this.CurDBMetaData.GroupFieldNames != null) {
                bl = this.CurDBMetaData.GroupFieldNames.length == 0;
            }
            this.oTextSectionHandler.insertTextSection(RECORDSECTION, string, bl);
            this.CurRecordTable = new RecordTable(this.oTextTableHandler);
            this.insertColumnstoRecordTable();
            if (this.CurRecordTable != null) {
                this.CurRecordTable.adjustOptimalTableWidths(this.xMSF, this.oViewHandler);
            }
        } else {
            this.CurRecordTable = null;
        }
    }

    public void refreshGroupFields(String[] stringArray) {
        int n = this.DBColumnsVector.size();
        for (int i = 0; i < n; ++i) {
            DBColumn dBColumn = (DBColumn)this.DBColumnsVector.elementAt(i);
            String string = dBColumn.CurDBField.getFieldName();
            if (string.equals(stringArray[i])) continue;
            dBColumn.CurDBField = this.CurDBMetaData.getFieldColumnByDisplayName(stringArray[i]);
            dBColumn.insertColumnData(this.oTextFieldHandler, this.bIsCurLandscape);
        }
    }

    public void replaceFieldValueInRecordSection(int n) {
        int n2 = this.CurDBMetaData.GroupFieldNames.length;
        int n3 = this.CurDBMetaData.getFieldNames().length;
        for (int i = n2; i < n3; ++i) {
            ((DBColumn)this.DBColumnsVector.elementAt(i)).insertColumnData(this.oTextFieldHandler, this.bIsCurLandscape);
        }
    }

    public void updateTextSections(String[] stringArray) throws Exception {
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string = TBLGROUPSECTION + Integer.toString(i + 1);
            DBColumn dBColumn = (DBColumn)this.DBColumnsVector.get(i);
            DBColumn dBColumn2 = new DBColumn(this.oTextTableHandler, this.CurDBMetaData, stringArray[i], i, string, dBColumn);
            dBColumn2.formatValueCell();
            this.DBColumnsVector.setElementAt(dBColumn2, i);
            dBColumn2.insertColumnData(this.oTextFieldHandler, this.bIsCurLandscape);
        }
    }

    public void replaceFieldValueInGroupTable(DBColumn dBColumn, int n) {
        String string = TBLGROUPSECTION + (n + 1);
        String string2 = dBColumn.xTableName.getName();
        if (string2.compareTo(string) != 0) {
            dBColumn.xTableName.setName(string);
        }
        dBColumn.insertColumnData(this.oTextFieldHandler, this.bIsCurLandscape);
        dBColumn.setCellFont();
    }

    public void replaceFieldValueInRecordTable() {
        String string = TBLRECORDSECTION;
        String string2 = this.CurRecordTable.xTableName.getName();
        if (string2.compareTo(string) != 0) {
            this.CurRecordTable.xTableName.setName(string);
        }
        int n = this.CurDBMetaData.GroupFieldNames.length;
        int n2 = this.CurDBMetaData.getRecordFieldNames().length;
        for (int i = n; i < n2; ++i) {
            ((DBColumn)this.DBColumnsVector.elementAt(i)).insertColumnData(this.oTextFieldHandler, this.bIsCurLandscape);
        }
    }

    public void insertColumnstoRecordTable() {
        try {
            int n;
            int n2;
            XTableColumns xTableColumns;
            int n3;
            int n4 = this.CurDBMetaData.GroupFieldNames.length;
            String string = this.CurRecordTable.xTableName.getName();
            if (string.compareTo(TBLRECORDSECTION) != 0) {
                this.CurRecordTable = new RecordTable(this.oTextTableHandler);
            }
            if ((n3 = (xTableColumns = this.CurRecordTable.xTextTable.getColumns()).getCount()) > (n2 = this.CurDBMetaData.getRecordFieldNames().length)) {
                n = n3 - n2;
                xTableColumns.removeByIndex(0, n);
            } else if (n3 < n2) {
                n = n2 - n3;
                this.CurRecordTable.xTextTable.getColumns().insertByIndex(n3, n);
            }
            for (n = 0; n < n2; ++n) {
                DBColumn dBColumn = new DBColumn(this.CurRecordTable, this.oTextTableHandler, this.CurDBMetaData, n, true);
                dBColumn.initializeNumberFormat();
                dBColumn.insertColumnData(this.oTextFieldHandler, this.bIsCurLandscape);
                if (this.DBColumnsVector.size() <= n + n4) {
                    this.DBColumnsVector.add(dBColumn);
                    continue;
                }
                this.DBColumnsVector.set(n + n4, dBColumn);
            }
        }
        catch (Exception exception) {
            this.showCommonReportErrorBox(exception);
        }
    }

    public boolean addGroupNametoDocument(String[] stringArray, String string, Vector vector, ArrayList arrayList, int n) {
        DBColumn dBColumn = null;
        int n2 = vector.size();
        if (n2 < 4) {
            this.removeGroupNamesofRecordTable(n);
            FieldColumn fieldColumn = this.CurDBMetaData.getFieldColumnByTitle(string);
            vector.addElement(fieldColumn.getFieldName());
            ++n2;
            try {
                String string2 = FileAccess.getPathFromList(this.xMSF, arrayList, "cnt-default.ott");
                this.oTextSectionHandler.insertTextSection(GROUPSECTION + n2, string2, n2 == 1);
                dBColumn = new DBColumn(this.oTextTableHandler, this.CurDBMetaData, fieldColumn.getFieldName(), n2 - 1, TBLGROUPSECTION + n2);
                dBColumn.formatValueCell();
                this.DBColumnsVector.addElement(dBColumn);
                this.replaceFieldValueInGroupTable(dBColumn, n2 - 1);
            }
            catch (Exception exception) {
                this.showCommonReportErrorBox(exception);
            }
        }
        return dBColumn != null;
    }

    public void removeGroupName(String[] stringArray, String string, Vector vector) {
        this.removeGroupNamesofRecordTable(stringArray.length + 1);
        FieldColumn fieldColumn = this.CurDBMetaData.getFieldColumnByTitle(string);
        vector.removeElement(fieldColumn.getFieldName());
        try {
            this.oTextSectionHandler.removeLastTextSection();
            this.oTextTableHandler.removeLastTextTable();
            if (JavaTools.FieldInList(stringArray, string) == -1) {
                this.updateTextSections(stringArray);
            }
            int n = stringArray.length;
            this.DBColumnsVector.remove(n);
        }
        catch (Exception exception) {
            this.showCommonReportErrorBox(exception);
        }
    }

    public void removeGroupNamesofRecordTable(int n) {
        int n2 = this.DBColumnsVector.size();
        if (n2 > n) {
            for (int i = n2 - 1; i >= n; --i) {
                this.DBColumnsVector.removeElementAt(i);
            }
        }
    }

    public void showCommonReportErrorBox(Exception exception) {
        String string = JavaTools.convertfromURLNotation(this.ContentTemplatePath);
        String string2 = JavaTools.replaceSubString(this.sMsgCommonReportError, string, "%PATH");
        this.CurDBMetaData.showMessageBox("ErrorBox", 0x400000, string2);
        exception.printStackTrace(System.out);
    }

    public void getallDBColumns() {
        try {
            for (int i = 0; i < this.CurDBMetaData.FieldColumns.length; ++i) {
                String string;
                DBColumn dBColumn;
                if (i < this.CurDBMetaData.GroupFieldNames.length) {
                    dBColumn = new DBColumn(this.oTextTableHandler, this.CurDBMetaData, this.CurDBMetaData.GroupFieldNames[i], i, COPYOFTBLGROUPSECTION + (i + 1));
                } else {
                    if (this.CurRecordTable == null) {
                        this.CurRecordTable = new RecordTable(this.oTextTableHandler);
                    }
                    dBColumn = new DBColumn(this.CurRecordTable, this.oTextTableHandler, this.CurDBMetaData, i - this.CurDBMetaData.GroupFieldNames.length);
                }
                if (dBColumn.xNameCell != null) {
                    this.DBColumnsVector.addElement(dBColumn);
                    continue;
                }
                if (i < this.CurDBMetaData.GroupFieldNames.length) {
                    string = this.CurDBMetaData.GroupFieldNames[i];
                    this.CurDBMetaData.GroupFieldNames = JavaTools.removefromList(this.CurDBMetaData.GroupFieldNames, new String[]{string});
                    this.CurDBMetaData.GroupFieldColumns = ReportTextDocument.removeFieldColumnByFieldName(string, this.CurDBMetaData.GroupFieldColumns);
                } else {
                    string = this.CurDBMetaData.getRecordFieldName(i - this.CurDBMetaData.GroupFieldNames.length);
                    String[] stringArray = JavaTools.removefromList(this.CurDBMetaData.getRecordFieldNames(), new String[]{string});
                    this.CurDBMetaData.setRecordFieldNames(stringArray);
                    this.CurDBMetaData.RecordFieldColumns = ReportTextDocument.removeFieldColumnByFieldName(string, this.CurDBMetaData.RecordFieldColumns);
                    this.CurDBMetaData.FieldColumns = ReportTextDocument.removeFieldColumnByFieldName(string, this.CurDBMetaData.FieldColumns);
                }
                --i;
            }
            Arrays.sort(this.CurDBMetaData.RecordFieldColumns, this);
        }
        catch (Exception exception) {
            this.showCommonReportErrorBox(exception);
        }
    }

    public int compare(Object object, Object object2) {
        FieldColumn fieldColumn = (FieldColumn)object;
        FieldColumn fieldColumn2 = (FieldColumn)object2;
        DBColumn dBColumn = this.getDBColumnByName(fieldColumn.getFieldName());
        DBColumn dBColumn2 = this.getDBColumnByName(fieldColumn2.getFieldName());
        if (dBColumn.ValColumn < dBColumn2.ValColumn) {
            return -1;
        }
        if (dBColumn.ValColumn == dBColumn2.ValColumn) {
            return 0;
        }
        return 1;
    }

    private DBColumn getDBColumnByName(String string) {
        for (int i = 0; i < this.DBColumnsVector.size(); ++i) {
            DBColumn dBColumn = (DBColumn)this.DBColumnsVector.get(i);
            if (!dBColumn.CurDBField.getFieldName().equals(string)) continue;
            return dBColumn;
        }
        return null;
    }

    public static FieldColumn[] removeFieldColumnByFieldName(String string, FieldColumn[] fieldColumnArray) {
        try {
            ArrayList<FieldColumn> arrayList = new ArrayList<FieldColumn>();
            for (int i = 0; i < fieldColumnArray.length; ++i) {
                FieldColumn fieldColumn = fieldColumnArray[i];
                if (fieldColumn.getFieldName().equals(string)) continue;
                arrayList.add(fieldColumn);
            }
            FieldColumn[] fieldColumnArray2 = new FieldColumn[arrayList.size()];
            arrayList.toArray(fieldColumnArray2);
            return fieldColumnArray2;
        }
        catch (RuntimeException runtimeException) {
            Logger.getLogger(ReportTextDocument.class.getName()).log(Level.SEVERE, null, runtimeException);
            return null;
        }
    }

    public void removeAllVisibleTextSections() {
        int n = this.CurDBMetaData.GroupFieldNames.length;
        String[] stringArray = new String[n + 1];
        stringArray[0] = RECORDSECTION;
        for (int i = 1; i <= n; ++i) {
            stringArray[i] = GROUPSECTION + i;
        }
        XNameAccess xNameAccess = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)this.oTextSectionHandler.xTextSectionsSupplier.getTextSections());
        String[] stringArray2 = xNameAccess.getElementNames();
        for (int i = 0; i < stringArray2.length; ++i) {
            String string = stringArray2[i];
            if (JavaTools.FieldInList(stringArray, string) >= 0) continue;
            this.oTextSectionHandler.removeTextSectionbyName(string);
        }
    }

    private String[] getLayoutTextTableNames() {
        int n = this.CurDBMetaData.GroupFieldNames.length;
        String[] stringArray = new String[n + 1];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = TBLGROUPSECTION + (i + 1);
        }
        stringArray[n] = TBLRECORDSECTION;
        return stringArray;
    }

    public void removeNonLayoutTextTables() {
        String[] stringArray = this.getLayoutTextTableNames();
        XNameAccess xNameAccess = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)this.oTextTableHandler.xTextTablesSupplier.getTextTables());
        String[] stringArray2 = xNameAccess.getElementNames();
        for (int i = 0; i < stringArray2.length; ++i) {
            String string = stringArray2[i];
            if (JavaTools.FieldInList(stringArray, string) >= 0) continue;
            this.oTextTableHandler.removeTextTablebyName(string);
        }
    }

    public void removeLayoutTextTables() {
        String[] stringArray = this.getLayoutTextTableNames();
        XNameAccess xNameAccess = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)this.oTextTableHandler.xTextTablesSupplier.getTextTables());
        XRelativeTextContentRemove xRelativeTextContentRemove = (XRelativeTextContentRemove)UnoRuntime.queryInterface(XRelativeTextContentRemove.class, (Object)this.xText);
        String[] stringArray2 = xNameAccess.getElementNames();
        for (int i = 0; i < stringArray2.length; ++i) {
            String string = stringArray2[i];
            if (JavaTools.FieldInList(stringArray, string) <= -1) continue;
            if (!string.equals(stringArray[0])) {
                XTextContent xTextContent = (XTextContent)UnoRuntime.queryInterface(XTextContent.class, (Object)this.oTextTableHandler.getByName(string));
                boolean bl = false;
                while (!bl) {
                    try {
                        xRelativeTextContentRemove.removeTextContentAfter(xTextContent);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        bl = true;
                    }
                }
            }
            this.oTextTableHandler.removeTextTablebyName(string);
        }
    }

    public void setLayoutSectionsVisible(boolean bl) {
        try {
            Object object;
            XNameAccess xNameAccess = this.oTextSectionHandler.xTextSectionsSupplier.getTextSections();
            int n = this.CurDBMetaData.GroupFieldNames.length;
            for (int i = 0; i < n; ++i) {
                object = xNameAccess.getByName(GROUPSECTION + String.valueOf(i + 1));
                Helper.setUnoPropertyValue(object, ISVISIBLE, bl);
            }
            if (xNameAccess.hasByName(RECORDSECTION)) {
                object = xNameAccess.getByName(RECORDSECTION);
                Helper.setUnoPropertyValue(object, ISVISIBLE, bl);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(ReportTextDocument.class.getName()).log(Level.SEVERE, null, exception);
        }
    }

    public void removeCopiedTextSections() {
        int n;
        int n2 = this.CurDBMetaData.GroupFieldNames.length;
        String[] stringArray = new String[n2 + 1];
        String[] stringArray2 = new String[n2 + 1];
        stringArray[0] = COPYOFRECORDSECTION;
        stringArray2[0] = COPYOFTBLRECORDSECTION;
        for (n = 1; n <= n2; ++n) {
            stringArray[n] = COPYOFGROUPSECTION + n;
            stringArray2[n] = COPYOFTBLGROUPSECTION + n;
        }
        for (n = 0; n <= n2; ++n) {
            this.oTextTableHandler.removeTextTablebyName(stringArray2[n]);
            this.oTextSectionHandler.removeTextSectionbyName(stringArray[n]);
        }
    }
}

