/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.common.email;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import net.suberic.crypto.MimeUtils;
import net.suberic.crypto.UpdatableMBP;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.smime.SMIMECapabilitiesAttribute;
import org.bouncycastle.asn1.smime.SMIMECapability;
import org.bouncycastle.asn1.smime.SMIMECapabilityVector;
import org.bouncycastle.asn1.smime.SMIMEEncryptionKeyPreferenceAttribute;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.i18n.ErrorBundle;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.mail.smime.SMIMEException;
import org.bouncycastle.mail.smime.SMIMESigned;
import org.bouncycastle.mail.smime.SMIMESignedGenerator;
import org.bouncycastle.mail.smime.validator.SignedMailValidator;
import org.bouncycastle.x509.PKIXCertPathReviewer;

public class EncryptionUtil {
    private X509Certificate originalCertificate;
    private X509Certificate issuerCertificate;
    private PrivateKey privateKey;
    private static final String RESOURCE_NAME = "org.bouncycastle.mail.smime.validator.SignedMailValidatorMessages";
    public static final int TITLE = 0;
    public static final int TEXT = 1;
    public static final int SUMMARY = 2;
    public static final int DETAIL = 3;
    static int dbgLvl = 3;

    public static EncryptionUtil getInstance(String pfxFile, String password, String keyAlias) {
        try {
            KeyStore keystore = EncryptionUtil.getKeyStore(pfxFile, password);
            String alias = keyAlias == null ? keystore.aliases().nextElement() : keyAlias;
            X509Certificate originalCertificate = (X509Certificate)keystore.getCertificate(alias);
            PrivateKey privateKey = (PrivateKey)keystore.getKey(alias, password.toCharArray());
            Certificate[] certChain = keystore.getCertificateChain(alias);
            X509Certificate issuerCertificate = null;
            if (certChain.length > 1) {
                issuerCertificate = (X509Certificate)certChain[1];
            }
            Security.addProvider((Provider)new BouncyCastleProvider());
            return new EncryptionUtil(privateKey, originalCertificate, issuerCertificate);
        }
        catch (Exception e) {
            return null;
        }
    }

    private EncryptionUtil(PrivateKey privateKey, X509Certificate originalCertificate, X509Certificate issuerCertificate) {
        this.issuerCertificate = issuerCertificate;
        this.originalCertificate = originalCertificate;
        this.privateKey = privateKey;
    }

    public MimeMessage signSimpleMessage(MimeMessage mimeMessage, Session session) {
        MimeMessage signedMimeMessage;
        try {
            SMIMESignedGenerator gen = this.getSMIMEGenerator();
            signedMimeMessage = new MimeMessage(session);
            MimeMessage cMsg = MimeUtils.canonicalize((MimeMessage)mimeMessage, (Session)session);
            Enumeration hLineEnum = cMsg.getAllHeaderLines();
            while (hLineEnum.hasMoreElements()) {
                signedMimeMessage.addHeaderLine((String)hLineEnum.nextElement());
            }
            MimeMultipart mp = gen.generate(cMsg, "BC");
            signedMimeMessage.setContent((Multipart)mp);
            signedMimeMessage.saveChanges();
        }
        catch (Exception e) {
            e.printStackTrace();
            return mimeMessage;
        }
        return signedMimeMessage;
    }

    public MimeMessage signMultiPartMessage(MimeMessage mimeMessage, Session session) {
        MimeMessage signedMimeMessage = new MimeMessage(session);
        try {
            Enumeration hdrLines = mimeMessage.getAllHeaderLines();
            while (hdrLines.hasMoreElements()) {
                signedMimeMessage.addHeaderLine((String)hdrLines.nextElement());
            }
            Object o = mimeMessage.getContent();
            UpdatableMBP mbp = new UpdatableMBP();
            mbp.setContent(o, mimeMessage.getContentType());
            mbp.updateMyHeaders();
            MimeBodyPart signedPart = this.signBodyPart((MimeBodyPart)mbp, session);
            signedMimeMessage.setContent((Multipart)signedPart.getContent());
            signedMimeMessage.saveChanges();
        }
        catch (Exception e) {
            e.printStackTrace();
            return mimeMessage;
        }
        return signedMimeMessage;
    }

    public MimeBodyPart signBodyPart(MimeBodyPart mimeBodyPart, Session session) {
        MimeBodyPart signedMimeBodyPart = null;
        try {
            SMIMESignedGenerator gen = this.getSMIMEGenerator();
            MimeBodyPart cBp = MimeUtils.canonicalize((MimeBodyPart)mimeBodyPart);
            MimeMultipart mm = gen.generate(cBp, "BC");
            signedMimeBodyPart = new MimeBodyPart();
            signedMimeBodyPart.setContent((Multipart)mm);
        }
        catch (Exception e) {
            e.printStackTrace();
            return mimeBodyPart;
        }
        return signedMimeBodyPart;
    }

    private static KeyStore getKeyStore(String keystoreFilename, String password) throws Exception {
        FileInputStream fIn = null;
        KeyStore keystore = null;
        try {
            fIn = new FileInputStream(keystoreFilename);
            keystore = KeyStore.getInstance("PKCS12");
            keystore.load(fIn, password.toCharArray());
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                fIn.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return keystore;
    }

    private SMIMESignedGenerator getSMIMEGenerator() throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException, CertStoreException, SMIMEException {
        SMIMESignedGenerator gen = new SMIMESignedGenerator();
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        certList.add(this.originalCertificate);
        certList.add(this.issuerCertificate);
        CertStore certsAndcrls = CertStore.getInstance("Collection", new CollectionCertStoreParameters(certList));
        ASN1EncodableVector signedAttrs = new ASN1EncodableVector();
        SMIMECapabilityVector caps = new SMIMECapabilityVector();
        caps.addCapability(SMIMECapability.dES_EDE3_CBC);
        caps.addCapability(SMIMECapability.rC2_CBC, 128);
        caps.addCapability(SMIMECapability.dES_CBC);
        signedAttrs.add((DEREncodable)new SMIMECapabilitiesAttribute(caps));
        IssuerAndSerialNumber issAndSer = new IssuerAndSerialNumber(new X509Name(this.originalCertificate.getIssuerDN().getName()), this.originalCertificate.getSerialNumber());
        signedAttrs.add((DEREncodable)new SMIMEEncryptionKeyPreferenceAttribute(issAndSer));
        gen.addSigner(this.privateKey, this.originalCertificate, SMIMESignedGenerator.DIGEST_SHA1, new AttributeTable((DEREncodableVector)signedAttrs), null);
        gen.addCertificatesAndCRLs(certsAndcrls);
        return gen;
    }

    public PKIXParameters getPKIXParameters() throws Exception {
        HashSet<TrustAnchor> trustanchors = new HashSet<TrustAnchor>();
        TrustAnchor trustAnchor = new TrustAnchor(this.originalCertificate, null);
        trustanchors.add(trustAnchor);
        PKIXParameters param = new PKIXParameters(trustanchors);
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        certList.add(this.originalCertificate);
        certList.add(this.issuerCertificate);
        CertStore certsAndcrls = CertStore.getInstance("Collection", new CollectionCertStoreParameters(certList));
        param.addCertStore(certsAndcrls);
        param.setRevocationEnabled(true);
        return param;
    }

    private boolean verify(SMIMESigned s) throws Exception {
        CertStore certs = s.getCertificatesAndCRLs("Collection", "BC");
        SignerInformationStore signers = s.getSignerInfos();
        Collection collection = signers.getSigners();
        for (SignerInformation signer : collection) {
            Collection<? extends Certificate> certCollection;
            Iterator<? extends Certificate> certIt;
            X509Certificate cert;
            if (signer.verify(cert = (X509Certificate)(certIt = (certCollection = certs.getCertificates((CertSelector)signer.getSID())).iterator()).next(), "BC")) continue;
            return false;
        }
        return true;
    }

    public static void verifySignedMail(MimeMessage msg, PKIXParameters param) throws Exception {
        Locale loc = Locale.ENGLISH;
        SignedMailValidator validator = new SignedMailValidator(msg, param);
        for (SignerInformation signer : validator.getSignerInformationStore().getSigners()) {
            PKIXCertPathReviewer review;
            ErrorBundle errMsg;
            SignedMailValidator.ValidationResult result = validator.getValidationResult(signer);
            if (result.isValidSignature()) {
                errMsg = new ErrorBundle(RESOURCE_NAME, "SignedMailValidator.sigValid");
                System.out.println(errMsg.getText(loc));
            } else {
                errMsg = new ErrorBundle(RESOURCE_NAME, "SignedMailValidator.sigInvalid");
                System.out.println(errMsg.getText(loc));
                System.out.println("Errors:");
                for (ErrorBundle errorMsg : result.getErrors()) {
                    if (dbgLvl == 3) {
                        System.out.println("\t\t" + errorMsg.getDetail(loc));
                        continue;
                    }
                    System.out.println("\t\t" + errorMsg.getText(loc));
                }
            }
            if (!result.getNotifications().isEmpty()) {
                System.out.println("Notifications:");
                for (ErrorBundle notMsg : result.getNotifications()) {
                    if (dbgLvl == 3) {
                        System.out.println("\t\t" + notMsg.getDetail(loc));
                        continue;
                    }
                    System.out.println("\t\t" + notMsg.getText(loc));
                }
            }
            if ((review = result.getCertPathReview()) == null) continue;
            if (review.isValidCertPath()) {
                System.out.println("Certificate path valid");
            } else {
                System.out.println("Certificate path invalid");
            }
            System.out.println("\nCertificate path validation results:");
            System.out.println("Errors:");
            for (ErrorBundle errorMsg : review.getErrors(-1)) {
                if (dbgLvl == 3) {
                    System.out.println("\t\t" + errorMsg.getDetail(loc));
                    continue;
                }
                System.out.println("\t\t" + errorMsg.getText(loc));
            }
            System.out.println("Notifications:");
            for (ErrorBundle noteMsg : review.getNotifications(-1)) {
                System.out.println("\t" + noteMsg.getText(loc));
            }
            Iterator<? extends Certificate> certIt = review.getCertPath().getCertificates().iterator();
            int i = 0;
            while (certIt.hasNext()) {
                X509Certificate cert = (X509Certificate)certIt.next();
                System.out.println("\nCertificate " + i + "\n========");
                System.out.println("Issuer: " + cert.getIssuerDN().getName());
                System.out.println("Subject: " + cert.getSubjectDN().getName());
                System.out.println("\tErrors:");
                for (ErrorBundle errorMsg : review.getErrors(i)) {
                    if (dbgLvl == 3) {
                        System.out.println("\t\t" + errorMsg.getDetail(loc));
                        continue;
                    }
                    System.out.println("\t\t" + errorMsg.getText(loc));
                }
                System.out.println("\tNotifications:");
                for (ErrorBundle noteMsg : review.getNotifications(i)) {
                    if (dbgLvl == 3) {
                        System.out.println("\t\t" + noteMsg.getDetail(loc));
                        continue;
                    }
                    System.out.println("\t\t" + noteMsg.getText(loc));
                }
                ++i;
            }
        }
    }
}

