/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.common.javaclass;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Map;

public class PluginInvokationHandler
implements InvocationHandler {
    private static ExLogger log = ExLogger.getExLogger(PluginInvokationHandler.class);
    Object plugin = null;
    ClassLoader pluginClassLoader = null;

    public PluginInvokationHandler(Object plugin, ClassLoader pluginClassLoader, Map<String, String> initParams) {
        this.plugin = plugin;
        this.pluginClassLoader = pluginClassLoader;
        if (initParams != null) {
            this.initParams(initParams);
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result = null;
        Thread.currentThread().setContextClassLoader(this.pluginClassLoader);
        try {
            result = method.invoke(this.plugin, args);
        }
        catch (Throwable t) {
            throw t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(this.pluginClassLoader.getParent());
        }
        return result;
    }

    private void initParams(Map<String, String> map) {
        try {
            this.plugin.getClass().getMethod("initParams", Map.class).invoke(this.plugin, map);
        }
        catch (NoSuchMethodException e) {
        }
        catch (Exception e) {
            log.error("Couldn't load plugin " + this.plugin.getClass().getSimpleName() + " initial parameters", e, new String[0]);
        }
    }
}

