/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.common.security;

import com.exlibris.core.infra.common.security.UserPrincipal;
import java.security.Principal;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import javax.servlet.http.HttpServletRequest;

public class UserPrincipalRetriever {
    public static final String IGNORE_REQUEST = "ignoreRequest";

    public static UserPrincipal getUserPrincipal() throws PolicyContextException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)PolicyContext.getContext((String)"javax.servlet.http.HttpServletRequest");
        Principal p = null;
        if (httpServletRequest != null && httpServletRequest.getUserPrincipal() != null && httpServletRequest.getAttribute(IGNORE_REQUEST) == null) {
            p = httpServletRequest.getUserPrincipal();
        } else {
            Subject caller = (Subject)PolicyContext.getContext((String)"javax.security.auth.Subject.container");
            if (caller != null && caller.getPrincipals() != null && caller.getPrincipals().iterator().hasNext()) {
                p = caller.getPrincipals().iterator().next();
            }
        }
        if (p != null && p instanceof UserPrincipal) {
            return (UserPrincipal)p;
        }
        return null;
    }

    public static String getInstitutionPath() throws PolicyContextException {
        UserPrincipal principal = UserPrincipalRetriever.getUserPrincipal();
        if (principal != null) {
            return principal.getInstitutionPath();
        }
        return null;
    }

    public static boolean isLoggedIn() {
        boolean result = false;
        try {
            Subject caller = (Subject)PolicyContext.getContext((String)"javax.security.auth.Subject.container");
            HttpServletRequest httpServletRequest = (HttpServletRequest)PolicyContext.getContext((String)"javax.servlet.http.HttpServletRequest");
            Principal p = null;
            if (httpServletRequest != null && httpServletRequest.getUserPrincipal() != null) {
                p = httpServletRequest.getUserPrincipal();
            } else if (caller != null && caller.getPrincipals() != null && caller.getPrincipals().iterator().hasNext()) {
                p = caller.getPrincipals().iterator().next();
            }
            if (p instanceof UserPrincipal) {
                result = true;
            }
        }
        catch (PolicyContextException policyContextException) {
            // empty catch block
        }
        return result;
    }

    public static String getInstitutionPathNoException() {
        String institutionPath;
        try {
            institutionPath = UserPrincipalRetriever.getInstitutionPath();
        }
        catch (Exception e) {
            return null;
        }
        return institutionPath;
    }
}

