/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.model;

import com.exlibris.core.infra.model.DividedDate;
import com.exlibris.core.infra.model.HFrUserRoles;
import com.exlibris.core.infra.model.HOwneredEntity;
import com.exlibris.core.infra.model.annotation.Searchable;
import com.exlibris.core.infra.model.annotation.emailData;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Lob;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlType;
import org.hibernate.annotations.Cascade;
import org.hibernate.validator.Length;

@Entity
@NamedQueries(value={@NamedQuery(name="FIND_USER_BY_NAME", query="select u from HFrUser u where u.userName = :userName and u.status <> :status"), @NamedQuery(name="FIND_USER_BY_EXTERNAL_ID", query="select u from HFrUser u where u.externalId = :externalId and u.status <> :status"), @NamedQuery(name="IS_AUTHORIZED", query="select u from HFrUser u where u.userName = :userName and u.password <> :password and u.status = :status"), @NamedQuery(name="FIND_USER_BY_RECORD_TYPE", query="select u from HFrUser u where u.recordType = :recordType and u.status <> :status"), @NamedQuery(name="FIND_ALL_ACTIVE_USERS", query=" from HFrUser where status = :status and (recordType = :recordType1 or recordType = :recordType2) order by userName ")})
@Table(name="HFRUSER")
public class HFrUser
extends HOwneredEntity {
    private static final long serialVersionUID = 1L;
    private Calendar expiryDate;
    private DividedDate expiryDateDummy;
    private RecordType recordType;
    private String userRecordType;
    private UserType userType;
    private String userUserType;
    private String userGroup;
    private String defaultLanguage = "en";
    private Boolean lockedOut = false;
    private Calendar lockedOutDate;
    private Integer failedAuthentication = 0;
    private String externalId;
    private String password;
    private String passwordVerify;
    private Status status;
    private String userStatus;
    private Calendar statusDate;
    private DividedDate statusDateDummy;
    private String userName;
    private String firstName;
    private String lastName;
    private String middleName;
    private String jobTitle;
    private String address1;
    private String address2;
    private String address3;
    private String address4;
    private String address5;
    private String zip;
    private String emailAddress;
    private String webSiteUrl;
    private String telephone1;
    private String telephone2;
    private String fax;
    private String registrationKey;
    private String indexXml;
    private Calendar passExpDate;
    private DividedDate passExpDateDummy;
    private String secretKey;
    private String productName;
    private List<HFrUserRoles> userRoles = new ArrayList<HFrUserRoles>();

    public HFrUser() {
        this.status = Status.ACTIVE;
        this.recordType = RecordType.USER;
        this.userRecordType = this.recordType.toString();
        this.userType = UserType.INTERNAL;
        this.statusDate = Calendar.getInstance();
        this.setStatusDate(this.statusDate);
        this.setExpiryDate(this.expiryDate);
        this.setPassExpDate(this.passExpDate);
    }

    public HFrUser(Long id, RecordType recordType, UserType userType, Status status, Calendar statusDate, Calendar modificationDate, String userName, String firstName, String lastName, String jobTitle, String emailAddress, String telephone1) {
        this();
        this.setId(id);
        this.recordType = recordType;
        this.userType = userType;
        this.status = status;
        this.statusDate = statusDate;
        this.setModificationDate(modificationDate);
        this.userName = userName;
        this.firstName = firstName;
        this.lastName = lastName;
        this.jobTitle = jobTitle;
        this.emailAddress = emailAddress;
        this.telephone1 = telephone1;
    }

    @Column(name="expiry_date")
    @Searchable
    @emailData
    public Calendar getExpiryDate() {
        if (this.expiryDate == null || this.expiryDate.getTimeInMillis() == 0L) {
            return null;
        }
        return this.expiryDate;
    }

    public void setExpiryDate(Calendar expiryDate) {
        this.expiryDate = expiryDate;
        this.expiryDateDummy = new DividedDate(this.expiryDate);
        this.expiryDate = this.expiryDateDummy.getCalendar();
    }

    @Transient
    public DividedDate getExpiryDateDummy() {
        return this.expiryDateDummy;
    }

    public void setExpiryDateDummy(DividedDate expiryDateDummy) {
        this.expiryDateDummy = expiryDateDummy;
    }

    @Column(name="user_name")
    @Searchable
    @emailData
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Column(name="record_type")
    @Enumerated
    @Searchable
    @emailData
    public RecordType getRecordType() {
        return this.recordType;
    }

    public void setRecordType(RecordType recordType) {
        this.recordType = recordType;
    }

    @Transient
    public String getUserRecordType() {
        return this.recordType.toString();
    }

    public void setUserRecordType(String userRecordType) {
        this.recordType = RecordType.valueOf(userRecordType);
        this.userRecordType = userRecordType;
    }

    @Column(name="registration_key")
    @emailData
    public String getRegistrationKey() {
        return this.registrationKey;
    }

    public void setRegistrationKey(String registrationKey) {
        this.registrationKey = registrationKey;
    }

    @Column
    @Length(max=50)
    @emailData
    public String getTelephone1() {
        return this.telephone1;
    }

    public void setTelephone1(String telephone1) {
        this.telephone1 = telephone1;
    }

    @Column
    @Length(max=50)
    @emailData
    public String getTelephone2() {
        return this.telephone2;
    }

    public void setTelephone2(String telephone2) {
        this.telephone2 = telephone2;
    }

    @Column(name="user_type")
    @Enumerated
    @Searchable
    @emailData
    public UserType getUserType() {
        return this.userType;
    }

    public void setUserType(UserType userType) {
        this.userType = userType;
    }

    @Transient
    public String getUserUserType() {
        return this.userType.toString();
    }

    public void setUserUserType(String userUserType) {
        this.userType = UserType.valueOf(userUserType);
        this.userUserType = userUserType;
    }

    @Column(name="user_group")
    @emailData
    public String getUserGroup() {
        return this.userGroup;
    }

    public void setUserGroup(String userGroup) {
        this.userGroup = userGroup;
    }

    @Column(name="default_language")
    @emailData
    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public void setDefaultLanguage(String defaultLanguage) {
        this.defaultLanguage = defaultLanguage;
    }

    @Column(name="locked_out")
    @emailData
    @Searchable
    public Boolean getLockedOut() {
        return this.lockedOut;
    }

    public void setLockedOut(Boolean lockedOut) {
        this.lockedOut = lockedOut;
    }

    @Column(name="locked_out_date")
    @emailData
    public Calendar getLockedOutDate() {
        return this.lockedOutDate;
    }

    public void setLockedOutDate(Calendar lockedOutDate) {
        this.lockedOutDate = lockedOutDate;
    }

    @Column(name="failed_authentication")
    @emailData
    public Integer getFailedAuthentication() {
        return this.failedAuthentication;
    }

    public void setFailedAuthentication(Integer failedAuthentication) {
        this.failedAuthentication = failedAuthentication;
    }

    @Column(name="external_id")
    @Searchable
    @emailData
    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    @Column
    @emailData
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Transient
    public String getPasswordVerify() {
        return this.passwordVerify;
    }

    public void setPasswordVerify(String passwordVerify) {
        this.passwordVerify = passwordVerify;
    }

    @Column(name="web_site_url")
    @emailData
    public String getWebSiteUrl() {
        return this.webSiteUrl;
    }

    public void setWebSiteUrl(String webSiteUrl) {
        this.webSiteUrl = webSiteUrl;
    }

    @Column
    @Length(max=50)
    @emailData
    public String getZip() {
        return this.zip;
    }

    public void setZip(String zip) {
        this.zip = zip;
    }

    @Column(name="email_address")
    @emailData
    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    @Column
    @Enumerated
    @Searchable
    @emailData
    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    @Transient
    public String getUserStatus() {
        return this.status.toString();
    }

    public void setUserStatus(String userStatus) {
        this.status = Status.valueOf(userStatus);
        this.userStatus = userStatus;
    }

    @Column(name="status_date")
    @emailData
    public Calendar getStatusDate() {
        if (this.statusDate == null || this.statusDate.getTimeInMillis() == 0L) {
            return null;
        }
        return this.statusDate;
    }

    public void setStatusDate(Calendar statusDate) {
        this.statusDate = statusDate;
        this.statusDateDummy = new DividedDate(this.statusDate);
        this.statusDate = this.statusDateDummy.getCalendar();
    }

    @Transient
    public DividedDate getStatusDateDummy() {
        return this.statusDateDummy;
    }

    public void setStatusDateDummy(DividedDate statusDateDummy) {
        this.statusDateDummy = statusDateDummy;
    }

    @Column(name="first_name")
    @Searchable
    @emailData
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    @Column(name="last_name")
    @Searchable
    @emailData
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @Column(name="middle_name")
    @Searchable
    @emailData
    public String getMiddleName() {
        return this.middleName;
    }

    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }

    @Column(name="job_title")
    @Searchable
    @emailData
    public String getJobTitle() {
        return this.jobTitle;
    }

    public void setJobTitle(String jobTitle) {
        this.jobTitle = jobTitle;
    }

    @Column
    @Length(max=100)
    @Searchable
    @emailData
    public String getAddress1() {
        return this.address1;
    }

    public void setAddress1(String address1) {
        this.address1 = address1;
    }

    @Column
    @Length(max=100)
    @emailData
    public String getAddress2() {
        return this.address2;
    }

    public void setAddress2(String address2) {
        this.address2 = address2;
    }

    @Column
    @Length(max=100)
    @emailData
    public String getAddress3() {
        return this.address3;
    }

    public void setAddress3(String address3) {
        this.address3 = address3;
    }

    @Column
    @Length(max=100)
    @emailData
    public String getAddress4() {
        return this.address4;
    }

    public void setAddress4(String address4) {
        this.address4 = address4;
    }

    @Column
    @Length(max=100)
    @emailData
    public String getAddress5() {
        return this.address5;
    }

    public void setAddress5(String address5) {
        this.address5 = address5;
    }

    @OneToMany(mappedBy="user", targetEntity=HFrUserRoles.class, fetch=FetchType.LAZY, cascade={CascadeType.MERGE})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<HFrUserRoles> getUserRoles() {
        return this.userRoles;
    }

    public void setUserRoles(List<HFrUserRoles> userRoles) {
        this.userRoles = userRoles;
    }

    @Column(name="index_xml")
    @Lob
    public String getIndexXml() {
        return this.indexXml;
    }

    public void setIndexXml(String indexXml) {
        this.indexXml = indexXml;
    }

    public static void main(String[] args) {
        Status s = Status.ACTIVE;
        Class<?> c = ((Object)((Object)s)).getClass();
        System.out.println(c.getName());
    }

    public Calendar getPassExpDate() {
        if (this.passExpDate == null || this.passExpDate.getTimeInMillis() == 0L) {
            return null;
        }
        return this.passExpDate;
    }

    public void setPassExpDate(Calendar passExpDate) {
        this.passExpDate = passExpDate;
        this.passExpDateDummy = new DividedDate(this.passExpDate);
        this.passExpDate = this.passExpDateDummy.getCalendar();
    }

    @Transient
    public DividedDate getPassExpDateDummy() {
        return this.passExpDateDummy;
    }

    public void setPassExpDateDummy(DividedDate passExpDateDummy) {
        this.passExpDateDummy = passExpDateDummy;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    @Column(name="secret_key")
    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    @Column(name="product_name")
    @emailData
    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    @Column
    @Length(max=50)
    @emailData
    public String getFax() {
        return this.fax;
    }

    public void setFax(String fax) {
        this.fax = fax;
    }

    public static enum UserType {
        CASUAL,
        INTERNAL,
        EXTERNAL,
        INTEXTAUTH;

    }

    public static enum RecordType {
        USER,
        CONTACT,
        ORGANIZATION,
        STAFF,
        PUBLIC;

    }

    @XmlType(name="user_status")
    public static enum Status {
        ACTIVE,
        INACTIVE,
        DELETED;

    }
}

