/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.model.properties;

import com.exlibris.core.infra.model.HPersistent;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;

@Entity
@NamedQueries(value={@NamedQuery(name="FIND_PROPERTIES_CONFIGURATION_BY_NAME", query="select pc from PropertiesConfiguration pc where upper(pc.fieldName) = upper(:fieldName)"), @NamedQuery(name="FIND_PROPERTIES_CONFIGURATION_BY_LEVEL", query="select pc from PropertiesConfiguration pc where pc.entityLevel = :level"), @NamedQuery(name="FIND_FIELD_NAME_BY_LEVEL", query="select fieldName from PropertiesConfiguration pc where pc.entityLevel = :level"), @NamedQuery(name="FIND_FIELD_NAME_BY_LEVEL_AND_TYPE", query="select fieldName from PropertiesConfiguration pc where pc.entityLevel = :level and type = :type"), @NamedQuery(name="FIND_FIELD_NAME_BY_LEVEL_SELECTABLE", query="select fieldName from PropertiesConfiguration pc where pc.entityLevel = :level and sqlSelectForm is not null"), @NamedQuery(name="FIND_FIELD_NAME_BY_LEVEL_SORTABLE", query="select fieldName from PropertiesConfiguration pc where pc.entityLevel = :level and (pc.repeatable = false or pc.metadataType = 'DC')"), @NamedQuery(name="FIND_ALL_FIELD_NAMES", query="select fieldName from PropertiesConfiguration"), @NamedQuery(name="FIND_ALL_FIELD_NAMES_SORTABLE", query="select fieldName from PropertiesConfiguration pc where (pc.repeatable = false or pc.metadataType = 'DC')"), @NamedQuery(name="FIND_PROPERTIES_CONFIGURATION_1", query="select r from PropertiesConfiguration r where r.metadataType = :metadataType1 order by r.fieldName"), @NamedQuery(name="FIND_PROPERTIES_CONFIGURATION_2", query="select r from PropertiesConfiguration r where r.metadataType = :metadataType1 or  r.metadataType = :metadataType2 order by r.fieldName"), @NamedQuery(name="FIND_FIELD_NAME_WITH_FACET", query="select fieldName from PropertiesConfiguration pc where pc.entityLevel = :level and facet is not null"), @NamedQuery(name="DELETE_SP_PROPERTIES", query="delete from PropertiesConfiguration r where r.metadataType = :metadataType1"), @NamedQuery(name="DELETE_SP_BY_NAME", query="delete from PropertiesConfiguration r where r.fieldName = :fieldName1")})
@Table(name="PropertiesConfiguration", uniqueConstraints={@UniqueConstraint(columnNames={"FIELDNAME"})})
public class PropertiesConfiguration
extends HPersistent {
    private static final long serialVersionUID = -7471948274821239542L;
    private String fieldName;
    private String description;
    private Level entityLevel;
    private MetadataType metadataType;
    private Type type;
    private UIType uiType;
    private String lookupMethod;
    private boolean repeatable;
    private Facet facet;
    private String sqlSelectForm;

    @Column
    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    @Column
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Column
    @Enumerated(value=EnumType.STRING)
    public MetadataType getMetadataType() {
        return this.metadataType;
    }

    public void setMetadataType(MetadataType metadataType) {
        this.metadataType = metadataType;
    }

    @Column
    @Enumerated(value=EnumType.STRING)
    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    @Column
    @Enumerated(value=EnumType.STRING)
    public UIType getUiType() {
        return this.uiType;
    }

    public void setUiType(UIType uiType) {
        this.uiType = uiType;
    }

    @Column
    public String getLookupMethod() {
        return this.lookupMethod;
    }

    public void setLookupMethod(String lookupMethod) {
        this.lookupMethod = lookupMethod;
    }

    @Column
    public boolean isRepeatable() {
        return this.repeatable;
    }

    public void setRepeatable(boolean repeatable) {
        this.repeatable = repeatable;
    }

    @Column
    @Enumerated(value=EnumType.STRING)
    public Level getEntityLevel() {
        return this.entityLevel;
    }

    public void setEntityLevel(Level entityLevel) {
        this.entityLevel = entityLevel;
    }

    @Column
    @Enumerated(value=EnumType.STRING)
    public Facet getFacet() {
        return this.facet;
    }

    public void setFacet(Facet facet) {
        this.facet = facet;
    }

    @Column(length=2000)
    public String getSqlSelectForm() {
        return this.sqlSelectForm;
    }

    public void setSqlSelectForm(String sqlSelectForm) {
        this.sqlSelectForm = sqlSelectForm;
    }

    public static enum Facet {
        RANGE,
        VALUE;

    }

    public static enum MetadataType {
        DC,
        DNX,
        SP;

    }

    public static enum Level {
        IE,
        REP,
        FILE;

    }

    public static enum UIType {
        FREE_TEXT,
        DATE,
        LOOKUP,
        DROPDOWN,
        BOOLEAN,
        TREE;


        public static UIType getDefault(Type type) {
            switch (type) {
                case DATE: {
                    return DATE;
                }
                case BOOLEAN: {
                    return BOOLEAN;
                }
            }
            return FREE_TEXT;
        }
    }

    public static enum Type {
        TEXT,
        STRING,
        NUMBER,
        DATE,
        BOOLEAN,
        NORM_STRING;

    }
}

