/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.model.storage;

import com.exlibris.core.infra.model.HOwneredVersionedEntity;
import com.exlibris.core.infra.model.storage.Storage;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Cascade;
import org.hibernate.collection.PersistentBag;

@Entity
@Table(name="STORAGE_GROUP")
public class StorageGroup
extends HOwneredVersionedEntity {
    private static final long serialVersionUID = 1L;
    private Strategy strategyMethod;
    private List<Storage> storages;
    private String name;
    private String description;
    private String moduleType;
    private String storageNamingClass;
    private Integer matchRate;

    @OneToMany(mappedBy="group", targetEntity=Storage.class, cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<Storage> getStorages() {
        return this.storages;
    }

    @Column(name="NAME")
    public String getName() {
        return this.name;
    }

    @Column(name="DESCRIPTION")
    public String getDescription() {
        return this.description;
    }

    @Column(name="MODULE_TYPE")
    public String getModuleType() {
        return this.moduleType;
    }

    @Column(name="NAMING_CLASS")
    public String getStorageNamingClass() {
        return this.storageNamingClass;
    }

    @Column(name="STRATEGY_METHOD")
    public Strategy getStrategyMethod() {
        return this.strategyMethod;
    }

    @Transient
    public Integer getMatchRate() {
        return this.matchRate;
    }

    @Transient
    public String getMatchRateStr() {
        if (this.matchRate == null) {
            return null;
        }
        return this.matchRate + "%";
    }

    public void setStorages(List<Storage> storages) {
        this.storages = storages;
        if (storages != null && !storages.getClass().equals(PersistentBag.class)) {
            for (Storage storage : storages) {
                storage.setGroup(this);
            }
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setModuleType(String moduleType) {
        this.moduleType = moduleType;
    }

    public void setMatchRate(Integer matchRate) {
        this.matchRate = matchRate;
    }

    public void setStorageNamingClass(String storageNamingClass) {
        this.storageNamingClass = storageNamingClass;
    }

    public void setStrategyMethod(Strategy strategyMethod) {
        this.strategyMethod = strategyMethod;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.matchRate == null ? 0 : this.matchRate.hashCode());
        result = 31 * result + (this.moduleType == null ? 0 : this.moduleType.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.storages == null ? 0 : ((Object)this.storages).hashCode());
        result = 31 * result + (this.strategyMethod == null ? 0 : this.strategyMethod.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StorageGroup other = (StorageGroup)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.matchRate == null ? other.matchRate != null : !this.matchRate.equals(other.matchRate)) {
            return false;
        }
        if (this.moduleType == null ? other.moduleType != null : !this.moduleType.equals(other.moduleType)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.storages == null ? other.storages != null : !((Object)this.storages).equals(other.storages)) {
            return false;
        }
        return !(this.strategyMethod == null ? other.strategyMethod != null : !this.strategyMethod.equals((Object)other.strategyMethod));
    }

    public static enum Strategy {
        ORDERED,
        RANDOM;

    }
}

