/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.common;

import com.exlibris.core.infra.model.logs.LogTable;
import com.exlibris.core.infra.svc.api.locator.ServiceLocator;
import com.exlibris.core.infra.svc.api.logs.LogTableService;
import java.util.Calendar;

public class DBLogger {
    private LogTable.LogStatus logStatus;
    private String group;
    private String source;
    private Calendar startTime;
    private StringBuilder content;

    public DBLogger(String group, String source, Calendar startTime) {
        this.group = group;
        this.source = source;
        this.logStatus = LogTable.LogStatus.SUCCESS;
        this.startTime = startTime;
        this.content = new StringBuilder();
    }

    public DBLogger(String group, String source) {
        this(group, source, Calendar.getInstance());
    }

    public LogTable.LogStatus getLogStatus() {
        return this.logStatus;
    }

    public void setLogStatus(LogTable.LogStatus logStatus) {
        this.logStatus = logStatus;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public Calendar getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Calendar startTime) {
        this.startTime = startTime;
    }

    public StringBuilder getContent() {
        return this.content;
    }

    public void setContent(StringBuilder content) {
        this.content = content;
    }

    public void info(String message) {
        this.appendMessage("INFO", message);
    }

    public void warn(String message) {
        if (this.logStatus == LogTable.LogStatus.SUCCESS) {
            this.logStatus = LogTable.LogStatus.WARN;
        }
        this.appendMessage("WARN", message);
    }

    public void error(String message) {
        this.logStatus = LogTable.LogStatus.ERROR;
        this.appendMessage("ERROR", message);
    }

    private void appendMessage(String msgType, String message) {
        this.content.append("\n").append(Calendar.getInstance().getTime().toString()).append("   ").append(msgType).append("   ").append(message);
    }

    public void save() {
        LogTableService logTableService = (LogTableService)ServiceLocator.getInstance().lookUp(LogTableService.class);
        long duration = System.currentTimeMillis() - this.startTime.getTimeInMillis();
        logTableService.log(this.logStatus, this.group, this.source, this.content.toString().trim(), this.startTime, duration);
    }
}

