/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.config;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.common.interfaces.Resettable;
import com.exlibris.core.infra.model.codetables.HCodeTables;
import com.exlibris.core.infra.model.codetables.HMappingTables;
import com.exlibris.core.infra.svc.api.CodeTablesManager;
import com.exlibris.core.infra.svc.api.locator.ServiceLocator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;

public class EventCacheManager
implements Resettable {
    private static final ExLogger log = ExLogger.getExLogger(EventCacheManager.class);
    private static EventCacheManager cmt = null;
    private HashMap<String, ArrayList<String>> parametersForEventType = new HashMap();
    private HashMap<String, String[]> propertiesForEventType = new HashMap();
    private HashMap<String, ArrayList<String>> analyzersForEventType = new HashMap();
    private Hashtable<String, String> codeEventType = new Hashtable();
    private Hashtable<String, String> IsProvenanceForEventType = new Hashtable();
    private HashMap<String, ArrayList<String>> eventKeys = new HashMap();
    private HashMap<String, ArrayList<String>> eventContext = new HashMap();
    private ArrayList<String> analyzerType = new ArrayList();
    private boolean isInit = false;

    public static synchronized EventCacheManager getInstance() {
        if (cmt == null) {
            cmt = new EventCacheManager();
            cmt.load();
        }
        return cmt;
    }

    private void load() {
        try {
            this.retriveAnalyzerType();
            this.retrieveParametersForEventType();
            this.retrievePropertiesForEventType();
            this.retrieveAnalyzersForEventType();
            this.retriveCodeForEventType();
            this.retrieveIsprovenanceForEventType();
            this.retrieveEventKeysForEventType();
            this.retrieveEventContextForEventType();
            this.isInit = true;
            log.info("Setting Loaded");
        }
        catch (Throwable e) {
            log.error("Failed to load", new String[0]);
        }
    }

    private void retriveAnalyzerType() {
        log.info("Setting Codes For EventAnalyzers");
        CodeTablesManager codeTablesManagerObj = (CodeTablesManager)ServiceLocator.getInstance().lookUp(CodeTablesManager.class);
        List<HCodeTables> codeTables = codeTablesManagerObj.findAllCodeTableByTableName("EventAnalyzers");
        for (HCodeTables row : codeTables) {
            String analyzerClass = row.getDescription();
            this.analyzerType.add(analyzerClass);
        }
    }

    private void retriveCodeForEventType() {
        log.info("Setting Codes For EventType");
        CodeTablesManager codeTablesManagerObj = (CodeTablesManager)ServiceLocator.getInstance().lookUp(CodeTablesManager.class);
        List<HCodeTables> codeTables = codeTablesManagerObj.findAllCodeTableByTableName("EventType");
        for (HCodeTables row : codeTables) {
            String eventTypeCode = row.getCode();
            String eventTypeName = row.getDescription();
            this.codeEventType.put(eventTypeCode, eventTypeName);
        }
    }

    private void retrieveParametersForEventType() {
        log.info("Setting Parameters For EventType");
        CodeTablesManager codeTablesManagerObj = (CodeTablesManager)ServiceLocator.getInstance().lookUp(CodeTablesManager.class);
        List<HMappingTables> mappingTables = codeTablesManagerObj.findAllMappingTableByName("EventParameters");
        for (HMappingTables row : mappingTables) {
            ArrayList<Object> parameters;
            String eventType = row.getTargetCode();
            if (this.parametersForEventType.get(eventType) == null) {
                parameters = new ArrayList<String>();
                parameters.add(row.getSourceCode1());
                this.parametersForEventType.put(eventType, parameters);
                continue;
            }
            parameters = this.parametersForEventType.get(eventType);
            parameters.add(row.getSourceCode1());
        }
    }

    private void retrievePropertiesForEventType() {
        log.info("Setting Properties For EventType");
        CodeTablesManager codeTablesManagerObj = (CodeTablesManager)ServiceLocator.getInstance().lookUp(CodeTablesManager.class);
        List<HMappingTables> mappingTables = codeTablesManagerObj.findAllMappingTableByName("EventMng");
        for (HMappingTables row : mappingTables) {
            String eventType = row.getTargetCode();
            String[] properties = new String[]{row.getSourceCode1(), row.getSourceCode2(), row.getSourceCode3(), row.getSourceCode4(), row.getSourceCode5()};
            this.propertiesForEventType.put(eventType, properties);
        }
    }

    private void retrieveAnalyzersForEventType() {
        log.info("Setting Analyzers For EventType");
        CodeTablesManager codeTablesManagerObj = (CodeTablesManager)ServiceLocator.getInstance().lookUp(CodeTablesManager.class);
        List<HMappingTables> mappingTables = codeTablesManagerObj.findAllMappingTableByName("Analyzer");
        for (HMappingTables row : mappingTables) {
            ArrayList<Object> analyzers;
            String eventType = row.getSourceCode1();
            if (this.analyzersForEventType.get(eventType) == null) {
                analyzers = new ArrayList<String>();
                analyzers.add(row.getTargetCode());
                this.analyzersForEventType.put(eventType, analyzers);
                continue;
            }
            analyzers = this.analyzersForEventType.get(eventType);
            if (analyzers.contains(row.getTargetCode())) continue;
            analyzers.add(row.getTargetCode());
        }
    }

    private void retrieveIsprovenanceForEventType() {
        log.info("Setting Properties For EventTypeProvenance");
        CodeTablesManager codeTablesManagerObj = (CodeTablesManager)ServiceLocator.getInstance().lookUp(CodeTablesManager.class);
        List<HMappingTables> mappingTables = codeTablesManagerObj.findAllMappingTableByName("isProvenance");
        for (HMappingTables row : mappingTables) {
            String eventType = row.getTargetCode();
            String properties = row.getSourceCode1();
            this.IsProvenanceForEventType.put(eventType, properties);
        }
    }

    private void retrieveEventKeysForEventType() {
        log.info("Setting Keys For EventType");
        CodeTablesManager codeTablesManagerObj = (CodeTablesManager)ServiceLocator.getInstance().lookUp(CodeTablesManager.class);
        List<HMappingTables> mappingTables = codeTablesManagerObj.findAllMappingTableByName("EventKeys");
        for (HMappingTables row : mappingTables) {
            String eventType = row.getTargetCode();
            if (this.eventKeys.get(eventType) == null) {
                ArrayList<String> keys = new ArrayList<String>();
                keys.add(row.getSourceCode1());
                this.eventKeys.put(eventType, keys);
                continue;
            }
            this.eventKeys.get(eventType).add(row.getSourceCode1());
        }
    }

    private void retrieveEventContextForEventType() {
        log.info("Setting Context For EventType");
        CodeTablesManager codeTablesManagerObj = (CodeTablesManager)ServiceLocator.getInstance().lookUp(CodeTablesManager.class);
        List<HMappingTables> mappingTables = codeTablesManagerObj.findAllMappingTableByName("EventContext");
        for (HMappingTables row : mappingTables) {
            String eventType = row.getTargetCode();
            if (this.eventContext.get(eventType) == null) {
                ArrayList<String> context = new ArrayList<String>();
                context.add(row.getSourceCode1());
                this.eventContext.put(eventType, context);
                continue;
            }
            this.eventContext.get(eventType).add(row.getSourceCode1());
        }
    }

    @Override
    public synchronized void reset() {
        this.load();
    }

    public static void main(String[] args) {
        new EventCacheManager().load();
    }

    public HashMap<String, ArrayList<String>> getParametersForEventType() {
        return this.parametersForEventType;
    }

    public void setParametersForEventType(HashMap<String, ArrayList<String>> parametersForEventType) {
        this.parametersForEventType = parametersForEventType;
    }

    public HashMap<String, ArrayList<String>> getKeysForEventType() {
        return this.eventKeys;
    }

    public void setKeysForEventType(HashMap<String, ArrayList<String>> eventKeys) {
        this.eventKeys = eventKeys;
    }

    public HashMap<String, ArrayList<String>> getContextForEventType() {
        return this.eventContext;
    }

    public void setContextForEventType(HashMap<String, ArrayList<String>> eventContext) {
        this.eventContext = eventContext;
    }

    public HashMap<String, String[]> getPropertiesForEventType() {
        return this.propertiesForEventType;
    }

    public void setPropertiesForEventType(HashMap<String, String[]> propertiesForEventType) {
        this.propertiesForEventType = propertiesForEventType;
    }

    public HashMap<String, ArrayList<String>> getAnalyzersForEventType() {
        return this.analyzersForEventType;
    }

    public void setAnalyzersForEventType(HashMap<String, ArrayList<String>> analyzersForEventType) {
        this.analyzersForEventType = analyzersForEventType;
    }

    public Hashtable<String, String> getIsProvenanceForEventType() {
        return this.IsProvenanceForEventType;
    }

    public void setIsProvenanceForEventType(Hashtable<String, String> isProvenanceForEventType) {
        this.IsProvenanceForEventType = isProvenanceForEventType;
    }

    public ArrayList<String> getAnalyzerType() {
        return this.analyzerType;
    }

    public void setAnalyzerType(ArrayList<String> analyzerType) {
        this.analyzerType = analyzerType;
    }

    public Hashtable<String, String> getCodeEventType() {
        return this.codeEventType;
    }

    public void setCodeEventType(Hashtable<String, String> codeEventType) {
        this.codeEventType = codeEventType;
    }
}

