/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.scriptRunner;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.svc.api.scriptRunner.ExecAbstract;
import com.exlibris.core.infra.svc.api.scriptRunner.ExecStrategy;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.tanukisoftware.wrapper.WrapperManager;
import org.tanukisoftware.wrapper.WrapperProcess;
import org.tanukisoftware.wrapper.WrapperProcessConfig;

public class ExecWrapper
extends ExecAbstract
implements ExecStrategy {
    private static final long serialVersionUID = -5883613952915737594L;
    private static final ExLogger logger = ExLogger.getExLogger(ExecWrapper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int execExternalProcess(String cmd, List<String> args) {
        super.execExternalProcess(cmd, args);
        WrapperProcess proccess = null;
        ArrayList<String> processArgs = new ArrayList<String>();
        if (args != null) {
            for (int i = 0; i < args.size(); ++i) {
                processArgs.add(args.get(i));
            }
        }
        try {
            int i;
            processArgs.add(0, cmd);
            String osName = System.getProperty("os.name");
            if (!(osName.equals("Unix") || osName.equals("Linux") || osName.equals("SunOS"))) {
                for (i = 1; i < processArgs.size(); ++i) {
                    processArgs.set(i, "\"" + (String)processArgs.get(i) + "\"");
                }
                processArgs.add(0, "/C");
                processArgs.add(0, "cmd.exe");
            }
            i = 0;
            String[] wrapperArgs = new String[processArgs.size()];
            Iterator i$ = processArgs.iterator();
            while (i$.hasNext()) {
                String arg;
                wrapperArgs[i] = arg = (String)i$.next();
                ++i;
            }
            WrapperProcessConfig wpConfig = new WrapperProcessConfig();
            if (WrapperProcessConfig.isSupported((int)1)) {
                wpConfig.setStartType(1);
            }
            proccess = WrapperManager.exec((String[])wrapperArgs, (WrapperProcessConfig)wpConfig);
            StreamReader errorStr = new StreamReader(proccess.getErrorStream(), "ERROR");
            StreamReader outputStream = new StreamReader(proccess.getInputStream(), "INFO");
            errorStr.start();
            outputStream.start();
            try {
                errorStr.join(0L);
                outputStream.join(0L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            proccess.waitFor();
            this.exitValue = proccess.exitValue();
            this.inputStream = outputStream.getOutput();
            if (this.exitValue == 1) {
                this.errorStream = errorStr.getOutput();
            }
        }
        catch (Throwable t) {
            logger.error(System.getProperty("java.classpath"), new String[0]);
            this.errorStream = t.getMessage();
            logger.error(t);
            this.exitValue = 1;
        }
        finally {
            if (proccess != null) {
                proccess.destroy();
                proccess = null;
            }
        }
        return this.exitValue;
    }

    public static class StreamReader
    extends Thread {
        InputStream is;
        String type;
        StringBuffer output = null;
        final String LINE_SEP = System.getProperty("line.separator");

        StreamReader(InputStream is, String type) {
            this.is = is;
            this.type = type;
            this.output = new StringBuffer();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    if (this.type != null && this.type.equalsIgnoreCase("ERROR")) {
                        logger.info(this.type + ": " + line);
                    }
                    this.output.append(line).append(this.LINE_SEP);
                }
            }
            catch (IOException ioe) {
            }
            finally {
                if (this.is != null) {
                    try {
                        this.is.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        public String getOutput() {
            if (this.output != null) {
                return this.output.toString();
            }
            return "";
        }
    }
}

