/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.utils;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.svc.api.GeneralParameterManager;
import com.exlibris.core.infra.svc.api.locator.ServiceLocator;
import java.util.HashMap;
import java.util.Map;
import org.dom4j.Namespace;

public class DublinCoreDefinition {
    private static ExLogger log = ExLogger.getExLogger(DublinCoreDefinition.class);
    private static Map<String, Namespace> nameSpaceMap = null;
    public static final String DC_PREFIX = "dc";
    public static final String DCTERMS_PERFIX = "dcterms";
    public static final String XSI_TYPE = "xsi:type";
    public static final String XML_LANG = "xml:lang";
    public static final Namespace dcNamespace = new Namespace("dc", "http://purl.org/dc/elements/1.1/");
    public static final Namespace dctermsNamespace = new Namespace("dcterms", "http://purl.org/dc/terms/");
    public static final Namespace xsiNamespace = new Namespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
    public static final Namespace xmlNamespace = new Namespace("xml", "http://www.w3.org/XML/1998/namespace");

    private static void addPropertyNameSpaceToMap(String property) {
        String[] array = property.split("=");
        if (array == null || array.length != 2 || array[0].length() < 7 || array[1].length() < 3) {
            log.warn((Object)"general-parameter - dublincore_additional_namespaces has wrong value", new String[0]);
            return;
        }
        String prefix = array[0].substring(6);
        int length = array[1].length();
        if (array[1].charAt(0) != '\"' && array[1].charAt(length - 1) != '\"') {
            log.warn((Object)"general-parameter - dublincore_additional_namespaces has wrong value", new String[0]);
            return;
        }
        String name = array[1].substring(1, length - 1);
        Namespace namespace = new Namespace(prefix, name);
        nameSpaceMap.put(prefix, namespace);
    }

    private static void initNameSpaceMap() {
        nameSpaceMap = new HashMap<String, Namespace>();
        GeneralParameterManager genParamMng = (GeneralParameterManager)ServiceLocator.getInstance().lookUp(GeneralParameterManager.class);
        String namespaces = genParamMng.getParameter("general", "dublincore_additional_namespaces");
        if (namespaces == null) {
            return;
        }
        String[] array = namespaces.split(";xmlns:");
        if (array == null || array.length <= 0) {
            return;
        }
        DublinCoreDefinition.addPropertyNameSpaceToMap(array[0]);
        for (int i = 1; i < array.length; ++i) {
            DublinCoreDefinition.addPropertyNameSpaceToMap("xmlns:" + array[i]);
        }
    }

    public static Map<String, Namespace> getNameSpaceMap() {
        return nameSpaceMap;
    }

    public static void setNameSpaceMap(Map<String, Namespace> nameSpaceMap) {
        DublinCoreDefinition.nameSpaceMap = nameSpaceMap;
    }

    public static Namespace getNameSpace(String namespace) {
        if (namespace.compareToIgnoreCase(DC_PREFIX) == 0) {
            return dcNamespace;
        }
        if (namespace.compareToIgnoreCase(DCTERMS_PERFIX) == 0) {
            return dctermsNamespace;
        }
        if (namespace.compareToIgnoreCase(XSI_TYPE) == 0) {
            return xsiNamespace;
        }
        if (namespace.compareToIgnoreCase(XML_LANG) == 0) {
            return xmlNamespace;
        }
        return nameSpaceMap.get(namespace);
    }

    static {
        DublinCoreDefinition.initNameSpaceMap();
    }
}

