/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.sdk.utils;

import com.exlibris.core.infra.common.util.IOUtil;
import com.exlibris.core.infra.svc.api.CodeTablesResourceBundle;
import com.exlibris.core.sdk.formatting.DublinCore;
import com.exlibris.core.sdk.shared.FileData;
import com.exlibris.core.sdk.utils.ContentStructureValidator;
import com.exlibris.core.sdk.utils.FileUtil;
import com.exlibris.core.sdk.utils.FolderUtil;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Node;
import org.dom4j.XPath;
import org.dom4j.io.SAXReader;

public class DepositDirUtil
extends FolderUtil {
    public static final String METS_XML = "mets.xml";
    public static final String MARCS_XML = "marcs.xml";
    public static final String MODS_XML = "mods.xml";
    public static final String DCS_XML = "dcs.xml";
    public static final String CSV_FIlE = "csv.csv";
    public static final String DIRECTORY_STRUCTURE = "directoryStructure.txt";
    public static final String SET_OF_FILES = "setOfFiles.xml";
    public static final String COPYRIGHTS_FILE = "copyrights.txt";
    public static final String ACCESS_RIGHTS_XML = "access_rights.xml";
    public static final String CONVERTING_RULES_XML = "converting_rules.xml";
    public static final String PARAMS_XML = "params.xml";
    public static final String DC_XML = "dc.xml";
    public static final String IE_MD_XML = "ieMd.xml";
    public static final String XML = "xml";
    public static final String DEPOSIT_DIR = "deposit";
    public static final String STREAMS_DIR = "streams";
    public static final String CONTENT_DIR = "content";
    public static final String SETTINGS_DIR = "settings";
    public static final String RECORDS_NODE_NAME = "records";
    protected String m_depositDir = this.m_folderDir + "deposit" + File.separator;
    protected String m_streamsDir = null;
    protected String m_contentDir = this.m_depositDir + "content" + File.separator;
    protected String m_settingsDir = null;

    public DepositDirUtil(String areaDir, String folderId) {
        super(areaDir, folderId);
        this.m_streamsDir = this.m_contentDir + STREAMS_DIR + File.separator;
        this.m_settingsDir = this.m_depositDir + SETTINGS_DIR + File.separator;
    }

    @Override
    public boolean createNewDirStructure() {
        FileUtil.createFile(this.m_depositDir);
        FileUtil.createFile(this.m_contentDir);
        FileUtil.createFile(this.m_streamsDir);
        FileUtil.createFile(this.m_settingsDir);
        return true;
    }

    @Override
    public void deleteDirStructure() throws IOException {
        FileUtil.forceDelete(this.m_folderDir);
    }

    @Override
    public void resetDirStructure() throws IOException {
        this.deleteDirStructure();
        this.createNewDirStructure();
    }

    public boolean addFileToDeposit(String sourcePath, depositDirectories targetDir) throws IOException {
        switch (targetDir) {
            case STREAMS_DIR: {
                return this.addFile(sourcePath, this.m_streamsDir);
            }
            case CONTENT_DIR: {
                return this.addFile(sourcePath, this.m_contentDir);
            }
            case SETTINGS_DIR: {
                return this.addFile(sourcePath, this.m_settingsDir);
            }
        }
        return false;
    }

    public boolean addFileToDeposit(File sourcePath, depositDirectories targetDir) throws IOException {
        switch (targetDir) {
            case STREAMS_DIR: {
                return this.addFile(sourcePath, this.m_streamsDir);
            }
            case CONTENT_DIR: {
                return this.addFile(sourcePath, this.m_contentDir);
            }
            case SETTINGS_DIR: {
                return this.addFile(sourcePath, this.m_settingsDir);
            }
        }
        return false;
    }

    public boolean addFileToDeposit(InputStream source, String fileName, depositDirectories targetDir) throws IOException {
        switch (targetDir) {
            case STREAMS_DIR: {
                return this.addFile(source, fileName, this.m_streamsDir);
            }
            case CONTENT_DIR: {
                return this.addFile(source, fileName, this.m_contentDir);
            }
            case SETTINGS_DIR: {
                return this.addFile(source, fileName, this.m_settingsDir);
            }
        }
        return false;
    }

    public boolean addFileToDeposit(String fileContents, String fileNameWithExt, depositDirectories targetDir) throws IOException {
        switch (targetDir) {
            case STREAMS_DIR: {
                return this.addFile(fileContents, fileNameWithExt, this.m_streamsDir);
            }
            case CONTENT_DIR: {
                return this.addFile(fileContents, fileNameWithExt, this.m_contentDir);
            }
            case SETTINGS_DIR: {
                return this.addFile(fileContents, fileNameWithExt, this.m_settingsDir);
            }
        }
        return false;
    }

    public boolean addFilesToDeposit(String[] files, depositDirectories targetDir) throws IOException {
        switch (targetDir) {
            case STREAMS_DIR: {
                return this.addFiles(files, this.m_streamsDir);
            }
            case CONTENT_DIR: {
                return this.addFiles(files, this.m_contentDir);
            }
            case SETTINGS_DIR: {
                return this.addFiles(files, this.m_settingsDir);
            }
        }
        return false;
    }

    public boolean addFilesToDeposit(List<String> files, depositDirectories targetDir) throws IOException {
        switch (targetDir) {
            case STREAMS_DIR: {
                return this.addFiles(files, this.m_streamsDir);
            }
            case CONTENT_DIR: {
                return this.addFiles(files, this.m_contentDir);
            }
            case SETTINGS_DIR: {
                return this.addFiles(files, this.m_settingsDir);
            }
        }
        return false;
    }

    public boolean removeAllFilesFromDepositDir(depositDirectories targetDir) throws IOException {
        switch (targetDir) {
            case STREAMS_DIR: {
                return this.removeAllFiles(this.m_streamsDir);
            }
            case CONTENT_DIR: {
                return this.removeAllFiles(this.m_contentDir);
            }
            case SETTINGS_DIR: {
                return this.removeAllFiles(this.m_settingsDir);
            }
        }
        return false;
    }

    public boolean removeFileFromDeposit(String fileName, depositDirectories targetDir) throws IOException {
        switch (targetDir) {
            case STREAMS_DIR: {
                return this.removeFile(fileName, this.m_streamsDir);
            }
            case CONTENT_DIR: {
                return this.removeFile(fileName, this.m_contentDir);
            }
            case SETTINGS_DIR: {
                return this.removeFile(fileName, this.m_settingsDir);
            }
        }
        return false;
    }

    public File[] getAllFilesFromDeposit(depositDirectories targetDir) {
        return this.getAllFilesFromDeposit(targetDir, false);
    }

    public File[] getAllFilesFromDeposit(depositDirectories targetDir, boolean recursive) {
        switch (targetDir) {
            case STREAMS_DIR: {
                return this.getAllFiles(this.m_streamsDir, recursive);
            }
            case CONTENT_DIR: {
                return this.getAllFiles(this.m_contentDir, recursive);
            }
            case SETTINGS_DIR: {
                return this.getAllFiles(this.m_settingsDir, recursive);
            }
        }
        return null;
    }

    public long getFilesSizeFromDeposit(depositDirectories targetDir) {
        switch (targetDir) {
            case STREAMS_DIR: {
                return this.getFilesSize(this.m_streamsDir);
            }
            case CONTENT_DIR: {
                return this.getFilesSize(this.m_contentDir);
            }
            case SETTINGS_DIR: {
                return this.getFilesSize(this.m_settingsDir);
            }
        }
        return 0L;
    }

    public File getFileFromDeposit(String name, depositDirectories targetDir) {
        switch (targetDir) {
            case STREAMS_DIR: {
                return this.getFile(name, this.m_streamsDir);
            }
            case CONTENT_DIR: {
                return this.getFile(name, this.m_contentDir);
            }
            case SETTINGS_DIR: {
                return this.getFile(name, this.m_settingsDir);
            }
        }
        return null;
    }

    public File getFileFromDepositContent(String name) {
        File file = new File(this.m_contentDir + name);
        return file;
    }

    public boolean addCopyrightsFile(File sourcePath) throws IOException {
        String dest = sourcePath.getAbsolutePath().replaceFirst(sourcePath.getName(), COPYRIGHTS_FILE);
        File tempFile = new File(dest);
        FileUtil.copyFile(sourcePath, tempFile);
        return this.addFile(tempFile, this.m_settingsDir);
    }

    public boolean addAccessRightsFile(File sourcePath) throws IOException {
        String dest = sourcePath.getAbsolutePath().replaceFirst(sourcePath.getName(), ACCESS_RIGHTS_XML);
        File tempFile = new File(dest);
        FileUtil.copyFile(sourcePath, tempFile);
        return this.addFile(tempFile, this.m_settingsDir);
    }

    public boolean addContentStructureXml(File sourcePath) throws IOException {
        String dest = sourcePath.getAbsolutePath().replaceFirst(sourcePath.getName(), CONVERTING_RULES_XML);
        File tempFile = new File(dest);
        FileUtil.copyFile(sourcePath, tempFile);
        return this.addFile(tempFile, this.m_settingsDir);
    }

    public boolean addParamsXml(File sourcePath) throws IOException {
        String dest = sourcePath.getAbsolutePath().replaceFirst(sourcePath.getName(), PARAMS_XML);
        File tempFile = new File(dest);
        FileUtil.copyFile(sourcePath, tempFile);
        return this.addFile(tempFile, this.m_settingsDir);
    }

    public boolean addDcFile(File sourcePath) throws IOException {
        String dest = sourcePath.getAbsolutePath().replaceFirst(sourcePath.getName(), DC_XML);
        File tempFile = new File(dest);
        FileUtil.copyFile(sourcePath, tempFile);
        return this.addFile(tempFile, this.m_settingsDir);
    }

    public File getCopyrightsFile() throws IOException {
        return this.getFile(COPYRIGHTS_FILE, this.m_settingsDir);
    }

    public File getAccessRightsFile() throws IOException {
        return this.getFile(ACCESS_RIGHTS_XML, this.m_settingsDir);
    }

    public File getConvertingRulesFile() throws IOException {
        return this.getFile(CONVERTING_RULES_XML, this.m_settingsDir);
    }

    public File getParamsFile() throws IOException {
        return this.getFile(PARAMS_XML, this.m_settingsDir);
    }

    public File getDcFile() throws IOException {
        return this.getFile(DC_XML, this.m_contentDir);
    }

    public File getExpectedContentStructureFile(ContentStructures CStructure) {
        switch (CStructure) {
            case METS: {
                return this.getFile(METS_XML, this.m_contentDir);
            }
            case MARC: {
                return this.getFile(MARCS_XML, this.m_contentDir);
            }
            case MODS: {
                return this.getFile(MODS_XML, this.m_contentDir);
            }
            case DC: {
                return this.getFile(DCS_XML, this.m_contentDir);
            }
            case CSV: {
                return this.getFile(CSV_FIlE, this.m_contentDir);
            }
            case DIRECTORY_STRUCTURE: {
                return this.getFile(DIRECTORY_STRUCTURE, this.m_contentDir);
            }
            case SET_OF_FILES: {
                return this.getFile(SET_OF_FILES, this.m_contentDir);
            }
        }
        return null;
    }

    public File[] getExistingContentStructureFiles(ContentStructures CStructure) {
        if (!CStructure.equals((Object)ContentStructures.METS) && !CStructure.equals((Object)ContentStructures.DC)) {
            File expectedContentStructureFile = this.getExpectedContentStructureFile(CStructure);
            if (expectedContentStructureFile != null && expectedContentStructureFile.exists()) {
                return new File[]{expectedContentStructureFile};
            }
            return new File[0];
        }
        ArrayList<File> toReturn = new ArrayList<File>();
        File[] potentialCSFiles = this.getAllFiles(this.m_contentDir);
        if (potentialCSFiles != null) {
            block6: for (int i = 0; i < potentialCSFiles.length; ++i) {
                File potentialCSFile = potentialCSFiles[i];
                if (potentialCSFile.isDirectory()) continue;
                switch (CStructure) {
                    case METS: {
                        try {
                            if (!ContentStructureValidator.validateMetsXML(potentialCSFile)) continue block6;
                            toReturn.add(potentialCSFile);
                        }
                        catch (Exception e) {}
                        continue block6;
                    }
                    case DC: {
                        if (!ContentStructureValidator.validateDcsXML(potentialCSFile)) continue block6;
                        toReturn.add(potentialCSFile);
                    }
                }
            }
        }
        return toReturn.toArray(new File[toReturn.size()]);
    }

    public void addUrlFile(String fileName, byte[] content) throws Exception {
        BufferedOutputStream bis = new BufferedOutputStream(new FileOutputStream(new File(this.m_streamsDir + fileName)));
        IOUtil.copy(content, (OutputStream)bis);
        bis.close();
    }

    public void addUrlToExistingUrlFile(String fileName, String content) throws Exception {
        new File(this.m_streamsDir + fileName).createNewFile();
        BufferedWriter out = new BufferedWriter(new FileWriter(this.m_streamsDir + fileName, true));
        out.write(content);
        out.close();
    }

    public String getDepositDirName() {
        return this.m_depositDir;
    }

    public String getContentDirName() {
        return this.m_contentDir;
    }

    public String getStreamsDirName() {
        return this.m_streamsDir;
    }

    public String getMetsXmlFileName() {
        return this.m_contentDir + METS_XML;
    }

    public String getMarcXmlFileName() {
        return this.m_contentDir + MARCS_XML;
    }

    public File[] getMarcXMLFiles() {
        File f = new File(this.m_folderDir);
        return f.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return (name = name.toLowerCase()).indexOf("marc") != -1;
            }
        });
    }

    public String getModsXmlFileName() {
        return this.m_contentDir + MODS_XML;
    }

    public File[] getModsXMLFiles() {
        File f = new File(this.m_folderDir);
        return f.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return (name = name.toLowerCase()).indexOf("mods") != -1;
            }
        });
    }

    public void makeOrderInDCS(List<String> orderedFileList) throws Exception {
        String DC_IDENTIFIER_WITH_PREFIX = "dc:identifier";
        File dcsXml = this.getExpectedContentStructureFile(ContentStructures.DC);
        String lineSeparator = System.getProperty("line.separator");
        FileInputStream fileInputStream = null;
        List existingRecords = null;
        ArrayList dcIdentifiers = new ArrayList();
        if (dcsXml.exists() && dcsXml.length() > 0L) {
            try {
                fileInputStream = new FileInputStream(dcsXml);
                String dcsStr = IOUtil.toString(fileInputStream);
                Document document = DocumentFactory.getInstance().createDocument();
                SAXReader reader = new SAXReader();
                document = reader.read((Reader)new StringReader(dcsStr));
                HashMap<String, String> uris = new HashMap<String, String>();
                uris.put("dc", "http://purl.org/dc/elements/1.1/");
                XPath xpath = document.createXPath("//" + DublinCore.RECORD_NODE_NAME.getQualifiedName());
                xpath.setNamespaceURIs(uris);
                existingRecords = xpath.selectNodes((Object)document);
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        HashMap<String, Node> mapExistingRecords = new HashMap<String, Node>();
        if (existingRecords != null) {
            for (Node existingRecord : existingRecords) {
                String dcIdentifier;
                List existingDcIdentifiers = existingRecord.selectNodes("dc:identifier");
                if (existingDcIdentifiers == null || existingDcIdentifiers.size() != 1 || (dcIdentifier = ((Node)existingDcIdentifiers.iterator().next()).getStringValue()) == null || dcIdentifiers.contains(dcIdentifier)) continue;
                mapExistingRecords.put(dcIdentifier, existingRecord);
            }
        }
        Writer writer = null;
        try {
            dcsXml.delete();
            dcsXml = this.getExpectedContentStructureFile(ContentStructures.DC);
            writer = new BufferedWriter(new FileWriter(dcsXml));
            writer.write("<records>" + lineSeparator);
            for (String file : orderedFileList) {
                writer.write(((Node)mapExistingRecords.get(file)).asXML());
            }
            writer.write("</records>");
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public void updateDcsXml(DublinCore dublinCore) throws Exception {
        if (dublinCore == null) {
            return;
        }
        String DC_IDENTIFIER_WITH_PREFIX = "dc:identifier";
        String DC_IDENTIFIER = "identifier";
        String XML_DECLARATION_PREFIX = "<?xml";
        String XML_DECLARATION_POSTFIX = "?>";
        File dcsXml = this.getExpectedContentStructureFile(ContentStructures.DC);
        String lineSeparator = System.getProperty("line.separator");
        List existingRecords = null;
        FileInputStream fileInputStream = null;
        if (dcsXml.exists() && dcsXml.length() > 0L) {
            try {
                fileInputStream = new FileInputStream(dcsXml);
                String dcsStr = IOUtil.toString(fileInputStream);
                Document document = DocumentFactory.getInstance().createDocument();
                SAXReader reader = new SAXReader();
                document = reader.read((Reader)new StringReader(dcsStr));
                HashMap<String, String> uris = new HashMap<String, String>();
                uris.put("dc", "http://purl.org/dc/elements/1.1/");
                XPath xpath = document.createXPath("//" + DublinCore.RECORD_NODE_NAME.getQualifiedName());
                xpath.setNamespaceURIs(uris);
                existingRecords = xpath.selectNodes((Object)document);
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        Writer writer = null;
        try {
            dcsXml.delete();
            dcsXml = this.getExpectedContentStructureFile(ContentStructures.DC);
            writer = new BufferedWriter(new FileWriter(dcsXml));
            writer.write("<records>" + lineSeparator);
            if (existingRecords != null) {
                for (Node existingRecord : existingRecords) {
                    List existingDcIdentifiers = existingRecord.selectNodes("dc:identifier");
                    if (existingDcIdentifiers == null || existingDcIdentifiers.size() != 1) continue;
                    String dcIdentifier = ((Node)existingDcIdentifiers.iterator().next()).getStringValue();
                    if (dcIdentifier != null && dcIdentifier.equals(dublinCore.getDcValue("identifier"))) {
                        String newDcRecordXml = dublinCore.toXml();
                        if (newDcRecordXml.trim().startsWith("<?xml")) {
                            int xmlDecPostfixPos = newDcRecordXml.indexOf("?>");
                            if (xmlDecPostfixPos > 0) {
                                xmlDecPostfixPos += "?>".length();
                            }
                            newDcRecordXml = newDcRecordXml.substring(xmlDecPostfixPos).trim();
                        }
                        writer.write(newDcRecordXml);
                        continue;
                    }
                    writer.write(existingRecord.asXML());
                }
            }
            writer.write("</records>");
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public void addRecordsToDcsXml(Collection<DublinCore> dublinCoreRecords) throws Exception {
        if (dublinCoreRecords == null) {
            return;
        }
        String DC_IDENTIFIER = "identifier";
        String DC_IDENTIFIER_WITH_PREFIX = "dc:identifier";
        ArrayList<String> dcIdentifiers = new ArrayList<String>();
        for (DublinCore dcRecord : dublinCoreRecords) {
            String dcIdentifier = dcRecord.getDcValue("identifier");
            if (dcIdentifier == null) continue;
            dcIdentifiers.add(dcIdentifier);
        }
        File dcsXml = this.getExpectedContentStructureFile(ContentStructures.DC);
        String lineSeparator = System.getProperty("line.separator");
        List existingRecords = null;
        FileInputStream fileInputStream = null;
        if (dcsXml.exists() && dcsXml.length() > 0L) {
            try {
                fileInputStream = new FileInputStream(dcsXml);
                String dcsStr = IOUtil.toString(fileInputStream);
                Document document = DocumentFactory.getInstance().createDocument();
                SAXReader reader = new SAXReader();
                document = reader.read((Reader)new StringReader(dcsStr));
                HashMap<String, String> uris = new HashMap<String, String>();
                uris.put("dc", "http://purl.org/dc/elements/1.1/");
                XPath xpath = document.createXPath("//" + DublinCore.RECORD_NODE_NAME.getQualifiedName());
                xpath.setNamespaceURIs(uris);
                existingRecords = xpath.selectNodes((Object)document);
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        Writer writer = null;
        try {
            dcsXml.delete();
            dcsXml = this.getExpectedContentStructureFile(ContentStructures.DC);
            writer = new BufferedWriter(new FileWriter(dcsXml));
            writer.write("<records>" + lineSeparator);
            if (existingRecords != null) {
                for (Node existingRecord : existingRecords) {
                    String dcIdentifier;
                    List existingDcIdentifiers = existingRecord.selectNodes("dc:identifier");
                    if (existingDcIdentifiers == null || existingDcIdentifiers.size() != 1 || (dcIdentifier = ((Node)existingDcIdentifiers.iterator().next()).getStringValue()) == null || dcIdentifiers.contains(dcIdentifier)) continue;
                    writer.write(existingRecord.asXML());
                }
            }
            Iterator<DublinCore> newDcIter = dublinCoreRecords.iterator();
            String XML_DECLARATION_PREFIX = "<?xml";
            String XML_DECLARATION_POSTFIX = "?>";
            while (newDcIter.hasNext()) {
                DublinCore newDcRecord = newDcIter.next();
                String newDcRecordXml = newDcRecord.toXml();
                if (newDcRecordXml.trim().startsWith("<?xml")) {
                    int xmlDecPostfixPos = newDcRecordXml.indexOf("?>");
                    if (xmlDecPostfixPos > 0) {
                        xmlDecPostfixPos += "?>".length();
                    }
                    newDcRecordXml = newDcRecordXml.substring(xmlDecPostfixPos).trim();
                }
                writer.write(newDcRecordXml);
            }
            writer.write("</records>");
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public void removeRecordsFromDcsXml(Collection<String> dcIdentifiers) throws Exception {
        if (dcIdentifiers == null || dcIdentifiers.isEmpty()) {
            return;
        }
        String DC_IDENTIFIER_WITH_PREFIX = "dc:identifier";
        File dcsXml = this.getExpectedContentStructureFile(ContentStructures.DC);
        String lineSeparator = System.getProperty("line.separator");
        List existingRecords = null;
        FileInputStream fileInputStream = null;
        if (dcsXml.exists() && dcsXml.length() > 0L) {
            try {
                fileInputStream = new FileInputStream(dcsXml);
                String dcsStr = IOUtil.toString(fileInputStream);
                Document document = DocumentFactory.getInstance().createDocument();
                SAXReader reader = new SAXReader();
                document = reader.read((Reader)new StringReader(dcsStr));
                HashMap<String, String> uris = new HashMap<String, String>();
                uris.put("dc", "http://purl.org/dc/elements/1.1/");
                XPath xpath = document.createXPath("//" + DublinCore.RECORD_NODE_NAME.getQualifiedName());
                xpath.setNamespaceURIs(uris);
                existingRecords = xpath.selectNodes((Object)document);
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        Writer writer = null;
        try {
            dcsXml.delete();
            dcsXml = this.getExpectedContentStructureFile(ContentStructures.DC);
            writer = new BufferedWriter(new FileWriter(dcsXml));
            writer.write("<records>" + lineSeparator);
            if (existingRecords != null) {
                for (Node existingRecord : existingRecords) {
                    String dcIdentifier;
                    List existingDcIdentifiers = existingRecord.selectNodes("dc:identifier");
                    if (existingDcIdentifiers == null || existingDcIdentifiers.size() != 1 || (dcIdentifier = ((Node)existingDcIdentifiers.iterator().next()).getStringValue()) == null || dcIdentifiers.contains(dcIdentifier)) continue;
                    writer.write(existingRecord.asXML());
                }
            }
            writer.write("</records>");
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public List<FileData> getSIPFiles() {
        ResourceBundle resourceBundle = CodeTablesResourceBundle.getDefaultBundle(null);
        String metadata = "Metadata";
        String stream = "Stream";
        try {
            metadata = resourceBundle.getString("ui.sip_content_list.type.metadata");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            stream = resourceBundle.getString("ui.sip_content_list.type.stream");
        }
        catch (Exception e) {
            // empty catch block
        }
        ArrayList<FileData> fileList = new ArrayList<FileData>();
        File[] files = null;
        FileData fileData = null;
        String fileType = null;
        ContentStructures[] fileTypes = ContentStructures.values();
        for (int i = 0; i < fileTypes.length; ++i) {
            files = this.getExistingContentStructureFiles(fileTypes[i]);
            fileType = fileTypes[i].toString();
            if (files == null) continue;
            for (int j = 0; j < files.length; ++j) {
                fileData = new FileData(files[j], fileType, metadata);
                fileList.add(fileData);
            }
        }
        File[] streamFiles = this.getAllFilesFromDeposit(depositDirectories.STREAMS_DIR, true);
        for (int i = 0; i < streamFiles.length; ++i) {
            fileData = new FileData(streamFiles[i], null, stream);
            fileList.add(fileData);
        }
        return fileList;
    }

    public static enum ContentStructures {
        METS,
        MARC,
        MODS,
        DC,
        CSV,
        DIRECTORY_STRUCTURE,
        SET_OF_FILES;

    }

    public static enum depositDirectories {
        STREAMS_DIR,
        CONTENT_DIR,
        SETTINGS_DIR;

    }
}

