/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.sdk.utils;

import com.exlibris.core.infra.common.util.IOUtil;
import com.exlibris.core.infra.svc.api.CodeTablesResourceBundle;
import com.exlibris.core.infra.svc.api.common.DateHandler;
import com.exlibris.core.sdk.shared.FileData;
import com.exlibris.core.sdk.utils.DepositDirUtil;
import com.exlibris.core.sdk.utils.FileUtil;
import com.exlibris.core.sdk.utils.SipDirUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.List;
import java.util.ResourceBundle;

public class FSDepositAreaUtil {
    private final GregorianCalendar m_calendar = new GregorianCalendar();
    private StringBuffer m_buffer = null;
    private final String logicDepositArea;
    private final String m_folderId;
    private String m_folderDir = null;
    private final Hashtable m_fosHash = new Hashtable();

    public FSDepositAreaUtil(String depositAreaDir) {
        this.logicDepositArea = null;
        this.m_folderId = null;
        this.m_buffer = new StringBuffer(100);
        this.m_folderDir = this.m_buffer.append(depositAreaDir).append(File.separator).toString();
        this.createNewDirStructure();
    }

    public boolean isExists() {
        File f = new File(this.m_folderDir);
        return f.exists() && f.isDirectory();
    }

    public String getFolderDir() {
        return this.m_folderDir;
    }

    public boolean createNewDirStructure() {
        FileUtil.createFile(this.m_folderDir);
        return true;
    }

    public DepositDirUtil addDepositDir(long folderId) throws IOException {
        DepositDirUtil m_depositUtil = new DepositDirUtil(this.m_folderDir, String.valueOf(folderId));
        m_depositUtil.resetDirStructure();
        return m_depositUtil;
    }

    public SipDirUtil addSipDir(long folderId) throws IOException {
        SipDirUtil m_sipUtil = new SipDirUtil(this.m_folderDir, String.valueOf(folderId));
        m_sipUtil.createNewDirStructure();
        return m_sipUtil;
    }

    public SipDirUtil getSipDirUtil(long folderId) {
        SipDirUtil m_sipUtil = new SipDirUtil(this.m_folderDir, String.valueOf(folderId));
        return m_sipUtil;
    }

    public DepositDirUtil getDepositDirUtil(long folderId) {
        DepositDirUtil m_depositUtil = new DepositDirUtil(this.m_folderDir, String.valueOf(folderId));
        return m_depositUtil;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putFile(String relativePath, String fileName, InputStream doc) throws IOException {
        if (this.m_folderDir == null) {
            return false;
        }
        File nFile = new File(this.m_folderDir + relativePath);
        if (!nFile.exists()) {
            nFile.mkdirs();
        }
        BufferedOutputStream bof = new BufferedOutputStream(new FileOutputStream(nFile.getAbsolutePath() + "/" + fileName));
        try {
            IOUtil.copy(doc, (OutputStream)bof);
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        finally {
            bof.close();
        }
        return true;
    }

    public void writeMsgInternal(String msg, String fileName, boolean append, boolean closeFile, boolean writeToConsole) {
        BufferedOutputStream fos = (BufferedOutputStream)this.m_fosHash.get(fileName);
        if (fos == null) {
            try {
                fos = new BufferedOutputStream(new FileOutputStream(this.m_folderDir + fileName, append));
            }
            catch (Exception e) {
                System.out.println("Fail to init log file:" + this.m_folderDir + fileName);
            }
        }
        try {
            StringBuffer fullMsg = new StringBuffer(DateHandler.formatDateAndTime(new Date())).append(" : ").append(msg).append("\n");
            IOUtil.copy(fullMsg.toString(), (OutputStream)fos);
            if (writeToConsole) {
                System.out.print(fullMsg);
            }
            if (!closeFile) {
                this.m_fosHash.put(fileName, fos);
            } else {
                fos.close();
            }
        }
        catch (IOException e1) {
            System.out.println("Fail writing message to log:" + msg);
        }
    }

    public void close() {
        Enumeration enums = this.m_fosHash.elements();
        while (enums.hasMoreElements()) {
            BufferedOutputStream fos = (BufferedOutputStream)enums.nextElement();
            if (fos == null) continue;
            try {
                fos.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void deleteDirStructure() throws IOException {
        FileUtil.forceDelete(this.m_folderDir);
    }

    public String getFolderId() {
        return this.m_folderId;
    }

    public List<FileData> getSIPFiles(long folderId, boolean includeMets) throws Exception {
        File[] streamFiles;
        ResourceBundle resourceBundle = CodeTablesResourceBundle.getDefaultBundle(null);
        String metadata = "Metadata";
        String stream = "Stream";
        try {
            metadata = resourceBundle.getString("ui.sip_content_list.type.metadata");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            stream = resourceBundle.getString("ui.sip_content_list.type.stream");
        }
        catch (Exception e) {
            // empty catch block
        }
        ArrayList<FileData> fileList = new ArrayList<FileData>();
        FileData fileData = null;
        File[] ieFiles = this.getSipDirUtil(folderId).getAllFilesFromSip(SipDirUtil.depositDirectories.IES_DIR);
        if (ieFiles != null && includeMets) {
            for (int j = 0; j < ieFiles.length; ++j) {
                fileData = new FileData(ieFiles[j], DepositDirUtil.ContentStructures.METS.toString(), metadata);
                fileList.add(fileData);
            }
        }
        if ((streamFiles = this.getDepositDirUtil(folderId).getAllFilesFromDeposit(DepositDirUtil.depositDirectories.STREAMS_DIR, true)) != null) {
            for (int i = 0; i < streamFiles.length; ++i) {
                fileData = new FileData(streamFiles[i], null, stream);
                fileList.add(fileData);
            }
        }
        return fileList;
    }
}

