/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.sdk.utils;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.common.fsutils.InfraFSUtil;
import com.exlibris.core.infra.svc.api.GeneralParameterManager;
import com.exlibris.core.infra.svc.api.config.InfraConfigurationManager;
import com.exlibris.core.infra.svc.api.locator.ServiceLocator;
import com.exlibris.core.sdk.utils.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.ArrayList;
import java.util.List;

public class FSUtil
extends InfraFSUtil {
    public static final String XML_EXT = ".xml";
    private static final String DIGITOOL_HOME = "digitool.home";
    private static final String PROFILE = "../profile";
    private static final String WORK = "work/";
    private static final String COLLECTION = "collection/";
    private static final String TEMPLATES = "templates/";
    private static final String METADATA = "metadata/";
    private static final String COPYRIGHTS = "copyrights/";
    private static final String DES_DESCRIPTORS_DIR = "services/des_descriptors";
    private static final String DES_PARAMS_DIR = "services/des_params";
    private static final String UNITS = "units/";
    private static final String STORAGE = "storage/";
    private static final String JMAGICK_WORK = "jmagick/";
    public static final String XSLT_WORK = "xslt_viewer_tmp/";
    private static final String METS_WORK_DIR = "mets_viewer_tmp/";
    private static final String METS_TEMP_DIR = "mets_viewer_tmp/temp/";
    private static final String DEPLOY_DIR = "/thirdparty/openserver/server/default/deploy/";
    private static final String DPS_DEPLOY_DIR = File.separator + "thirdparty" + File.separator + "jboss" + File.separator + "server" + File.separator + "default" + File.separator + "deploy" + File.separator;
    private static final String REPORTS = "reports/";
    private static final String EXPORT = "export/";
    private static final String DE_SERVICE_TMP_DIR = "de_service_tmp/";
    private static final String SOURCE_CONTROL_DIR = "CVS";
    private static final String LICENSE_PATH = "/license";
    private static final String LICENSE_ROOT = "u3_";
    private static final String LICENSE_ROOT_ALT = "d3_";
    private static final String PRODUCT = "/product/bin/";
    private static final String REPLICATIONS = "replications/";
    private static final String REPLICATIONS_LOGS = "logs/";
    private static final String REPLICATIONS_TIMESTAMPS = "timestamps/";
    private static final String REPLICATIONS_RECOVERY = "recovery/";
    private static final String REPLICATIONS_CONF = "conf/";
    private static final String SYNCHRONISATION = "synchronisations/";
    private static final String SYNCHRONISATION_LOGS = "logs/";
    private static final String SYNCHRONISATION_TIMESTAMPS = "timestamps/";
    private static final String SYNCHRONISATION_CONF = "conf/";
    private static final String SYNCHRONISATION_FILES = "files/";
    private static final String SYNCHRONISATION_RUN = "run/";
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static final String JHOVE_CONF_FILE = "/thirdparty/jhove/conf/jhove.conf";
    private static String m_digitoolHome = null;
    private static String m_workHome = null;
    private static String m_metsWorkDir = null;
    private static String m_deServiceWorkDir = null;
    private static String m_metsTempWorkDir = null;
    private static String m_profileHome = null;
    private static String m_collectionHome = null;
    private static String m_copyrightsHome = null;
    private static String m_confHome = null;
    private static String reportsDir = null;
    private static String exportDir = null;
    private static String m_deployDir = null;
    private static String m_dpsDeployDir = null;
    private static String m_des_desc = null;
    private static String replicationsDir = null;
    private static String replicationsLogsDir = null;
    private static String replicationsTimestampsDir = null;
    private static String replicationsRecoveryDir = null;
    private static String replicationsConfDir = null;
    private static String synchronisationsDir = null;
    private static String synchronisationsLogsDir = null;
    private static String synchronisationsTimestampsDir = null;
    private static String synchronisationsConfDir = null;
    private static String synchronisationsFilesDir = null;
    private static String synchronisationsRunDir = null;
    private static String templatesDir = null;
    private static String metadataDir = null;
    private static String jhoveConfDir = null;
    private static String m_systemConfDir = null;
    private static ExLogger log = ExLogger.getExLogger(FSUtil.class);

    public static String getTemplatesDir() {
        if (templatesDir != null) {
            return templatesDir;
        }
        templatesDir = FSUtil.getConfDir() + TEMPLATES;
        return templatesDir;
    }

    public static String getMetadataDir() {
        if (metadataDir != null) {
            return metadataDir;
        }
        metadataDir = FSUtil.getTemplatesDir() + METADATA;
        return metadataDir;
    }

    public static String getReplicationsDir() {
        if (replicationsDir != null) {
            return replicationsDir;
        }
        replicationsDir = FSUtil.getProfileDir() + REPLICATIONS;
        return replicationsDir;
    }

    public static String getReplicationsLogsDir() {
        if (replicationsLogsDir != null) {
            return replicationsLogsDir;
        }
        replicationsLogsDir = FSUtil.getReplicationsDir() + "logs/";
        return replicationsLogsDir;
    }

    public static String getReplicationsTimestampsDir() {
        if (replicationsTimestampsDir != null) {
            return replicationsTimestampsDir;
        }
        replicationsTimestampsDir = FSUtil.getReplicationsDir() + "timestamps/";
        return replicationsTimestampsDir;
    }

    public static String getReplicationsRecoveryDir() {
        if (replicationsRecoveryDir != null) {
            return replicationsRecoveryDir;
        }
        replicationsRecoveryDir = FSUtil.getReplicationsDir() + REPLICATIONS_RECOVERY;
        return replicationsRecoveryDir;
    }

    public static String getReplicationsConfDir() {
        if (replicationsConfDir != null) {
            return replicationsConfDir;
        }
        replicationsConfDir = FSUtil.getReplicationsDir() + "conf/";
        return replicationsConfDir;
    }

    public static String getSynchronisationsDir() {
        if (synchronisationsDir != null) {
            return synchronisationsDir;
        }
        synchronisationsDir = FSUtil.getProfileDir() + SYNCHRONISATION;
        return synchronisationsDir;
    }

    public static String getSynchronisationsLogsDir() {
        if (synchronisationsLogsDir != null) {
            return synchronisationsLogsDir;
        }
        synchronisationsLogsDir = FSUtil.getSynchronisationsDir() + "logs/";
        return synchronisationsLogsDir;
    }

    public static String getSynchronisationsTimestampsDir() {
        if (synchronisationsTimestampsDir != null) {
            return synchronisationsTimestampsDir;
        }
        synchronisationsTimestampsDir = FSUtil.getSynchronisationsDir() + "timestamps/";
        return synchronisationsTimestampsDir;
    }

    public static String getSynchronisationsConfDir() {
        if (synchronisationsConfDir != null) {
            return synchronisationsConfDir;
        }
        synchronisationsConfDir = FSUtil.getSynchronisationsDir() + "conf/";
        return synchronisationsConfDir;
    }

    public static String getSynchronisationsFilesDir() {
        if (synchronisationsFilesDir != null) {
            return synchronisationsFilesDir;
        }
        synchronisationsFilesDir = FSUtil.getSynchronisationsDir() + SYNCHRONISATION_FILES;
        return synchronisationsFilesDir;
    }

    public static String getSynchronisationsRunDir() {
        if (synchronisationsRunDir != null) {
            return synchronisationsRunDir;
        }
        synchronisationsRunDir = FSUtil.getSynchronisationsDir() + SYNCHRONISATION_RUN;
        return synchronisationsRunDir;
    }

    public static File getLicenseFile() {
        File lf = null;
        String jpath = FSUtil.getSystemConfDir() + LICENSE_PATH;
        lf = new File(jpath);
        if (!lf.exists()) {
            lf = null;
        }
        return lf;
    }

    public static String getDigitoolHome() {
        if (m_digitoolHome != null) {
            return m_digitoolHome;
        }
        m_digitoolHome = FSUtil.getHome() + "../";
        File f = new File(m_digitoolHome);
        try {
            m_digitoolHome = f.getCanonicalPath() + SEPARATOR;
            return m_digitoolHome;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getXSLTWorkDir() {
        String destDir = FSUtil.getGeneralParamater("general", "operational_shared") + File.separator + "operational_delivery_shared" + File.separator + XSLT_WORK;
        return destDir;
    }

    public static String getDeployDir() {
        if (m_deployDir != null) {
            return m_deployDir;
        }
        m_deployDir = FSUtil.getSystemDir() + DEPLOY_DIR;
        return m_deployDir;
    }

    public static String getDpsDeployDir() {
        if (m_dpsDeployDir != null) {
            return m_dpsDeployDir;
        }
        m_dpsDeployDir = FSUtil.getSystemDir() + DPS_DEPLOY_DIR;
        return m_dpsDeployDir;
    }

    public static String getDefaultStorageDir() {
        return FSUtil.getProfileDir() + STORAGE;
    }

    private static String getGeneralParamater(String module, String paramName) {
        GeneralParameterManager manager = (GeneralParameterManager)ServiceLocator.getInstance().lookUp(GeneralParameterManager.class);
        return manager.getParameter(module, paramName);
    }

    public static String getReportsWorkDir() {
        File reportsDirFile;
        if (reportsDir == null && !(reportsDirFile = new File(reportsDir = FSUtil.getProfileDir() + REPORTS)).exists()) {
            reportsDirFile.mkdir();
        }
        return reportsDir;
    }

    public static String getJobWorkDir(Long jobId) {
        return FSUtil.getReportsWorkDir() + FILE_SEPARATOR + jobId;
    }

    public static String getExportWorkDir() {
        File exportDirFile;
        if (exportDir == null && !(exportDirFile = new File(exportDir = FSUtil.getProfileDir() + EXPORT)).exists()) {
            exportDirFile.mkdir();
        }
        return exportDir;
    }

    public static String getProfileDir() {
        if (m_profileHome != null) {
            return m_profileHome;
        }
        m_profileHome = FSUtil.getHome() + PROFILE + m_profileExtention + SEPARATOR;
        File f = new File(m_profileHome);
        try {
            m_profileHome = f.getCanonicalPath() + SEPARATOR;
            return m_profileHome;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getWorkDir() {
        if (m_workHome != null) {
            return m_workHome;
        }
        m_workHome = FSUtil.getProfileDir() + WORK;
        return m_workHome;
    }

    public static String getMetsWorkDir() {
        if (m_metsWorkDir != null) {
            return m_metsWorkDir;
        }
        if (m_workHome == null) {
            m_metsWorkDir = FSUtil.getWorkDir() + METS_WORK_DIR;
            return m_metsWorkDir;
        }
        m_metsWorkDir = m_workHome + METS_WORK_DIR;
        return m_metsWorkDir;
    }

    public static String getMetsTempWorkDir() {
        if (m_metsTempWorkDir != null) {
            return m_metsTempWorkDir;
        }
        if (m_workHome == null) {
            m_metsTempWorkDir = FSUtil.getWorkDir() + METS_TEMP_DIR;
            return m_metsTempWorkDir;
        }
        m_metsTempWorkDir = m_workHome + METS_TEMP_DIR;
        return m_metsTempWorkDir;
    }

    public static String getDeServiceWorkDir() {
        if (m_deServiceWorkDir != null) {
            return m_deServiceWorkDir;
        }
        if (m_workHome == null) {
            m_deServiceWorkDir = FSUtil.getWorkDir() + DE_SERVICE_TMP_DIR;
            return m_deServiceWorkDir;
        }
        m_deServiceWorkDir = m_workHome + DE_SERVICE_TMP_DIR;
        return m_deServiceWorkDir;
    }

    public static String getCollectionDir() {
        if (m_collectionHome != null) {
            return m_collectionHome;
        }
        m_collectionHome = FSUtil.getProfileDir() + COLLECTION;
        return m_collectionHome;
    }

    public static String getCopyrightsDir() {
        if (m_copyrightsHome != null) {
            return m_copyrightsHome;
        }
        m_copyrightsHome = FSUtil.getConfDir() + COPYRIGHTS;
        return m_copyrightsHome;
    }

    public static String getConfDir() {
        if (m_confHome != null) {
            return m_confHome;
        }
        m_confHome = FSUtil.getProfileDir() + "conf/";
        return m_confHome;
    }

    public static String getServicesDescriptorsDir() {
        if (m_des_desc != null) {
            return m_des_desc;
        }
        StringBuffer desc_buffer = new StringBuffer(50);
        m_des_desc = desc_buffer.append(FSUtil.getConfDir()).append(DES_DESCRIPTORS_DIR + SEPARATOR).toString();
        return m_des_desc;
    }

    public static String getServicesParamsDir() {
        if (m_des_desc != null) {
            return m_des_desc;
        }
        StringBuffer desc_buffer = new StringBuffer(50);
        m_des_desc = desc_buffer.append(FSUtil.getConfDir()).append(DES_PARAMS_DIR + SEPARATOR).toString();
        return m_des_desc;
    }

    public static List getUnitList() {
        ArrayList<String> ret = new ArrayList<String>();
        StringBuffer path = new StringBuffer(32);
        path.append(FSUtil.getProfileDir());
        path.append(SEPARATOR + UNITS);
        File[] fList = new File(path.toString()).listFiles(new FileUtil.DirectoryFilter());
        if (fList != null) {
            for (int i = 0; i < fList.length; ++i) {
                if (fList[i].getName().toUpperCase().equals(SOURCE_CONTROL_DIR)) continue;
                ret.add(fList[i].getName());
            }
        }
        return ret;
    }

    public static int getUnitsCount() {
        StringBuffer path = new StringBuffer(32);
        path.append(FSUtil.getProfileDir());
        path.append(SEPARATOR + UNITS);
        File[] fList = new File(path.toString()).listFiles(new FileUtil.DirectoryFilter());
        return fList.length;
    }

    public static FileLock lockFile(File pFile, FileChannel channel) throws IOException {
        channel = new RandomAccessFile(pFile, "rw").getChannel();
        FileLock lock = null;
        try {
            lock = channel.tryLock();
        }
        catch (OverlappingFileLockException e) {
            return null;
        }
        return lock;
    }

    public static boolean unlockFile(FileLock lock) throws IOException {
        if (lock == null) {
            return false;
        }
        lock.release();
        return true;
    }

    public static String getBatchExtention() {
        if (InfraConfigurationManager.getInstance().isDevelopmentMode()) {
            return ".bat";
        }
        return ".sh";
    }

    public static synchronized String getJHome() {
        String home = FSUtil.getDigitoolHome();
        return home;
    }

    public static synchronized String getProductDir() {
        String home = FSUtil.getDigitoolHome();
        return home + PRODUCT;
    }

    public static String getJhoveConfDir() {
        if (jhoveConfDir != null) {
            return jhoveConfDir;
        }
        jhoveConfDir = FSUtil.getSystemDir() + JHOVE_CONF_FILE;
        return jhoveConfDir;
    }

    public static void createDirectory(String basePath) {
        File dirFile = new File(basePath);
        if (!dirFile.exists()) {
            dirFile.mkdir();
        }
    }
}

