/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.sdk.utils;

import com.exlibris.core.infra.common.exceptions.InfraException;
import com.exlibris.core.infra.common.exceptions.logging.Descriptor;
import com.exlibris.core.infra.common.exceptions.logging.DescriptorConstants;
import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.model.HFrUser;
import com.exlibris.core.infra.model.HFrUserRoles;
import com.exlibris.core.infra.model.consortium.HFrInstitution;
import com.exlibris.core.infra.svc.api.ConsortiumManager;
import com.exlibris.core.infra.svc.api.PDSManager;
import com.exlibris.core.infra.svc.api.UserManager;
import com.exlibris.core.infra.svc.api.config.PrivilegeCacheManager;
import com.exlibris.core.infra.svc.api.locator.ServiceLocator;
import com.exlibris.core.infra.svc.api.pds.PdsConnector;
import com.exlibris.core.infra.svc.api.pds.PdsUserInfo;
import com.exlibris.core.sdk.utils.PdsUserData;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;

public class PdsUtils {
    public static final String PDS_HANDLE_EMPTY_ERROR = "pdsHandle cannot be empty";
    private static final ExLogger log = ExLogger.getExLogger(PdsUtils.class);

    public static PdsUserData getPdsUserData(String pdsHandle) {
        List<HFrUserRoles> userRoles;
        PdsUserData pdsUserData = new PdsUserData();
        pdsUserData.setValidPdsHandle(true);
        Descriptor descriptor = new Descriptor();
        PDSManager pdManager = (PDSManager)ServiceLocator.getInstance().lookUp(PDSManager.class);
        PdsUserInfo userInfo = pdManager.ValidatePdsHandle(pdsHandle, descriptor);
        if (userInfo == null) {
            descriptor = DescriptorConstants.DP_InvalidPdsHandle;
            String[] vars = new String[]{pdsHandle};
            descriptor.initMessage(vars);
            pdsUserData.setValidPdsHandle(false);
            pdsUserData.setDescriptor(descriptor);
            return pdsUserData;
        }
        String institutionIdStr = userInfo.getBorDeptM();
        ConsortiumManager consMng = (ConsortiumManager)ServiceLocator.getInstance().lookUp(ConsortiumManager.class);
        HFrInstitution institution = consMng.findInstitutionByCode(institutionIdStr);
        HFrUser user = null;
        String userIdStr = null;
        try {
            UserManager depMng = (UserManager)ServiceLocator.getInstance().lookUp(UserManager.class);
            user = depMng.getUserByName(userInfo.getUserName());
            userIdStr = user.getId().toString();
        }
        catch (Exception e) {
            descriptor = DescriptorConstants.DP_InvalidUserOrInstitution;
            String[] vars = new String[]{userIdStr, institutionIdStr};
            descriptor.initMessage(vars);
            pdsUserData.setValidPdsHandle(false);
            pdsUserData.setDescriptor(descriptor);
            return pdsUserData;
        }
        pdsUserData.setInstitution(institution);
        pdsUserData.setUser(user);
        try {
            userRoles = pdManager.getUserRoleByUserAndInstitution(user, institution.getPath());
        }
        catch (InfraException e) {
            log.error("Unable to get user roles for userName: " + user.getUserName(), new String[0]);
            return pdsUserData;
        }
        HashSet<String> privileges = new HashSet<String>();
        for (HFrUserRoles role : userRoles) {
            if (!role.getStatus().equals((Object)HFrUserRoles.Status.ACTIVE)) continue;
            String userRoleName = Integer.toString(role.getRoleType());
            privileges.addAll(PrivilegeCacheManager.getInstance().getPrivileges2Role(userRoleName));
        }
        pdsUserData.setPrivileges(privileges);
        return pdsUserData;
    }

    public static boolean validatePdsHandle(String pdsHandle, Descriptor descriptor) {
        PDSManager pdManager = (PDSManager)ServiceLocator.getInstance().lookUp(PDSManager.class);
        PdsUserInfo userInfo = pdManager.ValidatePdsHandle(pdsHandle, descriptor);
        if (userInfo == null) {
            return false;
        }
        String institutionIdStr = userInfo.getBorDeptM();
        String userIdStr = null;
        try {
            UserManager depMng = (UserManager)ServiceLocator.getInstance().lookUp(UserManager.class);
            userIdStr = depMng.getUserByName(userInfo.getUserName()).getId().toString();
        }
        catch (Exception e) {
            descriptor = DescriptorConstants.DP_InvalidUserOrInstitution;
            String[] vars = new String[]{userIdStr, institutionIdStr};
            descriptor.initMessage(vars);
            return false;
        }
        return true;
    }

    public static Locale getUserLocale(String pdsHandle) {
        HFrUser user = PdsUtils.getLogInUser(pdsHandle);
        if (user == null) {
            new Locale("en");
        }
        return new Locale(user.getDefaultLanguage());
    }

    public static HFrUser getLogInUser(String pdsHandle) {
        PdsConnector pdsConnector = PdsConnector.getInstance();
        PdsUserInfo userInfo = pdsConnector.getUserInfo(pdsHandle);
        UserManager depMng = (UserManager)ServiceLocator.getInstance().lookUp(UserManager.class);
        try {
            return depMng.getUserByName(userInfo.getUserName());
        }
        catch (InfraException e) {
            return null;
        }
    }
}

