/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.dps.demo.impl;

import com.exlibris.core.infra.common.exceptions.ExlibrisException;
import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.sdk.utils.FileUtil;
import com.exlibris.core.sdk.utils.XmlUtils;
import com.exlibris.digitool.deposit.service.xmlbeans.DepositActivityListDocument;
import com.exlibris.digitool.exceptions.DigitoolException;
import com.exlibris.dps.sdk.deposit.DepositWebServices;
import java.io.IOException;
import javax.jws.WebMethod;
import org.apache.xmlbeans.XmlException;

public class DepositServicesImpl
implements DepositWebServices {
    private static ExLogger log = ExLogger.getExLogger(DepositServicesImpl.class);
    private String userId = null;
    private String institutionId = null;
    private String materialFlowId = null;
    private String subDirectoryName = null;
    private String producerId = null;
    private String depositSetId = null;
    private String userParams = null;
    private String xmlReply = null;

    @Override
    public String submitDepositActivity(String pdsHandle, String materialFlowId, String subDirectoryName, String producerId, String depositSetId) {
        this.materialFlowId = materialFlowId;
        this.subDirectoryName = subDirectoryName;
        this.producerId = producerId;
        this.depositSetId = depositSetId;
        StringBuffer buffer = new StringBuffer();
        buffer.append("pdsHandle=").append(pdsHandle).append(", materialFlowId=").append(materialFlowId);
        buffer.append(", subDirectoryName=").append(subDirectoryName).append(", producerId=").append(producerId).append(", depositSetId=").append(depositSetId);
        this.userParams = buffer.toString();
        try {
            this.createDepositActivity();
        }
        catch (Exception e) {
            // empty catch block
        }
        return this.xmlReply;
    }

    @Override
    public String getDepositActivityBySubmitDate(String pdsHandle, String depositActivityStatus, String producerIdStr, String producerAgentIdStr, String submitDateFrom, String submitDateTo, String startRecord, String endRecord) {
        return this.getDepositActivityBySubmitDateByMaterialFlow(pdsHandle, depositActivityStatus, null, producerIdStr, producerAgentIdStr, submitDateFrom, submitDateTo, startRecord, endRecord);
    }

    @Override
    public String getDepositActivityBySubmitDateByMaterialFlow(String pdsHandle, String depositActivityStatus, String materialFlowId, String producerIdStr, String producerAgentIdStr, String submitDateFrom, String submitDateTo, String startRecord, String endRecord) {
        try {
            XmlUtils.convertStringToLong("producerId", producerIdStr);
            XmlUtils.convertStringToLong("producerAgentId", producerAgentIdStr);
        }
        catch (ExlibrisException e) {
            return XmlUtils.createXmlResponse(e.getLocalizedMessage());
        }
        String xml = FileUtil.getFileContent("demoXml/deposit_activitiy_submit_date.xml");
        return this.showXml(xml);
    }

    @Override
    public String getDepositActivityByUpdateDate(String pdsHandle, String depositActivityStatus, String producerIdStr, String producerAgentIdStr, String updateDateFrom, String updateDateTo, String startRecord, String endRecord) {
        return this.getDepositActivityByUpdateDateByMaterialFlow(pdsHandle, depositActivityStatus, null, producerIdStr, producerAgentIdStr, updateDateFrom, updateDateTo, startRecord, endRecord);
    }

    @Override
    public String getDepositActivityByUpdateDateByMaterialFlow(String pdsHandle, String depositActivityStatus, String materialFlowId, String producerIdStr, String producerAgentIdStr, String updateDateFrom, String updateDateTo, String startRecord, String endRecord) {
        try {
            XmlUtils.convertStringToLong("producerId", producerIdStr);
            XmlUtils.convertStringToLong("producerAgentId", producerAgentIdStr);
        }
        catch (ExlibrisException e) {
            return XmlUtils.createXmlResponse(e.getLocalizedMessage());
        }
        String xml = FileUtil.getFileContent("demoXml/deposit_activitiy_update_date.xml");
        return this.showXml(xml);
    }

    private String showXml(String xml) {
        if (xml == null) {
            return null;
        }
        try {
            DepositActivityListDocument doc = DepositActivityListDocument.Factory.parse(xml);
            return XmlUtils.toXML(doc, true);
        }
        catch (XmlException e) {
            return XmlUtils.createXmlResponse(e.getMessage());
        }
    }

    private boolean createDepositActivity() throws IOException, DigitoolException {
        return true;
    }

    @Override
    @WebMethod
    public String getHeartBit() {
        return this.getClass().getSimpleName();
    }
}

