/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.dps.repository.plugin.virusChcek;

import com.exlibris.core.infra.svc.api.scriptRunner.ScriptPluginRunner;
import com.exlibris.dps.repository.plugin.virusChcek.VirusCheckPlugin;
import java.io.File;
import org.apache.commons.lang.StringUtils;

public class VirusCheckPluginScript
extends ScriptPluginRunner
implements VirusCheckPlugin {
    private String output = "";
    private String agent = "";
    private boolean virusFree;

    @Override
    public void scan(String fileFullPath) {
        File file = new File(fileFullPath);
        boolean exitValue = this.runScript(file.getAbsolutePath());
        this.extractVirusCheckOutput(this.getInputStream(), this.getErrorStream(), exitValue);
    }

    @Override
    public boolean isVirusFree() {
        return this.virusFree;
    }

    public void setVirusFree(boolean virusFree) {
        this.virusFree = virusFree;
    }

    @Override
    public String getOutput() {
        return this.output;
    }

    @Override
    public String getAgent() {
        return this.agent;
    }

    private void extractVirusCheckOutput(String inStream, String errStream, boolean exitValue) {
        String content = null;
        if (exitValue) {
            content = inStream;
        } else if (StringUtils.isNotBlank((String)inStream)) {
            content = inStream;
        } else if (StringUtils.isNotBlank((String)errStream)) {
            content = errStream;
        }
        for (String line : content.split("\n")) {
            if (line.startsWith("AGENT=")) {
                this.agent = line.replaceFirst("AGENT=", "");
                continue;
            }
            if (line.startsWith("CONTENT=")) {
                this.output = line.replaceFirst("CONTENT=", "");
                continue;
            }
            if (!line.startsWith("STATUS=")) continue;
            String status = line.replaceFirst("STATUS=", "");
            int statusInt = 11;
            try {
                statusInt = Integer.parseInt(status.trim());
            }
            catch (Exception e) {
                // empty catch block
            }
            this.setVirusFree(statusInt == 0);
        }
    }
}

