/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.dps.sdk.delivery;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.svc.api.FileTableManager;
import com.exlibris.core.infra.svc.api.locator.ServiceLocator;
import com.exlibris.core.sdk.formatting.DublinCore;
import com.exlibris.core.sdk.parser.IEParserException;
import com.exlibris.digitool.common.dnx.DNXConstants;
import com.exlibris.digitool.common.dnx.DnxDocument;
import com.exlibris.digitool.common.dnx.DnxSection;
import com.exlibris.digitool.common.dnx.DnxSectionRecord;
import com.exlibris.dps.sdk.access.Access;
import com.exlibris.dps.sdk.access.AccessFactory;
import com.exlibris.dps.sdk.deposit.IEParser;
import com.exlibris.repository.persistence.digitalentity.HDeMetadata;
import gov.loc.mets.MdSecType;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang.StringUtils;

public class DeliveryUtil {
    private static ExLogger logger = ExLogger.getExLogger(DeliveryUtil.class);
    public static final String IID_PID = "PID";
    public static final String IID_UUID = "UUID";
    public static final String IID_SIPID = "SIPID";
    public static final String IID_DEPOSIT_SET_ID = "DepositSetID";

    public static String prepareForPrintJp2(String ieDvs, String iePid, String repPid, String filePid, String imagePath, String owner) throws Exception {
        Access access = AccessFactory.create();
        IEParser ie = access.getIEByDVS(ieDvs);
        FileTableManager fileMng = (FileTableManager)ServiceLocator.getInstance().lookUp(FileTableManager.class);
        String xslStr = fileMng.getFileByKeyAsString("com.exlibris.dps.viewers.delivery_print_xsl", owner);
        String metadata = DeliveryUtil.createXslt(xslStr, imagePath, ie, true, filePid, repPid, iePid, ieDvs);
        return metadata;
    }

    public static String prepareForPrintJpeg(String ieDvs, String iePid, String repPid, String filePid, String imagePath, String owner) throws Exception {
        Access access = AccessFactory.create();
        IEParser ie = access.getIEByDVS(ieDvs);
        FileTableManager fileMng = (FileTableManager)ServiceLocator.getInstance().lookUp(FileTableManager.class);
        String xslStr = fileMng.getFileByKeyAsString("com.exlibris.dps.viewers.delivery_print_xsl", owner);
        String metadata = DeliveryUtil.createXslt(xslStr, imagePath, ie, true, filePid, repPid, iePid, ieDvs);
        return metadata;
    }

    public static String createCmsXslt(String xslStr, String value) throws IOException, IEParserException, TransformerException {
        StringWriter output = new StringWriter();
        String xmlString = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + value;
        StringBuffer xml = new StringBuffer();
        xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        xml.append("<metadata>");
        xml.append("<ie_metadata>");
        xml.append(DeliveryUtil.appendCmsXml(value, null, null));
        xml.append("</ie_metadata>");
        xml.append("</metadata>");
        xmlString = xml.toString();
        DeliveryUtil.processHTML(xmlString, output, xslStr);
        return output.getBuffer().toString().replaceAll("&amp;", "&");
    }

    private static StringBuffer appendCmsXml(String value, String dvs, String iePid) {
        StringBuffer xml = new StringBuffer();
        try {
            String cms = null;
            if (StringUtils.isNotBlank((String)value)) {
                cms = value;
            } else {
                Access access = AccessFactory.create();
                DublinCore cmsRecord = null;
                if (dvs != null) {
                    cmsRecord = access.getCMSRecordByDVS(iePid, dvs);
                } else if (iePid != null) {
                    cmsRecord = access.getCMSRecord(iePid);
                }
                if (cmsRecord != null) {
                    cms = cmsRecord.toXml();
                }
            }
            if (StringUtils.isNotBlank((String)cms)) {
                xml.append("<ie-cms>");
                cms = DeliveryUtil.removeXmlDeclaration(cms);
                xml.append(cms);
                xml.append("</ie-cms>");
            } else {
                logger.info("*** No CMS section ***");
            }
        }
        catch (Exception e) {
            logger.error("*** No CMS section ***", e, new String[0]);
        }
        return xml;
    }

    public static String createXslt(String xslStr, String path, IEParser parser, boolean includeFileMD, String filePid, String repId, String iePID, String dvs) throws IOException, IEParserException, TransformerException {
        StringWriter output = new StringWriter();
        String xmlString = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + parser.toXML();
        StringBuffer xml = new StringBuffer();
        xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        xml.append("<metadata>");
        xml.append("<image_path>");
        xml.append(path);
        xml.append("</image_path>");
        xml.append("<ie_metadata>");
        xml.append("<ie-dc>");
        String dcXml = parser.getIeDublinCore().toXml();
        dcXml = DeliveryUtil.removeXmlDeclaration(dcXml);
        xml.append(dcXml);
        xml.append("</ie-dc>");
        xml.append(DeliveryUtil.appendCmsXml(null, dvs, iePID));
        if (parser.getIeDnx() != null) {
            xml.append("<ie-dnx>");
            String ieDnx = parser.getIeDnx().toString();
            ieDnx = DeliveryUtil.removeXmlDeclaration(ieDnx);
            xml.append(ieDnx);
            xml.append("</ie-dnx>");
        }
        List<MdSecType.MdWrap> ieSourceMDs = parser.getIeSourceMDs();
        for (MdSecType.MdWrap ieSourceMdWrap : ieSourceMDs) {
            String sourceMdType = ieSourceMdWrap.getMDTYPE().toString().toLowerCase();
            String sourceTag = "ie-source-" + sourceMdType;
            xml.append("<" + sourceTag + ">");
            String sourceMd = ieSourceMdWrap.getXmlData().xmlText();
            sourceMd = DeliveryUtil.removeXmlDeclaration(sourceMd);
            xml.append(sourceMd);
            xml.append("</" + sourceTag + ">");
        }
        xml.append("</ie_metadata>");
        if (repId != null) {
            try {
                String repDnx = parser.getFileGrpDnx(repId).toString();
                repDnx = DeliveryUtil.removeXmlDeclaration(repDnx);
                xml.append("<rep_metadata>");
                xml.append("<rep-dnx>");
                xml.append(repDnx);
                xml.append("</rep-dnx>");
                xml.append("</rep_metadata>");
            }
            catch (Exception e) {
                logger.error("*** No REP section ***", e, new String[0]);
            }
        }
        if (includeFileMD && filePid != null) {
            try {
                DeliveryUtil.addFileMD(xml, filePid, parser, dvs);
            }
            catch (Exception e) {
                logger.error("*** Due to Error File ( " + filePid + ") metadata section wasn't added to xsl***", e, new String[0]);
            }
        }
        xml.append("</metadata>");
        xmlString = xml.toString();
        DeliveryUtil.processHTML(xmlString, output, xslStr);
        return output.getBuffer().toString().replaceAll("&amp;", "&");
    }

    public static String createFileMDXslt(String xslStr, IEParser parser, String filePid, String dvs) throws Exception {
        StringWriter output = new StringWriter();
        String xmlString = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + parser.toXML();
        StringBuffer xml = new StringBuffer();
        xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        xml.append("<metadata>");
        try {
            DeliveryUtil.addFileMD(xml, filePid, parser, dvs);
        }
        catch (Exception e) {
            logger.error("*** Due to Error File ( " + filePid + ") metadata section wasn't added to xsl***", e, new String[0]);
        }
        xml.append("</metadata>");
        xmlString = xml.toString();
        DeliveryUtil.processHTML(xmlString, output, xslStr);
        return output.getBuffer().toString().replaceAll("&amp;", "&");
    }

    private static void addFileMD(StringBuffer xml, String filePid, IEParser parser, String dvs) throws Exception {
        xml.append("<file_metadata>");
        String fileDcXml = null;
        DnxDocument fileDnxDocument = null;
        List<MdSecType.MdWrap> fileSourceMDs = null;
        Access access = AccessFactory.create();
        if (parser.getFile(filePid) != null) {
            fileDnxDocument = parser.getFileDnx(filePid);
            fileDcXml = parser.getFile(filePid).getDMDID() != null ? parser.getDMDDC((String)parser.getFile(filePid).getDMDID().get(0)).toXml() : null;
            fileSourceMDs = parser.getSourceMDs(filePid + "-amd");
            for (MdSecType.MdWrap mdWrap : fileSourceMDs) {
                DeliveryUtil.addFileSourceMDs(xml, mdWrap.getMDTYPE().toString().toLowerCase(), mdWrap.getXmlData().xmlText());
            }
        } else {
            fileDnxDocument = access.getFileInfoByDVS(dvs, filePid);
            List<HDeMetadata> metadataList = access.getFileMetadatasByDVS(dvs, filePid);
            if (metadataList != null) {
                for (HDeMetadata metadata : metadataList) {
                    if (metadata.getMdId() == 2) {
                        fileDcXml = metadata.getValue();
                        continue;
                    }
                    DeliveryUtil.addFileSourceMDs(xml, metadata.getMdType(), metadata.getValue());
                }
            }
        }
        if (StringUtils.isNotBlank(fileDcXml)) {
            xml.append("<file-dc>");
            fileDcXml = DeliveryUtil.removeXmlDeclaration(fileDcXml);
            xml.append(fileDcXml);
            xml.append("</file-dc>");
        }
        if (fileDnxDocument != null) {
            xml.append("<file-dnx>");
            String fileDnx = fileDnxDocument.toString();
            fileDnx = DeliveryUtil.removeXmlDeclaration(fileDnx);
            xml.append(fileDnx);
            xml.append("</file-dnx>");
        }
        xml.append("</file_metadata>");
    }

    private static void addFileSourceMDs(StringBuffer xml, String sourceMdType, String sourceMd) {
        String sourceTag = "file-source-" + sourceMdType;
        xml.append("<" + sourceTag + ">");
        sourceMd = DeliveryUtil.removeXmlDeclaration(sourceMd);
        xml.append(sourceMd);
        xml.append("</" + sourceTag + ">");
    }

    public static String createCollectionXslt(String xslStr, IEParser parser) throws IOException, IEParserException, TransformerException {
        StringWriter output = new StringWriter();
        String xmlString = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + parser.toXML();
        StringBuffer xml = new StringBuffer();
        xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        xml.append("<metadata>");
        xml.append("<collection-metadata>");
        xml.append("<collection-dc>");
        String dcXml = parser.getDMDDC("collection-dmd").toXml();
        dcXml = DeliveryUtil.removeXmlDeclaration(dcXml);
        xml.append(dcXml);
        xml.append("</collection-dc>");
        List<MdSecType.MdWrap> collectionSourceMDs = parser.getSourceMDs("collection-amd");
        for (MdSecType.MdWrap collectionSourceMdWrap : collectionSourceMDs) {
            String sourceMdType = collectionSourceMdWrap.getMDTYPE().toString().toLowerCase();
            String sourceTag = "collection-source-" + sourceMdType;
            if (sourceMdType.toLowerCase().equals("other")) {
                sourceTag = sourceTag + "-" + collectionSourceMdWrap.getOTHERMDTYPE().toString().toLowerCase();
            }
            xml.append("<" + sourceTag + ">");
            String sourceMd = collectionSourceMdWrap.getXmlData().xmlText();
            sourceMd = DeliveryUtil.removeXmlDeclaration(sourceMd);
            xml.append(sourceMd);
            xml.append("</" + sourceTag + ">");
        }
        xml.append("</collection-metadata>");
        xml.append("</metadata>");
        xmlString = xml.toString();
        DeliveryUtil.processHTML(xmlString, output, xslStr);
        return output.getBuffer().toString().replaceAll("&amp;", "&");
    }

    private static String removeXmlDeclaration(String dcXml) {
        String XML_DECLARATION_PREFIX = "<?xml";
        String XML_DECLARATION_POSTFIX = "?>";
        if (dcXml.trim().startsWith("<?xml")) {
            int xmlPostfixPos = dcXml.indexOf("?>");
            if (xmlPostfixPos > 0) {
                xmlPostfixPos += "?>".length();
            }
            dcXml = dcXml.substring(xmlPostfixPos).trim();
        }
        return dcXml;
    }

    public static void processHTML(String xmlString, Writer output, String xslStr) throws TransformerException {
        StreamSource xmlSource = new StreamSource(new StringReader(xmlString));
        StreamSource xslSource = new StreamSource(new StringReader(xslStr));
        TransformerFactory transFact = TransformerFactory.newInstance();
        Transformer trans = transFact.newTransformer(xslSource);
        trans.setOutputProperty("omit-xml-declaration", "yes");
        trans.transform(xmlSource, new StreamResult(output));
    }

    public static String getIID(DnxDocument dnxDoc, String iidType) {
        List<DnxSectionRecord> recordList;
        DnxSection internalId = dnxDoc.getSectionById("internalIdentifier");
        if (internalId != null && (recordList = internalId.getRecordList()) != null) {
            for (DnxSectionRecord record : recordList) {
                String currType = record.getSectionKeyValue(DNXConstants.INTERNALIDENTIFIER.INTERNALIDENTIFIERTYPE.sectionKeyId);
                if (!currType.equals(iidType)) continue;
                String value = record.getSectionKeyValue(DNXConstants.INTERNALIDENTIFIER.INTERNALIDENTIFIERVALUE.sectionKeyId);
                return value;
            }
        }
        return null;
    }
}

