/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.dps.utils;

import com.exlibris.core.infra.common.enums.FileDeliveryRule;
import com.exlibris.core.infra.common.enums.IeDeliveryRule;
import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.common.rules.operators.Operator;
import com.exlibris.core.infra.model.codetables.HMappingTables;
import com.exlibris.core.infra.svc.api.CodeTablesManager;
import com.exlibris.core.infra.svc.api.locator.ServiceLocator;
import com.exlibris.core.infra.svc.api.locator.WebServiceLocator;
import com.exlibris.core.infra.svc.api.services.CacheServices;
import com.exlibris.core.sdk.consts.Enum;
import com.exlibris.digitool.common.dnx.DnxDocument;
import com.exlibris.digitool.common.dnx.DnxSection;
import com.exlibris.digitool.repository.ifc.RepositoryServicesWS;
import com.exlibris.dps.sdk.deposit.IEParser;
import com.exlibris.dps.sdk.deposit.IEParserFactory;
import com.exlibris.repository.persistence.delivery.DelRuleOutputParam;
import com.exlibris.repository.persistence.delivery.DeliveryRule;
import com.exlibris.repository.persistence.delivery.RepresentationProfile;
import com.exlibris.repository.persistence.delivery.RuleInputParam;
import gov.loc.mets.MetsType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DeliveryRulesManager {
    private static DeliveryRulesManager drm = null;
    private static Map<Integer, Operator> operatorMap = null;
    private static Set<String> ieDeliveryRuleValues = null;
    private static Set<String> fileDeliveryRuleValues = null;
    private static final ExLogger logger = ExLogger.getExLogger(DeliveryRulesManager.class);

    public static DeliveryRulesManager getInstance() throws Exception {
        if (drm == null) {
            drm = new DeliveryRulesManager();
        }
        return drm;
    }

    private DeliveryRulesManager() {
    }

    public DelRuleOutputParam getDefaultIERule() throws Exception {
        List<DeliveryRule> rules = this.getDeliveryRules();
        for (DeliveryRule rule : rules) {
            if (!rule.getRuleEntityType().equals((Object)DeliveryRule.RuleEntityType.INTELLECTUAL_ENTITY) || rule.getRuleOrder() != 0) continue;
            for (DelRuleOutputParam delRuleOutputParam : rule.getDelRuleOutputParam()) {
                if (delRuleOutputParam.getRuleParamOrder() != 0) continue;
                return delRuleOutputParam;
            }
        }
        return null;
    }

    public DelRuleOutputParam getMatchingRule(Map<String, String> paramsMap, Map<String, Map<String, String>> representationProfilesParams) throws Exception {
        List<DeliveryRule> rules = this.getDeliveryRules();
        Iterator<DeliveryRule> iter = rules.iterator();
        DeliveryRule defaultRule = null;
        DeliveryRule.RuleEntityType ruleEntityType = DeliveryRule.RuleEntityType.valueOf(paramsMap.get("RuleEntityType"));
        this.initDeliveryRuleEnumValuesSet();
        List<DelRuleOutputParam> delRuleOutputParams = null;
        while (iter.hasNext()) {
            DeliveryRule dvr = iter.next();
            if (!dvr.getRuleEntityType().equals((Object)ruleEntityType)) continue;
            if (dvr.getRuleOrder() == 0) {
                defaultRule = dvr;
                continue;
            }
            if (!this.isRuleMatched(dvr, paramsMap)) continue;
            delRuleOutputParams = dvr.getDelRuleOutputParam();
            break;
        }
        if (delRuleOutputParams == null) {
            delRuleOutputParams = defaultRule.getDelRuleOutputParam();
        }
        Collections.sort(delRuleOutputParams, new DelRuleOutputParam().new DelRuleOutputParam.OrderComparator());
        switch (ruleEntityType) {
            case INTELLECTUAL_ENTITY: {
                DelRuleOutputParam defaultDelRuleOutputParam = null;
                for (int i = 0; i < delRuleOutputParams.size(); ++i) {
                    DelRuleOutputParam cur = delRuleOutputParams.get(i);
                    if (cur.getRuleParamOrder() == 0) {
                        defaultDelRuleOutputParam = cur;
                        continue;
                    }
                    Collection<Map<String, String>> representationProfilesParamsList = representationProfilesParams.values();
                    for (Map<String, String> curParamsMap : representationProfilesParamsList) {
                        if (!this.isProfileMatched(cur.getRepresentationProfile(), curParamsMap)) continue;
                        return cur;
                    }
                }
                return defaultDelRuleOutputParam;
            }
            case FILE: {
                return delRuleOutputParams.get(0);
            }
        }
        return null;
    }

    public List<DeliveryRule> getDeliveryRules() throws Exception {
        List<DeliveryRule> rules = new ArrayList<DeliveryRule>();
        CacheServices cacheServices = (CacheServices)ServiceLocator.getInstance().lookUp(CacheServices.class);
        RepositoryServicesWS repositoryWS = null;
        int callTriesNum = 10;
        while (callTriesNum > 0) {
            try {
                rules = (List)cacheServices.getCacheValue("DELIVERY_RULE", 1);
                if (rules == null || rules.size() == 0) {
                    throw new Exception();
                }
                return rules;
            }
            catch (Exception e) {
                if (repositoryWS == null) {
                    repositoryWS = WebServiceLocator.getInstance().lookUp(RepositoryServicesWS.class);
                }
                repositoryWS.loadDeliveryRules();
                Thread.sleep(1000L);
                if (--callTriesNum != 0) continue;
                logger.error("Error loading Delivery Rules", e, new String[0]);
                throw e;
            }
        }
        return rules;
    }

    private void initOperatorsMap() throws Exception {
        operatorMap = new HashMap<Integer, Operator>();
        CodeTablesManager codeTableManager = (CodeTablesManager)ServiceLocator.getInstance().lookUp(CodeTablesManager.class);
        List<HMappingTables> mappingTables = codeTableManager.findMappingTableByName("Operator", "CRS00");
        for (HMappingTables mappingTable : mappingTables) {
            int key = Integer.parseInt(mappingTable.getTargetCode());
            Operator value = (Operator)Class.forName(mappingTable.getSourceCode3()).newInstance();
            operatorMap.put(key, value);
        }
    }

    private void initDeliveryRuleEnumValuesSet() {
        if (ieDeliveryRuleValues == null) {
            ieDeliveryRuleValues = new HashSet<String>();
        }
        for (IeDeliveryRule ieDeliveryRule : IeDeliveryRule.values()) {
            ieDeliveryRuleValues.add(ieDeliveryRule.name());
        }
        if (fileDeliveryRuleValues == null) {
            fileDeliveryRuleValues = new HashSet<String>();
        }
        for (Enum enum_ : FileDeliveryRule.values()) {
            fileDeliveryRuleValues.add(enum_.name());
        }
    }

    private Operator getOperator(Integer operatorId) {
        if (operatorMap == null) {
            try {
                this.initOperatorsMap();
            }
            catch (Exception e) {
                logger.error("Failed to parse Operator mapping table", e, new String[0]);
            }
        }
        if (operatorMap.containsKey(operatorId)) {
            return operatorMap.get(operatorId);
        }
        throw new RuntimeException("Operator " + operatorId + " not defined");
    }

    private boolean isRuleMatched(DeliveryRule rule, Map<String, String> paramsMap) {
        DeliveryRule.RuleEntityType ruleEntityType = DeliveryRule.RuleEntityType.valueOf(paramsMap.get("RuleEntityType"));
        Operator oper = null;
        block4: for (String key : paramsMap.keySet()) {
            switch (ruleEntityType) {
                case INTELLECTUAL_ENTITY: {
                    if (!ieDeliveryRuleValues.contains(key)) continue block4;
                    oper = this.getOperator(IeDeliveryRule.valueOf(key).getOperator());
                    break;
                }
                case FILE: {
                    if (!fileDeliveryRuleValues.contains(key)) continue block4;
                    oper = this.getOperator(FileDeliveryRule.valueOf(key).getOperator());
                }
            }
            for (int i = 0; i < rule.getRuleInputParam().size(); ++i) {
                RuleInputParam cur = rule.getRuleInputParam().get(i);
                if (!key.equals(cur.getKey()) || "*".equals(cur.getValue()) || oper.check(paramsMap.get(key), cur.getValue()).booleanValue()) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isProfileMatched(RepresentationProfile profile, Map<String, String> paramsMap) {
        if (paramsMap.get(com.exlibris.core.infra.common.enums.RepresentationProfile.LIFE_CYCLE.name()).equals((Object)Enum.LifeCycle.PENDING) && !Boolean.valueOf(paramsMap.get("is_staff")).booleanValue()) {
            return false;
        }
        for (String key : paramsMap.keySet()) {
            Operator oper = this.getOperator(com.exlibris.core.infra.common.enums.RepresentationProfile.valueOf(key).getOperator());
            for (int i = 0; i < profile.getRuleInputParam().size(); ++i) {
                RuleInputParam cur = profile.getRuleInputParam().get(i);
                if (!key.equals(cur.getKey()) || oper.check(paramsMap.get(key), cur.getValue()).booleanValue()) continue;
                return false;
            }
        }
        return true;
    }

    public Map<String, String> prepareData(IEParser parser, Map<String, String> paramMap, DnxDocument reqDnx) throws Exception {
        switch (DeliveryRule.RuleEntityType.valueOf(paramMap.get("RuleEntityType"))) {
            case INTELLECTUAL_ENTITY: {
                IeDeliveryRule[] ieKeys;
                for (IeDeliveryRule param : ieKeys = IeDeliveryRule.values()) {
                    if (param.getDnxSection() == null || param.getDnxSectionKey() == null) continue;
                    paramMap.put(param.name(), this.getDnxValue(parser.getIeDnx(), param.getDnxSection(), param.getDnxSectionKey()));
                }
                break;
            }
            case FILE: {
                FileDeliveryRule[] fileKeys;
                for (FileDeliveryRule param : fileKeys = FileDeliveryRule.values()) {
                    if (param.getDnxSection() == null || param.getDnxSectionKey() == null) continue;
                    paramMap.put(param.name(), this.getDnxValue(reqDnx, param.getDnxSection(), param.getDnxSectionKey()));
                }
                break;
            }
        }
        return paramMap;
    }

    public Map<String, Map<String, String>> prepareRepData(IEParser parser, HashMap<String, Enum.LifeCycle> RepLifeCycleList, boolean isStaff) throws Exception {
        MetsType.FileSec.FileGrp[] reps;
        HashMap<String, Map<String, String>> repParamMapList = new HashMap<String, Map<String, String>>();
        for (MetsType.FileSec.FileGrp rep : reps = parser.getFileGrpArray()) {
            repParamMapList.put(rep.getID(), this.prepareRepData(parser.getFileGrpDnx(rep.getID()), RepLifeCycleList.get(rep.getID()), isStaff));
        }
        return repParamMapList;
    }

    public Map<String, String> prepareRepData(DnxDocument repDnx, Enum.LifeCycle repLifeCycle, boolean isStaff) throws Exception {
        com.exlibris.core.infra.common.enums.RepresentationProfile[] repKeys = com.exlibris.core.infra.common.enums.RepresentationProfile.values();
        HashMap<String, String> repParamMap = new HashMap<String, String>();
        for (com.exlibris.core.infra.common.enums.RepresentationProfile param : repKeys) {
            repParamMap.put(param.name(), this.getDnxValue(repDnx, param.getDnxSection(), param.getDnxSectionKey()));
        }
        repParamMap.put(com.exlibris.core.infra.common.enums.RepresentationProfile.LIFE_CYCLE.name(), repLifeCycle.name());
        repParamMap.put(com.exlibris.core.infra.common.enums.RepresentationProfile.IS_STAFF.name(), String.valueOf(isStaff));
        return repParamMap;
    }

    public IEParser filterParser(String ieXml, RepresentationProfile representationProfile, Map<String, Map<String, String>> repData) throws Exception {
        IEParser parser = IEParserFactory.parse(ieXml);
        Set<String> repPids = repData.keySet();
        for (String repId : repPids) {
            if (this.isProfileMatched(representationProfile, repData.get(repId))) continue;
            parser.removeFileGrp(repId);
        }
        if (representationProfile.isSingleRepresentation().booleanValue()) {
            MetsType.FileSec.FileGrp[] fileGrpArray = parser.getFileGrpArray();
            for (int i = 1; i < fileGrpArray.length; ++i) {
                parser.removeFileGrp(fileGrpArray[i].getID());
            }
        }
        return parser;
    }

    private String getDnxValue(DnxDocument dnx, String section, String sectionKey) {
        DnxSection dnxSec = dnx.getSectionById(section);
        if (dnxSec != null) {
            return dnxSec.getSectionKeyValue(sectionKey);
        }
        return null;
    }
}

