/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.repository.persistence.sip;

import com.exlibris.repository.persistence.HOwneredEntity;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import org.apache.commons.lang.StringUtils;

@Entity
@NamedQueries(value={@NamedQuery(name="FIND_PROC_CONFIG_BY_OWNER", query="select a from HsProcConfig a where a.owner = :owner order by a.name"), @NamedQuery(name="FIND_ACTIVE_PROC_CONFIG_BY_OWNER", query="select a from HsProcConfig a where a.owner = :owner and a.active = :active order by a.name")})
public class HsProcConfig
extends HOwneredEntity {
    private static final long serialVersionUID = 5257307848006638181L;
    private String name;
    private String description;
    private Date createdDate;
    private Date updatedDate;
    private Long preApprove;
    private Long postApprove;
    private Long moveToPermanent;
    private boolean assessor;
    private boolean arranger;
    private boolean approver;
    private boolean active;
    private boolean rearrange = false;
    private int sampleRate;
    private boolean sendNotification = false;

    public HsProcConfig() {
        this.setCreatedDate(new Date());
    }

    public HsProcConfig(String owner) {
        this();
        if (StringUtils.isBlank((String)owner)) {
            throw new IllegalArgumentException("'owner' cannot be empty.");
        }
        this.setOwner(owner);
    }

    public HsProcConfig(HsProcConfig sipConf) {
        this.setOwner(sipConf.getOwner());
        this.setActive(sipConf.isActive());
        this.setApprover(sipConf.isApprover());
        this.setArranger(sipConf.isArranger());
        this.setAssessor(sipConf.isAssessor());
        this.setRearrange(sipConf.isRearrange());
        this.setName("copy of " + sipConf.getName());
        this.setPostApprove(sipConf.getPostApprove());
        this.setPreApprove(sipConf.getPreApprove());
        this.setSampleRate(sipConf.getSampleRate());
        this.setMoveToPermanent(sipConf.getMoveToPermanent());
        this.setSendNotification(sipConf.isSendNotification());
    }

    @Column(name="NAME", nullable=false, length=50)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(name="DESCRIPTION", length=200)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Column(name="PRE_APPROVE")
    public Long getPreApprove() {
        return this.preApprove;
    }

    public void setPreApprove(Long preApprove) {
        this.preApprove = preApprove;
    }

    @Column(name="POST_APPROVE")
    public Long getPostApprove() {
        return this.postApprove;
    }

    public void setPostApprove(Long postApprove) {
        this.postApprove = postApprove;
    }

    @Column(name="MOVE_TO_PERMANENT")
    public Long getMoveToPermanent() {
        return this.moveToPermanent;
    }

    public void setMoveToPermanent(Long moveToPermanent) {
        this.moveToPermanent = moveToPermanent;
    }

    @Column(name="IS_ASSESSOR", nullable=false)
    public boolean isAssessor() {
        return this.assessor;
    }

    public void setAssessor(boolean assessor) {
        this.assessor = assessor;
    }

    @Column(name="IS_ARRANGER", nullable=false)
    public boolean isArranger() {
        return this.arranger;
    }

    public void setArranger(boolean arranger) {
        this.arranger = arranger;
    }

    @Column(name="IS_APPROVER", nullable=false)
    public boolean isApprover() {
        return this.approver;
    }

    public void setApprover(boolean approver) {
        this.approver = approver;
    }

    @Column(name="IS_ACTIVE", nullable=false)
    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @Column(name="SAMPLE_RATE", nullable=false)
    public int getSampleRate() {
        return this.sampleRate;
    }

    public void setSampleRate(int sampleRate) {
        this.sampleRate = sampleRate;
    }

    @Column(name="CREATED_DATE")
    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    @Column(name="UPDATED_DATE")
    public Date getUpdatedDate() {
        return this.updatedDate;
    }

    public void setUpdatedDate(Date updatedDate) {
        this.updatedDate = updatedDate;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.approver ? 1231 : 1237);
        result = 31 * result + (this.arranger ? 1231 : 1237);
        result = 31 * result + (this.assessor ? 1231 : 1237);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.getId() == null ? 0 : this.getId().hashCode());
        result = 31 * result + (this.postApprove == null ? 0 : this.postApprove.hashCode());
        result = 31 * result + (this.preApprove == null ? 0 : this.preApprove.hashCode());
        result = 31 * result + this.sampleRate;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof HsProcConfig)) {
            return false;
        }
        HsProcConfig other = (HsProcConfig)obj;
        if (this.approver != other.approver) {
            return false;
        }
        if (this.arranger != other.arranger) {
            return false;
        }
        if (this.rearrange != other.rearrange) {
            return false;
        }
        if (this.getId() == null ? other.getId() != null : !this.getId().equals(other.getId())) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.postApprove == null ? other.postApprove != null : !this.postApprove.equals(other.postApprove)) {
            return false;
        }
        if (this.preApprove == null ? other.preApprove != null : !this.preApprove.equals(other.preApprove)) {
            return false;
        }
        return this.sampleRate == other.sampleRate;
    }

    @Column(name="IS_REARRANGE", nullable=false)
    public boolean isRearrange() {
        return this.rearrange;
    }

    public void setRearrange(boolean rearrange) {
        this.rearrange = rearrange;
    }

    @Column(name="SEND_NOTIFICATION", nullable=false)
    public boolean isSendNotification() {
        return this.sendNotification;
    }

    public void setSendNotification(boolean sendNotification) {
        this.sendNotification = sendNotification;
    }
}

