/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.repository.procauto;

import com.exlibris.core.infra.Common;
import com.exlibris.core.infra.common.normalizers.NormalizerUtil;
import com.exlibris.core.infra.common.util.IndexXmlUtil;
import com.exlibris.core.infra.model.annotation.Searchable;
import com.exlibris.repository.procauto.HPaProcessExecution;
import com.exlibris.repository.procauto.HPaProcessListener;
import com.exlibris.repository.procauto.HPaTaskChain;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Table;

@Entity
@javax.persistence.Table(name="HPAPROCESS")
@Table(appliesTo="HPAPROCESS")
@NamedQueries(value={@NamedQuery(name="getProcessesByCreator", query="from HPaProcess where createdBy =:createdBy")})
public class HPaProcess {
    public static String GET_PROCESSES_BY_CREATOR = "getProcessesByCreator";
    private Long processId;
    private String name;
    private Long setId;
    private ProcessGroup group;
    private CreatorType creatorType;
    private String createdBy;
    private Date creationDate;
    private String modifiedBy;
    private Date modificationDate;
    private ProcessStatus status;
    private Date statusDate;
    private Date startDate;
    private Date endDate;
    private ProcessLoggingPolicy loggingPolicy;
    private Common.SchedulingMode schedulerApplicationId;
    private String schedualingExpression;
    private String schedulingString;
    private boolean repeatFlag;
    private String sessionId;
    private String lockOwner;
    private HPaTaskChain taskChain;
    private List<HPaProcessListener> processListeners;
    private List<HPaProcessExecution> processExecution;
    private int runAttempts = 0;
    private String indexXml;
    private Boolean relative;

    public HPaProcess(Long processId, String name, Long setId, ProcessGroup group, CreatorType creatorType, String createdBy, Date creationDate, String modifiedBy, Date modificationDate, ProcessStatus status, Date statusDate, Date startDate, Date endDate, ProcessLoggingPolicy loggingPolicy, Common.SchedulingMode schedulerApplicationId, String schedualingExpression, boolean repeatFlag, HPaTaskChain taskChain) {
        this.processId = processId;
        this.name = name;
        this.setId = setId;
        this.group = group;
        this.creatorType = creatorType;
        this.createdBy = createdBy;
        this.creationDate = creationDate;
        this.modifiedBy = modifiedBy;
        this.modificationDate = modificationDate;
        this.status = status;
        this.statusDate = statusDate;
        this.startDate = startDate;
        this.endDate = endDate;
        this.loggingPolicy = loggingPolicy;
        this.schedulerApplicationId = schedulerApplicationId;
        this.schedualingExpression = schedualingExpression;
        this.repeatFlag = repeatFlag;
        this.taskChain = taskChain;
    }

    public HPaProcess() {
    }

    public HPaProcess(HPaProcess process) {
        this.setGroup(process.getGroup());
        this.setCreationDate(new Date());
        this.setModificationDate(new Date());
        this.setStatus(process.getStatus());
        this.setStatusDate(new Date());
        this.setStartDate(process.getStartDate());
        this.setEndDate(process.getEndDate());
        this.setLoggingPolicy(process.getLoggingPolicy());
        this.setSchedulerApplicationId(process.getSchedulerApplicationId());
        this.setSchedualingExpression(process.getSchedualingExpression());
        this.setRepeatFlag(process.getRepeatFlag());
        this.setSetId(process.getSetId());
        this.setTaskChain(process.getTaskChain());
        this.setProcessListeners(process.getProcessListeners());
        this.setProcessExecution(process.getProcessExecution());
    }

    @Id
    @Column(name="PROCESS_ID")
    @GeneratedValue(strategy=GenerationType.AUTO)
    public Long getProcessId() {
        return this.processId;
    }

    public void setProcessId(Long processId) {
        this.processId = processId;
    }

    @OneToMany(mappedBy="process", cascade={CascadeType.ALL})
    public List<HPaProcessListener> getProcessListeners() {
        return this.processListeners;
    }

    public void setProcessListeners(List<HPaProcessListener> processListeners) {
        this.processListeners = processListeners;
    }

    @OneToMany(mappedBy="process", cascade={CascadeType.ALL})
    public List<HPaProcessExecution> getProcessExecution() {
        return this.processExecution;
    }

    public void setProcessExecution(List<HPaProcessExecution> hpaprocessexecutionByProcessId) {
        this.processExecution = hpaprocessexecutionByProcessId;
    }

    public void addProcessExecution(HPaProcessExecution hProcessEsecutione) {
        if (this.getProcessExecution() == null) {
            this.setProcessExecution(new ArrayList<HPaProcessExecution>());
        }
        hProcessEsecutione.setProcess(this);
        this.getProcessExecution().add(hProcessEsecutione);
    }

    public void addProcessListener(HPaProcessListener listener) {
        if (listener != null) {
            if (this.getProcessListeners() == null) {
                this.setProcessListeners(new ArrayList<HPaProcessListener>());
            }
            listener.setProcess(this);
            this.getProcessListeners().add(listener);
        }
    }

    @ManyToOne
    @JoinColumn(name="TASK_CHAIN_ID", referencedColumnName="TASK_CHAIN_ID")
    public HPaTaskChain getTaskChain() {
        return this.taskChain;
    }

    public void setTaskChain(HPaTaskChain taskChain) {
        this.taskChain = taskChain;
    }

    @Column(name="REPEAT_FLAG")
    public boolean getRepeatFlag() {
        return this.repeatFlag;
    }

    public void setRepeatFlag(boolean repeatFlag) {
        this.repeatFlag = repeatFlag;
    }

    @Column(name="NAME", nullable=false, length=150)
    @Searchable
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Enumerated(value=EnumType.STRING)
    @Column(name="PROCESS_GROUP")
    @Searchable
    public ProcessGroup getGroup() {
        return this.group;
    }

    public void setGroup(ProcessGroup group) {
        this.group = group;
    }

    @Column(name="SET_ID")
    public Long getSetId() {
        return this.setId;
    }

    public void setSetId(Long setId) {
        this.setId = setId;
    }

    @Column(name="CREATED_BY", nullable=false, length=50)
    @Searchable
    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    @Column(name="CREATION_DATE", nullable=false, length=100)
    @Searchable
    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    @Column(name="MODIFIED_BY")
    public String getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(String modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    @Column(name="MODIFICATION_DATE")
    public Date getModificationDate() {
        return this.modificationDate;
    }

    public void setModificationDate(Date modificationDate) {
        this.modificationDate = modificationDate;
    }

    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="STATUS", nullable=false)
    @Index(name="PROCESS_STATUS_IDX")
    @Searchable
    public ProcessStatus getStatus() {
        return this.status;
    }

    public void setStatus(ProcessStatus status) {
        this.status = status;
        this.setStatusDate(new Date());
    }

    @Column(name="STATUS_DATE")
    public Date getStatusDate() {
        return this.statusDate;
    }

    public void setStatusDate(Date statusDate) {
        this.statusDate = statusDate;
    }

    @Column(name="START_DATE")
    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    @Column(name="END_DATE")
    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="LOGGING_POLICY")
    public ProcessLoggingPolicy getLoggingPolicy() {
        return this.loggingPolicy;
    }

    public void setLoggingPolicy(ProcessLoggingPolicy loggingPolicy) {
        this.loggingPolicy = loggingPolicy;
    }

    @Column(name="SCHEDULER_APPLICATION_ID")
    @Enumerated(value=EnumType.ORDINAL)
    public Common.SchedulingMode getSchedulerApplicationId() {
        return this.schedulerApplicationId;
    }

    public void setSchedulerApplicationId(Common.SchedulingMode schedulerApplicationId) {
        this.schedulerApplicationId = schedulerApplicationId;
    }

    @Column(name="SCHEDUALING_EXPRESSION")
    public String getSchedualingExpression() {
        return this.schedualingExpression;
    }

    public void setSchedualingExpression(String schedualingExpression) {
        this.schedualingExpression = schedualingExpression;
    }

    @Transient
    public String getSchedulingString() {
        return this.schedulingString;
    }

    public void setSchedulingString(String schedulingString) {
        this.schedulingString = schedulingString;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.processId == null ? 0 : this.processId.hashCode());
        result = 31 * result + (this.setId == null ? 0 : this.setId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HPaProcess)) {
            return false;
        }
        HPaProcess other = (HPaProcess)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.processId == null ? other.processId != null : !this.processId.equals(other.processId)) {
            return false;
        }
        return !(this.setId == null ? other.setId != null : !this.setId.equals(other.setId));
    }

    @Column(name="CREATOR_TYPE")
    @Enumerated(value=EnumType.STRING)
    @Searchable
    public CreatorType getCreatorType() {
        return this.creatorType;
    }

    public void setCreatorType(CreatorType creatorType) {
        this.creatorType = creatorType;
    }

    @Column(nullable=false, name="index_xml")
    @Lob
    public String getIndexXml() {
        return this.indexXml;
    }

    public void setIndexXml(String indexXml) {
        this.indexXml = indexXml;
    }

    public void rebuildIndexXml() {
        Element rootElement = IndexXmlUtil.generateIndexXmlForObject(this);
        HPaTaskChain taskChain2 = this.getTaskChain();
        Element taskChain = DocumentFactory.getInstance().createElement("taskChain");
        String taskChainName = taskChain2.getName();
        taskChain.setText(NormalizerUtil.normalizeWithProfileName("generic", taskChainName));
        rootElement.add(taskChain);
        this.setIndexXml(rootElement.asXML());
    }

    @Column(name="SESSION_ID")
    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    @Column(name="LOCK_OWNER")
    public String getLockOwner() {
        return this.lockOwner;
    }

    public void setLockOwner(String lockOwner) {
        this.lockOwner = lockOwner;
    }

    public Boolean getRelative() {
        return this.relative;
    }

    public void setRelative(Boolean relative) {
        this.relative = relative;
    }

    @Column(name="RUN_ATTEMPTS", nullable=false, columnDefinition="NUMBER DEFAULT 0")
    public int getRunAttempts() {
        return this.runAttempts;
    }

    public void setRunAttempts(int runAttempts) {
        this.runAttempts = runAttempts;
    }

    public static enum CreatorType {
        USER,
        SYSTEM;

    }

    public static enum ProcessGroup {
        SIP_HANDLING,
        MAINTENANCE,
        PRESERVATION,
        RIP_HANDLING;

    }

    public static enum ProcessLoggingPolicy {
        NEW,
        APPEND;

    }

    public static enum ProcessStatus {
        ACTIVE,
        INACTIVE,
        DELETED;

    }
}

