/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.Hashtable;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.Resources;
import org.icepdf.core.pobjects.Stream;
import org.icepdf.core.util.Library;

public class Thumbnail
extends Dictionary {
    private Stream thumbStream;
    private boolean initialized;
    private BufferedImage image;
    private Dimension dimension;

    public Thumbnail(Library library, Hashtable entries) {
        super(library, entries);
        Object thumb = library.getObject(entries, "Thumb");
        if (thumb != null && thumb instanceof Stream) {
            this.thumbStream = (Stream)thumb;
            int width = library.getInt(this.thumbStream.entries, "Width");
            int height = library.getInt(this.thumbStream.entries, "Height");
            this.dimension = new Dimension(width, height);
        }
    }

    public void init() {
        Resources resource = new Resources(this.library, this.thumbStream.entries);
        this.image = this.thumbStream.getImage(null, resource, false);
        this.initialized = true;
    }

    public BufferedImage getImage() {
        if (!this.initialized) {
            this.init();
        }
        return this.image;
    }

    public Dimension getDimension() {
        return this.dimension;
    }
}

