/**
 *	Copyright (C) 2011-2013 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.docudarc.admin;

/**
 * @author denis
 *
 * CHANGES HISTORY:
 *
 * 2.11.2 (Denis, 03.10.2013):
 * util.FileConverter, exception.FileConverterException: When the file converter fails, throw now an exception instead of just returning an error code.
 * 		Note: The interface has changed! Calls to util.FileConverter.convertFile(...) now have to catch FileConverterException.
 * mets.Document:
 * 		Corrected method "isValidSIPFolder()": the mets.xml within the folder MUST be a file - a folder will not do.
 * 		The methods "isLockedByWhom(String)" and "isLockedBySomebodyElse(String)" are now public.
 * 		Added methods "isLockedByWhom(File)" and "isLockedBySomebodyElse(File)".
 * 		Added methods "isLocked(File)" and "isLocked(String)".
 * Use Docutools 1.8.4 with correction in class out.MailSender: The mail body can now contain umlauts.
 * mets.Document, exceptions.FileOrFolderIsInUseException:
 * 		Throw an Exception when saving the SIP while a file or folder inside the SIP is in use, e.g. by another application or the Win7 file explorer.
 * mdconfig.LevelOfDescription, mdconfig.LevelOfDescriptionSet, ... (many resulting changes):
 * 		Access to Levels is not via static methods any more, but via instances of LevelOfDescriptionSet.
 * 		Added instance variable "protected LevelOfDescriptionSet levels" to DocumentAbstract. Each document has now its own LevelOfDescriptionSet.
 * exceptions.FileOrFolderIsInUseException: Add additional information "originalSIPName" and "securitySIPName" to improve message shown to user.
 * mets.Document, mets.structmap.NodeAbstract: Search in one SIP. (still under development)
 * structmap.NodeAbstract, structmap.NodeFile, structmap.NodeFolder: Extended with additional methods: getTreePath() and getWithDescendantsDepthFirst().
 * Use Docutools 1.8.4 with new class string.Pattern.
 * mets.Document: Corrected inconsistency when setting KeepBackupsCount: When now trying to set to null, ignore it and leave as is.
 * mets.Document: Allow to open a folder. Assume there is a mets.xml file within and open this.
 * mets.structmap.StructureMap: Fixed a bug when setting a new root folder, the initialization might fail because the old root folder was still in place.
 * exceptions.OriginalSIPIsMissingException, mets.Document: Throw an exception when the original SIP is missing while saving.
 * util.FileConverter: Finding out about current OO-Installation.
 * util.FileConverter$OOConverter, OOConverterShallNotBeUsedException:
 * 		If the default OO installation is absent and no external OO application path was supplied, assume that the OO Converter shall not be used.
 * util.FileConverter$OOConverter: Method disconnect() now cleans up the OOConverter thorougly.
 * util.BARSIPConverter: The BARSIPConverter can now handle ZIPs with or without a top folder.
 * ead.ComponentAbstract, mets.structmap.NodeAbstract: SubmitStatus. (still under development)
 * mets.Document: Submit. (still under development)
 * util.FileConverter: Fast initialization:
 * 		When initializing the OOConverter in a separate thread AND the service is being requested, wait for the initialization to finish.
 * lib/slf4j-log4j12-1.5.6.jar: redirect slf4j through log4j instead of java.util.logging (e.g. jodconverter)
 * Use Docutools 1.8.4 with extension:
 * 		file.PropertyFile: Resolve environment variables in property values.
 * sa.SubmissionAgreement: When getting all final SAs from the SA folder, ignore files that start with a "." or a "~".
 * lib: Use slf4j-api and slf4j-log4j12 version 1.6.1 instead of 1.5.6.
 * util.RosettaConverter: create IEs. (still under development)
 * -----	Not yet commited into SVN:
 *
 *
 * 2.11.1 (Andreas, 06.06.2013):
 * premis.EventOutcome und premis.EventType: accept other values than the predefined.
 * add *.dotx to known documents formats
 *        (Denis, 01.07.2013):
 * mdconfig.MetadataElementValidatorShort: New.
 * Use Docutools 1.8.2 with correction in class Zipper.
 * Corrections in FileConverter unit tests.
 * ead.DID, ead.ComponentAbstract: Add dynamic properties fromYear, toYear, characteristics, findingAids, and locationOfOriginals.
 * ead.ComponentAbstract: Cleanup and refactoring.
 * util.FileConverter$OOConverter: Refactoring. Introduce new static method to set the number of initialization retries.
 * Use Docutools 1.8.2 with correction in class FileUtil.
 * util.FileConverter$OOConverter: Initialize now the OOConverter with the path INCLUDING the OOO application name.
 * config_dist/levels.xml: Contains now all levels from Docustore and the ISAD(G) set of metadata for each level.
 * config_dist/levels_standard_*.xml: Translated standard levels.xml.
 * Use Docutools 1.8.3 with improved DROID-Exceptions.
 * config_dist/levels.xml, config_dist/levels_standard_*.xml: Add kB, MB, and GB to material-allowedValues.
 * ead.ComponentAbstract: Bug fix when creating a copy of a C or ArchDesc element.
 * mets.Document: Refactoring: Include class DocumentFactory as private inner class.
 * ead.Document: Refactoring: Include class DocumentFactory as private inner class.
 * sa.SubmissionAgreement: Refactoring: Include class SubmissionAgreementFactory as private inner class.
 * util.BARSIPDocument: Convert a BAR-SIP to a Matterhorn-SIP.
 * util.BARSIPDocument: Removed class from project.
 * config_dist/levels_generic.xml: New.
 * util.BARSIPConverter: Re-inserted and renamed class util.BARSIPDocument back into project.
 * Use Docutools 1.8.3 with method FileUtil.appendSuffixToFileName().
 * util.BARSIPConverter: Corrections.
 * util.BARSIPConverter: Corrections: When comparing file names, do it case-INsensitive.
 * structmap.NodeFolder: Methods insertFile(), insertFolder(), and createNewFolder() with additional parameter "boolean renameIfNecessary".
 * 		When true, the inserted file or folder will be renamed, if it already exists in the parent node, by adding "-i" to the name,
 * 		where i is a 3-digit integer.
 * util.BARSIPConverter: Can convert now zip files, too.
 * structmap.NodeFolder: Bug fix: When creating a new SIP, the root folder's access rights are now set correctly.
 * config_dist/levels*.xml: Set the level "Undefined" as the first default-sublevel for the level "Undefined".
 * filesec.File: If DROID doesn't return a unique mimetype for a file, don't leave the field "mimeType" undefined but set it to "".
 * mets.Document, structmap.NodeFolder, util.BARSIPConverter, exceptions.FolderNameIsEmptyException:
 * 		Throw an exception when trying to insert a folder with an empty name. Refactoring.
 * Use Docutools 1.8.4 which is adapted for Java 7.
 * util.VirusScannerClam: Fixed a potential memory leak.
 * mets.*.*: Inserted protected default constructors (for subclasses).
 * mets.Document: Changed the visibility of some methods from private to protected (for subclasses).
 * mets.Document: Added method saveAs(String newMETSFilePath);
 * Use Docutools 1.8.4 with correction in SystemOutRedirector: When redirecting SYSOUT, the log4j logs are now redirected, too.
 * Use Docutools 1.8.4 with improved Exception and ExceptionCollector.
 * Switch back to Java 6. Use Docutools 1.8.4 which is adapted for Java 6.
 * Use Docutools 1.8.4 with correction when opening a file externally in Windows.
 * Use Docutools 1.8.4 with extended SmallPeskyMessageWindow and SmallPeskyProgressBarWindow which can now block the underlying parent window.
 * mets.Document: When saving a SIP with backup, limit the number of backups, i.e. delete some of the oldest.
 * util.FileConverter$OOConverter, sa.SubmissionAgreement: Added some missing getter methods.
 * Use Docutools 1.8.4 with correction:
 * 		gui.JTableWithSpecificCellEditorPerRow: Added method "commitOrCancelCurrentCellEditor()" to commit (or cancel if commit fails) the current cell editor.
 * build.xml: Don't overwrite config_dist/log4j.xml when getting Docutools.
 * build.xml: Correction in target manifest.classpath.
 *
 *
 * 2.11.0 (Denis, 05.02.2013):
 * mets.Document: SIPs can now be opened in readOnly mode.
 * 		Redesign and Refactoring => Interface changed => move from version 2.10.2 to 2.11.0
 * mets.Document, structmap.StructureMap, common.DocumentAbstract: Bug fix: Clean-up in METS-Template when creating a new SIP.
 * mets.Document: Bug fix: When creating a new SIP, don't save it twice.
 * structmap.StructureMap, structmap.NodeFile: Fixed a bug when the root file was migrated WITH keeping the original file.
 * mets.Document: Refactoring of some method names due to inconsistent and unlogic naming.
 * mets.Document: Throw DocumentIsReadOnlyException when trying to save a readOnly document.
 * mets.Document: When savingAs a readOnly document under a different name, change the document mode from readOnly to readWrite.
 * mets.Document: Can now set the document's SA.
 * structmap.NodeFile: File nodes can now be marked as notAllowedBySA.
 * mets.Document, structmap.StructureMap, structmap.NodeAbstract, structmap.NodeFolder, structmap.NodeFile:
 * 		Check against other SA.
 *
 * 2.10.2 (Denis, 22.01.2013):
 * structmap.NodeAbstract: Refactoring usage of method initializeDynamicMetadataElementInstancesWhichAreMandatoryOrAlwaysDisplayed().
 * mets.Document: When creating a SIP from a template, initialize all node's dynamic metadata elements.
 * All java sources: Change copyright message from "2011-2012" to "2011-2013".
 * mdconfig.LevelOfDescription, mdconfig.MetadataElement: Lazy initialization.
 * Use Docutools 1.8.1 with new DROID.
 * structmap.StructureMap: Bug fix: When creating a new SIP, the orphaned DMDSection of the original root node (from the template) is now removed.
 * filesec.File, premis.Object, structmap.NodeFile: Checksum is now stored only in premis.Object, not any more in filesec.File too.
 * All classes: JavaDoc.
 *
 * 2.10.1 (Denis, 20.12.2012):
 * ead.ComponentAbstact, ead.C, ead.ArchDesc, mets.Document, structmap.NodeAbstract:
 * 		Big refactoring: Move all dynamic metadata properties from C up to ComponentAbstract, so that ArchDesc has all these properties, too.
 * 		Reason is that generated EAD export files contain all dynamic metadata.
 * ead.DID: Get rid of the property "unitId" since it is not used. Lots of resulting changes.
 * Use Docutools 1.8.0.
 *
 * 2.10.0 (Denis, 12.12.2012):
 * ead.ComponentAbstract, ead.C, ead.ArchDesc: PID is now a dynamic metadata element.
 * Use Docutools 1.6.6.
 * structmap.NodeAbstract: When changing a node's level, initialize dynamic metadata if necessary and possible.
 * ead.DID: Changed XPath of "unitTitle" from "EAD:unittitle" to "EAD:unittitle[@label = 'main']".
 * unittest/files/*: Many UnitTest files had to be adapted.
 * ead.DID, config_dist/levels.xml: Added new dynamic metadata field "unitTitleAdditional" with XPath "EAD:unittitle[@label = 'additional']".
 * structmap.NodeAbstract: Added methods getDynamicMetadataValueForName(String) and getDynamicMetadataValueForName(String, String) WITHOUT parameter "int index", for non-repeatable items.
 * Use Docutools 1.6.7.
 * mets.Document: When creating the working copy, preserve the file's and folder's access rights.
 * structmap.NodeAbstract: When building up the tree, don't throw exceptions if a file or a folder is missing or not readable.
 * structmap.NodeAbstract, structmap.NodeFolder, structmap.NodeFile:
 * 		Added methods "hasPredecessorNotReadableByCurrentUser()" and "hasDescendantNotReadableByCurrentUser()".
 * Use Docutools 1.7.0.
 * many classes: Adapted to new exception handling in FileUtil.
 * structmap.NodeAbstract, structmap.NodeFolder, structmap.NodeFile:
 * 		Added methods "hasPredecessorNotWritableByCurrentUser()" and "hasDescendantNotWritableByCurrentUser()".
 * structmap.NodeAbstract: Added method "hasPredecessorNeitherReadableNorWritableByCurrentUser()".
 * structmap.NodeFolder: Added method "hasDescendantNeitherReadableNorWritableByCurrentUser()".
 * mets.Document: Disable saving with backup when document has at least one file that is not readable.
 * Use Docutools 1.7.1.
 * mets.Document: Set files and folders to writable before cleanup.
 * mets.Document: Cleanup properly after creating new SIP - no dead bodies left behind any more.
 * structmap.NodeAbstract: Renamed method "hasPredecessorNeitherReadableNorWritableByCurrentUser()" to "hasPredecessorNotReadableOrWritableByCurrentUser()".
 * structmap.NodeFolder: Renamed method "hasDescendantNeitherReadableNorWritableByCurrentUser()" to "hasDescendantNotReadableOrWritableByCurrentUser()".
 * mets.DocumentAbstract, structmap.NodeAbstract: New boolean property in DocumentAbstract: "isAtLeastOneFileNotWritable".
 * mets.Document: When saving with backup a SIP that contains nonreadable files, don't make a backup.
 * mets.Document: When saving a SIP that contains nonreadable or nonwritable files, ignore all FileUtilExceptions.
 * structmap.NodeAbstract, structmap.NodeFile, structmap.NodeFolder: Set the node's access rights when adding files or folders to a node.
 * util.FileConverter: When setting the folder of the OOO application for converting files, now only the location of the "OpenOffice.org" folder must be provided, not the complete path to the executable file within.
 * structmap.StructureMap, resources/templates/mets_sip.xml: Don't accept METS-Files whose structmap has a root element count != 1. The METS-template contains now an empty structmap root element.
 * structmap.NodeAbstract: Improve handling of bad structmap root nodes: strictly don't accept empty or improper types.
 * mets.Document: Now locks are removed and working copies are cleaned-up even when exceptions occur opening bad SIPs.
 * structmap.NodeFolder: Refactoring when inserting folders, retaining their access rights.
 * structmap.NodeAbstract: Initialize mandatory & repeatable dynamic metadata elements which have no instance, with one empty instance.
 * mdconfig.LevelMetadataElement, mdconfig.LevelOfDescription, structmap.NodeAbstract, config_dist/levels.xsd:
 * 		Added new level property "boolean isAlwaysDisplayed".
 * ead.MetadataElementInstance, mdconfig.MetadataElement: Add toolTipTexts.
 * Use Docutools 1.7.2 with Interface "ToolTipText".
 * When creating a template from a SIP, delete all metadata.
 * mdconfig.LevelOfDescription, mdconfig.LevelMetadataElement, mets.Document, config_dist/levels.xsd:
 * 		Added new level property "boolean keepInTemplate".
 * 		When creating a template from a SIP, delete all metadata except those marked with "keepInTemplate='true'".
 * mets.dmdsec.DMDSectionWithEAD: When creating a new node, set the unitTitle to the node's label (= file name), if the node is a folder.
 * 		If the node is a file, cut away the label's extension.
 * ead.C, ead.DID, ead.ComponentAbstract, ead.EADNodeAbstract:
 * 		When deleting some dynamic metadata, delete the parent element if empty.
 * mdconfig.LevelOfDescription, structmap.NodeFolder, structmap.NodeFile:
 * 		Levels have now a default sublevel.
 * 		Initialization of a new subelement's level to the parent level's defaultSubLevel. Before: "Undefined".
 * mets.Document: Added methods isValidSIPFolder(File) and isValidSIPFolder(String).
 *
 * 2.9.4 (Denis, 08.10.2012):
 * Use Docutols 1.6.4.
 * mets.Document: Locking.
 * mets.Document: Refactoring instance variables "filePath" and "originalSipFolder". Added variables "isWorkingFolder" and "lockedBy".
 * ead.MetadataElementInstance: Avoid overwriting a value with the same value, marking the document wrongly as "modified".
 * mets.Document, mets.structmap.StructureMap: New method "hasNodesWithDynamicMetadataElementInstancesWhichAreMandatoryButNotSet()" :-)
 * mdconfig.LevelOfDescription, mdconfig.MetadataElement, config/levels.xml, config/levels.xsd:
 * 		Add element "AllowedValuesSeparator" to element "MetadataElements" in "levels.xml".
 * mdconfig.LevelMetadataElement, config/levels.xml, config/levels.xsd:
 * 		Add attribute "displayRows" to element "LevelMetadataElement" in "levels.xml".
 * Use Docutools 1.6.5 with class NextNumber.
 * mets.structmap.NodeFolder: Add method boolean isPredecessorOf(NodeAbstract).
 * mets.Document: It is now possible to set a backup folder where all backups are made into.
 * mets.Document: Correction in the template handling: Unlock the template and cleanup after creating a template.
 *
 * 2.9.3 (Denis, 19.09.2012):
 * Use Docutools 1.6.3.
 * ead.C, ead.DID, config_dist/levels.xml: Integrate all remaining dynamic metadata fields.
 * ead.MetadataElement: Refactoring: renamed to ead.MetadataElementInstance.
 * structmap.NodeAbstract: Handling of mandatory AND repeatable dynamic metadata.
 * mets.Document, mets.amdsec.AMDSection, mets.amdsec.DigiprovAbstract: Create a SIP out of a template, create a template out of a SIP.
 *
 * 2.9.2 (Andreas, 28.08.2012):
 * Use Docutools 1.6.2 (with possibility to set different DROID signature file).
 *
 * 2.9.1 (Denis, 07.08.2012):
 * ead.Header: Correction: Mark the document as isModified when the eadId is being set.
 * config_dist/levels.xml: Define the Docuteam standard levels.
 *
 * 2.9.0 (Denis, 06.08.2012):
 * NOTE: The interface changed because the LevelOfDescriptions are now read from an xml-file and not any more from a csv-file!
 * ead.DataElement, ead.LevelDataElement: new classes for dynamic metadata properties.
 * ead.LevelOfDescription: Extend to contain LevelMetadataElements and allowedSubLevels.
 * ead.MetadataElementValidator: Interface to validate DataElements.
 * ead.MetadataElementValidatorAlwaysOK: Example implementation of DataElementValidator which always returns 'OK' (that is: null).
 * ead.MetadataElementValidatorAlwaysNOK: Example implementation of DataElementValidator which always returns 'Not OK' (that is: an error Message).
 * ead.MetadataElementTester: Temporary class during development.
 * ead.LevelMetadataElement: Class to join a LevelOfDescription with a MetadataElement.
 * mets.structmap.NodeAbstract: Add methods for the level logic.
 * ead.C: Add methods to access dynamic metadata.
 * mets.structmap.NodeAbstract: Add methods to access dynamic metadata.
 * exceptions.MetadataElementValidatorException: New exception class indicating that a validator rejected a value.
 * ead.MetadataElementValidatorDate: Implementation of DataElementValidator which accepts only date strings in 'yyyy-mm-dd' format.
 * ead.MetadataElementValidatorYear: Implementation of DataElementValidator which accepts only a 4-digit number.
 * ead.*, mdconfig.*: Refactoring: moved some classes from package ead to package mdconfig.
 * ead.MetadataElement: Created new class.
 * util.JavaInterpreter: Created new class.
 * lib.bsh-core-2.0b4.jar: New lib (BeanShell) for the JavaInterpreter.
 * ead.MetadataElement: Dynamic Metadata logic.
 * mets.dmdsec.DMDSectionWithEAD: The C element is now (optionally) nested within an EAD:ead element.
 * mets.structmap.NodeAbstract: Clear unneeded metadata values when switching level of description.
 * mets.Document: Corrected bug: In some circumstances the original SIP folder was deleted on cleanup.
 * mets.Document: Can now create a new SIP as a FOLDER. Before, only new SIPs as ZIPs were possible.
 * apps_dist/*: Both OpenOffice.org packages (OS X and Windows) replaced by the current version 3.4.
 * mets.Document: When creating a new SIP, throw an exception if the destination folder already exists and is not empty.
 * exceptions.FolderIsNotEmptyException: Created new class.
 * structmap.Node*, mdconfig.MetadataElement, mdconfig.LevelMetadataElement:
 * 		Initialization of mandatory dynamic metadata elements happens now only when a new file or folder gets inserted into the tree.
 * 		MetadataElements are listed in the order in which they appear in the level.xml file.
 * structmap.NodeAbstract: Detach a node's label (= fileName) from its unitTitle. Initialize the unitTitle with the fileName omitting the file extension.
 * mdconfig.MetadataElement: When validating dynamic metadata elements, always allow null value.
 * Use Docutools 1.5.5. This version includes the possibility to suppress the automatic popping-up of the SystemOutView when output occurs.
 * structmap.NodeAbstract: Added method hasDynamicMetadataElementInstancesWhichAreMandatoryButNotSet().
 * mdconfig.MetadataElement: Correction in methods isMandatoryButNotSet() and isMandatoryOrSet() (empty string is equivalent to null).
 * util.FileConverter.OOConverter: Added methods: initializeDontWait(...) to initialize OOConverter without waiting until initialization is finished.
 * Use Docutools 1.5.6.
 * ead.ComponentAbstract, ead.C, ead.ArchDesc, structmap.NodeAbstract: AccessNr is now a dynamic metadata field.
 * ead:MetadataElement: Correction in method boolean isMandatoryOrSet().
 * licences.*: Added required software licenses to the project.
 * mets.Document: Use FileUtil.deleteOnExit() instead of File.deleteOnExit() because the latter doesn't work on non-empty folders.
 * Use Docutools 1.6.0.
 *
 * 2.8.2 (Denis, 23.05.2012):
 * Use Docutools 1.5.1.
 * mets.Document, mets.structmap.NodeAbstract: When reading a METS-file with files the current user can't read, don't throw an exception but set a flag in NodeAbstract and document.
 * mets.structmap.NodeAbstract: Has now four new attributes: canRead, canWrite, canExecute, and fileExists.
 * mets.structmap.NodeAbstract: Add method 'filesAndFoldersNotReadableByCurrentUser()' that returns all files and folders the current user is not allowed to read.
 *
 * 2.8.1 (Andreas, 16.05.2012):
 * VirusScannerClam: will now hand over file references to clamd instead of streaming the files through the socket (which is still available as a separate method).
 * Document: set the working directory of a sip to be deleted on exit.
 *
 * 2.8.0 (Denis, 15.05.2012):
 * mets.structmap.StructureMap, NodeAbstract, NodeFolder, NodeFile: Method searchLabel(String) now returns a List<NodeAbstract> instead of a NodeAbstract.
 * mets.Document: Set the property "isModified" whenever something changes, and clear it on save.
 *
 * 2.7.5 (Denis, 11.05.2012):
 * mets.DocumentAbstract: Has now a MessageDistributor to be able to send messages to any Observer who is interested in.
 * 						  When inserting files and folders, distribute via MessageDistributor the filename currently inserting.
 * Use Docutools 1.5.0.
 * util.FileConverter$OOConverter: Destroy the OOConverter process when disconnecting from the OOConverter service.
 * mets.structmap.NodeFile: Bug fix when migrating a file where the destination file already exists.
 *
 * 2.7.4 (Denis, 13.04.2012):
 * Use Docutools 1.4.11.
 * When using a temporary folder, use now FileUtil.getTempFolder().
 * Bug Fix in Docutools.util.FileUtil.
 *
 * 2.7.3 (Denis, 29.03.2012):
 * config.document-formats.xml, config.migration-config.xml: Added docm and xlsm so that util.FileConverter can handle MS Word documents and MS Excel sheets that contain macros.
 * util.FileConverter: If the destination file name of a conversion alrady exists, append the current timestamp to the filename.
 * sa.SubmissionAgreement: After downloading the current SAs from the server, return the list of SA file names that are NOT on the server. The caller might want to delete them.
 * Use Docutools 1.4.10.
 *
 * 2.7.2 (Denis, 06.03.2012):
 * ead.C and ead.ArchDesc: Place the dao element BEHIND the did element.
 * All sources: Changed the copyright message from 2011 to 2011-2012.
 *
 * 2.7.1 (Denis, 20.02.2012):
 * Use Docutools 1.4.7.
 * structmap.NodeFolder: Handle correctly inserting files and folders from a drive (like "D:/")
 *
 * 2.7.0 (Denis, 09.02.2012):
 * mets.Document: Allow reading a SIP without creating a working copy. In this case, all operations manipulating files are not allowed.
 * Created: exception.FileOperationNotAllowedException.
 * Created: common.DocumentAbstract: New superclass of mets.Document and ead.Document.
 * mets.Document: Introduce a boolean variable 'isModified' that indicates whether this document was modified or not.
 * Use Docutools 1.4.6.
 *
 * 2.6.5 (Denis, 26.01.2012):
 * sa.SubmissionAgreement.updateSAsFromServer(): Removed catch() statements because the method should throw exceptions rather than catch them.
 * structmap.NodeFolder: Added method boolean doesLabelHaveNumericPrefix();
 *
 * 2.6.4 (Denis, 20.12.2011):
 * ead.*: EAD export: Export with levelsOfDescription and acquisitionNo. Refactoring and cleanup.
 * ead.*: EAD export: Export with PID (= EAD:dao xlink:href).
 *
 * 2.6.3 (Denis, 08.12.2011):
 * ead.C: Contains now an acqinfo element.
 *
 * 2.6.2 (Denis, 07.12.2011):
 * Renamed class ead.ComponentOtherLevel to ead.LevelOfDescription.
 * Corrected bug in ead.LevelOfDescription: When initialized, the "Undefined" Level is now the 1st level in the list. Before, it was exactly "undefined".
 * mets.structmap.NodeAbstract: Added convenience methods getLevel() and setLevel(LevelOfDescription).
 * mets.structmap.NodeAbstract: Added methods getAcquisitionNo() and setAcquisitionNo(String).
 * mets.structmap.NodeAbstract and subclasses: Added methods getDepth() and getTreeDepth().
 * mets.structmap.NodeAbstract and subclasses: Added method getWithDescendants().
 *
 * 2.6.1 (Denis, 06.12.2011):
 * ead.C: Extend with DAO.
 * Added class: ead.ComponentOtherLevel.
 * ead.C: Extend with mutable "otherlevel".
 *
 * 2.6.0 (Denis, 29.11.2011):
 * structMap.NodeAbstract: Renamed method getEvents() to getMyEvents() and getEvent(i) to getMyEvent(i).
 * structMap.NodeAbstract: Generate an associated DMDSectionWithEAD automatically when none is already present.
 * structMap.NodeAbstract: Handle associated DMDSectionWithEAD when inserting, deleting, renaming, and migrating files and folders.
 * structMap.StructureMap: Allow temporarily null as root.
 *
 * 2.5.2 (Denis, 24.11.2011):
 * Refactoring: Overall unification of method names and great cleanup.
 *
 * 2.5.1 (Denis, 22.11.2011):
 * Added classes: mets.dmdsec.DMDSectionGeneric and mets.dmdsec.DMDSecionWithEAD.
 * Refactoring in classes: ead.*
 * mets.Document: Added method: insertDMDSectionWithEADsForAllFiles(). A METS-file can now be extended with dmdsecs that contain EAD.
 *
 * 2.5.1 (Andreas, 05.01.2012):
 * Extended OOConverter to be able to use external configuration file (default: config/document-formats.xml).
 *
 * 2.5.0 (Denis, 16.11.2011):
 * sa.SubmissionAgreement: deleted static method getOverview().
 * sa.SubmissionAgreement: added method getOverviews() and static method getAllFinalOverviews(), each returning a List<Overview>.
 * Use DocuTools 1.4.1.
 * build.xml: Rename project from DocuDarc to Docudarc.
 *
 * 2.4.4 (Denis, 14.11.2011):
 * sa.SubmissionAgreement: Get SA overview from the SAs that are currently in the SA folder.
 * sa.SubmissionAgreement: Added static method initializeBaseURL(String) to initialize URL for both updateSAsFromServer() AND openAsHTMLExternally().
 *
 * 2.4.3 (Denis, 11.11.2011):
 * sa.SubmissionAgreement: Don't use environment variable "SUBM_AGR_DIR" any more, but the static method setSAFolder(String) to set the SA folder.
 * sa.SubmissionAgreement: Added static method updateSAsFromServer(String remoteSADirName) to update the SAs from the network.
 * mets.Document: Don't use environment variable "DOCUDARC_HOME" any more, but the static method setMETS_SIPTemplateFile(String) to set the SIP Template file location.
 * ead.EAD: Don't use environment variable "DOCUDARC_HOME" any more, but the static method setEADTemplateFile(String) to set the EAD Template file location.
 * util.FileConverter: Don't use environment variable "DOCUDARC_HOME" any more, but the static method setMigrationConfigFile(String) to set the migration-config file location.
 * util.FileConverter: Don't use environment variable "DOCUDARC_HOME" any more, but the static method setMigrationHomeFolder(String) to set the migration home folder.
 *
 * 2.4.2 (Denis, 09.11.2011):
 * log4j.xml: Add encoding parameter.
 *
 * 2.4.1 (Denis, 07.11.2011):
 * Use DocuTools 1.4.0.
 * mets.structmap.StructureMap: Throw exception when a METS file has no root element.
 * mets.Document: Added accessors needed by DocuPack.
 *
 * 2.4.0 (Denis, 07.11.2011):
 * Changed class mets.Document: Removed the possibility to open a METS document without a working copy. Thus the interface changed significantly.
 * Changed class mets.Document: Removed the possibility to save a METS document with a different METS file name (saveAs()). Thus the interface changed significantly.
 * Changed class mets.Document: Added Method saveTo() to save a copy of the SIP somewhere else.
 *
 * 2.3.3 (Denis, 03.11.2011):
 * Use DocuTools 1.3.17.
 *
 * 2.3.2 (Denis, 02.11.2011):
 * Fixed a bug in util.VirusScannerClam: in the rare case that the FileStream chunk size fits exactly into the file size, an IndexOutOfBounds exception was thrown.
 * Use DocuTools 1.3.16.
 * There are some weird problems with locked files under windows.
 *
 * 2.3.1 (Denis, 01.11.2011):
 * Removed classes: FileChecksumCalculator, FileWithMetadata, MetadataProviderDROID, MetadataProviderJHOVE, MetadataFromJPGFile (moved to Docutools)
 *
 * 2.3.0 (Denis, 26.10.2011):
 * MetadataProviderDROID: Moved from DROID Version 4 to Version 5. The interface changed significantly!
 * Added Copyright message to all source files.
 *
 * 2.2.10 (Andreas, 21.10.2011):
 * Use DocuTools 1.3.13
 * MetadataProviderDROID: look for config file in DOCUDARC_HOME first
 *
 * 2.2.9 (Andreas, 22.09.2011):
 * Use DocuTools 1.3.11
 * MetadataProviderDROID: Do not update DROID automatically
 *
 * 2.2.8 (Andreas, 25.08.2011):
 * Changed default chunk size for virus scanner streams
 *
 * 2.2.7 (Denis, 29.07.2011):
 * Using DocuTools 1.3.6.
 * Extend build.xml with target 'distWithOpenOfficeForOSXAndWindows'.
 * Renamed folder config_gen to config_dist and adapted build.xml accordingly.
 * Added folder apps_dist that contains the OOO Apps zipped for distribution.
 * Improved error message when the OOO App for converting files is not found.
 *
 * 2.2.6 (Denis, 26.07.2011):
 * Use DocuTools 1.3.5 (bug fix in class JTableWithDynamicToolTipTexts)
 *
 * 2.2.5 (Denis, 25.07.2011):
 * In folder 'app' the two OOO-packages are now zipped. On distribution they get unzipped.
 *
 * 2.2.4 (Denis, 25.07.2011):
 * Create an EAD-file from a METS-file.
 * EAD UnitTests.
 *
 * 2.2.3 (Andreas, 22.07.2011):
 * Undo previously commited config files
 *
 * 2.2.2 (Andreas, 22.07.2011):
 * Use DocuTools 1.3.4 (for zip files >4GB)
 *
 * 2.2.1 (Denis, 21.07.2011);
 * Refactoring in EAD package.
 * Can now insert new elements into the EAD.
 *
 * 2.2.0 (Denis, 20.07.2011);
 * Added EAD package.
 *
 * 2.1.30 (Denis, 20.07.2011):
 * Some UnitTests and the migration-config files had to be adapted because of the new DROID_SignatureFile_V51.
 * Refactoring: Moved class NodeAbstract from package 'mets.common' to 'common'.
 *
 * 2.1.29 (Andreas, 07.07.2011):
 * Implemented node type "rootfile"
 * bugfix virusscan unittest
 *
 * 2.1.28 (Denis, 07.07.2011):
 * Include OOO into project.
 *
 * 2.1.27 (Denis, 30.06.2011):
 * Use DocuTools 1.3.3.
 *
 * 2.1.26 (Denis, 24.06.2011):
 * util.FileConverter$OOConverter: Corrections and more flexible initialization.
 *
 * 2.1.25 (Denis, 20.06.2011):
 * Use DocuTools 1.3.2.
 * util.FileConverter$OOConverter: Use either an internal or a pre-installed OOO-Service. Improve and accelerate the initialization.
 *
 * 2.1.24 (Denis, 15.06.2011);
 * Use DocuTools 1.2.14.
 * Cleanup: Corrected some code showing warnings.
 *
 * 2.1.23 (Andreas, 09.06.2011):
 * Use DocuTools 1.2.13.
 *
 * 2.1.22 (Denis, 08.06.2011):
 * Use DocuTools 1.2.12.
 *
 * 2.1.21 (Denis, 30.05.2011):
 * Use DocuTools 1.2.10.
 * util.FileConverter$OOConverter: Made class and some of its methods public, to be used by other classes.
 *
 * 2.1.20 (Denis, 27.05.2011):
 * New class: util.VirusScannerClam
 *
 * 2.1.19 (Denis, 25.05.2011):
 * Use DocuTools 1.2.9.
 *
 * 2.1.18 (Denis, 18.05.2011):
 * structMap.NodeAbstract: Marked two unnecessary methods as deprecated (getRelativeSizeBar() and getRelativeSizeBar(int));
 *
 * 2.1.17 (Denis, 18.04.2011):
 * New class: structMap.FileAlreadyExistsException, used in structmap.NodeFolder.
 * Don't throw generic Exception any more, but more specific ones.
 *
 * 2.1.16 (Denis, 15.04.2011):
 * sa.SubmissionAgreement: added method openAsHTMLExternally() to display itself as HTML in the browser (requires to be initialized with the BaseURL)
 *
 * 2.1.15 (Denis, 12.04.2011):
 * sa.SubmissionAgreement: read(): throw 3 different Exceptions instead of 1 generic.
 * util.FileConverter: In migration_config.xml, 'parameter="..."' can now be in element "application" OR in element "mimeType", where "mimeType" takes precedence over "application".
 * sa.SubmissionAgreement: openExternally() prepared (not yet finished)
 *
 * 2.1.14 (Denis, 08.04.2011):
 * Don't use System.getenv() any more but only EnvironmentVariable.get...().
 *
 * 2.1.13 (Andreas, 08.04.2011):
 * mets.amdsec.AMDSection: Insert a amdSec at the correct position
 * mest.structmap.NodeAbstract: Add a digiprovMD element for a node if there is none
 *
 * 2.1.12 (Denis, 08.04.2011):
 * Use DocuTools 1.2.7.
 * New class: exception.BadPronomTypeException, used in util.FileConverter.
 *
 * 2.1.11 (Denis, 07.04.2010):
 * Use DocuTools 1.2.6.
 * util.FileConverter: location of migrationConfig file can be chosen.
 *
 * 2.1.10 (Denis, 04.04.2011):
 * util.FileConverter: Handles correctly file migrations while retaining the original files
 * util.FileConverter: Prepare restructuring the migration_config.xml file
 * util.FileConverter: Prepare getting rid of the conversion scripts in the bin folder
 *
 * 2.1.9 (Denis, 29.03.2011):
 * util.FileConverter: JODConverter is now utilized using the Java API and not the command line interface any more.
 * util.FileConverter: Can now handle conversions that consist of multiple steps
 * Added numerous libraries required by the JODConverter class.
 *
 * 2.1.8 (Denis, 28.03.2011):
 * mets.Document: Correction: document type is set when a new SIP is created
 * mets.Document: Correction: after reading a METS-file, the ExceptionCollector was cleared, what was wrong. Now the ExceptionCollector is left as is.
 *
 * 2.1.7 (Andreas, 28.03.2011):
 * mets.Document: added setType method
 *
 * 2.1.6 (Denis, 25.03.2011):
 * Use DocuTools 1.2.5.
 * mets.Document: filter out hidden files on import and creation
 * mets.Document: added method filesNotAllowedBySubmissionAgreement() that lists all FileNodes not compliant with the SA.
 *
 * 2.1.5 (Denis, 24.03.2011):
 * mets.Document: removed method createNewWithRootElement(...) and replaced it by createNewZIPWithRootElement(...).
 * That means that when a new SIP is created, it is packed into a ZIP archive.
 *
 * 2.1.4 (Andreas, 23.03.2011):
 * Updated Droid library
 * modified build process to create standard jar file
 *
 * 2.1.3 (Denis, 23.03.2011):
 * mets.Document can now insert a DC file even when the namespace in that file is spelled in lowercase letters.
 * Refactored classes dc.DC and dc.OAI_DC.
 * util.FileConverter doesn't use a working folder any more -> conversions are much faster
 * Use DocuTools 1.2.4.
 *
 * 2.1.2 (Denis, 21.03.2011):
 * Extend util.FileConverter to remember the name of the recently used file converter (this is needed in DocuMill).
 * Use DocuTools 1.2.3.
 *
 * 2.1.1 (Denis, 16.03.2011):
 * When the submission agreement can not be loaded, an Exception is now added to the ExceptionCollector (before: an Exception was thrown).
 * Use DocuTools 1.2.2.
 *
 * 2.1.0 (Denis, 11.03.2011):
 * When the submission agreement does NOT accept a file, an Exception is now added to the ExceptionCollector (before: an Exception was thrown, interrupting the operation).
 */
public abstract class Version
{
	static public final String Product = "Docudarc";
	static public final String Number = "2.11.2";
	static public final String LastChange = "03.10.2013";

	/**
	 * This main method is being used by the ant build script to be able to add a version number to the compiled jar file.
	 *
	 * @param args No parameters are expected.
	 */
	public static void main(String[] args)
	{
		System.out.println(Number);
	}
}
