/**
 *	Copyright (C) 2011-2013 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.docudarc.ead;

import java.util.ArrayList;
import java.util.List;

import org.dom4j.Element;

import ch.docuteam.docudarc.common.NodeAbstract;

/**
 * This class occurs in <a href="./ArchDesc.html">ArchDesc</a> and <a href="./C.html">C</a> objects.
 * It contains many of the dynamic metadata objects.
 *
 * @author denis
 *
 */
public class DID extends EADNodeAbstract
{
	//	===========================================================================================
	//	========	Structure				=======================================================
	//	===========================================================================================

	//	========	Static Final Public		=======================================================

	static private final String XPathUnitTitle				= "EAD:unittitle[@label = 'main']";

	static private final String XPathUnitTitleAdditional	= "EAD:unittitle[@label = 'additional']";
	static private final String XPathOrigination			= "EAD:origination";
	static private final String XPathCreationPeriod			= "EAD:unitdate[@label = 'creationPeriod']";
	static private final String XPathCreationPeriodNotes	= "EAD:unitdate[@label = 'creationPeriodNotes']";
	static private final String XPathFromYear				= "EAD:unitdate[@label = 'fromYear']";
	static private final String XPathToYear					= "EAD:unitdate[@label = 'toYear']";
	static private final String XPathLanguage				= "EAD:langmaterial/EAD:language";
	static private final String XPathLanguageNotes			= "EAD:langmaterial";
	static private final String XPathRefCode				= "EAD:unitid[@type = 'refCode']";
	static private final String XPathRefCodeOld				= "EAD:unitid[@type = 'refCodeOld']";
	static private final String XPathRefCodeAdmin			= "EAD:unitid[@type = 'refCodeAdmin']";
	static private final String XPathExtent					= "EAD:physdesc/EAD:extent";
	static private final String XPathMaterial				= "EAD:physdesc/EAD:physfacet";

	static private final String XPathYear					= "EAD:unitdate[@label = 'year']";
	static private final String XPathAbstract				= "EAD:abstract";

	//	========	Static Final Private	=======================================================

	//	========	Static Public			=======================================================

	//	========	Static Private			=======================================================

	//	========	Instance Public			=======================================================

	//	========	Instance Private		=======================================================

	private String			unitTitle;

	//	--------			Dynamic:

	private List<String>	unitTitleAdditional;		//	Dynamic
	private List<String>	origination;				//	Dynamic
	private List<String>	creationPeriod;				//	Dynamic
	private List<String>	creationPeriodNotes;		//	Dynamic
	private List<String>	fromYear;					//	Dynamic
	private List<String>	toYear;						//	Dynamic
	private List<String>	language;					//	Dynamic
	private List<String>	languageNotes;				//	Dynamic
	private List<String>	refCode;					//	Dynamic
	private List<String>	refCodeOld;					//	Dynamic
	private List<String>	refCodeAdmin;				//	Dynamic
	private List<String>	extent;						//	Dynamic
	private List<String>	material;					//	Dynamic

	private List<String>	year;						//	Dynamic
	private List<String>	abstract_;					//	Dynamic

	//	===========================================================================================
	//	========	Main					=======================================================
	//	===========================================================================================

	//	===========================================================================================
	//	========	Methods					=======================================================
	//	===========================================================================================

	//	========	Static Initializer		=======================================================

	//	========	Constructors Public		=======================================================

	//	========	Constructors Private	=======================================================

	/**
	 * This constructor is used only when an EAD-File is being read.
	 */
	private DID(NodeAbstract parent, Element element)
	{
		this.document = parent.getDocument();
		this.parent = parent;
		this.element = element;

		this.unitTitle = this.getElementText(XPathUnitTitle, true);

		this.unitTitleAdditional = this.getDynamicElementTexts(XPathUnitTitleAdditional);
		this.origination = this.getDynamicElementTexts(XPathOrigination);
		this.creationPeriod = this.getDynamicElementTexts(XPathCreationPeriod);
		this.creationPeriodNotes = this.getDynamicElementTexts(XPathCreationPeriodNotes);
		this.fromYear = this.getDynamicElementTexts(XPathFromYear);
		this.toYear = this.getDynamicElementTexts(XPathToYear);
		this.language = this.getDynamicElementTexts(XPathLanguage);
		Element languageNotesElement = ((Element)this.element.selectSingleNode(XPathLanguageNotes));
		if (languageNotesElement != null)
		{
			this.languageNotes = new ArrayList<String>(1);
			this.languageNotes.add(languageNotesElement.attributeValue("label"));
		}
		this.refCode = this.getDynamicElementTexts(XPathRefCode);
		this.refCodeOld = this.getDynamicElementTexts(XPathRefCodeOld);
		this.refCodeAdmin = this.getDynamicElementTexts(XPathRefCodeAdmin);
		this.extent = this.getDynamicElementTexts(XPathExtent);
		this.material = this.getDynamicElementTexts(XPathMaterial);

		this.year = this.getDynamicElementTexts(XPathYear);
		this.abstract_ = this.getDynamicElementTexts(XPathAbstract);
	}


	/**
	 * This constructor is used when a new DID is created programmatically.
	 */
	protected DID(ComponentAbstract parent, String title)
	{
		this.document = parent.getDocument();

		this.unitTitle = title;

		//	create dom4j element:
		this.element = parent.getElement().addElement("EAD:did");
		this.element.addElement("EAD:unittitle")
						.addAttribute("label", "main")
						.addText(title);

		this.document.setIsModified();
	}

	//	========	Static Public			=======================================================

	//	========	Static Private			=======================================================

	/**
	 * This method is used only when an EAD-File is being read.
	 */
	static DID parse(NodeAbstract parent, Element element)
	{
		return new DID(parent, (Element)element.selectSingleNode("./EAD:did"));
	}

	//	========	Instance Public			=======================================================

	//	--------		Accessing			-------------------------------------------------------

	public String getUnitTitle()
	{
		return this.unitTitle;
	}

	public void setUnitTitle(String unitTitle)
	{
		this.unitTitle = unitTitle;

		this.element.selectSingleNode(XPathUnitTitle).setText(this.unitTitle);

		this.document.setIsModified();
	}

	//	--------		Accessing Dynamic	-------------------------------------------------------

	/**
	 * Dynamic Metadata
	 */
	public List<String> getUnitTitleAdditional()
	{
		return this.unitTitleAdditional;
	}

	/**
	 * Dynamic Metadata
	 */
	public void setUnitTitleAdditional(List<String> values)
	{
		this.unitTitleAdditional = values;

		this.setDynamicElementTexts(this.unitTitleAdditional, XPathUnitTitleAdditional);

		this.document.setIsModified();
	}

	/**
	 * Dynamic Metadata
	 */
	public List<String> getOrigination()
	{
		return this.origination;
	}

	/**
	 * Dynamic Metadata
	 */
	public void setOrigination(List<String> values)
	{
		this.origination = values;

		this.setDynamicElementTexts(this.origination, XPathOrigination);

		this.document.setIsModified();
	}

	/**
	 * Dynamic Metadata
	 */
	public List<String> getCreationPeriod()
	{
		return this.creationPeriod;
	}

	/**
	 * Dynamic Metadata
	 */
	public void setCreationPeriod(List<String> values)
	{
		this.creationPeriod = values;

		this.setDynamicElementTexts(this.creationPeriod, XPathCreationPeriod);

		this.document.setIsModified();
	}

	/**
	 * Dynamic Metadata
	 */
	public List<String> getCreationPeriodNotes()
	{
		return this.creationPeriodNotes;
	}

	/**
	 * Dynamic Metadata
	 */
	public void setCreationPeriodNotes(List<String> values)
	{
		this.creationPeriodNotes = values;

		this.setDynamicElementTexts(this.creationPeriodNotes, XPathCreationPeriodNotes);

		this.document.setIsModified();
	}


	/**
	 * Dynamic Metadata
	 */
	public List<String> getFromYear()
	{
		return this.fromYear;
	}

	/**
	 * Dynamic Metadata
	 */
	public void setFromYear(List<String> values)
	{
		this.fromYear = values;

		this.setDynamicElementTexts(this.fromYear, XPathFromYear);

		this.document.setIsModified();
	}


	/**
	 * Dynamic Metadata
	 */
	public List<String> getToYear()
	{
		return this.toYear;
	}

	/**
	 * Dynamic Metadata
	 */
	public void setToYear(List<String> values)
	{
		this.toYear = values;

		this.setDynamicElementTexts(this.toYear, XPathToYear);

		this.document.setIsModified();
	}


	/**
	 * Dynamic Metadata
	 */
	public List<String> getLanguage()
	{
		return this.language;
	}

	/**
	 * Dynamic Metadata
	 */
	public void setLanguage(List<String> values)
	{
		this.language = values;

		this.setDynamicElementTexts(this.language, XPathLanguage);

		this.document.setIsModified();
	}

	/**
	 * Dynamic Metadata
	 */
	public List<String> getLanguageNotes()
	{
		return this.languageNotes;
	}

	/**
	 * Dynamic Metadata: special way to set the values - don't use the standard way with this.setDynamicElementTexts(value, XPath);
	 */
	public void setLanguageNotes(List<String> values)
	{
		this.languageNotes = values;

		Element base = (Element)this.element.selectSingleNode(XPathLanguageNotes);
		if (base == null)				base = this.element.addElement(XPathLanguageNotes);

		if (this.languageNotes != null && this.languageNotes.size() != 0)
		{
			//	Just take the 1st element and ignore all others (anyway there should never be more than one):
			base.addAttribute("label", this.languageNotes.get(0));
		}
		else
		{
			base.addAttribute("label", null);
		}

		this.document.setIsModified();
	}

	/**
	 * Dynamic Metadata
	 */
	public List<String> getExtent()
	{
		return this.extent;
	}

	/**
	 * Dynamic Metadata
	 */
	public void setExtent(List<String> values)
	{
		this.extent = values;

		this.setDynamicElementTexts(this.extent, XPathExtent);

		this.document.setIsModified();
	}

	/**
	 * Dynamic Metadata
	 */
	public List<String> getMaterial()
	{
		return this.material;
	}

	/**
	 * Dynamic Metadata
	 */
	public void setMaterial(List<String> values)
	{
		this.material = values;

		this.setDynamicElementTexts(this.material, XPathMaterial);

		this.document.setIsModified();
	}

	/**
	 * Dynamic Metadata
	 */
	public List<String> getRefCode()
	{
		return this.refCode;
	}

	/**
	 * Dynamic Metadata
	 */
	public void setRefCode(List<String> values)
	{
		this.refCode = values;

		this.setDynamicElementTexts(this.refCode, XPathRefCode);

		this.document.setIsModified();
	}

	/**
	 * Dynamic Metadata
	 */
	public List<String> getRefCodeOld()
	{
		return this.refCodeOld;
	}

	/**
	 * Dynamic Metadata
	 */
	public void setRefCodeOld(List<String> values)
	{
		this.refCodeOld = values;

		this.setDynamicElementTexts(this.refCodeOld, XPathRefCodeOld);

		this.document.setIsModified();
	}

	/**
	 * Dynamic Metadata
	 */
	public List<String> getRefCodeAdmin()
	{
		return this.refCodeAdmin;
	}

	/**
	 * Dynamic Metadata
	 */
	public void setRefCodeAdmin(List<String> values)
	{
		this.refCodeAdmin = values;

		this.setDynamicElementTexts(this.refCodeAdmin, XPathRefCodeAdmin);

		this.document.setIsModified();
	}


	/**
	 * Dynamic Metadata
	 */
	public List<String> getYear()
	{
		return this.year;
	}

	/**
	 * Dynamic Metadata
	 */
	public void setYear(List<String> year)
	{
		this.year = year;

		this.setDynamicElementTexts(this.year, XPathYear);

		this.document.setIsModified();
	}

	/**
	 * Dynamic Metadata
	 */
	public List<String> getAbstract()
	{
		return this.abstract_;
	}

	/**
	 * Dynamic Metadata
	 */
	public void setAbstract(List<String> abstract_)
	{
		this.abstract_ = abstract_;

		this.setDynamicElementTexts(this.abstract_, XPathAbstract);

		this.document.setIsModified();
	}

	//	--------		Inquiring			-------------------------------------------------------
	//	--------		Interface			-------------------------------------------------------
	//	--------		Business Ops		-------------------------------------------------------
	//	--------		Persistence			-------------------------------------------------------
	//	--------		Support				-------------------------------------------------------
	//	--------		Utilities			-------------------------------------------------------
	//	---------		Misc				-------------------------------------------------------
	//	--------		Debugging			-------------------------------------------------------
	//	---------		Temporary			-------------------------------------------------------

	//	========	Instance Private		=======================================================

	//	--------		Initializing		-------------------------------------------------------
	//	--------		Accessing			-------------------------------------------------------
	//	--------		Inquiring			-------------------------------------------------------
	//	--------		Interface			-------------------------------------------------------
	//	--------		Business Ops		-------------------------------------------------------
	//	--------		Persistence			-------------------------------------------------------
	//	--------		Support				-------------------------------------------------------
	//	--------		Utilities			-------------------------------------------------------
	//	---------		Misc				-------------------------------------------------------
	//	--------		Debugging			-------------------------------------------------------

	@Override
	public String toString()
	{
		return new StringBuilder("[did:'")
			.append(this.unitTitle)
			.append("']")
			.toString();
	}

	//	---------		Temporary			-------------------------------------------------------

	//	===========================================================================================
	//	========	Inner Classes			=======================================================
	//	===========================================================================================

}
