/**
 *	Copyright (C) 2011-2013 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.docudarc.mdconfig;

import ch.docuteam.docudarc.mets.structmap.NodeAbstract;
import ch.docuteam.docutools.string.StringUtil;


/**
 * A MetadataElementValidator that only accepts a 4-digit positive integer number = a year.
 *
 * @author denis
 *
 */
public class MetadataElementValidatorYear implements MetadataElementValidator
{
	/* (non-Javadoc)
	 * @see ch.docuteam.docudarc.ead.DataElementValidator#check(java.lang.String, java.lang.Object)
	 */
	@Override
	public String check(String value, NodeAbstract context, MetadataElement metadataElement)
	{
		if (!StringUtil.isNumeric(value))		return "Not numeric: '" + value + "'";
		if (value.length() != 4)				return "Not 4 digits: '" + value + "'";

		try
		{
			new Integer(value);
		}
		catch (NumberFormatException ex)
		{
			return "Con't convert to number: '" + value + "'";
		}

		return null;
	}

}
