/**
 *	Copyright (C) 2011-2013 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.docudarc.mets.dmdsec;

import org.dom4j.Element;

import ch.docuteam.docudarc.dc.OAI_DC;
import ch.docuteam.docudarc.mets.Document;


/**
 * This class, used by the class <a href="../Document.html">Document</a>, represents the METS Descriptive Metadata Section
 * that contains an <a href="../../dc/OAI_DC.html">OAI_DC</a> element.
 *
 * @author denis
 */
public class DMDSectionWithOAI_DC extends DMDSectionAbstract
{
	//	===========================================================================================
	//	========	Structure				=======================================================
	//	===========================================================================================

	//	========	Static Public			=======================================================

	//	========	Static Private			=======================================================

	//	========	Instance Public			=======================================================

	//	========	Instance Private		=======================================================

	private OAI_DC				oaiDc;

	//	===========================================================================================
	//	========	Methods					=======================================================
	//	===========================================================================================

	//	========	Constructors Public		=======================================================

	/**
	 * This method is used only when a DMDSectionWithOAI_DC is created programmatically.
	 */
	public DMDSectionWithOAI_DC(Document document)
	{
		super(document);
	}

	//	========	Constructors Private	=======================================================

	/**
	 * This constructor is used only when a METS-File is being read.
	 * Create the DMDSectionWithOAI_DC out of the given document.
	 */
	protected DMDSectionWithOAI_DC(Document document, Element element)
	{
		super(document, element);

		//	Look for an optional OAI-DC-Element:
		this.oaiDc = OAI_DC.parse(this, this.element);
	}

	//	========	Static Public			=======================================================

	//	========	Static Private			=======================================================

	//	========	Instance Public			=======================================================

	//	--------		Accessing			-------------------------------------------------------

	/**
	 * @param oaiDc the oaiDc to set
	 */
	public void setOaiDc(OAI_DC oaiDc)
	{
		this.oaiDc = oaiDc;
	}

	/**
	 * @return the oaiDc
	 */
	public OAI_DC getOaiDc()
	{
		return this.oaiDc;
	}

	//	--------		Inquiring			-------------------------------------------------------
	//	--------		Interface			-------------------------------------------------------
	//	--------		Business Ops		-------------------------------------------------------
	//	--------		Persistence			-------------------------------------------------------
	//	--------		Support				-------------------------------------------------------
	//	--------		Utilities			-------------------------------------------------------
	//	--------		Debugging			-------------------------------------------------------

	@Override
	public String toString()
	{
		StringBuilder buf = new StringBuilder("\n[DMDSection:" + this.id);
		if (this.oaiDc != null)		buf.append("\n\t" + this.oaiDc);
		buf.append("\n]");

		return buf.toString();
	}

	//	---------		Temporary			-------------------------------------------------------

	//	========	Instance Private		=======================================================

	//	--------		Initializing		-------------------------------------------------------
	//	--------		Accessing			-------------------------------------------------------
	//	--------		Inquiring			-------------------------------------------------------
	//	--------		Business Ops		-------------------------------------------------------
	//	--------		Persistence			-------------------------------------------------------
	//	--------		Support				-------------------------------------------------------
	//	--------		Utilities			-------------------------------------------------------
	//	--------		Debugging			-------------------------------------------------------
	//	---------		Temporary			-------------------------------------------------------

}
