/**
 *	Copyright (C) 2011-2013 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.docutools.exception;
/**
 *
 */


import java.util.List;
import java.util.Vector;


/**
 *This abstract class collects <a href="./Exception.html">Exception</a>s and offers a public static interface to count, retrieve, and clear the Exceptions.
 *
 * @author denis
 *
 */
public abstract class ExceptionCollector
{
	//	===========================================================================================
	//	========	Structure				=======================================================
	//	===========================================================================================

	//	========	Static Public			=======================================================

	//	========	Static Private			=======================================================

	/**
	 * It's here where the Exceptions are collected (in the order they are inserted).
	 */
	static private List<Exception>			All = new Vector<Exception>();

	//	===========================================================================================
	//	========	Methods					=======================================================
	//	===========================================================================================

	//	========	Static Initializer		=======================================================

	//	========	Static Public			=======================================================

	//	--------		Accessing			-------------------------------------------------------

	static void add(Exception e)
	{
		All.add(e);
	}


	static public Integer size()
	{
		return All.size();
	}


	static public Exception get(Integer i)
	{
		return All.get(i);
	}


	static public List<Exception> getAll()
	{
		return All;
	}


	static public String getMessageAll()
	{
		if (All.isEmpty())		return "[ExceptionCollector(empty)]";

		StringBuilder stringBuilder = new StringBuilder("[ExceptionCollector(")
			.append(All.size())
			.append("):");

		for (Exception e: All)		stringBuilder.append("\n\t").append(e.getMessage());

		return stringBuilder.append("\n]").toString();
	}


	@Deprecated
	static public String messageAll()
	{
		return getMessageAll();
	}


	static public void printStackTrace()
	{
		if (All.isEmpty())		System.err.println("ExceptionCollector(empty)");
		else
		{
			System.err.println("ExceptionCollector:");

			int i = 1;
			for (Exception e: All)
			{
				System.err.print("#");
				System.err.print(i);
				System.err.print(":");
				System.err.println();
				e.printStackTrace();
				i++;
			}
		}
	}


	static public void clear()
	{
		All = new Vector<Exception>();
	}

	//	--------		Inquiring			-------------------------------------------------------

	static public Boolean isEmpty()
	{
		return All.isEmpty();
	}

	//	--------		Debugging			-------------------------------------------------------

	static public String toStringAll()
	{
		if (All.isEmpty())		return "[ExceptionCollector(empty)]";

		StringBuilder stringBuilder = new StringBuilder("[ExceptionCollector(")
			.append(All.size())
			.append("):");

		for (Exception e: All)		stringBuilder.append("\n\t").append(e.toString());

		return stringBuilder.append("\n]").toString();
	}


	static public void systemOut()
	{
		System.out.println(toStringAll());
	}

	//	========	Static Private			=======================================================

}
