/**
 *	Copyright (C) 2011-2013 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.docutools.file;


import java.io.File;

/**
 * @author nef
 * @author lem
 *
 */
public abstract class FileFilter
{
	public static class METS extends javax.swing.filechooser.FileFilter implements java.io.FileFilter
	{
		/*
		 * (non-Javadoc)
		 *
		 * @see javax.swing.filechooser.FileFilter#accept(java.io.File)
		 */
		@Override
		public boolean accept(File f)
		{
			String fileNameLowerCase = f.getName().toLowerCase();
			return	!(f.isHidden() || fileNameLowerCase.startsWith("."))		//	No hidden files and directories
					&& (fileNameLowerCase.startsWith("mets") && fileNameLowerCase.endsWith(".xml"));
		}

		/* (non-Javadoc)
		 *
		 * @see javax.swing.filechooser.FileFilter#getDescription()
		 */
		@Override
		public String getDescription()
		{
			return "METS XML-files";
		}
	}


	public static class ZIP extends javax.swing.filechooser.FileFilter implements java.io.FileFilter
	{
		/*
		 * (non-Javadoc)
		 *
		 * @see javax.swing.filechooser.FileFilter#accept(java.io.File)
		 */
		@Override
		public boolean accept(File f)
		{
			return	!(f.isHidden() || f.getName().startsWith("."))		//	No hidden files and directories
					&& f.getName().toLowerCase().endsWith(".zip");
		}

		/* (non-Javadoc)
		 * @see javax.swing.filechooser.FileFilter#getDescription()
		 */
		@Override
		public String getDescription()
		{
			return "ZIP-files";
		}
	}


	public static class METSorZIP extends javax.swing.filechooser.FileFilter implements java.io.FileFilter
	{
		/*
		 * (non-Javadoc)
		 *
		 * @see javax.swing.filechooser.FileFilter#accept(java.io.File)
		 */
		@Override
		public boolean accept(File f)
		{
			String fileNameLowerCase = f.getName().toLowerCase();
			return	!(f.isHidden() || fileNameLowerCase.startsWith("."))		//	No hidden files and directories
					&& (fileNameLowerCase.endsWith(".zip")
						|| (fileNameLowerCase.startsWith("mets") && fileNameLowerCase.endsWith(".xml")));
		}

		/* (non-Javadoc)
		 * @see javax.swing.filechooser.FileFilter#getDescription()
		 */
		@Override
		public String getDescription()
		{
			return "METS- or ZIP-files";
		}
	}


	/**
	 * Accept folders that contain the file mets.xml.
	 * @author denis
	 *
	 */
	public static class SIP extends javax.swing.filechooser.FileFilter implements java.io.FileFilter
	{
		@Override
		public boolean accept(File file)
		{
			if (file.isHidden() || file.getName().startsWith("."))		return false;

			if (file.isDirectory())
			{
				File[] metsFilesWithin = file.listFiles();
				if (metsFilesWithin == null)							return false;

				for (File f: metsFilesWithin)
					if (f.getName().toLowerCase().equals("mets.xml"))	return true;
			}

			return false;
		}

		@Override
		public String getDescription()
		{
			return "SIP Folder";
		}
	}


	/**
	 * Accept zip files and folders that contain the file mets.xml.
	 * @author denis
	 *
	 */
	public static class SIPorZIP extends javax.swing.filechooser.FileFilter implements java.io.FileFilter
	{
		@Override
		public boolean accept(File file)
		{
			if (file.isHidden() || file.getName().startsWith("."))		return false;

			if (file.isFile())
			{
				if (file.getName().toLowerCase().endsWith(".zip"))		return true;
			}
			else
			{
				File[] metsFilesWithin = file.listFiles();
				if (metsFilesWithin == null)							return false;

				for (File f: metsFilesWithin)
					if (f.getName().toLowerCase().equals("mets.xml"))	return true;
			}

			return false;
		}

		@Override
		public String getDescription()
		{
			return "SIP Folder or ZIP-Files";
		}
	}


	public static class AllExceptHidden extends javax.swing.filechooser.FileFilter implements java.io.FileFilter
	{
		/*
		 * (non-Javadoc)
		 *
		 * @see javax.swing.filechooser.FileFilter#accept(java.io.File)
		 */
		@Override
		public boolean accept(File f)
		{
			return !(f.isHidden() || f.getName().startsWith("."));
		}

		/* (non-Javadoc)
		 * @see javax.swing.filechooser.FileFilter#getDescription()
		 */
		@Override
		public String getDescription()
		{
			return "All files and directories except hidden ones";
		}
	}


	public static class AllFilesExceptHidden extends javax.swing.filechooser.FileFilter implements java.io.FileFilter
	{
		/*
		 * (non-Javadoc)
		 *
		 * @see javax.swing.filechooser.FileFilter#accept(java.io.File)
		 */
		@Override
		public boolean accept(File f)
		{
			return !(f.isHidden() || f.getName().startsWith(".")) && f.isFile();
		}

		/* (non-Javadoc)
		 * @see javax.swing.filechooser.FileFilter#getDescription()
		 */
		@Override
		public String getDescription()
		{
			return "All files except hidden ones";
		}
	}

}
