/**
 *	Copyright (C) 2011-2013 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/**
 *	Copyright (C) 2011-2013 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.docutools.file.exception;

import java.util.List;

import uk.gov.nationalarchives.droid.core.interfaces.IdentificationResult;





/**
 * @author denis
 *
 */
public class DROIDMultipleIdentificationsFoundException extends Exception
{
	private List<IdentificationResult>			resultList;

	//	===========================================================================================
	//	========	Methods					=======================================================
	//	===========================================================================================

	//	========	Constructors Public		=======================================================

	public DROIDMultipleIdentificationsFoundException(String filePath, List<IdentificationResult> resultList)
	{
		super(filePath);
		this.resultList = resultList;
	}

	//	========	Accessors				=======================================================

	public List<IdentificationResult> getResultList()
	{
		return this.resultList;
	}

	@Override
	public String getMessage()
	{
		StringBuilder message = new StringBuilder(super.getMessage());
		for (IdentificationResult r: this.resultList)
			message.append("\npuid='").append(r.getPuid())
					.append("' name='").append(r.getName())
					.append("' ver='").append(r.getVersion())
					.append("' mime='").append(r.getMimeType())
					.append("' method='").append(r.getMethod())
					.append("'");

		return message.toString();
	}

}
