/**
 *	Copyright (C) 2011-2013 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *	
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *	
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.docutools.gui;

import java.awt.*;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.border.EmptyBorder;

/**
 * @author denis
 *
 */
public class ScrollableMessageDialog extends JDialog
{
	//	===========================================================================================
	//	========	Structure				=======================================================
	//	===========================================================================================

	//	========	Static Final Public		=======================================================

	//	========	Static Final Private	=======================================================

	static private Dimension		StartScreenSize = new Dimension(600, 300);

	//	========	Static Public			=======================================================

	//	========	Static Private			=======================================================

	//	========	Instance Public			=======================================================

	//	========	Instance Private		=======================================================

	private JTextArea				textArea;
	private JButton					closeButton;

	//	===========================================================================================
	//	========	Main					=======================================================
	//	===========================================================================================

	/**
	 * @param args
	 */
	public static void main(String[] args)
	{
		final JFrame f = new JFrame();
		f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		JButton b = new JButton();
		b.addActionListener(new ActionListener()
		{ @Override public void actionPerformed(ActionEvent e)
			{
				new ScrollableMessageDialog(f, "Hier", "Test Text Test Text Test Text Test Text Test Text\nTest Text Test Text Test Text Test Text Test Text Test Text Test Text Test Text Test Text Test Text Test Text Test Text Test Text Test Text Test Text ");
			}
		});
		f.add(b);
		f.setSize(400, 200);
		f.setLocationRelativeTo(null);
		f.setVisible(true);
	}

	//	===========================================================================================
	//	========	Methods					=======================================================
	//	===========================================================================================

	//	========	Static Initializer		=======================================================

	//	========	Constructors Public		=======================================================

	//	========	Constructors Private	=======================================================

	public ScrollableMessageDialog(Window parent, String headerText, String text)
	{
		this(parent, headerText, text, null);
	}


	public ScrollableMessageDialog(Window parent, String headerText, String text, ImageIcon icon)
	{
		super(parent, headerText, ModalityType.APPLICATION_MODAL);

		this.textArea = new JTextArea(text);
		this.textArea.setEnabled(true);
		this.textArea.setEditable(false);
		this.textArea.setLineWrap(false);

		this.closeButton = new JButton("OK");
		this.closeButton.addActionListener(
			new ActionListener() { @Override public void actionPerformed(ActionEvent e) { close(); }});

		GridBagPanel gridBag = new GridBagPanel(new EmptyBorder(20, 20, 20, 20), new Insets(5, 5, 5, 5));
		gridBag.add(new JLabel(icon),									1,    0,   	GridBagConstraints.NORTHWEST);
		gridBag.add(new JScrollPane(this.textArea),						1,    1,    GridBagConstraints.WEST,		GridBagConstraints.BOTH,		1, 1);
		gridBag.add(this.closeButton,									2,    1,   	GridBagConstraints.EAST);

		//	Both the ESC key and the return key close the Dialog:
		gridBag.getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW).put(KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0), "Close");
		gridBag.getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW).put(KeyStroke.getKeyStroke(KeyEvent.VK_ENTER, 0), "Close");
		gridBag.getActionMap().put("Close",
			new AbstractAction() { @Override public void actionPerformed(ActionEvent e) { close(); }});

		this.add(gridBag);

		this.setSize(StartScreenSize);
		this.setLocationRelativeTo(parent);

		this.setVisible(true);
	}

	//	========	Static Public			=======================================================

	//	--------		Initializing		-------------------------------------------------------
	//	--------		Accessing			-------------------------------------------------------
	//	--------		Inquiring			-------------------------------------------------------
	//	--------		Business Ops		-------------------------------------------------------
	//	--------		Persistence			-------------------------------------------------------
	//	--------		Support				-------------------------------------------------------
	//	--------		Utilities			-------------------------------------------------------
	//	---------		Misc				-------------------------------------------------------
	//	--------		Debugging			-------------------------------------------------------
	//	---------		Temporary			-------------------------------------------------------

	//	========	Static Private			=======================================================

	//	--------		Initializing		-------------------------------------------------------
	//	--------		Accessing			-------------------------------------------------------
	//	--------		Inquiring			-------------------------------------------------------
	//	--------		Business Ops		-------------------------------------------------------
	//	--------		Persistence			-------------------------------------------------------
	//	--------		Support				-------------------------------------------------------
	//	--------		Utilities			-------------------------------------------------------
	//	---------		Misc				-------------------------------------------------------
	//	--------		Debugging			-------------------------------------------------------
	//	---------		Temporary			-------------------------------------------------------

	//	========	Instance Public			=======================================================

	//	--------		Initializing		-------------------------------------------------------
	//	--------		Accessing			-------------------------------------------------------
	//	--------		Inquiring			-------------------------------------------------------
	//	--------		Interface			-------------------------------------------------------
	//	--------		Actions				-------------------------------------------------------
	//	--------		Business Ops		-------------------------------------------------------
	//	--------		Persistence			-------------------------------------------------------
	//	--------		Support				-------------------------------------------------------
	//	--------		Utilities			-------------------------------------------------------
	//	---------		Misc				-------------------------------------------------------
	//	--------		Debugging			-------------------------------------------------------
	//	---------		Temporary			-------------------------------------------------------

	//	========	Instance Private		=======================================================

	//	--------		Initializing		-------------------------------------------------------
	//	--------		Accessing			-------------------------------------------------------
	//	--------		Inquiring			-------------------------------------------------------
	//	--------		Interface			-------------------------------------------------------
	
	private void close()
	{
		this.setVisible(false);
		this.dispose();
	}
	
	//	--------		Actions				-------------------------------------------------------
	//	--------		Business Ops		-------------------------------------------------------
	//	--------		Persistence			-------------------------------------------------------
	//	--------		Support				-------------------------------------------------------
	//	--------		Utilities			-------------------------------------------------------
	//	---------		Misc				-------------------------------------------------------
	//	--------		Debugging			-------------------------------------------------------
	//	---------		Temporary			-------------------------------------------------------

	//	===========================================================================================
	//	========	Inner Classes			=======================================================
	//	===========================================================================================

}
