/**
 *	Copyright (C) 2011-2013 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *	
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *	
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.docutools.string;
/**
 * 
 */


import java.util.List;


/**
 * A corresponding set of StringSetElements is defined by creating a subclass of StringSetElement and specifying in the static initializer its elements.
 * 
 * @author denis
 *
 */
public class StringSetElementExample extends StringSetElement
{
	//	===========================================================================================
	//	========	Main					=======================================================
	//	===========================================================================================
	
	//	========	Static Initializer		=======================================================

	/**
	 * Here the StringSetElements for this class are defined.
	 */
	static
	{
		new StringSetElementExample("Yes");
		new StringSetElementExample("No");
		new StringSetElementExample("Maybe");
		new StringSetElementExample("Don't Know");
	}
	
	
	//	========	Constructors Private	=======================================================

	private StringSetElementExample(String value)
	{
		super(value);
	}

	
	//	========	Static Public			=======================================================

	/**
	 * This method is mandatory! Unfortunately, it is not possible to define static abstract methods in the superclass >:-(
	 * <p>
	 * Using this static method, the user can retrieve specific StringSetElements.
	 * Note that the value is extremely flexible: One can omit or add spaces and non-alphanumeric characters, or change the case, and still the StringSetElement will be found.
	 */
	static public StringSetElementExample get(String value)
	{
		return (StringSetElementExample)StringSet.get(StringSetElementExample.class, value);
	}

	
	/**
	 * This method is mandatory! Unfortunately, it is not possible to define static abstract methods in the superclass >:-(
	 * <p>
	 * Return all StringSetElements of this class.
	 */
	static public List<? extends StringSetElement> getAll()
	{
		return StringSet.getAll(StringSetElementExample.class);
	}
	
}

